// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Direct.cpp,v 1.4 2001/08/02 07:20:26 seagull Exp $
//


#include "UssCommon.h"
#include "UssIOBuffer.h"


int
UssIOBuffer_Direct::read(void* buf, int len)
{
  testRedirected();
  IUssIO* io = getRedirectTo();
		
  int n = 0;
  while (n < len)
    {
      int readed = io->read(static_cast<uint8_t*>(buf) + n, len - n);
      if (readed < 0) // found OS level error
      {
        if (errno != EAGAIN && errno != EINTR)
          throw new EUssOSError();
      }
      else if (readed == 0) // found EOF
        return n;
      else
        n += readed;
    }
  return n;
}




int
UssIOBuffer_Direct::write(void const* buf, int len)
{
  testRedirected();
  IUssIO* io = getRedirectTo();

  int n = 0;
  while (n < len)
    {
      int wrote = io->write(static_cast<uint8_t*>(buf) + n, len - n);
      if (wrote < 0)
        throw new EUssOSError();
      n += wrote;
    }
  return n;
}



size_t
UssIOBuffer_Direct::getBufferSize() const
{
  return 0;
}


size_t
UssIOBuffer_Direct::getFreeSize() const
{
  return UINT_MAX;
}



size_t
UssIOBuffer_Direct::getUsedSize() const
{
  return 0;
}



bool
UssIOBuffer_Direct::isEmpty() const
{
  return false;
}


bool
UssIOBuffer_Direct::isFull() const
{
  return false;
}


int
UssIOBuffer_Direct::flush()
{
  return 0;
}

int
UssIOBuffer_Direct::fetch()
{
  return 0;
}



bool
UssIOBuffer_Direct::lookAhead(int offset, uint8_t* p)
{
  return false;
}

