// -*- mode:c++; indent-tabs-moe:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Queue.h,v 1.7 2001/07/24 05:54:55 seagull Exp $
//


#if !defined(USS_H_IOBuffer_Queue)
#define USS_H_IOBuffer_Queue

#include <limits.h>

class UssIOBuffer_Queue;

class IUssIOPacketBase
{
public:
  friend class UssIOBuffer_Queue;

  IUssIOPacketBase();
  virtual ~IUssIOPacketBase();
  virtual void onSendStart();
  virtual void onSendFinish();

  virtual unsigned int doSend(IUssIO* io, unsigned int offset) = 0;
  virtual unsigned int getLength() = 0;

protected:
  IUssIOPacketBase* m_pNext;
};



class UssIOPacket : public IUssIOPacketBase
{
public:
  UssIOPacket(uint8_t* p, int len);
  virtual ~UssIOPacket();


  virtual unsigned int doSend(IUssIO* io, unsigned int offset);
  virtual unsigned int getLength();


protected:
  uint8_t* m_pBuffer;
  size_t m_len;
};





/**
   塼 UssIOBuffer

   NOTE: read бƤޤ
 */
class UssIOBuffer_Queue : public UssIOBufferBase
{
public:
  UssIOBuffer_Queue();
  virtual ~UssIOBuffer_Queue();

  virtual void reset();

  //
  // Operations
  //
  virtual int read(void* buf, int len);
  virtual int write(void const* buf, int len);
  virtual int write(IUssIOPacketBase* packet);

  virtual size_t getBufferSize() const;
  virtual size_t getFreeSize() const;
  virtual size_t getUsedSize() const;
  virtual bool isEmpty() const;
  virtual bool isFull() const;


  //
  // redirect service
  //

  virtual int flush();
  virtual int fetch();


  /**
     б
   */
  virtual bool lookAhead(int offset, uint8_t* p);

  

  /**
     ΥѥåȤʤ
   */
  void retry()
  {
    m_nCurrOffset = 0;
  }


protected:
  IUssIOPacketBase* m_pHead;
  IUssIOPacketBase* m_pTail;

  unsigned int m_nCurrOffset;
};


#endif
