// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Raw.cpp,v 1.2 2001/07/19 15:11:59 seagull Exp $
//

#include "UssCommon.h"
#include "UssIOBuffer.h"


UssIOBuffer_Raw::UssIOBuffer_Raw()
{
  m_pBuffer = NULL;
  m_pBufferTail = NULL;
}


UssIOBuffer_Raw::~UssIOBuffer_Raw()
{
  if (m_pBuffer)
    delete[] m_pBuffer;
}


void
UssIOBuffer_Raw::init(int bufflen)
{
  if (bufflen == 0)
    throw new EUssOSError(EINVAL);

  m_pBuffer = new uint8_t[bufflen];
  if (m_pBuffer == NULL)
    throw new EUssOSError();

  m_pBufferTail = m_pBuffer + bufflen;
  
  reset();
}
