// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Ring.cpp,v 1.10 2001/07/19 15:11:59 seagull Exp $
//


#include "UssCommon.h"
#include "UssIOBuffer.h"



int
UssIOBuffer_Ring::read(void* buff, int len)
{
  if (isEmpty())
    return 0;

  uint8_t* dst = static_cast<uint8_t*>(buff);

  while (len-- && m_pReadPtr != m_pWritePtr)
    {
      *dst++ = *m_pReadPtr++;

      // wrap
      if (m_pReadPtr == m_pBufferTail)
        m_pReadPtr = m_pBuffer;
    }


  //
  // ХåեˤʤäΤʤ顢ݥ󥿤
  //
  if (m_pReadPtr == m_pWritePtr)
  {
    m_pReadPtr = NULL;
    m_pWritePtr = m_pBuffer;
  }

  return dst - static_cast<uint8_t*>(buff);
}








int
UssIOBuffer_Ring::write_impl(void const* buff, int len)
{
  if (getFreeSize() < (size_t)len)
    {
      throw new EUssIOBufferOverflow(this);
      return 0;
    }

  uint8_t* src = static_cast<uint8_t*>(buff);

  while (len-- && m_pReadPtr != m_pWritePtr)
    {
      if (m_pReadPtr == NULL)
        m_pReadPtr = m_pWritePtr;
      *m_pWritePtr++ = *src++;

      // wrap
      if (m_pWritePtr >= m_pBufferTail)
        m_pWritePtr = m_pBuffer;
    }

  return src - static_cast<uint8_t*>(buff);;
}









int
UssIOBuffer_Ring::flush()
{
  testRedirected();
  
  if (isEmpty()) return 0;
  int n = getRedirectTo()->write(m_pReadPtr,
                                 isWrapped()? (m_pBufferTail - m_pReadPtr) :
                                 (m_pWritePtr - m_pReadPtr));
  if (n > 0)
    {
      m_pReadPtr += n;
      if (m_pReadPtr >= m_pBufferTail)
        m_pReadPtr = m_pBuffer;
      if (m_pReadPtr == m_pWritePtr)
        {
          m_pReadPtr = NULL;
          m_pWritePtr = m_pBuffer;
        }
    }

  return n;
}








int
UssIOBuffer_Ring::fetch()
{
  testRedirected();
  
  if (isFull()) return 0;
  int n = getRedirectTo()->read(m_pWritePtr,
                                isWrapped()? (m_pReadPtr - m_pWritePtr) : 
                                (m_pBufferTail - m_pWritePtr) );
  if (n > 0)
    {
      if (m_pReadPtr == NULL)
        m_pReadPtr = m_pWritePtr;
      
      m_pWritePtr += n;
      if (m_pWritePtr >= m_pBufferTail)
        m_pWritePtr = m_pBuffer;

      if (getEventListener() != NULL)
        getEventListener()->onWrite(this, n);
    }

  return n;
}





bool
UssIOBuffer_Ring::lookAhead(int offset, uint8_t* p)
{
  if (isEmpty()) return false;
  if (m_pWritePtr > m_pReadPtr)
    {
      if (m_pWritePtr - m_pReadPtr < offset)
        return false;
      *p = *(m_pReadPtr + offset);
      return true;
    }
  offset -= m_pBufferTail - m_pReadPtr;
  if (m_pWritePtr - m_pBuffer < offset)
    return false;
  *p = *(m_pBuffer + offset);
  return true;
}

