// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssSerialPort.h,v 1.3 2001/08/18 16:32:30 seagull Exp $
//


#if !defined(USS_H_SERIALPORT)
#define USS_H_SERIALPORT

#include <termios.h>
#include <unistd.h>

#include "UssException.h"
#include "UssFileDescriptor.h"


class UssSerialPort;


/**
   륢ݡȼ㳰Ƥδ쥯饹Ǥ
*/
class EUssSerialPort : public EUssException
{
public:
  EUssSerialPort(UssSerialPort* obj)
    : EUssException(static_cast<void*>(obj))
  {
  }
};


/**
   ۾ʥܡ졼ȤǤ򼨤ޤ
 */
class EUssBadBaudRate : public EUssSerialPort
{
public:
  EUssBadBaudRate(UssSerialPort* obj) : EUssSerialPort(obj)
  {
  }
  

  char const* what()
  {
    return "Bad baud rate";
  }
};


/**
   ۾ʥǡӥåĹǤ򼨤ޤ
 */
class EUssBadDataBit : EUssSerialPort
{
public:
  EUssBadDataBit(UssSerialPort* obj) : EUssSerialPort(obj)
  {
  }
  

  char const* what()
  {
    return "Bad baud rate";
  }
};





/**
   ꥢݡȤ򰷤 UssFileDescriptor Ǥ
 */
class UssSerialPort : public UssFileDescriptor
{
public:
  UssSerialPort(int fd = -1)
    : UssFileDescriptor(fd)
  {
  }

  /// ѥƥΥ
  enum parity_t
    {
      /// 
      PAR_EVEN,
      /// 
      PAR_ODD,
      /// ̵
      PAR_NONE
    };

  /// ե
  enum flowctrl_t
    {
      /// ϡɥ
      FLOW_HW,
      /// XIN/XOUT
      FLOW_XONOFF,
      /// ̵
      FLOW_NONE
    };

  /**
     ꥢݡȤ򥪡ץ󤷤ޤ

     @param device   ꥢݡȥǥХꤷޤ(: /dev/ttyS1)
     @param baudrate ܡ졼ȤꤷޤƤΥܡ졼ȤݡȤƤǤϤޤ
     @param parity   ѥƥΥפꤷޤ (PER_EVENT/PER_ODD/PER_NONE)
     @param flow     եȥΥפꤷޤ (FLOW_HW/FLOW_XONXOFF/FLOW_NONE)
     @param blocal   ǥ࿮ͭˤ false ꤷޤ
     @param databit  ǡӥåĹꤷޤ
     @param stop2    ȥåץӥåȤ2ӥåȤˤˤ true ꤷޤ
     
     @return
     ץǤfdᤷޤץǤʤˤᤷޤ¿ξ㳰ޤ
     
   */
  int open(char const* device, int baudrate = 38400,
           parity_t parity = PAR_NONE, flowctrl_t flow = FLOW_NONE,
           bool blocal = true,
           uint databit = 8, bool stop2 = false);


protected:
  termios m_oldtio;
  termios m_curtio;
};


#endif
