// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// UssSocket.h
// $Id: UssSocket.h,v 1.10 2001/09/08 07:47:16 seagull Exp $
//

#if !defined(USS_H_Socket)
#define USS_H_Socket

#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "UssException.h"
#include "UssFileDescriptor.h"




/**
   åȤɽ쥯饹Ǥ
   Υ饹Socket򥪡ץ󤹤ϤǤޤ󤬡ץѤΥå
   򥢥åꡢUssServerSocket Ȥäƥ饤Ȥ³
   դΤ˻Ȥޤ


   UssClientSocket, UssServerSocketʤɤζŪʷѾ饹
   ۤƤ
 */
class UssSocket : public UssFileDescriptor
{
public:
  /**
     Socket ֥Ȥۤޤ

     ˥ץ󤵤Ƥ륽åȤꤷơۤƱ˥å
     ǤޤǥեȤǤ -1(åʤ)Ǥ
     
     @param fd  ˥ץ󤵤Ƥ륽å
   */
  UssSocket(int fd = -1) : UssFileDescriptor(fd) { }



  /**
     Υ᥽åɤƤӽФȡ EUssBadOperation㳰
     ȯޤ
  */
  int open();
};




/**
   饤¦(ǽưץ¦)ΥåȤ򰷤ޤ
 */
class UssClientSocket : public UssSocket
{
public:
  /**
     ֥Ȥۤޤ
   */
  UssClientSocket() { }


  /**
     饤¦åȤ򥪡ץ(ǽưץ)ޤ

     @param host  ³Υۥ IP ɥ쥹ޤϥۥ̾
     @param port  ³Υݡֹ
     @param async Ʊ³true³λޤ
                  Ԥľfalse
     @return
     ³ˤϥ֥Ȥ˥å줿
     եǥץᤵޤ
     ̵ -1 ᤵޤ

     顼(ۥ̾Ǥʤ)ˤEUssOSErrorޤ
  */
  int open(char const* host, int port, bool async=false);



  /**
     饤¦åȤ򥪡ץ(ǽưץ)ޤ

     @param addr  ³γǼ줿 sockaddr_in ¤
     @param async Ʊ³true³λޤ
                  Ԥľfalse
     @return
     ³ˤϥ֥Ȥ˥å줿
     եǥץᤵޤ

     顼ˤEUssOSError 㳰ޤ
     ޤconnect ॢȤޤǥ֥åޤ
  */
  int open(sockaddr_in& addr, bool async);
};



/**
   ¦(ưץ¦)ΥåȤ򰷤ޤ
 */
class UssServerSocket : public UssSocket
{
public:
  /**
     ֥Ȥۤޤ
   */
  UssServerSocket() { }

  /**
     ¦åȤ򥪡ץ󤷡ꤵ줿ݡȤlistenޤ

     @param port        listenݡ
     @param allowfrom   ³ǽʥۥ
     @param backlog     Хåο

     @return bind,linsten ˤϡå줿ե
             ǥץᤵޤ

             顼ˤϡEUssOSError 㳰ޤ

             open Ǥϥ饤Ȥ³줿ˤϤʤޤ
              accept ɬפޤ
   */
  int open(int port, long allowfrom = INADDR_ANY, int backlog = 5);


  /**
     ³ԵΥ饤ȤȤ³Ωޤ

     @param sock   ºݤ³˻Ѥ UssSocket ֥

     @return ³ˤ sock ˥å줿ե
             ǥץᤵޤ
             顼ˤϡEUssOSError 㳰ޤ
   */
  virtual int accept(UssSocket* sock);
};

#endif


