// -*- mode:c++; indent-tabs-moe:nil; tab-width:2; -*-
// $Id: UssStackTracer.h,v 1.3 2001/09/10 13:55:22 seagull Exp $
//
// åȥ졼
//

#if !defined(H_USS_STACKTRACER)
#define H_USS_STACKTRACER

#include <stdio.h>



/**
   ƤӽФåΥȥ졼Ԥ٤Υޡ֥ȡ

   ȥ졼ݥȤ֤֥åǥ֥Ȥ
   ưѿȤƺƤ
   ｪλϡ֥åȴ leave ᥽å
   ƤӽФƤ

   leave ᥽åɤƤӽФ˥ǥȥ饯ƤӽФ줿
   (㳰)ˡۻ˻ꤷʸ,եֹ̾
   ꤷȥ꡼˽Ϥޤ

   㤨,
   \code
   int foo()
   {
     UssStackTracer stracer("foo()", __FILE__, __LINE__);

     if (...)
       throw ...

     stracer.leave();
   }
   \endcode

   ͤ˻Ѥ㳰ȯ leave ƤФ줺˥ǥȥ饯
   ƤӽФȥȥ꡼(ǥեȤǤɸ२顼)˥å
   Ϥޤ
 */
class UssStackTracer
{
public:
  /**
     ȥ졼֥Ȥۤޤ

     @param desc   Ϥ˻Ѥɽ̾̾ϴؿ̾
     @param fname  Ϥ˻Ѥե̾̾ __FILE__
     @param n      Ϥ˻Ѥֹ档̾ __LINE__
   */
  UssStackTracer(char const* desc,
                 char const* fname=UssStackTracer::unknown,
                 int n=-1);
  virtual ~UssStackTracer();



  /**
     ۻ˻ꤵ줿ɽʸޤ

     @return ɽʸؤΥݥ
   */
  char const* getDescription() const 
  {
    return description;
  }

  /**
     Υ֥Ȥ˴Ƥ⹽ʤ褦ˤʤäؼޤ
   */
  void leave()
  {
    leaved = true;
  }


  static void print();


  /**
     ȥ졼Ϥνꤷޤ
   */
  static void setStream(FILE* fp)
  {
    outfp = fp;
  }
  

  /**
     ۻ˻ꤵ줿ե̾ޤ
     @return ե̾ؤΥݥ
   */
  char const* getFilename() const { return filename; }

  /**
     ۻ˻ꤵ줿ֹ档
     @return ֹ
   */
  int getLineno() const { return lineno; }


protected:
  /**
     ۻ˻ꤵ줿 description ǽϤޤ
   */
  void printDescription()
  {
    fprintf(outfp,
            "UssStackTrace: %s in file %s line %d\n",
            description, filename, lineno);
  }
  

protected:
  char const* filename;    ///< ۻ˻ꤵ줿ե̾ؤΥݥ
  int lineno;              ///< ۻ˻ꤵ줿ֹ
  char const* description; ///< ۻ˻ꤵ줿ɽʸ
  UssStackTracer* previous; ///< ľ˺줿 UssStackTracer ֥
  bool leaved; ///< ۻ false ǽ졢 leave ƤӽФ true ˤʤ롣

  static UssStackTracer* top;
  static FILE* outfp;
  static char const unknown[];
};


#endif

