// -*- mode:c++;indent-tabs-mode:nil;tab-width:2; -*-
//
// $Id: UssStateMachine.h,v 1.4 2001/07/23 11:18:18 seagull Exp $
//

#if !defined(USS_H_StateMachine)
#define USS_H_StateMachine

class IUssStateMachine
{
public:
  IUssStateMachine()
  {
  }

  virtual ~IUssStateMachine()
  {
  }

  unsigned int getState() const
  {
    return m_nState;
  }
  void setState(unsigned int state)
  {
    if (state != m_nState)
    {
      onStateLeave();
      m_nState = state;
      onStateEnter();
    }
  }

  virtual void onStateLeave() = 0;
  virtual void onStateEnter() = 0;

  virtual void onEvent(unsigned int event)
  {
  }

protected:
  unsigned int m_nState;
};


#endif
