// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssTimerEvent.h,v 1.8 2001/09/10 13:55:22 seagull Exp $
//

#if !defined(USS_H_TimerEvent)
#define USS_H_TimerEvent


#include <sys/time.h>

#include <list>

/**
   ޥ٥ȥ֥ȡ

   UssTimerEventMonitor˴ϢդƻѤޤ
 */
class UssTimerEvent
{
public:
  enum timerstate_t
    {
      TE_STOP = 0,   ///< 
      TE_TIMER = 1,  ///< ñȯ
      TE_CYCLE = 2,  ///< (ֳ)
      TE_CLOCK = 3   ///< ()
    };

  /**
     ޥ٥ȥ֥Ȥۤޤ

     ֤ϥƥ५򸵤˷׻Τǡư˻碌
     ȯȥ󥿡ХͤΤˤʤޤ

     @param interval   󥿡Хͤߥñ̤ǻꤷޤ
     @param type       ޤ¨˳Ϥˡޤμ
                       ꤷޤ
   */
  UssTimerEvent()
  {
    m_nInterval = 0;
    m_state = TE_STOP;
  }
  UssTimerEvent(int interval)
  {
    m_nInterval = interval;
    m_state = TE_STOP;
  }
  UssTimerEvent(timerstate_t type, int interval)
  {
    start(type, interval);
  }

  /**
     󥿡Хͤꤷޤ

     Ǥ˳ϤƤ륿ޤˤϱƶڤܤޤ
     ǳϤƤˤϡΥॢåװʹ
     ˤꤷͤαƶޤ

     @param interval   󥿡Хͤߥñ̤ǻꤷޤ
   */
  void setInterval(int interval)
  {
    m_nInterval = interval;
  }

  /**
     󥿡Хͤޤ
     @return ꤵƤ륤󥿡Х͡(ߥ)
   */
  int getInterval() const
  {
    return m_nInterval;
  }


  /**
     ޤ򳫻Ϥޤ
     Ǥ˳ϤƤϡߤλ򸵤˺Ƶưޤ

     @PARAM cycle    true ꤹȼޤˤʤޤ
     @PARAM interval 󥿡Х(ߥ)ʲꤹȡ
                     ۻ˻ꤷͤѤޤ
   */
  void start(timerstate_t type, int interval = -1);



  /**
     ٥Ȥȥꥬ˸ƤӽФޤ
   */
  virtual void onTimerSignal() = 0;

  /**
     ٥ȤȥꥬɤơonTimerSignal
     ƤӽФޤ
     Ū˸ƤӽФɬפޤUssTimerEventMonitor
     ȤäƤˤϡUssTimerEventMonitor::pump()
     ƤӽФǤޤȤƽޤ
   */
  virtual void pump();

  

  /**
     ޤθߤξ֤ᤷޤ
   */
  timerstate_t getCycle() const
  {
    return m_state;
  }

  /**
     ׻ꤷޤ

     @param tv     ꤹ
   */
  void setStarting(timeval const& tv)
  {
    setStarting(tv.tv_sec, tv.tv_usec);
  }
  void setStarting(long sec, long usec)
  {
    m_starttime.tv_sec = sec;
    m_starttime.tv_usec = usec;
  }

  /**
     ׻ޤ

     @return 
   */
  timeval const& getStarting() const
  {
    return m_starttime;
  }


protected:
  int m_nInterval;
  timerstate_t m_state;

  timeval m_starttime;   // ׻
  timeval m_timeuptime;  // ॢåͽ
};






/**
  ٥ȥȥꥬˡǤդΥ֥ȤΥ᥽åɤƤӽФ
  ޡ٥ȡ
*/
template <class T>
class UssCallbackTimerEvent : public UssTimerEvent
{
public:
  UssCallbackTimerEvent(T* obj, void (T::*proc)(UssTimerEvent*))
    : UssTimerEvent()
  {
    setProc(obj, proc);
  }
  UssCallbackTimerEvent(T* obj, void (T::*proc)(UssTimerEvent*), int interval) : UssTimerEvent(interval)
  {
    setProc(obj, proc);
  }
  UssCallbackTimerEvent(T* obj, void (T::*proc)(UssTimerEvent*), timerstate_t type, int interval)
    : UssTimerEvent(type, interval)
  {
    setProc(obj, proc);
  }



  /**
     ȥꥬ줿Ȥ˸ƤӽФ륪֥Ȥȥ᥽åɤꤷޤ
     
     @param obj   оݤΥ֥
     @param proc  ƤӽФ᥽å
   */
  void setProc(T* obj, void (T::*proc)(UssTimerEvent*))
  {
    m_obj = obj;
    m_proc = proc;
  }



  void onTimerSignal()
  {
    (m_obj->*m_proc)(this);
  }

protected:
  T* m_obj;
  void (T::*m_proc)(UssTimerEvent*);
};





/**
   ʣΥޥ٥Ȥ륳ƥʥ饹
 */
class UssTimerEventMonitor
{
public:
  UssTimerEventMonitor();
  ~UssTimerEventMonitor();

  //
  // ޥ٥Ȥݥפޤ
  //
  void pump();


  // ٥ȤϿޤ
  template <typename T>
  void add(T* p)
  {
    m_events.push_back(p);
  }

  // ٥Ȥޤ
  void remove(UssTimerEvent* p)
  {
    m_events.remove(p);
  }


protected:
  list<UssTimerEvent*> m_events;
};


#endif

