// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// 1. еǽΥƥ
//   a) Ϥ򤽤Τޤޥ
//   b) Ϥ stdout ؽϤ
//   c) Ϣ³̵֤̿ˤ뼫ư
//
// $Id: test0003.cpp,v 1.4 2001/07/10 10:15:28 seagull Exp $
//
#include <stdio.h>
#include "UssSocket.h"
#include "UssConnectionMonitor.h"
#include "UssIOBuffer.h"

class EchoClient :
  public TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Direct, UssIOBuffer_Ring>
{
public:

  void init(UssServerSocketConnectionEvent* server)
  {
    getOBuffer()->init(1024);
    setAutoDisconnectTimer(30000);
  }

  virtual void onReadSignal()
  {
    // ϤϥХåեؼǡ褦ˤޤ
    if (getOBuffer()->fetch() == 0)
      onDisconnectSignal();
  }


  virtual void onDisconnectSignal()
  {
    TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Direct, UssIOBuffer_Ring>::onDisconnectSignal();

    fprintf(stderr, "Disconnected from client.\n");
    getIBuffer()->reset();
    getOBuffer()->reset();
  }

  virtual void onConnectSignal()
  {
    TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Direct, UssIOBuffer_Ring>::onConnectSignal();
    fprintf(stderr, "Connected from client.\n");
  }
};


class NullClient : 
  public TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Ring, UssIOBuffer_Null>
{
public:
  void init(UssServerSocketConnectionEvent* server)
  {
    getIBuffer()->init(1024);
//    setAutoDisconnectTimer(5000);
  }



  virtual void onReadSignal()
  {
    TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Ring, UssIOBuffer_Null>::onReadSignal();
    char buf[1024];
    int n = getIBuffer()->read(buf, 1023);
    if (n > 0)
      {
        buf[n] = '\0';
        printf("%d: %s", n, buf);
      }
  }

  virtual void onDisconnectSignal()
  {
    TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Ring, UssIOBuffer_Null>::onDisconnectSignal();

    fprintf(stderr, "Disconnected from client.\n");
    getIBuffer()->reset();
    getOBuffer()->reset();
  }

  virtual void onConnectSignal()
  {
    TIUssBufferedConnectionEvent<UssSocket, UssIOBuffer_Ring, UssIOBuffer_Null>::onConnectSignal();
    fprintf(stderr, "Connected from client.\n");
  }
};



int main(int argc, char* argv[])
{
  if (argc < 2)
    return 0;


  UssConnectionMonitor mon;
  try
    {
      UssServerSocketConnectionEvent server1(atoi(argv[1]));
      server1.makePool<EchoClient>(5);
      UssServerSocketConnectionEvent server2(atoi(argv[1]) + 1);
      server2.makePool<NullClient>(5);

      mon.addServer(&server1);
      mon.addServer(&server2);

      for (;;)
        mon.WaitForEvent();

    }
  catch (EUssException* e)
    {
      e->report();
      delete e;
      return 0;
    }
  
  return 0;
}
