/************************************************************
* Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include <stdio.h>

#include <wiiremote.h>
#include <wiiremote_utils.h>

#include "say_wiiremote_WiiRemote.h"

static
WRMT_WiiRemote *
GetNativeWiiRemoteFrom(JNIEnv *env, jobject wiiRemote)
{
	WRMT_WiiRemote *nativeWiiRemote;
	jclass clazz;
	jfieldID fid;
	jint deviceIndex;

	/* deviceIndex = this.deviceIndex */
	clazz = (*env)->GetObjectClass(env, wiiRemote);
	fid = (*env)->GetFieldID(env, clazz, "deviceIndex", "I");
	deviceIndex= (*env)->GetIntField(env, wiiRemote, fid);

	nativeWiiRemote = WRMT_GetWiiRemoteAt(deviceIndex);

	return nativeWiiRemote;
}


/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_init
  (JNIEnv *env, jclass clazz)
{
	int rc;

	rc = WRMT_Init();
	if (rc != 0)
	{
		jclass exceptionClazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, exceptionClazz, "WRMT_Init() failed.");
	}

	return ;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    quit
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_quit
  (JNIEnv *env, jclass clazz)
{
	WRMT_Quit();
	return ;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    update
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_updateAll
  (JNIEnv *env, jclass clazz)
{
	int rc;

	rc = WRMT_UpdateAll();
	if (rc == WRMT_IO_ERROR)
	{
		/* FIXME : check message */
		jclass exceptionClazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, exceptionClazz, "WRMT_Update() failed.");
	}

	return ;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    poll
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_say_wiiremote_WiiRemote_poll
  (JNIEnv *env, jclass clazz)
{
	jint result = 0;

	result = WRMT_Poll();
	if (result == WRMT_IO_ERROR)
	{
		/* FIXME : check message */
		jclass exceptionClazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, exceptionClazz, "WRMT_Poll() failed.");
	}

	return result;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    getNumWiiRemote
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_say_wiiremote_WiiRemote_getNumWiiRemote
  (JNIEnv *env, jclass clazz)
{
	jint result = 0;

	result = WRMT_GetNumWiiRemote();

	return result;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    getWiiRemoteAt
 * Signature: (I)Lsay/wiiremote/WiiRemote
* {
* }
 */
JNIEXPORT jobject JNICALL Java_say_wiiremote_WiiRemote_getWiiRemoteAt
  (JNIEnv *env, jclass clazz, jint deviceIndex)
{
	jobject result = NULL; 
	int number;
	jobject wiiremotes;
	jfieldID fid;

	/* check deviceIndex range */
	number = WRMT_GetNumWiiRemote();
	if (deviceIndex < 0 || deviceIndex >= WRMT_GetNumWiiRemote())
	{
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "deviceIndex is out of bound.");
		return NULL;
	}

	/* wiiremotes = WiiRemote.WIIREMOTES; */
	fid = (*env)->GetStaticFieldID(env, clazz, "WIIREMOTES", "[Lsay/wiiremote/WiiRemote;");
	wiiremotes = (*env)->GetStaticObjectField(env, clazz, fid);

	/* result = wiiremotes[deviceIndex]; */
	result = (*env)->GetObjectArrayElement(env, wiiremotes, deviceIndex);

	return result;
}


/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    open
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_open
  (JNIEnv *env, jobject this)
{
	WRMT_WiiRemote *nativeWiiRemote;
	WRMT_IOReturn rc;

	nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);

	/* open */
	rc = WRMT_WiiRemote_Open(nativeWiiRemote);
	if (rc != WRMT_IO_SUCCESS)
	{
		/* FIXME : message*/
		jclass exceptionClazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, exceptionClazz, "WRMT_WiiRemote_Open() failed.");
	}
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    isOpened
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_say_wiiremote_WiiRemote_isOpened
  (JNIEnv *env, jobject this)
{
	jboolean result = JNI_FALSE;
	WRMT_WiiRemote *nativeWiiRemote;

	nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
	if (WRMT_WiiRemote_IsOpened(nativeWiiRemote))
	{
		result = JNI_TRUE;
	}

	return result;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    close
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_close
  (JNIEnv *env, jobject this)
{
	WRMT_WiiRemote *nativeWiiRemote;

	nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
	WRMT_WiiRemote_Close(nativeWiiRemote);

	return ;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    update
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_update
  (JNIEnv *env, jobject this)
{
	WRMT_WiiRemote *nativeWiiRemote;
	WRMT_IOReturn rc;

	nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
	rc = WRMT_WiiRemote_Update(nativeWiiRemote);
	if (rc != WRMT_IO_SUCCESS)
	{
		/* FIXME : message*/
		jclass exceptionClazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, exceptionClazz, "WRMT_WiiRemote_Update() failed.");
	}

	return ;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    isEnabled
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_say_wiiremote_WiiRemote_isEnabled
  (JNIEnv *env, jobject this, jint functionType)
{
	jboolean result = JNI_FALSE;

	if (functionType < 0 || functionType >= WRMT_NUMBER_OF_FUNCTIONS)
	{
		/* FIXME : message*/
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "functionType is out of bound.");
	}
	else
	{
		WRMT_WiiRemote *nativeWiiRemote;

		nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
		if (WRMT_WiiRemote_IsEnabled(nativeWiiRemote, functionType))
		{
			result = JNI_TRUE;
		}
	}

	return result;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    setEnabled
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_setEnabled
  (JNIEnv *env, jobject this, jint functionType, jboolean value)
{
	if (functionType < 0 || functionType >= WRMT_NUMBER_OF_FUNCTIONS)
	{
		/* FIXME : message*/
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "functionType is out of bound.");
	}
	else
	{
		WRMT_WiiRemote *nativeWiiRemote;

		nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
		WRMT_WiiRemote_SetEnabled(nativeWiiRemote, functionType, value);
	}
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    getState
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_say_wiiremote_WiiRemote_getState
  (JNIEnv *env, jobject this, jint dataType)
{
	jint result = 0;

	if (dataType < 0 || dataType >= WRMT_NUMBER_OF_DATA_TYPE)
	{
		/* FIXME : message*/
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "dataType is out of bound.");
	}
	else
	{
		WRMT_WiiRemote *nativeWiiRemote;

		nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
		result = WRMT_WiiRemote_GetState(nativeWiiRemote, dataType);
	}

	return result;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    setState
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_setState
  (JNIEnv *env, jobject this, jint dataType, jint value)
{
	if (dataType < 0 || dataType > WRMT_DATA_SPEAKER_SAMPLE_RATE)
	{
		/* FIXME : check message */
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "dataType is out of bound.");
	}
	else
	{
		WRMT_WiiRemote *nativeWiiRemote;

		nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
		WRMT_WiiRemote_SetState(nativeWiiRemote, dataType, value);
	}
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    playSound
 * Signature: ([BII)V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_playSound
  (JNIEnv *env, jobject this, jbyteArray data, jint offset, jint length)
{
	jint dataLength;
	jbyte *dataPtr;
	WRMT_IOReturn rc;
	WRMT_WiiRemote *nativeWiiRemote;

	dataLength = (*env)->GetArrayLength(env, data);

	if (offset < 0 || offset >= dataLength)
	{
		/* FIXME : check message */
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "offset parameter is out of bound.");
	}

	if (length <= 0)
	{
		/* FIXME : check message */
		jclass exceptionClazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		(*env)->ThrowNew(env, exceptionClazz, "length parameter must be positive number.");
	}

	if (offset + length > dataLength)
	{
		length = dataLength - offset;
	}

	dataPtr = (*env)->GetByteArrayElements(env, data, NULL);
	nativeWiiRemote = GetNativeWiiRemoteFrom(env, this);
	rc = WRMT_WiiRemote_PlaySound(nativeWiiRemote, ((unsigned char *)dataPtr+offset), length);
	if (rc != WRMT_IO_SUCCESS)
	{
		(*env)->ReleaseByteArrayElements(env, data, dataPtr, JNI_ABORT); 
		/* FIXME : check message */
		jclass exceptionClazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, exceptionClazz, "WRMT_WiiRemote_PlaySound() Failed.");
	}

	(*env)->ReleaseByteArrayElements(env, data, dataPtr, JNI_ABORT); 

	return ;
}

/*
 * Class:     say_wiiremote_WiiRemote
 * Method:    writeDataToMemory
 * Signature: (I[BI)V
 */
JNIEXPORT void JNICALL Java_say_wiiremote_WiiRemote_writeDataToMemory
  (JNIEnv *env, jobject this, jint address, jbyteArray data, jint dataSize)
{
}

