



# Conditionals
# Invoke "rpmbuild --without <feature>" or "rpmbuild --with <feature>"
# to disable or enable specific features
%bcond_with testagents
%bcond_with watchdog
%bcond_with monitoring
%bcond_with snmp
%bcond_with dbus
%bcond_with rdma
%bcond_with runautogen

Name: corosync
Summary: The Corosync Cluster Engine and Application Programming Interfaces
Version: 1.4.6
Release: 1%{?numcomm:.%{numcomm}}%{?alphatag:.%{alphatag}}%{?dirty:.%{dirty}}%{?dist}
License: BSD
Group: System Environment/Base
URL: http://ftp.corosync.org
Source0: ftp://ftp:user@ftp.corosync.org/downloads/%{name}-%{version}/%{name}-%{version}%{?numcomm:.%{numcomm}}%{?alphatag:-%{alphatag}}%{?dirty:-%{dirty}}.tar.gz

# Runtime bits
Requires: corosynclib = %{version}-%{release}
Requires(pre): /usr/sbin/useradd
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Conflicts: openais <= 0.89, openais-devel <= 0.89

# Build bits

%if %{with runautogen}
BuildRequires: autoconf automake
%endif
BuildRequires: nss-devel
%if %{with rdma}
BuildRequires: libibverbs-devel librdmacm-devel
%endif
%if %{with snmp}
BuildRequires: net-snmp-devel
%endif
%if %{with dbus}
BuildRequires: dbus-devel
%endif

BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

%prep
%setup -q -n %{name}-%{version}%{?numcomm:.%{numcomm}}%{?alphatag:-%{alphatag}}%{?dirty:-%{dirty}}

%build
%if %{with runautogen}
./autogen.sh
%endif

%if %{with rdma}
export ibverbs_CFLAGS=-I/usr/include/infiniband \
export ibverbs_LIBS=-libverbs \
export rdmacm_CFLAGS=-I/usr/include/rdma \
export rdmacm_LIBS=-lrdmacm \
%endif
%{configure} \
	--enable-nss \
%if %{with testagents}
	--enable-testagents \
%endif
%if %{with watchdog}
	--enable-watchdog \
%endif
%if %{with monitoring}
	--enable-monitoring \
%endif
%if %{with snmp}
	--enable-snmp \
%endif
%if %{with dbus}
	--enable-dbus \
%endif
%if %{with rdma}
	--enable-rdma \
%endif
	--with-initddir=%{_initrddir}

make %{_smp_mflags}

%install
rm -rf %{buildroot}

make install DESTDIR=%{buildroot}

%if %{with dbus}
mkdir -p -m 0700 %{buildroot}/%{_sysconfdir}/dbus-1/system.d
install -m 644 %{_builddir}/%{name}-%{version}/conf/corosync-signals.conf %{buildroot}/%{_sysconfdir}/dbus-1/system.d/corosync-signals.conf
%endif

## tree fixup
# drop static libs
rm -f %{buildroot}%{_libdir}/*.a
# drop docs and html docs for now
rm -rf %{buildroot}%{_docdir}/*
# /etc/sysconfig/corosync-notifyd
mkdir -p %{buildroot}%{_sysconfdir}/sysconfig
install -m 644 tools/corosync-notifyd.sysconfig.example \
   %{buildroot}%{_sysconfdir}/sysconfig/corosync-notifyd

%clean
rm -rf %{buildroot}

%description
This package contains the Corosync Cluster Engine Executive, several default
APIs and libraries, default configuration files, and an init script.

%post
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add corosync || :
fi

%preun
if [ $1 -eq 0 ]; then
	/sbin/service corosync stop &>/dev/null || :
	/sbin/chkconfig --del corosync || :
fi

%files
%defattr(-,root,root,-)
%doc LICENSE SECURITY
%{_bindir}/corosync-blackbox
%{_sbindir}/corosync
%{_sbindir}/corosync-keygen
%{_sbindir}/corosync-objctl
%{_sbindir}/corosync-cfgtool
%{_sbindir}/corosync-fplay
%{_sbindir}/corosync-pload
%{_sbindir}/corosync-cpgtool
%{_sbindir}/corosync-quorumtool
%{_sbindir}/corosync-notifyd
%dir %{_sysconfdir}/corosync
%dir %{_sysconfdir}/corosync/service.d
%dir %{_sysconfdir}/corosync/uidgid.d
%config(noreplace) %{_sysconfdir}/corosync/corosync.conf.example
%config(noreplace) %{_sysconfdir}/corosync/corosync.conf.example.udpu
%config(noreplace) %{_sysconfdir}/sysconfig/corosync-notifyd
%if %{with dbus}
%{_sysconfdir}/dbus-1/system.d/corosync-signals.conf
%endif
%if %{with snmp}
%{_datadir}/snmp/mibs/COROSYNC-MIB.txt
%endif
%{_initrddir}/corosync
%{_initrddir}/corosync-notifyd
%dir %{_libexecdir}/lcrso
%{_libexecdir}/lcrso/coroparse.lcrso
%{_libexecdir}/lcrso/objdb.lcrso
%{_libexecdir}/lcrso/service_cfg.lcrso
%{_libexecdir}/lcrso/service_cpg.lcrso
%{_libexecdir}/lcrso/service_evs.lcrso
%{_libexecdir}/lcrso/service_confdb.lcrso
%{_libexecdir}/lcrso/service_pload.lcrso
%{_libexecdir}/lcrso/quorum_votequorum.lcrso
%{_libexecdir}/lcrso/quorum_testquorum.lcrso
%{_libexecdir}/lcrso/vsf_quorum.lcrso
%{_libexecdir}/lcrso/vsf_ykd.lcrso
%dir %{_localstatedir}/lib/corosync
%dir %{_localstatedir}/log/cluster
%{_mandir}/man8/corosync_overview.8*
%{_mandir}/man8/corosync.8*
%{_mandir}/man8/corosync-blackbox.8*
%{_mandir}/man8/corosync-objctl.8*
%{_mandir}/man8/corosync-keygen.8*
%{_mandir}/man8/corosync-cfgtool.8*
%{_mandir}/man8/corosync-cpgtool.8*
%{_mandir}/man8/corosync-fplay.8*
%{_mandir}/man8/corosync-pload.8*
%{_mandir}/man8/corosync-notifyd.8*
%{_mandir}/man8/corosync-quorumtool.8*
%{_mandir}/man5/corosync.conf.5*
%{_mandir}/man8/confdb_keys.8*

%package -n corosynclib
Summary: The Corosync Cluster Engine Libraries
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description -n corosynclib
This package contains corosync libraries.

%files -n corosynclib
%defattr(-,root,root,-)
%doc LICENSE
%{_libdir}/libcfg.so.*
%{_libdir}/libcpg.so.*
%{_libdir}/libconfdb.so.*
%{_libdir}/libevs.so.*
%{_libdir}/libtotem_pg.so.*
%{_libdir}/liblogsys.so.*
%{_libdir}/libcoroipcc.so.*
%{_libdir}/libcoroipcs.so.*
%{_libdir}/libquorum.so.*
%{_libdir}/libvotequorum.so.*
%{_libdir}/libpload.so.*
%{_libdir}/libsam.so.*

%post -n corosynclib -p /sbin/ldconfig

%postun -n corosynclib -p /sbin/ldconfig

%package -n corosynclib-devel
Summary: The Corosync Cluster Engine Development Kit
Group: Development/Libraries
Requires: corosynclib = %{version}-%{release}
Requires: pkgconfig
Provides: corosync-devel = %{version}
Obsoletes: corosync-devel < 0.92-7

%description -n corosynclib-devel
This package contains include files and man pages used to develop using
The Corosync Cluster Engine APIs.

%files -n corosynclib-devel
%defattr(-,root,root,-)
%doc LICENSE README.devmap
%dir %{_includedir}/corosync/
%{_includedir}/corosync/cs_config.h
%{_includedir}/corosync/corodefs.h
%{_includedir}/corosync/coroipc_types.h
%{_includedir}/corosync/coroipcs.h
%{_includedir}/corosync/coroipcc.h
%{_includedir}/corosync/cfg.h
%{_includedir}/corosync/confdb.h
%{_includedir}/corosync/corotypes.h
%{_includedir}/corosync/cpg.h
%{_includedir}/corosync/evs.h
%{_includedir}/corosync/hdb.h
%{_includedir}/corosync/list.h
%{_includedir}/corosync/mar_gen.h
%{_includedir}/corosync/sam.h
%{_includedir}/corosync/swab.h
%{_includedir}/corosync/quorum.h
%{_includedir}/corosync/votequorum.h
%dir %{_includedir}/corosync/totem/
%{_includedir}/corosync/totem/coropoll.h
%{_includedir}/corosync/totem/totem.h
%{_includedir}/corosync/totem/totemip.h
%{_includedir}/corosync/totem/totempg.h
%dir %{_includedir}/corosync/lcr/
%{_includedir}/corosync/lcr/lcr_ckpt.h
%{_includedir}/corosync/lcr/lcr_comp.h
%{_includedir}/corosync/lcr/lcr_ifact.h
%dir %{_includedir}/corosync/engine
%{_includedir}/corosync/engine/config.h
%{_includedir}/corosync/engine/coroapi.h
%{_includedir}/corosync/engine/logsys.h
%{_includedir}/corosync/engine/objdb.h
%{_includedir}/corosync/engine/quorum.h
%{_libdir}/libcfg.so
%{_libdir}/libcpg.so
%{_libdir}/libconfdb.so
%{_libdir}/libevs.so
%{_libdir}/libtotem_pg.so
%{_libdir}/liblogsys.so
%{_libdir}/libcoroipcc.so
%{_libdir}/libcoroipcs.so
%{_libdir}/libquorum.so
%{_libdir}/libvotequorum.so
%{_libdir}/libpload.so
%{_libdir}/libsam.so
%{_libdir}/pkgconfig/*.pc
%{_mandir}/man3/cpg_*3*
%{_mandir}/man3/evs_*3*
%{_mandir}/man3/confdb_*3*
%{_mandir}/man3/votequorum_*3*
%{_mandir}/man3/sam_*3*
%{_mandir}/man8/cpg_overview.8*
%{_mandir}/man8/evs_overview.8*
%{_mandir}/man8/confdb_overview.8*
%{_mandir}/man8/logsys_overview.8*
%{_mandir}/man8/votequorum_overview.8*
%{_mandir}/man8/coroipc_overview.8*
%{_mandir}/man8/sam_overview.8*

%changelog
* Mon Dec 23 2013 Autotools generated version <nobody@nowhere.org> - 1.4.6-1-@numcomm@.@alphatag@.
- Autotools generated version
