#!perl

use Test::More tests => 48;

BEGIN {
  require "t/common.pl";
  start_server();
}

$ldap = client();
if (!$ldap) {
  die "can't contact ldap server";
}

$mesg = $ldap->bind($MANAGERDN, password => $PASSWD);

if($mesg->code) {
  die "can't bind: ".$mesg->error;
}

ldif_populate($ldap, "data/00-in.ldif");

# Add
$mesg = $ldap->search(base => $BASEDN, filter => 'objectClass=*');
compare_ldif("0001",$mesg,$mesg->sorted);


$dn = "uid=user0001,ou=Tech,ou=IT,ou=People,$MASTERDN";

# Modify
$mesg = $ldap->modify($dn, replace => {'mail' => 'user0001@lism.org'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0002",$mesg,$mesg->sorted);

$mesg = $ldap->modify("uid=user0005,ou=Tech,ou=Machine,ou=People,$MASTERDN", add => {'mail' => 'user0005@lism.org'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0005');
compare_ldif("0003",$mesg,$mesg->sorted);

$mesg = $ldap->modify("uid=user0005,ou=Tech,ou=Machine,ou=People,$MASTERDN", delete => {'mail' => 'user0005@lism.org'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0005');
compare_ldif("0004",$mesg,$mesg->sorted);


# Rewrite
# test move to 12rewrite-handler.t
#ok(!compare("$TESTCSV/group.csv","data/0005-cmp.csv"), "data/0005-cmp.csv");
ok(1);

# Sync Information
## Synchronization
$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0006",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});

$mesg = $ldap->search(base => $BASEDN, filter => '(|(uid=user0001)(uid=user0004))');
compare_ldif("0007",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0008",$mesg,$mesg->sorted);

## Add entry
ldif_populate($ldap, "data/0009-in.ldif");

# master sync
$mesg = $ldap->search(base => "cn=master-sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0009",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=master-sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});

$mesg = $ldap->search(base => $BASEDN, filter => '(|(uid=user0004)(|(uid=user0006)(uid=user0007)))');
compare_ldif("0010",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=master-sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0011",$mesg,$mesg->sorted);

# cluster sync
$mesg = $ldap->search(base => "cn=cluster-sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0012",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=cluster-sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});

$mesg = $ldap->search(base => $BASEDN, filter => '(|(uid=user0006)(uid=user0007))');
compare_ldif("0013",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=cluster-sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0014",$mesg,$mesg->sorted);

# Delete entry
$mesg = $ldap->delete("uid=user0002,ou=Tech,ou=IT,ou=People,$CSVDN");

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0015",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});

$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0002');
ok($mesg->count == 0, "delete uid=user0002");

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0017",$mesg,$mesg->sorted);

$mesg = $ldap->delete("uid=user0003,ou=Sales,ou=IT,ou=People,$SQLDN");

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0018",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});

$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0003');
compare_ldif("0019",$mesg,$mesg->sorted);

ldif_populate($ldap, "data/0020-in.ldif");

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0020",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=admin');
compare_ldif("0021",$mesg,$mesg->sorted);

# Modify passowrd
$mesg = $ldap->modify("uid=user0001,ou=Tech,ou=IT,ou=People,$SQLDN", replace => {'userpassword' => 'sql0001'});

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0022",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", replace => {'lismSyncStatus' => 'sync'});

$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0023",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0024",$mesg,$mesg->sorted);

# synchronize specified data
ldif_populate($ldap, "data/0025-in.ldif");

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'lismSyncWrongNode=CSV' , scope => 'base');
compare_ldif("0025",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'lismSyncWrongNode=SQL' , scope => 'base');
compare_ldif("0026",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", delete => {'lismSyncWrongNode' => 'CSV'});

$mesg = $ldap->search(base => $BASEDN, filter => '(uid=user0001)');
compare_ldif("0027",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0028",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=sync,$BASEDN", delete => {'lismSyncWrongNode' => 'SQL'});

$mesg = $ldap->search(base => $BASEDN, filter => '(uid=user0004)');
compare_ldif("0029",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => "cn=sync,$BASEDN", filter => 'objectClass=*' , scope => 'base');
compare_ldif("0030",$mesg,$mesg->sorted);

# syncfail log
# Add
ldif_populate($ldap, "data/0031-in.ldif");

$mesg = $ldap->delete("uid=user0008,ou=Tech,ou=IT,ou=people,$CSVDN");
# Modify
$mesg = $ldap->modify("uid=user0008,ou=Tech,ou=IT,ou=people,$MASTERDN",
                      add => {'telephoneNumber' => '01-2345-6789'},
                      replace => {'userPassword' => 'passwd0008',
                                  'mail' => 'user0008@lism.org'});

# Delete
$mesg = $ldap->delete("uid=user0008,ou=Tech,ou=IT,ou=people,$MASTERDN");

ok(!compare_log("$TEMPDIR/syncfail-CSV.log", "data/0031-cmp.log"), "data/0031-cmp.log");

# Cluster
$mesg = $ldap->search(base => "cn=cluster,$BASEDN", filter => 'objectClass=*', scope => 'base');
compare_ldif("0032",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=cluster,$BASEDN", delete => {'lismClusterActive' => 'SQL'});
$mesg = $ldap->modify("uid=user0001,ou=Tech,ou=IT,ou=People,$MASTERDN", replace => {'mail' => 'user0001@lism.org'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0033",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=cluster,$BASEDN", add => {'lismClusterActive' => 'SQL'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0034",$mesg,$mesg->sorted);

# Failover and Failback
$mesg = $ldap->modify("cn=cluster,$BASEDN", delete => {'lismClusterActive' => 'LDAP'});
$mesg = $ldap->search(base => "cn=cluster,$BASEDN", filter => 'objectClass=*', scope => 'base');
compare_ldif("0035",$mesg,$mesg->sorted);

$mesg = $ldap->modify("uid=user0001,ou=Tech,ou=IT,ou=People,$MASTERDN", replace => {'mail' => 'user0001@lism.com'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0036",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=cluster,$BASEDN", add => {'lismClusterActive' => 'LDAP'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0037",$mesg,$mesg->sorted);

$mesg = $ldap->modify("uid=user0001,ou=Tech,ou=IT,ou=People,$MASTERDN", replace => {'mail' => 'user0001@lism.org'});
$mesg = $ldap->search(base => $BASEDN, filter => 'uid=user0001');
compare_ldif("0038",$mesg,$mesg->sorted);

# Access rule
ldif_populate($ldap, "data/0039-in.ldif");

$mesg = $ldap->bind("uid=user0009,ou=Tech,ou=IT,ou=People,$LDAPDN", password => 'user0009');
$mesg = $ldap->modify("uid=wuser0001,ou=Tech,ou=IT,ou=People,$LDAPDN", replace => {'mail' => 'wuser0001@lism.org'});
$mesg = $ldap->search(base => $LDAPDN, filter => 'uid=wuser0001');
compare_ldif("0039",$mesg,$mesg->sorted); 

$mesg = $ldap->bind("uid=wuser0001,ou=Tech,ou=IT,ou=People,$LDAPDN", password => 'wuser0001');
$mesg = $ldap->modify("uid=user0009,ou=Tech,ou=IT,ou=People,$LDAPDN", replace => {'mail' => 'user0009@lism.org'});
$mesg = $ldap->search(base => $LDAPDN, filter => 'uid=user0009');
compare_ldif("0040",$mesg,$mesg->sorted);

$mesg = $ldap->bind("uid=ruser0001,ou=Tech,ou=IT,ou=People,$LDAPDN", password => 'ruser0001');
$mesg = $ldap->modify("uid=ruser0001,ou=Tech,ou=IT,ou=People,$LDAPDN", replace => {'mail' => 'ruser0001@lism.org'});
$mesg = $ldap->search(base => $LDAPDN, filter => 'uid=ruser0001');
compare_ldif("0041",$mesg,$mesg->sorted);

$mesg = $ldap->search(base => $LDAPDN, filter => 'uid=*');
compare_ldif("0042",$mesg,$mesg->sorted);

$mesg = $ldap->bind("uid=wuser0001,ou=Tech,ou=IT,ou=People,$LDAPDN", password => 'wuser0001');
ldif_populate($ldap, "data/0043-in.ldif");
$mesg = $ldap->search(base => "ou=App,ou=Roles,$LDAPDN", filter => 'cn=*');
compare_ldif("0043",$mesg,$mesg->sorted);

$mesg = $ldap->modify("cn=Guest,ou=App,ou=Roles,$LDAPDN", replace => {'description' => 'Guest'});
ok($mesg->code == 50);

# Delete
$mesg = $ldap->bind($MANAGERDN, password => $PASSWD);
$mesg = $ldap->delete($dn);
$mesg = $ldap->search(base => $SQLDN, filter => 'uid=user0001');
ok($mesg->count == 0, "delete uid=user0001");

$mesg = $ldap->search(base => $LDAPDN, filter => 'uid=user0001');
ok($mesg->count == 0, "delete uid=user0001");

$mesg = $ldap->search(base => $CSVDN, filter => 'uid=user0001');
ok($mesg->count == 0, "delete uid=user0001");

# Reload configuration
open(CONF, "<$LISMCONF");
open(TMP, ">$TEMPDIR/lism.tmp");
while (<CONF>) {
    s/ou=LDAP/ou=LDAP2/g;
    print TMP $_;
}
close(CONF);
close(TMP);
rename("$TEMPDIR/lism.tmp", $LISMCONF);

$mesg = $ldap->modify("cn=config,$BASEDN", replace => {'lismConfigOperation' => 'reload'});
$mesg = $ldap->search(base => "ou=LDAP2,$BASEDN", filter => 'uid=*');
compare_ldif("0048",$mesg,$mesg->sorted);
