#!/usr/bin/perl
#
#  This code was developped by SECIOSS (http://www.secioss.co.jp/).
#
#                 Copyright (C) 2007 SECIOSS CORPORATION
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public License
#  as published by the Free Software Foundation.

use strict;
use Crypt::SmbHash;
use Data::Dumper;

sub smbPassword
{
    my ($pwdline) = @_;
    my ($attr, $passwd) = ($pwdline =~ /^([^:]+): (.*)$/);

    if (!$attr) {
        return $pwdline;
    }

    my ($pwhtype) = ($passwd =~ /^\{([^\}]+)\}/);
    if ($pwhtype && $pwhtype !~ /^CLEARTEXT$/i) {
        return $pwdline;
    }

    $passwd =~ s/^\{[^\}]+\}//;
    my ($lmpasswd, $ntpasswd) = ntlmgen $passwd;

    return "$pwdline\nsambaLMPassword: $lmpasswd\nsambaNTPassword: $ntpasswd\nsambaPwdLastSet: ".time;
}

1;
