/**
 * @file  DialogSizeHelper.h
 * @brief _CAOTCYύXNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#ifndef ___DIALOGUTILITY_DIALOGSIZEHELPER_H
#define ___DIALOGUTILITY_DIALOGSIZEHELPER_H

namespace DialogUtility {

/**
 * _CAOTCYύX.
 */
class CDialogSizeHelper
{
public:
	/**
	 * TCYύXɑ΂铯IvV.
	 */
	enum SyncTypeEnum {
		SyncTypeNone	= 0x00,		/// Ȃ
		SyncTypeNormal	= 0x01,		/// 
	};

public:
	/**
	 * TCYύXɑ΂铯p[^.
	 */
	struct SyncInfo {
		SyncInfo(SyncTypeEnum type = SyncTypeNone, double param = 1.0)
			: nType(type), fParam(param)
		{
		}

		/// IvV
		SyncTypeEnum nType;
		/// p[^
		/// (_CAÕTCYύXʂɑ΂ARg[̈ړ/TCYύXʂ̊)
		double fParam;
	};

	/**
	 * TCYύXɑ΂铯p[^̃yA (cA).
	 */
	struct SyncInfoPair {
		SyncInfoPair()
		{
		}
		SyncInfoPair(const SyncInfo& info)
			: VerticalInfo(info), HorizontalInfo(info)
		{
		}
		SyncInfoPair(const SyncInfo& vertical, const SyncInfo& horizontal)
			: VerticalInfo(vertical), HorizontalInfo(horizontal)
		{
		}

		/// 
		SyncInfo VerticalInfo;
		/// 
		SyncInfo HorizontalInfo;
	};

	// for obsolete enum
	static const SyncInfoPair SyncTypeBottom;
	static const SyncInfoPair SyncTypeRight;
	static const SyncInfoPair SyncTypeBottomRight;

public:
	CDialogSizeHelper(BOOL bGlobalUpdate = FALSE, BOOL bMoveBaseTopLeft = FALSE);
	virtual ~CDialogSizeHelper();

	/**
	 * Rg[܂܂EBhE (eEBhE) w肷.
	 */
	void SetParent(CWnd* pParent);
	/**
	 * Rg[܂܂_CAȎ傫̍őƍŏw肷.
	 * (eEBhE_CAÔƂ̂ݗL)
	 */
	void SetParentRange(const CSize* sizeMin, const CSize* sizeMax);

	/**
	 * Rg[ǉ.
	 */
	void AddControl(
		/// Rg[̃EBhEnh
		CWnd* pWnd,
		/// TCY
		const SyncInfoPair& SizeInfo,
		/// ʒu
		const SyncInfoPair& PositionInfo,
		/// ɍĕ`悷邩ǂ
		BOOL bForceInvalidate = FALSE);
	/**
	 * Rg[ǉ (TCY).
	 */
	void AddControlForSize(
		CWnd* pWnd, const SyncInfoPair& SizeInfo, BOOL bForceInvalidate = FALSE);
	/**
	 * Rg[ǉ (ʒu).
	 */
	void AddControlForPosition(
		CWnd* pWnd, const SyncInfoPair& PositionInfo, BOOL bForceInvalidate = FALSE);

	/**
	 * WM_INITDIALOG Ŏs.
	 */
	void Initialize();
	/**
	 * WM_SIZE Ŏs.
	 */
	void OnSize();
	/**
	 * WM_SIZING Ŏs.
	 * (eEBhE_CAÔƂ̂ݗL)
	 */
	void OnSizing(UINT nSide, LPRECT lpRect);

private:
	/// TCYύXOɃ_CAOŜ̕`~߂āATCYύXɂׂčĕ`悷.
	BOOL m_bGlobalUpdate;
	/// ړ̊ɂ.
	/// HACK: EɂƁATCYύXƈړ𓯎ɍsƂɐɏȂB
	/// HACK: ɂƁAC_CAOŐɏȂ(?)B
	BOOL m_bMoveBaseTopLeft;

	/// Rg[܂܂EBhE (eEBhE)
	CWnd* m_pParent;
	/// ̐eEBhE ClientRect
	CRect m_rectParentClient;
	/// ̐eEBhE WindowRect (NCAgW)
	CRect m_rectParentWindow;

	/// eEBhE̍ŏTCY
	CSize m_sizeMin;
	/// eEBhE̍őTCY
	CSize m_sizeMax;

	/**
	 * Rg[.
	 */
	struct ControlInfo {
		CWnd* pWnd;					/// EBhEnh
		SyncInfoPair SizeInfo;		/// TCY
		SyncInfoPair PositionInfo;	/// ʒu
		CRect rectControl;			/// Rg[̏ʒu
		BOOL bForceInvalidate;		/// ɍĕ`悷邩ǂ
	};
	class ControlInfoVec;
	/// Rg[Rei
	ControlInfoVec* m_pControlID;
};

}	// namespace DialogUtility

#endif
