/**
 * @file  GlobalAlloc.cpp
 * @brief  GlobalAlloc/GlobalLock NX.
 *
 * @author JIN
 *
 * Copyright (C) 2009- JIN All rights reserved.
 */
#include "StdAfx.h"

#include "GlobalAlloc.h"

namespace GenericUtility {

/////////////////////////////////////////////////////////////////////////////
// CGlobalAlloc

CGlobalAlloc::CGlobalAlloc(SIZE_T dwBytes)
	: m_hGlobal(::GlobalAlloc(GMEM_MOVEABLE, dwBytes))
{
}

CGlobalAlloc::CGlobalAlloc(LPCTSTR lpszText)
	: m_hGlobal(NULL)
{
	// ̒ (I[ NUL ܂)
	size_t size = _tcslen(lpszText) + 1;
	// obt@TCY
	size_t nBufferSize = sizeof(TCHAR) * size;
	// m
	CGlobalAlloc ga(nBufferSize);
	ASSERT(ga);
	if (!ga) {
		return;
	}

	{
		// |C^擾
		CGlobalLock gl(ga);
		ASSERT(gl);
		if (!gl) {
			return;
		}

		// Rs[
		_tcsncpy_s(gl, size /* obt@̕ */, lpszText, _TRUNCATE);
	}

	// ׂĐAێ
	m_hGlobal = ga.Detach();
}

CGlobalAlloc::CGlobalAlloc(const std::vector<CString>& fileNames)
	: m_hGlobal(NULL)
{
	// ׂẴt@C̘̒a ( '\0' ܂)
	size_t nTotalFileNameSize = 0;
	// ׂĂ̕𑫂
	for (std::vector<CString>::const_iterator it = fileNames.begin(); it != fileNames.end(); ++it) {
		nTotalFileNameSize += it->GetLength() + 1 /*  '\0' */;
	}

	// obt@TCY
	size_t nBufferSize = sizeof(DROPFILES) + sizeof(TCHAR) * (nTotalFileNameSize + 1 /* I[ "\0\0" ̓Ԗڂ '\0' */);

	// m
	CGlobalAlloc ga(nBufferSize);
	ASSERT(ga);
	if (!ga) {
		return;
	}

	{
		// |C^擾
		CGlobalLock gl(ga);
		ASSERT(gl);
		if (!gl) {
			return;
		}

		LPDROPFILES lpDropFiles = gl;
		if (!lpDropFiles) {
			return;
		}

		// t@CXg̃ItZbg
		lpDropFiles->pFiles = sizeof(DROPFILES);
		lpDropFiles->pt.x = 0;
		lpDropFiles->pt.y = 0;
		lpDropFiles->fNC = FALSE;
#ifdef _UNICODE
		lpDropFiles->fWide = TRUE;		// UNICODE
#else	// #ifdef _UNICODE
		lpDropFiles->fWide = FALSE;		// ANSI
#endif	// #ifdef _UNICODE

		// t@CXg̃obt@AhX
		LPTSTR lpBuff = reinterpret_cast<LPTSTR>(&lpDropFiles[1]);

		for (std::vector<CString>::const_iterator it = fileNames.begin(); it != fileNames.end(); ++it) {
			// Rs[
			_tcsncpy_s(lpBuff, it->GetLength() + 1 /* obt@̕ (I[ '\0' ܂) */, *it, _TRUNCATE);
			lpBuff += it->GetLength() + 1;
		}

		// I[ "\0\0" ̓Ԗڂ '\0'
		*lpBuff = _T('\0');
	}

	// ׂĐAێ
	m_hGlobal = ga.Detach();
}

CGlobalAlloc::~CGlobalAlloc()
{
	if (m_hGlobal) {
		VERIFY(!::GlobalFree(m_hGlobal));
	}
}

CGlobalAlloc::operator HGLOBAL()
{
	return m_hGlobal;
}

HGLOBAL CGlobalAlloc::Detach()
{
	HGLOBAL hGlobal = m_hGlobal;
	m_hGlobal = NULL;
	return hGlobal;
}

/////////////////////////////////////////////////////////////////////////////
// CGlobalLock

CGlobalLock::CGlobalLock(HGLOBAL hGlobal)
	: m_hGlobal(hGlobal), m_p(::GlobalLock(hGlobal))
{
}

CGlobalLock::~CGlobalLock()
{
	if (m_p) {
		::GlobalUnlock(m_p);
		ASSERT(::GetLastError() == NO_ERROR);
	}
}

CGlobalLock::operator bool()
{
	return m_p != NULL;
}

CGlobalLock::operator LPVOID()
{
	return m_p;
}

CGlobalLock::operator LPCSTR() const
{
	return static_cast<LPCSTR>(m_p);
}

CGlobalLock::operator LPSTR()
{
	return static_cast<LPSTR>(m_p);
}

CGlobalLock::operator LPCWSTR() const
{
	return static_cast<LPCWSTR>(m_p);
}

CGlobalLock::operator LPWSTR()
{
	return static_cast<LPWSTR>(m_p);
}

CGlobalLock::operator const DROPFILES*() const
{
	return static_cast<const DROPFILES*>(m_p);
}

CGlobalLock::operator LPDROPFILES()
{
	return static_cast<LPDROPFILES>(m_p);
}

}	// namespace GenericUtility
