/**
 * @file  GlobalAlloc.h
 * @brief  GlobalAlloc/GlobalLock NX`.
 *
 * @author JIN
 *
 * Copyright (C) 2009- JIN All rights reserved.
 */
#pragma once

namespace GenericUtility {

/////////////////////////////////////////////////////////////////////////////

/**
 *  GlobalAlloc().
 */
class CGlobalAlloc : boost::noncopyable
{
public:
	CGlobalAlloc(SIZE_T dwBytes);

	/**
	 * mۂāARs[.
	 */
	CGlobalAlloc(LPCTSTR lpszText);

	/**
	 * mۂāAt@CXg DROPFILES ɃRs[.
	 */
	CGlobalAlloc(const std::vector<CString>& fileNames);

	~CGlobalAlloc();

	/**
	 * nh擾.
	 */
	operator HGLOBAL();

	/**
	 * nhf^b`.
	 */
	HGLOBAL Detach();

private:
	/// O[oIuWFNgnh
	HGLOBAL m_hGlobal;
};

typedef boost::shared_ptr<CGlobalAlloc> CGlobalAllocPtr;

/////////////////////////////////////////////////////////////////////////////

/**
 *  GlobalLock().
 */
class CGlobalLock : boost::noncopyable
{
public:
	CGlobalLock(HGLOBAL hGlobal);
	~CGlobalLock();

	/**
	 * |C^Lǂ擾.
	 */
	operator bool();

	/**
	 * |C^擾.
	 */
	operator LPVOID();

	/**
	 * ANSI |C^擾.
	 */
	operator LPCSTR() const;
	/**
	 * ANSI |C^擾.
	 */
	operator LPSTR();
	/**
	 * UNICODE |C^擾.
	 */
	operator LPCWSTR() const;
	/**
	 * UNICODE |C^擾.
	 */
	operator LPWSTR();

	/**
	 * DROPFILES \̂ւ̃|C^擾.
	 */
	operator const DROPFILES*() const;
	/**
	 * DROPFILES \̂ւ̃|C^擾.
	 */
	operator LPDROPFILES();

private:
	/// O[oIuWFNgnh
	HGLOBAL m_hGlobal;
	/// |C^
	LPVOID m_p;
};

typedef boost::shared_ptr<CGlobalLock> CGlobalLockPtr;

}	// namespace GenericUtility
