#include "StdAfx.h"
#include "DataManager.h"

#include "../GenericLib/SerializeObject.h"

namespace ListPasteLib {

	////////////////////////////////////////////////////////////////////////////////

	CDataGroup::CDataGroup()
	{
	}

	CDataGroup::CDataGroup(const std::wstring& name)
		: m_name(name)
	{
	}

	CDataGroup::~CDataGroup()
	{
	}

	void CDataGroup::Swap(CDataGroup& group)
	{
		m_name.swap(group.m_name);
		m_texts.swap(group.m_texts);
	}

	void CDataGroup::SetName(const std::wstring& name)
	{
		m_name = name;
	}

	const std::wstring& CDataGroup::GetName() const
	{
		return m_name;
	}

	bool CDataGroup::Add(size_t index, const std::wstring& text)
	{
		if (index > m_texts.size()) {
			index = m_texts.size();
		}

		WStrings::iterator it = m_texts.begin();
		std::advance(it, index);
		m_texts.insert(it, text);

		return true;
	}

	bool CDataGroup::Add(size_t index, const std::vector<std::wstring>& texts)
	{
		if (index > m_texts.size()) {
			index = m_texts.size();
		}

		WStrings::iterator it = m_texts.begin();
		std::advance(it, index);
		m_texts.insert(it, texts.begin(), texts.end());

		return true;
	}

	bool CDataGroup::Modify(size_t index, const std::wstring& text)
	{
		if (index >= m_texts.size()) {
			return false;
		}

		WStrings::iterator it = m_texts.begin();
		std::advance(it, index);
		
		*it = text;

		return true;
	}

	bool CDataGroup::Delete(size_t index)
	{
		if (index >= m_texts.size()) {
			return false;
		}

		WStrings::iterator it = m_texts.begin();
		std::advance(it, index);
		m_texts.erase(it);

		return true;
	}

	const CDataGroup::WStrings& CDataGroup::GetTexts() const
	{
		return m_texts;
	}

	CDataGroup::IndexVec CDataGroup::Search(const std::wstring& search, bool matchFirst) const
	{
		IndexVec indices;
		// 擪̂݃}b`
		if (matchFirst) {
			for (WStrings::const_iterator it = m_texts.begin(); it != m_texts.end(); ++it) {
				// HACK: 啶͋ʂȂ
				if (_wcsnicmp(it->c_str(), search.c_str(), search.size()) == 0) {
					indices.push_back(std::distance(m_texts.begin(), it));
				}
			}
		}
		// ǂł}b`
		else {
			for (WStrings::const_iterator it = m_texts.begin(); it != m_texts.end(); ++it) {
				// HACK: 啶͋ʂȂ
				if (StrStrIW(it->c_str(), search.c_str())) {
					indices.push_back(std::distance(m_texts.begin(), it));
				}
			}
		}
		return indices;
	}

	////////////////////////////////////////////////////////////////////////////////

	CDataManager::CDataManager()
	{
		SetupDefaultGroup();
	}

	CDataManager::~CDataManager()
	{
	}

	void CDataManager::SetupDefaultGroup()
	{
		// O[v΁AȂ
		if (!m_groups.empty()) {
			return;
		}

		// HACK: ftHgO[vǉ
		m_groups.push_back(CDataGroup(s_defaultGroupName));

		// HACK: ftHgO[vJgɂ
		m_currentGroup = 0;
	}

	bool CDataManager::Save(const std::wstring& filename) const
	{
		return GenericUtility::SaveObject(filename.c_str(), *this);
	}

	bool CDataManager::Load(const std::wstring& filename)
	{
		bool ret = GenericUtility::LoadObject(filename.c_str(), *this);

		// HACK: O[vȂ΁AftHgO[vǉ
		SetupDefaultGroup();
		assert(!m_groups.empty());

		// HACK: ǂݍݓrŎsꍇt@CҏWꂽꍇAJgO[vsɂȂ\
		// HACK: JgO[vmFĂȂ̂ŁANȂ悤ɂŃ`FbNĂ
		if (m_currentGroup >= m_groups.size()) {
			m_currentGroup = m_groups.size() - 1;
		}

		return ret;
	}

	bool CDataManager::Add(const std::wstring& name)
	{
		m_groups.push_back(CDataGroup(name));
		return true;
	}

	bool CDataManager::Delete(size_t index)
	{
		if (index >= m_groups.size()) {
			return false;
		}
		// HACK: ݂̃O[v͍폜łȂ
		if (index == m_currentGroup) {
			return false;
		}
#if 0	// HACK: Ō̈݂͌̃JeS[̂͂Ȃ̂ŁA`FbNKvȂ
		// HACK: Ō̂ЂƂ͍폜łȂ
		if (m_groups.size() <= 1) {
			return false;
		}
#endif

		m_groups.erase(m_groups.begin() + index);
		// JgÔ̂폜ꂽÂw悤ɃJgCfbNX𒲐߂
		if (m_currentGroup > index) {
			--m_currentGroup;
		}
#if 0	// HACK: ݂̃JeS[͍폜łȂ̂ŁA`FbNKvȂ
		// Jg폜ꂽ牽Ȃ (̂̂JgɂȂ) AŌ̗vfꍇ͈Ow悤ɂ
		else if (m_currentGroup >= m_groups.size()) {
			m_currentGroup = m_groups.size() - 1;
		}
#endif
		return true;
	}

	bool CDataManager::Move(size_t index, INT_PTR nMove)
	{
		if (index >= m_groups.size()) {
			return false;
		}
		if (nMove == 0) {
			return false;
		}

		// Vʒu (nMove 𑫂ƕɂȂ\̂ INT_PTR ɂ)
		INT_PTR nNewPos = index + nMove;
		if (nNewPos < 0) {
			nNewPos = 0;
		}
		// (m_groups.size() - 1 ͍Ō)
		else if ((INT_PTR)m_groups.size() <= nNewPos) {
			nNewPos = m_groups.size() - 1;
		}
		// VʒuςȂΉȂ
		if (index == nNewPos) {
			return false;
		}

		// 
		int step = nMove > 0 ? 1 : -1;
		// 炵Ă
		for (size_t i = index; i != nNewPos; i += step) {
			// OƓւ
			m_groups[i].Swap(m_groups[i + step]);
		}

		// JgړAɂ킹
		if (index == m_currentGroup) {
			m_currentGroup = nNewPos;
		}
		// JgÔ̂JgɂAJgOɂ炷
		else if (index < m_currentGroup && m_currentGroup <= (size_t)nNewPos) {
			--m_currentGroup;
		}
		// Jĝ̂JgOɂAJgɂ炷
		else if ((size_t)nNewPos <= m_currentGroup && m_currentGroup < index) {
			++m_currentGroup;
		}

		return true;
	}

	size_t CDataManager::Find(const std::wstring& name) const
	{
		for (CDataGroupVec::const_iterator it = m_groups.begin(); it != m_groups.end(); ++it) {
			if (it->GetName() == name) {
				return std::distance(m_groups.begin(), it);
			}
		}
		// Ȃ
		return ~0;
	}

	size_t CDataManager::GetGroupCount() const
	{
		return m_groups.size();
	}

	CDataGroup& CDataManager::GetGroup(size_t index)
	{
		assert(index < m_groups.size());
		return m_groups[index];
	}

	const CDataGroup& CDataManager::GetGroup(size_t index) const
	{
		assert(index < m_groups.size());
		return m_groups[index];
	}

	size_t CDataManager::GetCurrentGroupIndex() const
	{
		return m_currentGroup;
	}

	bool CDataManager::SetCurrentGroup(size_t index)
	{
		if (index >= m_groups.size()) {
			return false;
		}

		m_currentGroup = index;
		return true;
	}

	CDataGroup& CDataManager::GetCurrentGroup()
	{
		assert(m_currentGroup < m_groups.size());
		return m_groups[m_currentGroup];
	}

	const CDataGroup& CDataManager::GetCurrentGroup() const
	{
		assert(m_currentGroup < m_groups.size());
		return m_groups[m_currentGroup];
	}

	std::wstring CDataManager::s_defaultGroupName = L"Default";

	void CDataManager::SetDefaultGroupName(const std::wstring& name)
	{
		s_defaultGroupName = name;
	}

}	// namespace ListPasteLib
