#pragma once

namespace ListPasteLib {

	// HACK: f[^ׂ͂ă|C^ł͂Ȃ̂ŎĂ
	// HACK: ̂߁AAdd()  Delete() ̃ptH[}Xɖ肪o\

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * f[^O[v.
	 */
	class CDataGroup
	{
	public:
		CDataGroup();
		CDataGroup(const std::wstring& name);
		~CDataGroup();

		/**
		 * Ǝւ.
		 */
		void Swap(CDataGroup& group);

		/**
		 * O[vݒ肷.
		 */
		void SetName(const std::wstring& name);
		/**
		 * O[v擾.
		 */
		const std::wstring& GetName() const;

		/**
		 * ǉ.
		 * @param[in] index ǉʒu (>= eLXg: ɒǉ)
		 */
		bool Add(size_t index, const std::wstring& text);
		/**
		 * ǉ.
		 * rɕǉꍇ́Axɒǉ.
		 * @param[in] index ǉʒu (>= eLXg: ɒǉ)
		 */
		bool Add(size_t index, const std::vector<std::wstring>& texts);
		/**
		 * ύX.
		 */
		bool Modify(size_t index, const std::wstring& text);
		/**
		 * 폜.
		 */
		bool Delete(size_t index);

		typedef std::deque<std::wstring> WStrings;
		/**
		 * ׂẴeLXg擾.
		 */
		const WStrings& GetTexts() const;

		typedef std::vector<size_t> IndexVec;
		/**
		 * .
		 * @param[in] search     
		 * @param[in] matchFirst ̐擪Ƀ}b`邩ǂ
		 * @return }b`eLXg̃CfbNX
		 */
		IndexVec Search(const std::wstring& search, bool matchFirst) const;

	private:
		/// O[v
		std::wstring m_name;
		/// eLXg
		WStrings m_texts;

	private:
		friend class boost::serialization::access;
		template<class Archive>
		void serialize(Archive& ar, const unsigned int version)
		{
			using boost::serialization::make_nvp;

			ar & make_nvp("Name", m_name);
			ar & make_nvp("Texts", m_texts);
		}
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * f[^}l[W.
	 */
	class CDataManager
	{
	public:
		CDataManager();
		~CDataManager();

		/**
		 * O[vȂ΁AftHgO[vǉ.
		 */
		void SetupDefaultGroup();

	public:
		/**
		 * VACY.
		 */
		std::wstring Serialize() const;
		/**
		 * fVACY.
		 */
		bool Deserialize(const std::wstring& strData);

		/**
		 * VACYăt@Cɕۑ.
		 */
		bool Save(const std::wstring& filename) const;
		/**
		 * t@CǂݍŃfVACY.
		 */
		bool Load(const std::wstring& filename);

	public:
		/**
		 * f[^O[v𖖔ɒǉ.
		 */
		bool Add(const std::wstring& name);
		/**
		 * f[^O[v폜.
		 */
		bool Delete(size_t index);
		/**
		 * index Ԗڂ̃f[^O[vړ.
		 * [邢͉[𒴂ꍇ́A[邢͉[ɂȂ.
		 * @param[in] nMove ړ (+: , -: )
		 * @return łړǂ.
		 */
		bool Move(size_t index, INT_PTR nMove);
		/**
		 * f[^O[v𖼑OŌ.
		 * @return ŏ̃CfbNX (~0 : Ȃ)
		 */
		size_t Find(const std::wstring& name) const;

		/**
		 * f[^O[v擾.
		 */
		size_t GetGroupCount() const;

		/**
		 * i Ԗڂ̃f[^O[v擾.
		 */
		CDataGroup& GetGroup(size_t index);
		/**
		 * i Ԗڂ̃f[^O[v擾.
		 */
		const CDataGroup& GetGroup(size_t index) const;

		/**
		 * ݂̃f[^O[v擾.
		 */
		size_t GetCurrentGroupIndex() const;
		/**
		 * ݂̃f[^O[vݒ肷.
		 */
		bool SetCurrentGroup(size_t index);

		/**
		 * ݂̃f[^O[v擾.
		 */
		CDataGroup& GetCurrentGroup();
		/**
		 * ݂̃f[^O[v擾.
		 */
		const CDataGroup& GetCurrentGroup() const;

		typedef std::vector<CDataGroup> CDataGroupVec;
		/**
		 * ׂẴf[^O[v擾.
		 */
		const CDataGroupVec& GetGroups() const;

		/**
		 * ftHgO[vݒ肷.
		 */
		static void SetDefaultGroupName(const std::wstring& name);

	private:
		/// JgO[ṽCfbNX
		size_t m_currentGroup;
		/// f[^O[v
		CDataGroupVec m_groups;

		/// ftHgO[v
		static std::wstring s_defaultGroupName;

	private:
		friend class boost::serialization::access;
		template<class Archive>
		void serialize(Archive& ar, const unsigned int version)
		{
			using boost::serialization::make_nvp;

			ar & make_nvp("CurrentGroup", m_currentGroup);
			ar & make_nvp("Groups", m_groups);
		}
	};

	typedef boost::shared_ptr<CDataManager> CDataManagerPtr;

}	// namespace ListPasteLib
