/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.crawler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.livepinger.crawler.CrawlException;
import net.sourceforge.livepinger.crawler.Messages;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

public class RequestRunner
extends Thread {
    String url;
    OnRequestDoneListener onRequestDoneListener;

    public RequestRunner(String url) {
        this(url, null);
    }

    public RequestRunner(String url, OnRequestDoneListener onRequestDoneListener) {
        this.url = url;
        this.onRequestDoneListener = onRequestDoneListener;
    }

    public String getUrl() {
        return this.url;
    }

    public OnRequestDoneListener getOnRequestDoneListener() {
        return this.onRequestDoneListener;
    }

    public void setOnRequestDoneListener(OnRequestDoneListener onRequestDoneListener) {
        this.onRequestDoneListener = onRequestDoneListener;
    }

    @Override
    public void run() {
        try {
            String data = this.getSimplePage();
            if (this.onRequestDoneListener != null) {
                this.onRequestDoneListener.onRequestDone(this, data);
            }
        }
        catch (CrawlException crawlException) {
            // empty catch block
        }
    }

    public String getSimplePage() throws CrawlException {
        HttpGet request = new HttpGet(this.url);
        request.setHeader("User-Agent", Messages.getString("Crawler.user_agent"));
        HttpEntity entity = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = client.execute(request);
            entity = response.getEntity();
        }
        catch (IOException e) {
            throw new CrawlException(e);
        }
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), Messages.getString("Crawler.livetuve_encode")));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        catch (IOException e) {
            throw new CrawlException(e);
        }
        return builder.toString();
    }

    public static interface OnRequestDoneListener {
        public void onRequestDone(RequestRunner var1, String var2);
    }
}

