/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.extracter;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.livepinger.crawler.CrawlException;
import net.sourceforge.livepinger.crawler.OnCrawlDoneListener;
import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.crawler.RequestRunnerQueue;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.NiconamaLive;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class NiconamaExtracter
extends ExtracterBase
implements RequestRunner.OnRequestDoneListener {
    private static Log log = LogFactory.getLog(NiconamaExtracter.class);
    static String CRAWL_URL = "http://live.nicovideo.jp/recent/rss?p=";
    static int ITEMS_PER_PAGE = 18;
    List<Live> rssLives = new ArrayList<Live>();
    int pageIndex = 0;
    int totalItemCount = 0;

    @Override
    public List<Live> extract(String data) {
        ArrayList<Live> lives = new ArrayList<Live>();
        try {
            SAXReader reader = new SAXReader(false);
            Document document = reader.read(new ByteArrayInputStream(data.getBytes("UTF-8")));
            if (this.totalItemCount == 0) {
                String totalItemCountStr = document.getRootElement().element("channel").element("total_count").getText();
                this.totalItemCount = Integer.valueOf(totalItemCountStr);
                log.info("[niconama rss] totalItemCount found: " + this.totalItemCount);
            }
            List entries = document.getRootElement().element("channel").elements("item");
            for (Element entry : entries) {
                Element url = entry.element("link");
                Element title = entry.element("title");
                Element name = entry.element("creator");
                Element listener = entry.element("view");
                Element coumment = entry.element("num_res");
                NiconamaLive live = new NiconamaLive(url.getText(), name.getText(), title.getText());
                live.setOnair(true);
                try {
                    live.setListener(Integer.valueOf(listener.getText()));
                    live.setCommentCount(Integer.valueOf(coumment.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                lives.add(live);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return lives;
    }

    @Override
    public String getCrawlUrl() {
        return CRAWL_URL;
    }

    @Override
    public Class getLiveClass() {
        return NiconamaLive.class;
    }

    @Override
    public void crawl(List<Live> targetLives, OnCrawlDoneListener crawlDoneListener) {
        if (!this.isRequireCrawl(targetLives)) {
            if (crawlDoneListener != null) {
                crawlDoneListener.onCrawlDone(this, new ArrayList<Live>());
            }
            return;
        }
        try {
            this.rssLives = new CopyOnWriteArrayList<Live>();
            this.pageIndex = 0;
            this.totalItemCount = 0;
            RequestRunner runner = new RequestRunner(String.valueOf(this.getCrawlUrl()) + this.pageIndex);
            String data = runner.getSimplePage();
            this.rssLives.addAll(this.extract(data));
            ++this.pageIndex;
            RequestRunnerQueue runnerQueue = new RequestRunnerQueue(20);
            while (this.pageIndex == 0 || this.totalItemCount > this.pageIndex * ITEMS_PER_PAGE) {
                runner = new RequestRunner(String.valueOf(this.getCrawlUrl()) + this.pageIndex, this);
                runnerQueue.schedule(runner);
                ++this.pageIndex;
            }
            runnerQueue.waitAll();
            if (crawlDoneListener != null) {
                crawlDoneListener.onCrawlDone(this, this.rssLives);
            }
        }
        catch (CrawlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestDone(RequestRunner runner, String data) {
        this.rssLives.addAll(this.extract(data));
    }
}

