/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.LivetubeLive;

public class TargetFile {
    public static String FILENAME = "targets.cfg";
    public static String CR = System.getProperty("line.separator");
    public static String DELIMITER = "\t";

    public static void save(List<Live> lives) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (Live live : lives) {
            buffer.append(live.getUrl());
            buffer.append(DELIMITER);
            buffer.append(live.getIdentifier());
            buffer.append(DELIMITER);
            buffer.append(live.getName());
            buffer.append(DELIMITER);
            buffer.append(CR);
        }
        File file = new File(FILENAME);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            out.write(buffer.toString());
            out.flush();
            out.close();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static List<Live> load() throws IOException {
        ArrayList<Live> lives = new ArrayList<Live>();
        File file = new File(FILENAME);
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = in.readLine()) != null) {
                Live live;
                String[] parts = line.split(DELIMITER);
                if (parts.length == 1) {
                    live = LivetubeLive.fromUrl(parts[0]);
                    if (live == null) continue;
                    lives.add(live);
                    continue;
                }
                if (parts.length != 3 || (live = Live.fromUrl(parts[0])) == null) continue;
                live.setIdentifier(parts[1]);
                live.setName(parts[2]);
                lives.add(live);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return lives;
    }
}

