package org.lixm.core.common;

/**
 * <p>モデルを識別するための定数群です。</p>
 * 
 * <pre class="code">
 *      AbstractModel model = list.get(0);
 * 
 *      if(model.matchType(XMLType.START_DOCUMENT)){
 *              System.out.println("ＸＭＬ文書が開始しました。");
 *      }
 * </pre>
 * <P>
 * 
 * @author tasogare
 * @version 1.0M2
 */
public final class XMLType {

    /**
     * 属性を表します。
     */
    public static int       ATTRIBUTE       = 2;
    
    /**
     * 属性のリストを表します。
     */
    public static final int ATTRIBUTES_LIST = 3;

    /**
     * コメントを表します。
     */
    public static final int COMMENT         = 12;

    public static final int CDATA         = 13;
    /**
     * 要素を表します。
     */
    public static final int ELEMENT         = 1;

    /**
     * ＣＤＡＴＡセクションが終了したことを表します。
     */
    public static final int END_CDATA       = 9;

    /**
     * ＸＭＬ文章の終了を表します。
     */
    public static final int END_DOCUMENT    = 5;

    /**
     * 終了タグを表します。
     */
    public static final int END_TAG         = 7;

    /**
     * 処理命令を表します。
     */
    public static final int PI              = 11;

    /**
     * ＣＤＡＴＡセクションが開始したことを表します。
     */
    public static final int START_CDATA     = 8;

    /**
     * ＸＭＬ文章の開始を表します。
     */
    public static final int START_DOCUMENT  = 4;

    /**
     * 開始タグを表します。
     */
    public static final int START_TAG       = 6;

    /**
     * ＸＭＬ文書中に出現する文字データを表します。
     */
    public static final int TEXT            = 10;

    /**
     * ＸＭＬ宣言を表します。
     */
    public static final int XML_DECL        = 0;
}
