package org.lixm.core.common;

import org.lixm.core.list.XMLModelList;

/**
 *  
 *  <h3>名前空間宣言のモデライズ</h3>
 *  
 *  <p>名前空間宣言の実体は特殊な属性とその値です。<br>
 *  モデライザが名前空間宣言をモデライズするかは実装依存です。</p>
 *  
 *  <p>しかし、LIXMは{@link org.lixm.core.model.ElementModel ElementModel}や
 *  {@link org.lixm.core.model.AttributeModel AttributeModel}が自分の名前空間に対する
 *  情報を保持できるのでアプリケーションによってはこれで十分です。</p>
 *  
 *  <p>そのため、低レベルでありポータブルである事を目指すLIXMはそれ以上の状況に対処しません。<br>
 *  その理由は以下の通りです。</p>
 *  
 *  <ol>
 *    <li>LIXMモデライザは既存のパーサーを利用して実装される事が予測されるが
 *    既存のパーサは名前空間宣言を発見した属性として報告しなかったり、
 *    また、名前空間宣言自体をサポートしないかもしれない。</li>
 *    
 *    <li>モデライズ行程はモデルを利用する直前に行われるものであり
 *    モデライズ済みモデルは既に利用可能な状態と見なし名前空間宣言に対する
 *    特殊な処理はプリプロセス行程で行う。</li>
 *  </ol>
 *  
 *  <h4>既存のパーサーに対する配慮</h4>
 *  
 * <p>一番目の問題は名前空間をサポートしていない既存パーサを利用して
 *  LIXMを実装したとき、<br>LIXM側の仕様で名前空間に対する処理を
 *  定義してしまった場合にその部分を新たに実装しなければならなくなり非効率です。</p>
 * 
 *  
 *  <p>{@link org.lixm.core.model.ElementModel#getNamespace()}、
 *  {@link org.lixm.core.model.ElementModel#getPefix()}
 *  といったメソッドは名前空間に関する情報を持たない場合<em>常に<code>null</code></em>
 *  となるので不必要な実装もせずこれらのメソッドで<code>null</code>を返すだけで済みます。</p>
 *  
 *  <h4>プリプロセッシングとモデライズ</h4>
 * 
 *  
 *  <p>二番目の問題はモデライズ済みのモデルは既に利用可のであるため、その時点で利用に必要な全ての処理が
 *  完了していなければなりません。<br>
 *  このためアプリケーション独自の名前空間宣言処理も完了している必要があります。
 *  でなければモデルを正しく扱えない可能性があります。</p>
 *  
 *  <p>このため一般的には名前空間宣言の処理はプリプロセス行程で行います。</p>
 * 
 * 
 * @author tasogare
 * @version 1.0.0
 */
public interface XMLModelizer {

	/**
	 * <p>モデライズフェーズを開始します。
	 * 先に何らかの方法で<code>XMLModelList</code>
	 * を関連付けておく必要があります。</p>
	 * 
	 * @param name ＸＭＬ文章のパス
	 * @throws LIXMPhaseException モデライズ中に何らかの例外が 発生した場合投げられます。
	 * 他の例外をラップしている可能性があります。
	 */
	void modelize(java.lang.String name) throws LIXMPhaseException;

	/**
	 * <p>このモデライザに関連付けられた 
	 * {@link org.lixm.core.list.XMLModelList XMLModelList}を取得します。</p>
	 * 
	 * モデルリストを関連付ける方法は任意ですがモデライズ前には必ず 関連付けておく必要があります。
	 * 
	 * @return 関連付けられたモデルリスト
	 */
	XMLModelList getList();
}
