package org.lixm.optional.v10.atattch;

import org.lixm.core.common.LIXMException;

/**
 * <p>{@link org.lixm.core.list.XMLModelList XMLModelList}
 * に格納された各モデルを実際に処理する{@link XMLReceiver}へ とディスパッチします。</p>
 * 
 * <p>XMLModelaizerが ＸＭＬ文章のトークナイズを行い、
 * {@link org.lixm.core.list.XMLModelList XMLModelList}を生成した後、
 * このインターフェイスを実装したクラスの{@link #dispath(XMLReceiver)}
 * によって処理したいモデルを{@link XMLReceiver}
 * を実装したクラスへ転送し任意の方法で処理します。</p>
 * 
 * <p>このインターフェイスは{@link XMLReceiver}との架け橋となるだけです。</p>
 * @author tasogare
 * @version 1.0.0
 * @since v08
 * @see #dispath(XMLReceiver)
 * @see XMLReceiver
 */
public interface XMLDispatcher {

    /**
     * <p>モデルを処理する{@link XMLReceiver}にモデルをディスパッチします。</p>
     * <p>レシーバが必要ない場合は明示的に<code>null</code>を渡します。</p>
     * 
     * @param receiver モデルを処理するレシーバ 
     * @exception LIXMException ディスパッチ中に発生した例外���
     * @see XMLReceiver#receive(org.lixm.core.model.AbstractModel)
     */
    public void dispath(XMLReceiver receiver)throws LIXMException;
}
