package org.xpnd.component.action.impl;

import java.io.IOException;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.AttributeModel;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartTagModel;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.renderer.HeilevelRenderer;

/**
 * vf
 * src
 * index
 * x
 * y
 * width
 * height
 * remove
 * visible
 * 
 * 
 * @author tasogare
 *
 */
public class ForeGroundElementAction implements ElementAction {
    private HeilevelRenderer renderer;

    public ForeGroundElementAction(HeilevelRenderer renderer){
	this.renderer = renderer;
    }

    public int actionEndTag(EndTagModel endTag) throws LIXMException {
	return 0;
    }

    public int actionStartTag(StartTagModel startTag) throws LIXMException {

	/*
	 * removȅ
	 */
	if(startTag.getAttributes().getName("remove") != null){
	    int index = Integer.parseInt(startTag.getAttributes().getName("index").getValue());
	    renderer.layerManager.remove(renderer.layerManager.getLayerAt(index+1));
	    renderer.sprites[index] = null;
	    renderer.spriteNames[index] = null;
	    return 0;
	}

	/*
	 * src̏
	 */
	AttributeModel srcAtt = startTag.getAttributes().getName("src");
	if(srcAtt != null){

	    String src = srcAtt.getValue();
	    int index = Integer.parseInt(startTag.getAttributes().getName("index").getValue());
	    if(!src.equalsIgnoreCase("") || src != null){

		int width = Integer.parseInt(startTag.getAttributes().getName("width").getValue());
		int height = Integer.parseInt(startTag.getAttributes().getName("height").getValue());
		try {
		    renderer.sprites[index] = new Sprite(Image.createImage(src), width, height);
		    renderer.spriteNames[index] = src;
		    renderer.sprites[index].setVisible(false);
		} catch (IOException e) {
		    System.err.println("摜F" + src + "܂");
		    renderer.getOwner().shutdown(true);
		    e.printStackTrace();
		}

		renderer.layerManager.insert(renderer.messFrameSprite, 0);
		renderer.layerManager.insert(renderer.sprites[index], index + 1);
		renderer.layerManager.remove(renderer.backgroundSprite);
		renderer.layerManager.append(renderer.backgroundSprite);
	    }
	}

	/*
	 * x,y̏
	 */
	AttributeModel xAtt = startTag.getAttributes().getName("x");
	AttributeModel yAtt = startTag.getAttributes().getName("y");
	if(xAtt != null && yAtt != null){
	    int x = Integer.parseInt(xAtt.getValue());
	    int y = Integer.parseInt(yAtt.getValue());

	    int index = Integer.parseInt(startTag.getAttributes().getName("index").getValue());
	    Sprite fg = (Sprite)renderer.layerManager.getLayerAt(index+1);
	    fg.move(x, y);
	}

	/*
	 * visiblȅ
	 */
	AttributeModel visibleAtt = startTag.getAttributes().getName("visible");
	if(visibleAtt==null) return 0;

	String visible = visibleAtt.getValue();
	if(visible != null || !visible.equalsIgnoreCase("")){

	    boolean isVisible = false;
	    if(visible.equalsIgnoreCase("true")){
		isVisible = true;
	    }else if(visible.equalsIgnoreCase("false")){
		isVisible = false;
	    }
	    int index = Integer.parseInt(startTag.getAttributes().getName("index").getValue());
	    renderer.sprites[index].setVisible(isVisible);

	    /*
	     *̃Rgvisible=trueɂȂƂܕ\邪A
	     *^C~Oŕ`悳镶֕`悳B
	     *͎̐B
	     */
//	    int layX = renderer.isHorizontal() ? renderer.getScreenWidh() : renderer.getScreenHeight();
//	    renderer.layerManager.paint(renderer.getGraphics(), layX, 0);

	}

	return 0;
    }

}
