package org.xpnd.component.action.impl;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartTagModel;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.renderer.HeilevelRenderer;
/**
 * src
 * loop
 * stop
 * start
 * @author tasogare
 *
 */
public class SoundElementAction implements ElementAction {

    private HeilevelRenderer renderer;
    private Manager manager;
    private Player player;
    private String revSrc = "";

    public SoundElementAction(HeilevelRenderer renderer){
	this.renderer = renderer;
    }
    public int actionEndTag(EndTagModel endTag) throws LIXMException {
	return 0;
    }

    public int actionStartTag(StartTagModel startTag) throws LIXMException {

	/*
	 * fBA̎擾
	 */
	if(startTag.getAttributes().getName("src") != null || startTag.getAttributes().getName("src").getValue().equals("")){

	    String src = startTag.getAttributes().getName("src").getValue();
	    if(src.equals(revSrc)) return 0;
	    revSrc = src;

	    if(src.endsWith(".mid") || src.endsWith(".midi")){

		InputStream is = getClass().getResourceAsStream(src);
		try {
		    player = manager.createPlayer(is, "audio/midi");
		} catch (IOException e) {
		    e.printStackTrace();
		    renderer.getOwner().shutdown(true);
		} catch (MediaException e) {
		    e.printStackTrace();
		    renderer.getOwner().shutdown(true);
		}
	    }
	} 

	if(player == null) return 0;

	/*
	 * [v̐ݒ
	 */
	if(startTag.getAttributes().getName("loop") != null){
	    try{
	    player.setLoopCount(-1);
	    }catch(IllegalStateException ise){
		throw new LIXMException(ise);
	    }
	}

	/*
	 * fBA̍Đ
	 */
	if(startTag.getAttributes().getName("start") != null){
	    try {
		player.start();
	    } catch (MediaException e) {
		e.printStackTrace();
		renderer.getOwner().shutdown(true);
	    }
	}

	/*
	 * fBA̒~
	 */
	if(startTag.getAttributes().getName("stop") != null){
	    try {
		player.stop();
	    } catch (MediaException e) {
		e.printStackTrace();
		renderer.getOwner().shutdown(true);
	    }
	}

	return 0;
    }

}
