package org.xpnd.component.action.impl.actions;

import java.util.Hashtable;
import java.util.Stack;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.AttributeModel;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartTagModel;
import org.xpnd.component.action.ActionSharedContext;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.renderer.HeilevelRenderer;
import org.xpnd.impl.modelizer.xpp.XMLModelListCache;

public class ContorolElementActions implements ActionSharedContext {

    /**
     * 䕶̃t[
     * @author tasogare
     *
     */
    class ContextFrame{

	private XMLModelListCache cache;
	private int returnAddr;

	public ContextFrame(XMLModelListCache cache, int returnAddr){
	    this.cache = cache;
	    this.returnAddr = returnAddr;
	}

	public XMLModelListCache getCache() {
	    return cache;
	}

	public int getReturnAddr() {
	    return returnAddr;
	}
    }

    /**
     * jumpvf
     * @author tasogare
     *
     */
    class JumpElementAction implements ElementAction {

	    private Hashtable labelTable;

	    public  JumpElementAction(HeilevelRenderer renderer){
		renderer = renderer;
	    }

	    public int actionEndTag(EndTagModel endTag)  throws LIXMException{
		return 0;
	    }

	    public int actionStartTag(StartTagModel startTag) throws LIXMException {
		if(labelTable==null){
		    labelTable = renderer.labelTable;
		}
		AttributeModel srcModel = (AttributeModel)startTag.getAttributes().getName("src");
		String jumpSRC = null;
		if(srcModel != null){
		    jumpSRC = srcModel.getValue();
		    Hashtable cacheTable = renderer.getXmlCache();
		    XMLModelListCache cache = (XMLModelListCache)cacheTable.get(jumpSRC);

		    if(cache != null){
			frameStack.push(new ContextFrame(new XMLModelListCache(renderer.models, renderer.labelTable), renderer.cursor.getIndex()+1));

			renderer.models = cache.getList();
			labelTable = cache.getLabelTable();
			renderer.cursor = renderer.models.getCursor();

			String id = startTag.getAttributes().getName("id").getValue();
			int index = ((Integer)labelTable.get(id)).intValue();
			renderer.cursor.setIndex(index);

		    }else{
			System.err.println("LbV " + jumpSRC + " ݂܂B");
		    }
		}else{
			String id = startTag.getAttributes().getName("id").getValue();
			int index = ((Integer)labelTable.get(id)).intValue();
			renderer.cursor.setIndex(index);
		}
		return 0;
	    }

	}

    /**
     * returnvf
     * @author tasogare
     *
     */
    class ReturnElementAction implements ElementAction{
	    public  ReturnElementAction(HeilevelRenderer renderer){
		renderer = renderer;
	    }

	    public int actionEndTag(EndTagModel endTag) throws LIXMException {
		return 0;
	    }

	    public int actionStartTag(StartTagModel startTag) throws LIXMException {

		ContextFrame frame = (ContextFrame)frameStack.pop();
		XMLModelListCache cache = frame.getCache();

		renderer.models = cache.getList();
		renderer.labelTable = cache.getLabelTable();
		renderer.cursor = renderer.models.getCursor();

		int index = frame.getReturnAddr();
		renderer.cursor.setIndex(index);
		return 0;
	    }

    }

    private HeilevelRenderer renderer;
    private Stack frameStack;
    private JumpElementAction jumpElem;
    private ReturnElementAction returnElem;

    public  ContorolElementActions(HeilevelRenderer renderer){
	this.renderer = renderer;
	frameStack = new Stack();
	jumpElem = new JumpElementAction(renderer);
	returnElem = new ReturnElementAction(renderer);
    }

    public ElementAction getAction(String actionName) {
	if(actionName.equals("jump")){
	    return jumpElem;
	}else if(actionName.equals("return")){
	    return returnElem;
	}else{
	    return null;
	}
    }

}
