package org.xpnd.impl.modelizer.xpp;

import java.io.InputStream;
import java.util.Hashtable;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.AttributesList;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AttributeModel;
import org.lixm.core.model.CharactersModel;
import org.lixm.core.model.ElementModel;
import org.lixm.core.model.EndDocumentModel;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartDocumentModel;
import org.lixm.core.model.StartTagModel;
import org.lixm.optional.v11.namespace.NamespaceBinding;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLModelizerImpl implements XMLModelizer, Locator, Attributes {

    public class LIXMHandler extends DefaultHandler {

	private NamespaceBindingImpl namespaces;

	public LIXMHandler() {
	    namespaces = new NamespaceBindingImpl();
	}

	public void startDocument() throws SAXException {
	    list.add(new StartDocumentModel(null));
	}

	public void endDocument() throws SAXException {
	    list.add(new EndDocumentModel(null));
	}

	public void characters(char[] ch, int start, int length)
		throws SAXException {
	    list.add(new CharactersModel(new String(ch, start, length)));
	}

	public void startElement(String uri, String localName, String qName,
		Attributes attributes) throws SAXException {

	    String elemPrefix = (String)namespaces.getPrefix(uri);

	    AttributesList attList = new AttributesList(attributes.getLength());
	    for (int i = 0; i < attributes.getLength(); i++) {

		String pref = (String)namespaces.getPrefix(attributes.getURI(i));
		attList.add(new AttributeModel(attributes.getLocalName(i),
			attributes.getValue(i), pref, attributes.getURI(i)));
	    }

	    list.add(new StartTagModel(new ElementModel(
		    localName, elemPrefix, uri), attList));
	}

	public void endElement(String uri, String localName, String qName)
		throws SAXException {

	    String elemPrefix = (String)namespaces.getPrefix(uri);
	    list.add(new EndTagModel(new ElementModel(
		    localName, elemPrefix, uri)));
	}

	public void startPrefixMapping(String prefix, String uri)
		throws SAXException {
	    namespaces.put(prefix, uri);
	}

	public void endPrefixMapping(String prefix) throws SAXException {
	}

	/**
	 * 名前空間バインディングを返す
	 * @return 名前空間バインディング
	 */
	public NamespaceBinding getNamespaceBinding(){
	    return namespaces;
	}
    }

    protected static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";

    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";

    protected static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";

    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";

    protected static final String APACHE_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";

    protected static final String APACHE_DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";

    protected String systemId;

    protected DefaultHandler defaultHandler;

    protected XMLModelList list;

    protected MXParser pp;

    private XMLModelizerImpl(){
    }

    public XMLModelizerImpl(XMLModelList list) throws LIXMPhaseException {
	pp = new MXParser();
	this.list = list;

	try {
	    setFeature(NAMESPACES_FEATURE, true);
	} catch (Exception e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
	}

	setContentHandler(new LIXMHandler());
    }

    public XMLModelizerImpl(XMLModelList list, DefaultHandler handler) throws LIXMPhaseException {
	pp = new MXParser();
	this.list = list;

	try {
	    setFeature(NAMESPACES_FEATURE, true);
	} catch (Exception e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
	}

	setContentHandler(handler);
    }

    // -- Attributes interface

    public int getLength() {
	return pp.getAttributeCount();
    }

    public String getURI(int index) {
	return pp.getAttributeNamespace(index);
    }

    public String getLocalName(int index) {
	return pp.getAttributeName(index);
    }

    public String getQName(int index) {
	final String prefix = pp.getAttributePrefix(index);
	if (prefix != null) {
	    return prefix + ':' + pp.getAttributeName(index);
	} else {
	    return pp.getAttributeName(index);
	}
    }

    public String getType(int index) {
	return pp.getAttributeType(index);
    }

    public String getValue(int index) {
	return pp.getAttributeValue(index);
    }

    public int getIndex(String uri, String localName) {
	for (int i = 0; i < pp.getAttributeCount(); i++) {
	    if (pp.getAttributeNamespace(i).equals(uri)
		    && pp.getAttributeName(i).equals(localName)) {
		return i;
	    }

	}
	return -1;
    }

    public int getIndex(String qName) {
	for (int i = 0; i < pp.getAttributeCount(); i++) {
	    if (pp.getAttributeName(i).equals(qName)) {
		return i;
	    }

	}
	return -1;
    }

    public String getType(String uri, String localName) {
	for (int i = 0; i < pp.getAttributeCount(); i++) {
	    if (pp.getAttributeNamespace(i).equals(uri)
		    && pp.getAttributeName(i).equals(localName)) {
		return pp.getAttributeType(i);
	    }

	}
	return null;
    }

    public String getType(String qName) {
	for (int i = 0; i < pp.getAttributeCount(); i++) {
	    if (pp.getAttributeName(i).equals(qName)) {
		return pp.getAttributeType(i);
	    }

	}
	return null;
    }

    public String getValue(String uri, String localName) {
	return pp.getAttributeValue(uri, localName);
    }

    public String getValue(String qName) {
	return pp.getAttributeValue(null, qName);
    }

    // -- Locator interface

    public String getPublicId() {
	return null;
    }

    public String getSystemId() {
	return systemId;
    }

    public int getLineNumber() {
	return pp.getLineNumber();
    }

    public int getColumnNumber() {
	return pp.getColumnNumber();
    }

    // --- XMLReader interface

    public boolean getFeature(String name) throws SAXNotRecognizedException,
	    SAXNotSupportedException {
	if (NAMESPACES_FEATURE.equals(name)) {
	    return pp.getFeature(MXParser.FEATURE_PROCESS_NAMESPACES);
	} else if (NAMESPACE_PREFIXES_FEATURE.equals(name)) {
	    return pp.getFeature(MXParser.FEATURE_REPORT_NAMESPACE_ATTRIBUTES);
	} else if (VALIDATION_FEATURE.equals(name)) {
	    return pp.getFeature(MXParser.FEATURE_VALIDATION);
	} else {
	    return pp.getFeature(name);
	}
    }

    public void setFeature(String name, boolean value)
	    throws SAXNotRecognizedException, SAXNotSupportedException {
	try {
	    if (NAMESPACES_FEATURE.equals(name)) {
		pp.setFeature(MXParser.FEATURE_PROCESS_NAMESPACES, value);
	    } else if (NAMESPACE_PREFIXES_FEATURE.equals(name)) {
		if (pp.getFeature(MXParser.FEATURE_REPORT_NAMESPACE_ATTRIBUTES) != value) {
		    pp.setFeature(MXParser.FEATURE_REPORT_NAMESPACE_ATTRIBUTES,
			    value);
		}
	    } else if (VALIDATION_FEATURE.equals(name)) {
		pp.setFeature(MXParser.FEATURE_VALIDATION, value);
	    } else {
		pp.setFeature(name, value);
	    }
	} catch (Exception ex) {
	    throw new SAXNotSupportedException("problem with setting feature "
		    + name + ": " + ex);
	}
    }

    public Object getProperty(String name) throws SAXNotRecognizedException,
	    SAXNotSupportedException {
	if (DECLARATION_HANDLER_PROPERTY.equals(name)) {
	    return null;
	} else if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
	    return null;
	} else {
	    return pp.getProperty(name);
	}
    }

    public void setProperty(String name, Object value)
	    throws SAXNotRecognizedException, SAXNotSupportedException {
	//
	if (DECLARATION_HANDLER_PROPERTY.equals(name)) {
	    throw new SAXNotSupportedException(
		    "not supported setting property " + name);// +" to
								// "+value);
	} else if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
	    throw new SAXNotSupportedException(
		    "not supported setting property " + name);// +" to
								// "+value);
	} else {
	    try {
		pp.setProperty(name, value);
	    } catch (Exception ex) {
		throw new SAXNotSupportedException(
			"not supported set property " + name + ": " + ex);
	    }
	    // throw new SAXNotRecognizedException("not recognized set property
	    // "+name);
	}
    }

    public void setContentHandler(DefaultHandler handler) {
	this.defaultHandler = handler;
    }

    public DefaultHandler getContentHandler() {
	return defaultHandler;
    }

    /**
     * 実装上の制限：XML文章のエンコーディングはUTF-8のみサポート
     */
    public void modelize(String name) throws LIXMPhaseException {

	InputStream stream = getClass().getResourceAsStream(name);
	defaultHandler.setDocumentLocator(this);

	try {

	    //XMLストリームが無ければシステムIDから取得
	    if (stream == null) {
		throw new SAXParseException("null source", this);
	    }

	    //UTF-8で固定
	    pp.setInput(stream, "UTF-8");

	} catch (SAXParseException e) {
	    throw new LIXMPhaseException("parsing initialization error ", e,
		    LIXMPhaseException.PHASE_MODELIZE);
	} catch (XmlPullParserException e) {
	    throw new LIXMPhaseException("not UTF-8 encoding streem error ", e,
		    LIXMPhaseException.PHASE_MODELIZE);
	}

	// start parsing - move to first start tag
	try {
	    defaultHandler.startDocument();

	    // get first event
	    pp.next();

	    // it should be start tag...
	    if (pp.getEventType() != MXParser.START_TAG) {
		throw new LIXMPhaseException("expected start tag not"
			+ pp.getPositionDescription(),
			LIXMPhaseException.PHASE_MODELIZE);
	    }
	} catch (Exception e) {
	    throw new LIXMPhaseException("parsing initialization error", e,
		    LIXMPhaseException.PHASE_MODELIZE);
	}

	// now real parsing can start!

	parseSubTree(pp);

	// and finished ...

	try {
	    defaultHandler.endDocument();
	} catch (SAXException e) {
	    throw new LIXMPhaseException("parsing initialization error", e,
		    LIXMPhaseException.PHASE_MODELIZE);
	}
    }

    public void parseSubTree(MXParser pp) throws LIXMPhaseException {

	this.pp = pp;
	boolean namespaceAware = pp.getFeature(MXParser.FEATURE_PROCESS_NAMESPACES);

	try {
	    if (pp.getEventType() != MXParser.START_TAG) {
		throw new LIXMPhaseException("start tag must be read before skiping subtree"
			+ pp.getPositionDescription(),LIXMPhaseException.PHASE_MODELIZE);
	    }

	    final int[] holderForStartAndLength = new int[2];
	    final StringBuffer rawName = new StringBuffer(16);
	    String prefix = null;
	    String name = null;
	    int level = pp.getDepth() - 1;
	    int type = MXParser.START_TAG;

	    LOOP: do {
		switch (type) {
		case MXParser.START_TAG:
		    if (namespaceAware) {

			final int depth = pp.getDepth() - 1;
			final int countPrev = (level > depth) ? pp.getNamespaceCount(depth) : 0;

				final int count = pp.getNamespaceCount(depth + 1);
			for (int i = countPrev; i < count; i++) {
			    defaultHandler.startPrefixMapping(
				    pp.getNamespacePrefix(i),
				    pp.getNamespaceUri(i));
			}

			name = pp.getName();
			prefix = pp.getPrefix();

			if (prefix != null) {
			    rawName.setLength(0);
			    rawName.append(prefix);
			    rawName.append(':');
			    rawName.append(name);
			}

			startElement(pp.getNamespace(), name,
				prefix != null ? name : rawName.toString());
		    } else {
			startElement(pp.getNamespace(), pp.getName(), pp
				.getName());
		    }

		    break;
		case MXParser.TEXT:
		    final char[] chars = pp
			    .getTextCharacters(holderForStartAndLength);
		    defaultHandler.characters(chars,
			    holderForStartAndLength[0], // start
			    holderForStartAndLength[1] // len
			    );
		    break;
		case MXParser.END_TAG:
		    // --level;
		    if (namespaceAware) {
			name = pp.getName();
			prefix = pp.getPrefix();
			if (prefix != null) {
			    rawName.setLength(0);
			    rawName.append(prefix);
			    rawName.append(':');
			    rawName.append(name);
			}
			defaultHandler.endElement(pp.getNamespace(), name,
				prefix != null ? name : rawName.toString());
			// when entering show prefixes for all levels!!!!
			final int depth = pp.getDepth();
			final int countPrev = (level > depth) ? pp
				.getNamespaceCount(pp.getDepth()) : 0;
			int count = pp.getNamespaceCount(pp.getDepth() - 1);
			// undeclare them in reverse order
			for (int i = count - 1; i >= countPrev; i--) {
			    defaultHandler.endPrefixMapping(pp
				    .getNamespacePrefix(i));
			}
		    } else {
			defaultHandler.endElement(pp.getNamespace(), pp
				.getName(), pp.getName());

		    }
		    break;
		case MXParser.END_DOCUMENT:
		    break LOOP;
		}
		type = pp.next();
	    } while (pp.getDepth() > level);
	} catch (Exception e) {
	    throw new LIXMPhaseException("parsing error", e,
		    LIXMPhaseException.PHASE_MODELIZE);
	}
    }

    /**
     * Calls
     * {@link ContentHandler.startElement(String, String, String, Attributes) startElement}
     * on the <code>ContentHandler</code> with <code>this</code> driver
     * object as the {@link Attributes} implementation. In default
     * implementation {@link Attributes} object is valid only during this method
     * call and may not be stored. Sub-classes can overwrite this method to
     * cache attributes.
     */
    protected void startElement(String namespace, String localName, String qName)
	    throws SAXException {
	defaultHandler.startElement(namespace, localName, qName, this);
    }

    public XMLModelList getList() {
	return list;
    }
}
