/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002-2003 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.Hatasaki <keisukeh@crl.hitachi.co.jp>
 * Updated by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/

#ifndef _LKST_COMMAND_H_
#define _LKST_COMMAND_H_

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_maskset.h>
#include <linux/lkst_buffer.h>
#include <linux/lkst_evhandler.h>

#define COPYRIGHT "COPYRIGHT (C) HITACHI,LTD. 2002-2003 ALL RIGHTS RESERVED."
// #define DEBUG 1

extern void version(char*, char*);
extern void needopt(void);
extern void badcommand(char*); 
extern int limited_strtoi(const char *str, int max, int min);

extern int open_dev(void);

struct command {
	char *name;			/* command name */
	void (*func)(int *, char **);	/* function of the command */
};

extern char *lkst_event_type_descriptions[];

#define STR2CPU(str) limited_strtoi(str,LKST_NR_CPUS_MAX-1,0)
#define STR2BID(str) (lkst_buffer_id)limited_strtoi(str,LKST_BUFFER_ID_MAX,0)
#define STR2MID(str) \
	(lkst_maskset_id)limited_strtoi(str,LKST_MASKSET_ID_MAX,0)
#define STR2EID(str) \
	(lkst_evhandler_id)limited_strtoi(str,LKST_EVHANDLER_ID_MAX,0)
#define STR2ETYPE(str) (lkst_event_type)limited_strtoi(str,LKST_ETYPE_MAX-1,0)

#endif
