/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2003 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/

#include "command.h"
#include <linux/lkst_private.h>


/* The list of descriptions:
 the list of LKST_ETYPE_DEF() will become a definition of 
 lkst_event_type_descriptions, 
 that is an array of descriptions of event types.	*/
/* remember to undef 
 LKST_ETYPE_DEF{,_ENUM*}		*/

/* each element of the array is a pair of 
 description and value of event type.	*/
#define LKST_ETYPE_DEF(event_type, hooktype, mnemonic, event_name, arg_1, arg_2, arg_3, arg_4)    \
        [(event_type)] = #mnemonic,
				/* The header of the array. */
char *lkst_event_type_descriptions[] = {
#include <linux/lkst_etype.h>
[LKST_ETYPE_VOID] = "LKST_ETYPE_VOID"
};

#undef LKST_ETYPE_DEF

