/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002-2003 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.Hatasaki <keisukeh@crl.hitachi.co.jp>
 *
 ************************************************************/

#include "evhandler.h"

int lkst_evhandler_getid(int fd, const char *name)
{
	int ret;
	struct lkst_evhandler_getparam egp;
	if(!name || name[0]=='\0')return -EINVAL;
	strncpy(egp.name, name, LKST_EVHANDLER_NAME_LEN-1);
	if( (ret = ioctl(fd, LKST_IOC_EVHANDLER_GETID, &egp)) < 0)
		return ret;
	return egp.id;
}

/*
int lkst_event_getid(const char *name )
{
	int i;
	for (i = 0; i< LKST_ETYPE_MAX; i++) {
		if( strcmp(lkst_event_type_mnemonics[i], name) == 0) {
			break;
		}
	}
	printf("%d\n",i);
}
*/

void evhandler_getid(const char *name )
{
	int fd;
	int ret;
	fd = open_dev();
	if((ret =lkst_evhandler_getid(fd, name))< 0){
		fprintf(stderr, "error: failed to get id: %s\n", strerror(errno));
		exit(1);
	}
	close(fd);
	printf("%d (0x%02x)\n", ret, ret);
}

void evhandler_list()
{
	int retval;
	int fd;
	int i;
	struct lkst_evhandler_listparam lp;
	struct lkst_evhandler_listent listent[LKST_EVHANDLER_TBL_MAX];

	fd = open_dev();

	lp.listent_size = LKST_EVHANDLER_LISTENT_SIZE(LKST_EVHANDLER_TBL_MAX);
	lp.listent = listent;

	retval = ioctl(fd, LKST_IOC_EVHANDLER_LIST, &lp); /* evhandler list */

	if (retval) {
		fprintf(stderr, "ioctl(LKST_IOC_EVHANDLER_LIST) error: %s\n", strerror(errno));
		exit(1);
	}

	printf("evhandler_id\tname\n");
	for (i = 0; i < LKST_EVHANDLER_TBL_MAX; i++) {
		if (lp.listent[i].id != LKST_EVHANDLER_ID_VOID) {
	  		printf(" %3d  (0x%02x)\t%s\n",
			       lp.listent[i].id,
			       lp.listent[i].id,
			       lp.listent[i].name);
		}
	}

	close(fd);
}

#define BUFSIZE 4096 

void evhandler_ctrl(lkst_evhandler_id id, const char *name,
		    const char *file_name)
{
	int retval;
	int fd;
	FILE *fp_i;
	char *buf;
	size_t bufsize;
	struct lkst_evhandler_ctrl_param evhandler_ctrl_param;
	struct stat file_stat;

	fd = open_dev();

	if(name[0]) {
		retval = lkst_evhandler_getid(fd, name);
		if (retval < 0 || retval == LKST_EVHANDLER_ID_VOID){
			fprintf(stderr, "error: %s is not found\n",name);
			exit(1);
		}
		id = (lkst_evhandler_id)retval;
	}
	if ((file_name[0] == '\0') || 
	    (0 == strncmp("-", file_name, 2))) {
		char temp[BUFSIZE],*buf2;
		fp_i = stdin;
		buf = NULL;
		bufsize = 0;
		do {
			retval = fread(temp, sizeof(char), BUFSIZE, fp_i);
			if ( retval < 0) { 
				perror("fread");
			}else if (retval > 0) {
				buf = (char*) realloc(buf, bufsize + retval);
				memcpy(buf + bufsize, temp, retval);
				bufsize += retval;
			}
		} while(!feof(fp_i));
	} else {
		if ((fp_i = fopen(file_name, "r")) == NULL) {
			perror("input");
			exit(1);
		}
		
		if (stat(file_name, &file_stat)) {
			perror("fstat");
			exit(1);
		}
		bufsize = (size_t) file_stat.st_size;
		buf = (char*) malloc(bufsize);
		fread(buf, sizeof(char), bufsize, fp_i);
	}

	evhandler_ctrl_param.id = id;
  
	evhandler_ctrl_param.buf = buf;	/* pointer to a communication area */
	evhandler_ctrl_param.bufsize = bufsize;	/* size of the area */

	retval = ioctl(fd, LKST_IOC_EVHANDLER_CTRL, &evhandler_ctrl_param);
						/* evhandler_ctrl */
	if (retval) {
		fprintf(stderr, "ioctl(LKST_IOC_EVHANDLER_CTRL) error: %s\n", strerror(errno));
		exit(1);
	}
 
	printf("ioctl retval=%d\n", retval);

	printf("control-function return value=%d\n", evhandler_ctrl_param.ret);

	close(fd);
}
