/* gfile.c */

#ifdef __cplusplus
extern "C" {
#endif

void	init_game_file( void );
char	*init_dir_game( char *home, char *dir, bool_t flg_GPL );
bool_t	load_game_conf( void );
bool_t	load_game_conf_head( FILE *fp, ver_t *ver );
void	load_game_conf_data_ver_1( FILE *fp, const ver_t *ver );
bool_t	load_game_conf_parse_ver_1( FILE *fp, const ver_t *ver );
bool_t	load_game_conf_set_val(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long val
);
bool_t	load_game_conf_set_str(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, char *str
);
bool_t	load_game_conf_id_char_str(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long c, char *str
);
bool_t	load_game_conf_id_char(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id, long c
);
bool_t	load_game_conf_id_brace(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id
);
bool_t	load_game_conf_clk_tck( char *id, long val );
bool_t	load_game_conf_scroll( char *id, char *str );
bool_t	load_game_conf_space_select( char *id, long val );
bool_t	load_game_conf_mul_line( char *id, long val );
bool_t	load_game_conf_vfx_mbr( flg_vfx_mbr_t flg, long val );
bool_t	load_game_conf_vfx_mnstr( flg_vfx_mnstr_t flg, long val );
bool_t	load_game_conf_vfx_wait( char *id, long val );
bool_t	load_game_conf_color_name( char *id, char *name );
bool_t	load_game_conf_color_fg( char *id, char *color );
bool_t	load_game_conf_color_bg( char *id, char *color );
bool_t	load_game_conf_attribute_underline( char *id, long val );
bool_t	load_game_conf_attribute_reverse( char *id, long val );
bool_t	load_game_conf_attribute_blink( char *id, long val );
bool_t	load_game_conf_attribute_bold( char *id, long val );
bool_t	load_game_conf_set_key( char *id, long c, char *str );
bool_t	load_game_conf_unset_key( char *id, long c );
bool_t	load_game_conf_menu(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id
);
bool_t	load_game_conf_menu_line(
	FILE *fp, const ver_t *ver, bool_t flg_err_exit,
	char *id
);
bool_t	save_game_conf( void );
bool_t	save_game_conf_ver_1( const ver_t *ver );
bool_t	save_game_conf_scroll( FILE *fp, const ver_t *ver );
bool_t	save_game_conf_vfx( FILE *fp, const ver_t *ver );
bool_t	save_game_conf_color( FILE *fp, const ver_t *ver );
bool_t	save_game_conf_color_sub(
	FILE *fp, char *name, curs_attr_n_t attr_n
);
char	*cv_color_to_name( int color );
int	cv_name_to_color( char *name );
bool_t	save_game_conf_user_menu( FILE *fp, const ver_t *ver );
bool_t	save_game_conf_key_tab( FILE *fp, const ver_t *ver );
bool_t	load_crsr_ptn( crsr_ptn_t *ptn, long *max_n );
bool_t	load_crsr_ptn_head( FILE *fp, crsr_ptn_t *ptn );
bool_t	load_crsr_ptn_misc( FILE *fp, crsr_ptn_t *ptn );
bool_t	load_crsr_ptn_data( FILE *fp, crsr_ptn_t *ptn );
bool_t	load_town_ptn( town_ptn_t *ptn );
bool_t	load_town_ptn_head( FILE *fp, town_ptn_t *ptn );
bool_t	load_town_ptn_col( FILE *fp, town_ptn_t *ptn );
bool_t	load_town_ptn_map( FILE *fp, town_ptn_t *ptn );
bool_t	save_crsr_ptn( crsr_ptn_t *ptn, long max_n );
void	back_up_town_ptn( void );
bool_t	save_town_ptn( town_ptn_t *ptn );
void	save_town_ptn_col_1byte( FILE *fp, town_ptn_t *ptn );
void	save_town_ptn_col_2byte( FILE *fp );
bool_t	load_game_data( bool_t flg_txt, long n );
void	reset_load_game_data( void );
bool_t	chk_load_game_data( void );
bool_t	load_game_data_head_ver_1( FILE *fp, ver_t *ver, bool_t flg_txt );
bool_t	load_game_data_ver_1( FILE *fp, const ver_t *ver, bool_t flg_txt );
bool_t	load_game_data_parse_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	load_game_data_id_eq_num_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id, long n
);
bool_t	load_game_data_id_num_eq_str_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id, long n, char *str
);
bool_t	load_game_data_auto_mark_ttl_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n, char *ttl
);
bool_t	load_game_data_block_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	char *id, long n
);
bool_t	load_game_data_class_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n
);
bool_t	load_game_data_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n
);
bool_t	load_game_data_pet_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long n
);
bool_t	load_game_data_chr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
);
bool_t	load_game_data_chr_fx_all_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
);
bool_t	load_game_data_chr_fx_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
);
bool_t	load_game_data_fx_data_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	fx_data_t *fx_data
);
bool_t	load_game_data_modifier_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	modifier_t *m
);
bool_t	load_game_data_potion_color_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	load_game_data_scroll_ttl_syllable_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	load_game_data_stick_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	stick_kind_t kind
);
bool_t	load_game_data_acce_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	acce_kind_t kind
);
bool_t	load_game_data_item_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
);
bool_t	load_game_data_item_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_wpn_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_armor_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_potion_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_scroll_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_stick_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_acce_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_inst_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_anthology_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_light_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_spike_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_food_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_chest_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_tobacco_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_pipe_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_disposal_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_rare_goods_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_coin_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_item_junk_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	load_game_data_auto_mark_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
);
bool_t	load_game_data_auto_mark_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n, long auto_mark_n
);
bool_t	load_game_data_spell_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	long ls_mbr_n
);
bool_t	load_game_data_mbr_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	load_game_data_pet_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	load_game_data_request_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	load_game_data_n( FILE *fp, long *n );
bool_t	load_game_data_s( FILE *fp, char *s, long len );
bool_t	load_game_data_c( FILE *fp, char *c );
bool_t	load_game_data_skip_c( FILE *fp, rc_token_t c, bool_t flg_draw );
bool_t	save_game_data( bool_t flg_txt, long n );
bool_t	save_game_data_ver_1( const ver_t *ver, bool_t flg_txt, long n );
bool_t	save_game_data_turn_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_class_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_chr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
);
bool_t	save_game_data_fx_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	fx_t *fx
);
bool_t	save_game_data_fx_data_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	fx_data_t *fx_data
);
bool_t	save_game_data_modifier_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	const modifier_t *m
);
bool_t	save_game_data_work_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	chr_t *chr
);
bool_t	save_game_data_item_all_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_item_mbr_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr
);
bool_t	save_game_data_item_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_wpn_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_armor_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_potion_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_scroll_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_stick_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_acce_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_inst_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_anthology_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_light_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_spike_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_food_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_chest_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_tobacco_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_pipe_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_disposal_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_rare_goods_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_coin_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_item_junk_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	mbr_t *mbr, item_t *item
);
bool_t	save_game_data_potion_color_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_scroll_ttl_syllable_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_stick_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	stick_kind_t kind
);
bool_t	save_game_data_acce_material_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	acce_kind_t kind
);
bool_t	save_game_data_auto_mark_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_auto_mark_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	const auto_mark_t *a
);
bool_t	save_game_data_spell_ls_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_spell_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt,
	cast_tab_t *tab
);
bool_t	save_game_data_mbr_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_pet_formation_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
bool_t	save_game_data_request_ver_1(
	FILE *fp, const ver_t *ver, bool_t flg_txt
);
FILE	*open_game_data( char type, long n, bool_t flg_txt );
bool_t	get_save_load_ttl( char *msg, long n, bool_t flg_txt );
bool_t	get_game_data_head_time( char *str, long n, bool_t flg_txt );
long	load_char( FILE *fp, bool_t flg_chk_eof );
char	*load_line_skip_spc( FILE *fp, bool_t flg_chk_eof );
char	*load_line( FILE *fp, bool_t flg_chk_eof );
char	*set_rc_lex_file_name( char *name );
char	*get_rc_lex_file_name( void );
long	clr_rc_lex_line( void );
long	inc_rc_lex_line( void );
long	dec_rc_lex_line( void );
long	get_rc_lex_line( void );
bool_t	set_rc_lex_err( bool_t flg );
bool_t	get_rc_lex_err( void );
rc_token_t	rc_lex( FILE *fp, rc_union_t *u, bool_t flg_err_exit );
void	rc_unlex( FILE *fp, rc_union_t *u, rc_token_t t );
rc_token_t	rc_lex_char( FILE *fp, rc_union_t *u, bool_t flg_err_exit );
rc_token_t	rc_lex_str( FILE *fp, rc_union_t *u, bool_t flg_err_exit );
long	rc_lex_oct( FILE *fp, long len, bool_t flg_err_exit );
long	rc_lex_dec( FILE *fp, long len, bool_t flg_err_exit );
long	rc_lex_hex_dec( FILE *fp, long len, bool_t flg_err_exit );
long	rc_lex_digit( FILE *fp, long base, long len, bool_t flg_err_exit );
void	rc_lex_id( FILE *fp, rc_union_t *u, bool_t flg_err_exit );
long	rc_lex_getc( FILE *fp, bool_t flg_chk_eof, bool_t flg_err_exit );
void	rc_lex_ungetc( FILE *fp, long c );
bool_t	rename_back_up_file( char *fname );
char	*get_out_map_file_name( char *s );
bool_t	out_map_file( void );
char	*cat_path( char *path, char *file );
bool_t	chk_exist_file( char *s );
bool_t	chk_exist_dir( char *s );
bool_t	make_dir( char *path );
char	*cv_esc_str( const char *str );
long	srandm_crypt( long n );
long	randm_crypt( long c );
void	reset_load_save( char *path, bool_t flg_txt );
void	set_flg_crypt_txt( bool_t flg_txt );
void	reset_load_crypt( FILE *fp, bool_t flg_txt );
void	reset_save_crypt( FILE *fp, bool_t flg_txt );
void	reset_save_crypt_tab( void );
long	set_save_crypt_tab( FILE *fp, long n );
long	save_crypt_tab( FILE *fp, const char *s, ... );
long	save_crypt_str( FILE *fp, const char *s, ... );
long	load_crypt_str( FILE *fp, char *buf, long n );
long	load_crypt_c( FILE *fp );
void	un_load_crypt_c( FILE *fp, long c );

#ifdef __cplusplus
}
#endif
