/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: mnstr-act.c,v 1.1 2004/07/26 10:02:44 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
#include	"misc.h"
#include	"turn.h"
#include	"dun.h"
#include	"town.h"
#include	"item.h"
/*#include	"spell.h"*/
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
/*#include	"fight.h"*/
#include	"fx.h"
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"amenu.h"*/
#include	"request.h"
/*#include	"gfile.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
/*#include	"gmain-prot.h"*/
#include	"misc-prot.h"
#include	"turn-prot.h"
#include	"dun-prot.h"
#include	"town-prot.h"
#include	"item-prot.h"
/*#include	"spell-prot.h"*/
#include	"chr-prot.h"
#include	"party-prot.h"
#include	"mnstr-prot.h"
#include	"mnstr-act-prot.h"
#include	"pet-prot.h"
/*#include	"fight-prot.h"*/
#include	"fx-prot.h"
/*#include	"trap-prot.h"*/
#include	"draw-prot.h"
/*#include	"curs-prot.h"*/
/*#include	"menu-prot.h"*/
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
#include	"request-prot.h"
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

/**/

#define	PICK_GOLD_RATE	((rate_t)10)
#define	PICK_GOLD_MAX_N	((gold_t)500)

#define	INCREASE_RATE_GIANT_RAT	20

#define	TOWNER_ENTER_DOOR_RATE	10
#define	TOWNER_ENTER_DOOR_R	3
#define	TOWNER_CANCEL_DOOR_RATE	10

#define	TOWNER_EXIT_DOOR_RATE_DAY	10
#define	TOWNER_EXIT_DOOR_RATE_NIGHT	2

/*  */

void	set_act_mnstr_std( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}
	if( p->attitude != ATTITUDE_ENEMY )
		return;

	mnstr_mark_mbr_std( p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_cubus( mnstr_t *p, sex_t sex )
{
	if( p == NULL )
		return;

	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}

	mnstr_mark_mbr_cubus( p, sex );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_metamorphose(
	mnstr_t *p, mnstr_kind_t kind, rate_t rate
)
{
	mnstr_tab_t	*meta_tab, *tab;

	if( p == NULL )
		return;
	if( p->mnstr_tab == NULL )
		return;

	meta_tab = get_mnstr_tab( kind, 0 );
	tab = NULL;

	if( rate_randm( rate ) ){
		if( p->face.mjr == p->mnstr_tab->face_mjr ){
			tab = meta_tab;
		} else {
			tab = p->mnstr_tab;
		}
	}

	if( tab != NULL ){
		p->move = tab->move;
		p->modifier_fx.face_mjr = tab->face_mjr;
		p->modifier_fx.face_mnr = tab->face_mnr;
	}

	if( p->face.mjr == p->mnstr_tab->face_mjr ){
		set_act_mnstr_std( p );
	} else {
		meta_tab->func( p );
	}
}

void	set_act_mnstr_towner( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( set_act_rescue_trgt( p ) )
		return;
	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}

	chk_discount_mark( p );
	if( p->trgt.kind == TRGT_KIND_QUEUE )
		return;

	if( p->act.kind == ACT_KIND_DOOR_OPEN ){
		if( rate_randm( TOWNER_CANCEL_DOOR_RATE ) )
			clr_chr_trgt_act( p, FALSE );
	} else {
		set_act_mnstr_std( p );
		set_act_towner_enter_door( p );
	}

	set_act_towner_exit_door( p );
}

/**/

void	set_act_towner_enter_door( mnstr_t *p )
{
	door_t	*dr;

	if( p == NULL )
		return;
	if( p->act.kind == ACT_KIND_DOOR_OPEN )
		return;
	if( !rate_randm( TOWNER_ENTER_DOOR_RATE ) )
		return;

	dr = get_door_towner( p->x, p->y, TOWNER_ENTER_DOOR_R );
	if( dr == NULL )
		return;
	if( chk_discount_door( dr ) )
		return;

	set_chr_act( p, ACT_KIND_DOOR_OPEN, NULL, NULL, 0, 0 );
	mark_door( p, dr, DIST_NEAR );
}

/**/

void	set_act_towner_exit_door( mnstr_t *p )
{
	door_t	*dr;

	if( p == NULL )
		return;
	if( p->work.enter_door == NULL )
		return;

	if( chk_night() ){
		if( !rate_randm( TOWNER_EXIT_DOOR_RATE_NIGHT ) ){
			return;
		}
	} else {
		if( !rate_randm( TOWNER_EXIT_DOOR_RATE_DAY ) ){
			return;
		}
	}

	dr = p->work.enter_door;
	if( dr == NULL )
		return;

	if( get_shop_n( dr->mnr ) == SHOP_N_BAR ){
		long	i, max_n;

		/* ǿʧ */

		max_n = roll_dice( 5, FALSE );
		for( i = 0; i < max_n; i++ ){
			drink_liquor( p, LIQUOR_KIND_ALE );
		}
	}

	put_chr( p, dr->x, dr->y, FALSE );
	p->work.enter_door = NULL;
}

/**/

void	set_act_mnstr_friendly( mnstr_t *p )
{
	if( set_act_tame_mnstr( p ) )
		return;

	set_act_mnstr_std( p );
}

bool_t	set_act_tame_mnstr( mnstr_t *p )
{
	if( p == NULL )
		return FALSE;
	if( p->work.request == NULL )
		return FALSE;
	if( p->work.request->kind != REQUEST_KIND_TAME_MNSTR )
		return FALSE;

	if( p->fx_data.stomach.rate < _100_PERCENT ){
		item_t	*food;

		do {
			food = get_item_food( p,
					ACT_KIND_ITEM_PICK_UP, FALSE );
			if( food == NULL )
				break;
			if( food->kind != ITEM_KIND_FOOD )
				break;
			if( food->tab.food == NULL )
				break;

			mark_item( p, food, DIST_NEAR );

			if( food->x != p->x )
				break;
			if( food->y != p->y )
				break;

			take_meal_chr( p, food->tab.food->fill_rate );
			del_item( food );
		} while( 0 );
	} else {
		if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
			return FALSE;

		mnstr_mark_mbr_std( p );
		if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
			/* λ */
			chk_finish_request_join( p->work.request, p );
		}
	}

	return TRUE;
}

/**/

bool_t	set_act_rescue_trgt( mnstr_t *p )
{
	if( p == NULL )
		return FALSE;
	if( p->work.request == NULL )
		return FALSE;
	if( p->work.request->kind != REQUEST_KIND_RESCUE )
		return FALSE;

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		return FALSE;

	mnstr_mark_mbr_std( p );

	if( !chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		return TRUE;

	/* ߽λ */

	chk_finish_request_join( p->work.request, p );

	return TRUE;
}

/**/

/******************************************************************/

/*  */
/* ɥ饴 */

/*  */

void	set_act_mnstr_phoenix( mnstr_t *p )
{
	party_t	*pty = get_party();
	long	i;

	if( p == NULL )
		return;

	if( p->attitude != ATTITUDE_MATE ){
		set_act_mnstr_std( p );
		return;
	}

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		if( chk_flg_or( pty->mbr[i]->stat, FLG_STAT_DEAD ) )
			fx_resurrection( pty->mbr[i], TRUE );
	}

	p->work.dismissal_turn--;
	if( p->work.dismissal_turn <= 0 ){
		fx_dismissal( p );
		return;
	}

	set_act_mnstr_std( p );
}

void	set_act_mnstr_unicorn( mnstr_t *p )
{
	party_t	*pty = get_party();
	long	i;

	if( p == NULL )
		return;

	if( p->attitude != ATTITUDE_MATE ){
		set_act_mnstr_std( p );
		return;
	}

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		fx_cure_all_status( pty->mbr[i] );
	}

	p->work.dismissal_turn--;
	if( p->work.dismissal_turn <= 0 ){
		fx_dismissal( p );
		return;
	}

	set_act_mnstr_std( p );
}

/*  */

void	set_act_mnstr_leprechaun( mnstr_t *p )
{
	chr_t	*mbr;

	if( p == NULL )
		return;

	mbr = mnstr_mark_mbr_adjoin( p );

	if( mbr != NULL ){
		fx_pick_gold( p, mbr, PICK_GOLD_RATE, PICK_GOLD_MAX_N );
		print_msg( FLG_NULL, MSG_MNSTR_DISAPPEAR, p->name );
		teleport_chr( p );
	}

	set_act_mnstr_std( p );
}

/*  */

/* ʪ */

void	set_act_mnstr_venus_fly_trap( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) != NULL )
		catch_chr( p, p->trgt.p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_slime( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) == NULL )
		mnstr_mark_mbr_std( p );

	set_act_mnstr_std( p );
}

/**/

void	set_act_mnstr_spore( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) != NULL )
		mnstr_move_or_atack_std( p );
}

/* ưʪ */

void	set_act_mnstr_giant_rat( mnstr_t *p )
{
	static long	increase_turn = -1;

	if( p == NULL )
		return;

	set_act_mnstr_std( p );

	if( increase_turn < get_turn() ){
		if( rate_randm( INCREASE_RATE_GIANT_RAT ) ){
			increase_mnstr( p );
			increase_turn = get_turn();
		}
	}
}

/*  */

void	set_act_mnstr_giant_spider( mnstr_t *p )
{
	mbr_t	*mbr;
	bool_t	flg_rel;

	if( p == NULL )
		return;

	mbr = mnstr_mark_mbr_adjoin( p );
	if( mbr == NULL )
		mnstr_mark_mbr_std( p );
	else
		catch_chr( p, mbr );

	if( mbr == NULL )
		flg_rel = TRUE;
	else if( rate_randm( 30 ) )
		flg_rel = TRUE;
	else
		flg_rel = FALSE;

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		if( flg_rel )
			release_chr( p );

		mnstr_move_or_atack_std( p );
	}
}

/* ʹ */

/* Ⱦ */

void	set_act_mnstr_werewolf( mnstr_t *p )
{
	set_act_mnstr_metamorphose( p, MNSTR_KIND_WOLF, 10 );
}

/**/

/*  */
/* ʪ */

void	set_act_mnstr_gigantic_centipede( mnstr_t *p )
{
	chr_t	*l;

	if( p == NULL )
		return;

	l = p->work.link_chr;
	if( l != NULL ){
		if( (l->pre_x != l->x) || (l->pre_y != l->y) )
			mark_pos( p, l->pre_x, l->pre_y, DIST_NEAR );
		p->move.force_kind = MOVE_KIND_STD;
		return;
	}

	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}
	if( p->attitude != ATTITUDE_ENEMY )
		return;

	mnstr_mark_mbr_std( p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/* ʪ */

/* ˡʪ */

void	set_act_mnstr_gargoyle( mnstr_t *p )
{
	dun_t	*dun = get_dun();

	if( p == NULL )
		return;

	/* begin */

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		mnstr_mark_mbr_std( p );
	} else {
		flg_map_t	flg_map;
		chr_t	*mark;

		flg_map = dun->map.obj.flg[p->y][p->x];
		dun->map.obj.flg[p->y][p->x] |= FLG_MAP_OBJ_PASS;
		mark = mnstr_mark_mbr_adjoin( p );
		dun->map.obj.flg[p->y][p->x] = flg_map;

		if( mark != NULL ){
			/* Ĥ */
			dun->map.obj.mjr[p->y][p->x] = FACE_MJR_FLOOR;
			dun->map.obj.mnr[p->y][p->x] = FACE_MNR_FLOOR;
			dun->map.obj.flg[p->y][p->x] = FLG_MAP_OBJ_PASS;
		}
	}

	/* end */

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_mimic( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) != NULL )
		catch_chr( p, p->trgt.p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/*  */

/* ǥå */

void	set_act_mnstr_vampire( mnstr_t *p )
{
	set_act_mnstr_metamorphose( p, MNSTR_KIND_GIANT_BAT, 10 );
}

/*  */

void	set_act_mnstr_incubus( mnstr_t *p )
{
	set_act_mnstr_cubus( p, FEMALE );
}

/**/


void	set_act_mnstr_succubus( mnstr_t *p )
{
	set_act_mnstr_cubus( p, MALE );
}

/*  */
/*  */

