/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: request.c,v 1.70 2004/07/26 10:02:47 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
#include	"misc.h"
#include	"turn.h"
#include	"dun.h"
/*#include	"town.h"*/
#include	"item.h"
/*#include	"spell.h"*/
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
/*#include	"fight.h"*/
#include	"fx.h"
/*#include	"trap.h"*/
#include	"draw.h"
#include	"curs.h"
#include	"menu.h"
/*#include	"amenu.h"*/
#include	"request.h"
/*#include	"gfile.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
/*#include	"gmain-prot.h"*/
#include	"misc-prot.h"
#include	"turn-prot.h"
#include	"dun-prot.h"
/*#include	"town-prot.h"*/
#include	"item-prot.h"
/*#include	"spell-prot.h"*/
#include	"chr-prot.h"
#include	"party-prot.h"
#include	"mnstr-prot.h"
#include	"pet-prot.h"
/*#include	"fight-prot.h"*/
#include	"fx-prot.h"
/*#include	"trap-prot.h"*/
#include	"draw-prot.h"
#include	"curs-prot.h"
#include	"menu-prot.h"
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
#include	"request-prot.h"
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

/**/

#define	FLG_DEBUG_REQUEST	1

#define	REQUEST_RARE_GOODS_AVE_LIMIT	7
#define	REQUEST_TAME_MNSTR_AVE_LIMIT	7
#define	REQUEST_RESCUE_AVE_LIMIT	7
#define	REQUEST_TOUR_GUIDE_AVE_LIMIT	10
#define	REQUEST_EXTERMINATE_AVE_LIMIT	10
#define	REQUEST_REVENGE_AVE_LIMIT	12
#define	REQUEST_WANTED_CRIMINAL_AVE_LIMIT	12

#define	REQUEST_DUN_MIN_LEV_EASY	1
#define	REQUEST_DUN_MAX_LEV_EASY	50
#define	REQUEST_DUN_MIN_LEV_NORMAL	10
#define	REQUEST_DUN_MAX_LEV_NORMAL	50
#define	REQUEST_DUN_RANGE_LEV	1

#define	REQUEST_CONTRACT_RATE	20

#define	REQUEST_RARE_GOODS_DROP_RATE	((rate_t)20)
#define	REQUEST_TAME_MNSTR_MNSTR_AVE_N	4
#define	REQUEST_TOUR_GUIDE_MNSTR_AVE_N	4
#define	REQUEST_EXTERMINATE_MNSTR_AVE_N	4

/**/

#define	REQUEST_RARE_GOODS_GOLD_RATE	((rate_t)2000)
#define	REQUEST_RARE_GOODS_EXP_RATE	((rate_t)1000)

#define	REQUEST_TAME_MNSTR_GOLD_RATE	((rate_t)1000)
#define	REQUEST_TAME_MNSTR_EXP_RATE	((rate_t)1000)

#define	REQUEST_RESCUE_GOLD_RATE	((rate_t)2000)
#define	REQUEST_RESCUE_EXP_RATE	((rate_t)2000)

#define	REQUEST_TOUR_GUIDE_GOLD_RATE	((rate_t)3000)
#define	REQUEST_TOUR_GUIDE_EXP_RATE	((rate_t)1000)

#define	REQUEST_EXTERMINATE_GOLD_RATE	((rate_t)2000)
#define	REQUEST_EXTERMINATE_EXP_RATE	((rate_t)2000)

#define	REQUEST_REVENGE_GOLD_RATE	((rate_t)1000)
#define	REQUEST_REVENGE_EXP_RATE	((rate_t)3000)

#define	REQUEST_WANTED_CRIMINAL_GOLD_RATE	((rate_t)3000)
#define	REQUEST_WANTED_CRIMINAL_EXP_RATE	((rate_t)2000)

/**/

static request_t	g_request[REQUEST_MAX_N];
static menu_t	ls_menu_request[1 + REQUEST_MAX_N * 2];

/**/

#include	"request-tab.h"

/**/

void	init_request( void )
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ )
		g_request[i].kind = REQUEST_KIND_NULL;
}

/**/

request_t	*make_request_randm( void )
{
	request_t	*req;

	req = alloc_request();
	if( req == NULL )
		return NULL;

	switch( randm( REQUEST_KIND_MAX_N ) ){
	case REQUEST_KIND_NULL:
		break;
	case REQUEST_KIND_RARE_GOODS:
		return make_request_rare_goods( req );
	case REQUEST_KIND_TAME_MNSTR:
		return make_request_tame_mnstr( req );
	case REQUEST_KIND_RESCUE:
		return make_request_rescue( req );
	case REQUEST_KIND_TOUR_GUIDE:
		return make_request_tour_guide( req );
	case REQUEST_KIND_EXTERMINATE:
		return make_request_exterminate( req );
	case REQUEST_KIND_REVENGE:
		return make_request_revenge( req );
	case REQUEST_KIND_WANTED_CRIMINAL:
		return make_request_wanted_criminal( req );
	case REQUEST_KIND_MAX_N:
		break;
	}

	free_request( req );
	return NULL;
}

/**/

request_t	*make_request_rare_goods( request_t *req )
{
	long	dun_lev;
	mnstr_tab_t	*tab;
	mnstr_lev_tab_t	*lev_tab;
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_RARE_GOODS;

	dun_lev = REQUEST_DUN_MIN_LEV_EASY;
	dun_lev += randm( REQUEST_DUN_MAX_LEV_EASY
			- REQUEST_DUN_MIN_LEV_EASY );

	tab = get_mnstr_tab_rand( -dun_lev );
	if( tab == NULL )
		return NULL;
	lev_tab = get_mnstr_lev_tab( tab->mnstr_kind, dun_lev );
	if( lev_tab == NULL )
		return NULL;

	req->flg_mnstr_is_npc = FALSE;
	req->mnstr_kind = tab->mnstr_kind;
	req->idx_mnstr_name = -1;

	req->dun_min_lev = -lev_tab->min_lev;
	req->dun_max_lev = -min_l( lev_tab->max_lev,
			REQUEST_DUN_MAX_LEV_EASY );
	req->dun_true_lev = req->dun_max_lev;

	limit = roll_dice( REQUEST_RARE_GOODS_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_RARE_GOODS_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_RARE_GOODS_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_rare_goods_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

request_t	*make_request_tame_mnstr( request_t *req )
{
	mnstr_tab_t	*tab;
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_TAME_MNSTR;

	set_request_dun_lev( req,
			REQUEST_DUN_MIN_LEV_EASY,
			REQUEST_DUN_MAX_LEV_EASY,
			REQUEST_DUN_RANGE_LEV );

	tab = get_mnstr_tab_friendly();
	if( tab == NULL )
		return NULL;

	req->flg_mnstr_is_npc = FALSE;
	req->mnstr_kind = tab->mnstr_kind;
	req->idx_mnstr_name = -1;
	req->mnstr_n = REQUEST_TAME_MNSTR_MNSTR_AVE_N;
	req->mnstr_n = roll_dice( req->mnstr_n, TRUE );

	limit = roll_dice( REQUEST_TAME_MNSTR_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_TAME_MNSTR_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_TAME_MNSTR_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_tame_mnstr_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

request_t	*make_request_rescue( request_t *req )
{
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_RESCUE;

	set_request_dun_lev( req,
			REQUEST_DUN_MIN_LEV_NORMAL,
			REQUEST_DUN_MAX_LEV_NORMAL,
			REQUEST_DUN_RANGE_LEV );

	limit = roll_dice( REQUEST_RESCUE_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}
	if( per_randm( 2 ) ){
		req->rescue_trgt_sex = FEMALE;
	} else {
		req->rescue_trgt_sex = MALE;
	}
	req->rescue_trgt_kind = get_npc_kind_randm();

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_RESCUE_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_RESCUE_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_rescue_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

request_t	*make_request_tour_guide( request_t *req )
{
	long	dun_lev;
	mnstr_tab_t	*tab;
	mnstr_lev_tab_t	*lev_tab;
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_TOUR_GUIDE;

	dun_lev = REQUEST_DUN_MIN_LEV_EASY;
	dun_lev += randm( REQUEST_DUN_MAX_LEV_EASY
			- REQUEST_DUN_MIN_LEV_EASY );

	tab = get_mnstr_tab_rand( -dun_lev );
	if( tab == NULL )
		return NULL;
	lev_tab = get_mnstr_lev_tab( tab->mnstr_kind, dun_lev );
	if( lev_tab == NULL )
		return NULL;

	req->flg_mnstr_is_npc = FALSE;
	req->mnstr_kind = tab->mnstr_kind;
	req->idx_mnstr_name = -1;
	req->mnstr_n = REQUEST_TOUR_GUIDE_MNSTR_AVE_N;
	req->mnstr_n = roll_dice( req->mnstr_n, TRUE );
	req->mnstr_exterminate_n = 0;

	req->dun_min_lev = -lev_tab->min_lev;
	req->dun_max_lev = -min_l( lev_tab->max_lev,
			REQUEST_DUN_MAX_LEV_EASY );
	req->dun_true_lev = req->dun_max_lev;

	limit = roll_dice( REQUEST_TOUR_GUIDE_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_TOUR_GUIDE_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_TOUR_GUIDE_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_tour_guide_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

request_t	*make_request_exterminate( request_t *req )
{
	long	dun_lev;
	mnstr_tab_t	*tab;
	mnstr_lev_tab_t	*lev_tab;
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_EXTERMINATE;

	dun_lev = REQUEST_DUN_MIN_LEV_NORMAL;
	dun_lev += randm( REQUEST_DUN_MAX_LEV_NORMAL
			- REQUEST_DUN_MIN_LEV_NORMAL );

	tab = get_mnstr_tab_rand( -dun_lev );
	if( tab == NULL )
		return NULL;
	lev_tab = get_mnstr_lev_tab( tab->mnstr_kind, dun_lev );
	if( lev_tab == NULL )
		return NULL;

	req->flg_mnstr_is_npc = FALSE;
	req->mnstr_kind = tab->mnstr_kind;
	req->idx_mnstr_name = -1;
	req->mnstr_n = REQUEST_EXTERMINATE_MNSTR_AVE_N;
	req->mnstr_n = roll_dice( req->mnstr_n, TRUE );
	req->mnstr_exterminate_n = 0;

	req->dun_min_lev = -lev_tab->min_lev;
	req->dun_max_lev = -min_l( lev_tab->max_lev,
			REQUEST_DUN_MAX_LEV_NORMAL );
	req->dun_true_lev = req->dun_max_lev;

	limit = roll_dice( REQUEST_EXTERMINATE_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_EXTERMINATE_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_EXTERMINATE_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_exterminate_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

request_t	*make_request_revenge( request_t *req )
{
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_REVENGE;

	set_request_dun_lev( req,
			REQUEST_DUN_MIN_LEV_NORMAL,
			REQUEST_DUN_MAX_LEV_NORMAL,
			REQUEST_DUN_RANGE_LEV );

	req->flg_mnstr_is_npc = TRUE;
	req->mnstr_kind = get_npc_kind_randm();
	req->idx_mnstr_name = -1;
	req->mnstr_n = 0;
	req->mnstr_exterminate_n = 0;

	limit = roll_dice( REQUEST_REVENGE_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}
	if( per_randm( 2 ) ){
		req->mnstr_sex = FEMALE;
	} else {
		req->mnstr_sex = MALE;
	}

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_REVENGE_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_REVENGE_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_revenge_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

request_t	*make_request_wanted_criminal( request_t *req )
{
	long	limit;

	if( req == NULL )
		return NULL;

	req->kind = REQUEST_KIND_WANTED_CRIMINAL;

	set_request_dun_lev( req,
			REQUEST_DUN_MIN_LEV_NORMAL,
			REQUEST_DUN_MAX_LEV_NORMAL,
			REQUEST_DUN_RANGE_LEV );

	req->flg_mnstr_is_npc = TRUE;
	req->mnstr_kind = get_npc_kind_randm();
	req->idx_mnstr_name = -1;
	req->mnstr_n = 0;
	req->mnstr_exterminate_n = 0;

	limit = roll_dice( REQUEST_WANTED_CRIMINAL_AVE_LIMIT, TRUE );
	req->limit = get_game_day() + limit;

	if( per_randm( 2 ) ){
		req->client_sex = FEMALE;
	} else {
		req->client_sex = MALE;
	}
	if( per_randm( 2 ) ){
		req->mnstr_sex = FEMALE;
	} else {
		req->mnstr_sex = MALE;
	}

	req->prize = calc_mnstr_gold( labs( req->dun_max_lev ),
			REQUEST_WANTED_CRIMINAL_GOLD_RATE );
	req->exp = calc_mnstr_exp( NULL, labs( req->dun_max_lev ) );
	req->exp *= REQUEST_WANTED_CRIMINAL_EXP_RATE;
	req->exp /= _100_PERCENT;

	req->idx_fmt = get_ls_n_msg_idx_randm( g_wanted_criminal_tab );
	set_request_msg( req );
	set_request_heading( req );

	return req;
}

/**/

bool_t	make_client( request_t *req, mnstr_kind_t kind, bool_t flg_now )
{
	mbr_t	*owner;
	pet_t	*npc;
	char	*name, *words_name;
	sex_t	sex, words_sex;
	long	npc_dun_lev;
	char	*msg_female, *msg_male;
	bool_t	flg_no_mark;

	/* 顼ȯ֤ */
	/* 饯Ϥɬפ̵ϥ顼ǤϤʤ */

	if( req == NULL )
		return FALSE;

	owner = get_mbr_randm( MAP_DEL_X, MAP_DEL_Y );
	if( owner == NULL )
		return FALSE;

	name = MSG_MNSTR_UNKNOWN;
	sex = FEMALE;
	npc_dun_lev = 1;
	msg_female = MSG_NULL;
	msg_male = MSG_NULL;
	flg_no_mark = FALSE;

	words_name = MSG_MNSTR_UNKNOWN;
	words_sex = FEMALE;

	switch( req->kind ){
	case REQUEST_KIND_NULL:
	case REQUEST_KIND_RARE_GOODS:
		return TRUE;
	case REQUEST_KIND_TAME_MNSTR:
		if( !flg_now )
			return TRUE;
		name = cv_idx_to_mnstr_name( req );
		sex = req->mnstr_sex;
		npc_dun_lev = 5;
		msg_female = MSG_WORDS_REQUEST_TAME_MNSTR_JOIN_FEMALE;
		msg_male = MSG_WORDS_REQUEST_TAME_MNSTR_JOIN_MALE;
		flg_no_mark = FALSE;

		words_name = owner->name;
		words_sex = owner->sex.cur;
		break;
	case REQUEST_KIND_RESCUE:
		if( !flg_now )
			return TRUE;
		name = cv_idx_to_rescue_trgt_name( req );
		sex = req->rescue_trgt_sex;
		npc_dun_lev = 5;
		msg_female = MSG_WORDS_REQUEST_RESCUE_JOIN_FEMALE;
		msg_male = MSG_WORDS_REQUEST_RESCUE_JOIN_MALE;
		flg_no_mark = TRUE;

		words_name = name;
		words_sex = sex;
		break;
	case REQUEST_KIND_TOUR_GUIDE:
		name = cv_idx_to_client_name( req );
		sex = req->client_sex;
		npc_dun_lev = 5;
		msg_female = MSG_WORDS_REQUEST_TOUR_GUIDE_JOIN_FEMALE;
		msg_male = MSG_WORDS_REQUEST_TOUR_GUIDE_JOIN_MALE;
		flg_no_mark = TRUE;

		words_name = name;
		words_sex = sex;
		break;
	case REQUEST_KIND_EXTERMINATE:
		return TRUE;
	case REQUEST_KIND_REVENGE:
		name = cv_idx_to_client_name( req );
		sex = req->client_sex;
		npc_dun_lev = req->dun_max_lev;
		msg_female = MSG_WORDS_REQUEST_REVENGE_JOIN_FEMALE;
		msg_male = MSG_WORDS_REQUEST_REVENGE_JOIN_MALE;
		flg_no_mark = FALSE;

		words_name = name;
		words_sex = sex;
		break;
	case REQUEST_KIND_WANTED_CRIMINAL:
	case REQUEST_KIND_MAX_N:
		return TRUE;
	}

	npc = make_pet( npc_dun_lev, kind, owner );
	if( npc == NULL )
		return FALSE;

	strncpy( npc->name, name, CHR_NAME_MAX_LEN );
	npc->sex.org = sex;
	npc->sex.cur = sex;
	npc->work.request = req;
	npc->flg_chr &= ~(FLG_CHR_CAN_DEL);
	if( flg_no_mark )
		npc->flg_chr |= FLG_CHR_NO_MARK_MNSTR;

	if( !join_pet( npc ) ){
		die_chr( npc, FALSE, FALSE, TRUE );
		return FALSE;
	}

	if( (msg_female != NULL) && (msg_male != NULL) ){
		print_words( words_name, words_sex,
				msg_female, msg_male, npc->name );
	}
	print_msg( FLG_NULL, MSG_JOIN_CHR, npc->name );

	return TRUE;
}

/**/

void	set_request_dun_lev(
	request_t *req,
	long min_lev, long max_lev, long range_lev
)
{
	long	lev, true_range_lev;

	if( req == NULL )
		return;

	min_lev = labs( min_lev );
	max_lev = labs( max_lev );
	if( max_lev < min_lev ){
		long	n;

		n = max_lev;
		max_lev = min_lev;
		min_lev = n;
	}

	lev = min_lev + randm( max_lev - min_lev );
	true_range_lev = randm( range_lev ) + 1;

	req->dun_min_lev = -lev;
	req->dun_max_lev = -(lev + (true_range_lev - 1));
	req->dun_true_lev = -(lev + randm( true_range_lev ));
}

/**/

n_msg_idx_t	get_ls_n_msg_idx_randm( n_msg_t ls[] )
{
	n_msg_idx_t	i;

	if( ls == NULL )
		return 0;

	for( i = 0; i < LOOP_MAX_4000; i++ )
		if( ls[i] == N_MSG_NULL )
			break;
	if( i <= 0 )
		return 0;

	return( randm( i ) );
}

/**/

request_t	*alloc_request( void )
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ )
		if( g_request[i].kind == REQUEST_KIND_NULL )
			break;
	if( i >= REQUEST_MAX_N )
		return NULL;

	g_request[i].kind = REQUEST_KIND_NULL;
	g_request[i].dun_min_lev = 0;
	g_request[i].dun_max_lev = 0;
	g_request[i].dun_true_lev = 0;
	g_request[i].prize = 0;
	g_request[i].exp = 0;
	g_request[i].limit = 0;
	g_request[i].flg_contract = FALSE;
	g_request[i].flg_contract_mbr = FALSE;
	g_request[i].idx_contract_name = -1;
	g_request[i].contract_sex = FEMALE;
	g_request[i].flg_finish = FALSE;

	g_request[i].rare_goods_kind = RARE_GOODS_KIND_NULL;
	g_request[i].flg_mnstr_is_npc = FALSE;
	g_request[i].mnstr_kind = MNSTR_KIND_NULL;
	g_request[i].mnstr_n = 1;
	g_request[i].mnstr_exterminate_n = 0;

	g_request[i].heading[0] = '\0';
	g_request[i].msg[0] = '\0';

	g_request[i].idx_client_name = -1;
	g_request[i].idx_mnstr_name = -1;
	g_request[i].idx_rescue_trgt_name = -1;
	g_request[i].idx_client_family_name = -1;
	g_request[i].idx_client_mate_name = -1;

	if( per_randm( 2 ) ){
		g_request[i].client_sex = FEMALE;
	} else {
		g_request[i].client_sex = MALE;
	}
	if( per_randm( 2 ) ){
		g_request[i].mnstr_sex = FEMALE;
	} else {
		g_request[i].mnstr_sex = MALE;
	}
	if( per_randm( 2 ) ){
		g_request[i].rescue_trgt_sex = FEMALE;
	} else {
		g_request[i].rescue_trgt_sex = MALE;
	}
	if( g_request[i].client_sex == MALE ){
		g_request[i].client_family_sex = FEMALE;
	} else {
		g_request[i].client_family_sex = MALE;
	}
	if( per_randm( 2 ) ){
		g_request[i].client_mate_sex = FEMALE;
	} else {
		g_request[i].client_mate_sex = MALE;
	}

	g_request[i].rescue_trgt_kind = MNSTR_KIND_NULL;

	g_request[i].idx_when_1 = -1;
	g_request[i].idx_when_2 = -1;

	g_request[i].idx_weapon = -1;

	return( &(g_request[i]) );
}

/**/

void	free_request( request_t *req )
{
	if( req == NULL )
		return;

	req->kind = REQUEST_KIND_NULL;
}

/**/

request_t	*get_request_ls( void )
{
	return g_request;
}

/**/

long	get_request_n( void )
{
	long	n;
	long	i;

	n = 0;
	for( i = 0; i < REQUEST_MAX_N; i++ )
		if( g_request[i].kind != REQUEST_KIND_NULL )
			n++;

	return n;
}

/**/

char	*get_request_kind_name( request_kind_t kind )
{
	switch( kind ){
	case REQUEST_KIND_NULL:
		break;
	case REQUEST_KIND_RARE_GOODS:
		return MSG_REQUEST_KIND_RARE_GOODS;
	case REQUEST_KIND_TAME_MNSTR:
		return MSG_REQUEST_KIND_TAME_MNSTR;
	case REQUEST_KIND_RESCUE:
		return MSG_REQUEST_KIND_RESCUE;
	case REQUEST_KIND_TOUR_GUIDE:
		return MSG_REQUEST_KIND_TOUR_GUIDE;
	case REQUEST_KIND_EXTERMINATE:
		return MSG_REQUEST_KIND_EXTERMINATE;
	case REQUEST_KIND_REVENGE:
		return MSG_REQUEST_KIND_REVENGE;
	case REQUEST_KIND_WANTED_CRIMINAL:
		return MSG_REQUEST_KIND_WANTED_CRIMINAL;
	case REQUEST_KIND_MAX_N:
		break;
	}

	return MSG_NULL;
}

/**/

void	chk_request_limit( void )
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		request_t	*req;

		req = &(g_request[i]);
		if( req->kind == REQUEST_KIND_NULL )
			continue;
		if( req->limit >= get_game_day() )
			continue;

		if( req->flg_contract && req->flg_contract_mbr ){
			char	*name;
			mbr_t	*mbr;

			chk_request_limit_client( req );

			name = get_request_kind_name( req->kind );
			mbr = get_mbr_randm( MAP_DEL_X, MAP_DEL_Y );

			curs_attrset_chr( mbr, -1, TRUE );
			print_msg( FLG_NULL, MSG_REQUEST_LIMIT, name );
			curs_attrset_dflt();

			fx_energy_drain_all_mbr();
		}

		free_request( req );
	}
}

/**/

bool_t	chk_request_limit_client( request_t *req )
{
	pet_t	*npc;
	mnstr_t	*mnstr;
	bool_t	flg_trans_mnstr;

	if( req == NULL )
		return FALSE;
	if( req->kind == REQUEST_KIND_NULL )
		return FALSE;
	if( !req->flg_contract )
		return FALSE;

	npc = get_npc_request( req );
	if( npc == NULL )
		return FALSE;

	if( chk_flg_or( npc->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
		print_msg( FLG_NULL, MSG_NOT_JOIN_CHR, npc->name );
		remove_pet( npc );
		return TRUE;
	}

	flg_trans_mnstr = FALSE;
	switch( req->kind ){
	case REQUEST_KIND_NULL:
	case REQUEST_KIND_RARE_GOODS:
		return FALSE;
	case REQUEST_KIND_TAME_MNSTR:
		return TRUE;	/* FALSE ǤϤʤ */
	case REQUEST_KIND_RESCUE:
		print_words( npc->name, npc->sex.cur,
				MSG_WORDS_REQUEST_RESCUE_LIMIT_FEMALE,
				MSG_WORDS_REQUEST_RESCUE_LIMIT_MALE,
				npc->name );
		flg_trans_mnstr = TRUE;
		break;
	case REQUEST_KIND_TOUR_GUIDE:
		print_words( npc->name, npc->sex.cur,
				MSG_WORDS_REQUEST_TOUR_GUIDE_LIMIT_FEMALE,
				MSG_WORDS_REQUEST_TOUR_GUIDE_LIMIT_MALE,
				npc->name );
		flg_trans_mnstr = FALSE;
		break;
	case REQUEST_KIND_EXTERMINATE:
		return FALSE;
	case REQUEST_KIND_REVENGE:
		print_words( npc->name, npc->sex.cur,
				MSG_WORDS_REQUEST_REVENGE_LIMIT_FEMALE,
				MSG_WORDS_REQUEST_REVENGE_LIMIT_MALE,
				npc->name );
		flg_trans_mnstr = TRUE;
		break;
	case REQUEST_KIND_WANTED_CRIMINAL:
	case REQUEST_KIND_MAX_N:
		return FALSE;
	}

	/* ̤ */

	print_msg( FLG_NULL, MSG_NOT_JOIN_CHR, npc->name );

	if( flg_trans_mnstr ){
		if( clip_pos( npc->x, npc->y ) ){
			long	x, y;

			mnstr = make_mnstr( MAP_DEL_X, MAP_DEL_Y,
					req->dun_max_lev, npc->mnstr_kind );
			x = npc->x;
			y = npc->y;
			if( !clip_pos( x, y ) ){
				x = randm( MAP_MAX_X );
				y = randm( MAP_MAX_Y );
			}
			put_chr( mnstr, x, y, FALSE );
		} else {
			mnstr = NULL;
		}
		if( mnstr != NULL ){
			strncpy( mnstr->name, npc->name, CHR_NAME_MAX_LEN );
			mnstr->sex.org = npc->sex.cur;
			mnstr->sex.cur = mnstr->sex.org;
		}
	}

	remove_pet( npc );

	return TRUE;
}

/**/

void	chk_request_contract( void )
{
	chk_clr_request_contract();
	chk_set_request_contract();
}

/**/

void	chk_clr_request_contract( void )
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( !g_request[i].flg_contract )
			continue;
		if( g_request[i].flg_contract_mbr )
			continue;

		/**/

		g_request[i].kind = REQUEST_KIND_NULL;
	}
}

/**/

void	chk_set_request_contract( void )
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		n_msg_idx_t	idx;
		sex_t	sex;

		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( g_request[i].flg_contract )
			continue;
		if( !rate_randm( REQUEST_CONTRACT_RATE ) )
			continue;

		/**/

		if( per_randm( 2 ) ){
			idx = get_ls_n_msg_idx_randm( g_ls_npc_name_female );
			sex = FEMALE;
		} else {
			idx = get_ls_n_msg_idx_randm( g_ls_npc_name_male );
			sex = MALE;
		}

		chr_contract_request( &(g_request[i]),
				CHR_KIND_MNSTR, idx, sex );
	}
}

/**/

bool_t	set_request_msg( request_t *req )
{
	char	buf[REQUEST_MSG_MAX_LEN * 2], *fmt;
	long	buf_idx, fmt_idx;
	char	str_contract[REQUEST_MSG_MAX_LEN + 1];

	if( req == NULL )
		return FALSE;

	fmt = cv_idx_to_request_fmt( req );

	buf[0] = '\0';
	for( buf_idx = 0, fmt_idx = 0; buf_idx < REQUEST_MSG_MAX_LEN - 2;
			buf_idx++, fmt_idx++ ){
		if( fmt[fmt_idx] == '\0' ){
			break;
		} else if( fmt[fmt_idx] == '\\' ){
			buf_idx--;
		} else if( fmt[fmt_idx] & 0x80 ){
			buf[buf_idx] = fmt[fmt_idx];
			buf_idx++;
			fmt_idx++;
			buf[buf_idx] = fmt[fmt_idx];
		} else if( fmt[fmt_idx] == '$' ){
			if( fmt[fmt_idx + 1] == '$' ){
				buf[buf_idx] = fmt[fmt_idx];
				fmt_idx++;
			} else if( fmt[fmt_idx + 1] != '{' ){
				buf[buf_idx] = fmt[fmt_idx];
			} else {
				set_request_msg_var(
						req,
						&(buf[buf_idx]), &buf_idx,
						&(fmt[fmt_idx]), &fmt_idx );
			}
		} else {
			buf[buf_idx] = fmt[fmt_idx];
		}
	}
	buf[buf_idx] = '\0';

	if( req->flg_contract ){
		char	*name;

		if( req->flg_contract_mbr )
			name = MSG_NPC_NAME_YOU_KIMIRA;
		else
			name = cv_idx_to_contract_name( req );

		sprintf( str_contract,
				MSG_REQUEST_CONTRACT_FMT, name );
	} else {
		strncpy( str_contract,
				MSG_REQUEST_DO_NOT_CONTRACT,
				REQUEST_MSG_MAX_LEN );
	}
	str_max_n_cat( buf, "\n", REQUEST_MSG_MAX_LEN );
	str_max_n_cat( buf, str_contract, REQUEST_MSG_MAX_LEN );

	strncpy( req->msg, buf, REQUEST_MSG_MAX_LEN );

	return TRUE;
}

/**/

void	set_request_msg_var(
	request_t *req,
	char *buf, long *buf_idx,
	char *fmt, long *fmt_idx
)
{
	char	*tail, *arg;
	long	len, max_len;
	long	i;

	if( buf == NULL )
		return;
	if( fmt == NULL )
		return;
	if( buf_idx == NULL )
		return;
	if( fmt_idx == NULL )
		return;

	buf[0] = '\0';

	fmt += 2;

	tail = strchr( fmt, '}' );
	if( tail == NULL )
		return;
	max_len = tail - fmt;

	arg = strchr( fmt, ':' );
	if( arg == NULL ){
		len = max_len;
	} else {
		len = arg - fmt;
		if( len < max_len ){
			arg++;
		} else {
			len = max_len;
			arg = NULL;
		}
	}

	*fmt_idx += 2;

	for( i = 0; i < LOOP_MAX_4000; i++ ){
		if( g_request_msg_var[i].name == NULL )
			break;
		if( strncmp( fmt, g_request_msg_var[i].name, len ) == 0 ){
			g_request_msg_var[i].func( req, buf, arg );
			*buf_idx += str_len_std( buf ) - 1;
			*fmt_idx += max_len + 1 - 1;
			break;
		}
	}
}

/**/

void	set_request_msg_var_dun_min_lev(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	sprintf( buf, "%ld", req->dun_min_lev );
}

/**/

void	set_request_msg_var_dun_max_lev(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	sprintf( buf, "%ld", req->dun_max_lev );
}

/**/

void	set_request_msg_var_dun_lev_range(
	request_t *req, char *buf, char *arg
)
{
	char	str_min[32 + 1], str_max[32 + 1];

	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->dun_min_lev >= +1 ){
		sprintf( str_min, MSG_FLOOR_FMT,
				labs( req->dun_min_lev ) );
	} else if( req->dun_min_lev <= -1 ){
		sprintf( str_min, MSG_BASE_FMT,
				labs( req->dun_min_lev ) );
	} else {
		sprintf( str_min, MSG_S, MSG_GROUND );
	}

	if( req->dun_max_lev >= +1 ){
		sprintf( str_max, MSG_FLOOR_FMT,
				labs( req->dun_max_lev ) );
	} else if( req->dun_max_lev <= -1 ){
		sprintf( str_max, MSG_BASE_FMT,
				labs( req->dun_max_lev ) );
	} else {
		sprintf( str_max, MSG_S, MSG_GROUND );
	}

	if( req->dun_min_lev == req->dun_max_lev ){
		sprintf( buf, MSG_REQUEST_DUN_LEV, str_max );
	} else {
		sprintf( buf, MSG_REQUEST_DUN_LEV_RANGE,
				str_min, str_max );
	}
}

/**/

void	set_request_msg_var_client(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->client_sex == FEMALE ){
		set_request_msg_var_ls( req, buf,
				&(req->idx_client_name),
				g_ls_npc_name_female, FALSE );
	} else {
		set_request_msg_var_ls( req, buf,
				&(req->idx_client_name),
				g_ls_npc_name_male, FALSE );
	}
}

/**/

void	set_request_msg_var_rare_goods(
	request_t *req, char *buf, char *arg
)
{
	rare_goods_tab_t	*tab;

	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->rare_goods_kind == RARE_GOODS_KIND_NULL )
		req->rare_goods_kind = get_rare_goods_randm();

	tab = get_rare_goods_tab( req->rare_goods_kind );
	if( tab == NULL )
		return;

	sprintf( buf, MSG_REQUEST_VAR_QUOTE, tab->name );
}

/**/

void	set_request_msg_var_mnstr(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->flg_mnstr_is_npc ){
		if( req->mnstr_sex == FEMALE ){
			set_request_msg_var_ls( req, buf,
					&(req->idx_mnstr_name),
					g_ls_npc_name_female, TRUE );
		} else {
			set_request_msg_var_ls( req, buf,
					&(req->idx_mnstr_name),
					g_ls_npc_name_male, TRUE );
		}
	} else {
		mnstr_tab_t	*tab;

		tab = get_mnstr_tab( req->mnstr_kind, req->dun_true_lev );
		if( tab == NULL ){
			sprintf( buf, MSG_REQUEST_VAR_QUOTE,
					MSG_MNSTR_UNKNOWN );
		} else {
			sprintf( buf, MSG_REQUEST_VAR_QUOTE,
					tab->name );
		}
	}
}

/**/

void	set_request_msg_var_mnstr_n(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	sprintf( buf, MSG_REQUEST_MNSTR_N, req->mnstr_n );
}

/**/

void	set_request_msg_var_rescue_trgt(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->rescue_trgt_sex == FEMALE ){
		set_request_msg_var_ls( req, buf,
				&(req->idx_rescue_trgt_name),
				g_ls_npc_name_female, TRUE );
	} else {
		set_request_msg_var_ls( req, buf,
				&(req->idx_rescue_trgt_name),
				g_ls_npc_name_male, TRUE );
	}
}

/**/

void	set_request_msg_var_client_family(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->client_sex == MALE ){
		/* 礬ʤ²Ϻ */
		req->client_family_sex = FEMALE;
	} else {
		/* 礬ʤ² */
		req->client_family_sex = MALE;
	}

	if( req->client_family_sex == FEMALE ){
		set_request_msg_var_ls( req, buf,
				&(req->idx_client_family_name),
				g_ls_family_female, FALSE );
	} else {
		set_request_msg_var_ls( req, buf,
				&(req->idx_client_family_name),
				g_ls_family_male, FALSE );
	}
}

/**/

void	set_request_msg_var_client_mate(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	if( req->client_mate_sex == FEMALE ){
		set_request_msg_var_ls( req, buf,
				&(req->idx_client_mate_name),
				g_ls_npc_name_female, FALSE );
	} else {
		set_request_msg_var_ls( req, buf,
				&(req->idx_client_mate_name),
				g_ls_npc_name_male, FALSE );
	}
}

/**/

void	set_request_msg_var_when_1(
	request_t *req, char *buf, char *arg
)
{
	n_msg_t	*ls_msg;

	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	ls_msg = g_ls_when_a;
	if( arg != NULL ){
		switch( arg[0] ){
		case 'a':
			ls_msg = g_ls_when_a;
			break;
		case 'b':
			ls_msg = g_ls_when_b;
			break;
		}
	}

	set_request_msg_var_ls( req, buf,
			&(req->idx_when_1),
			ls_msg, FALSE );
}

/**/

void	set_request_msg_var_when_2(
	request_t *req, char *buf, char *arg
)
{
	n_msg_t	*ls_msg;

	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	ls_msg = g_ls_when_a;
	if( arg != NULL ){
		switch( arg[0] ){
		case 'a':
			ls_msg = g_ls_when_a;
			break;
		case 'b':
			ls_msg = g_ls_when_b;
			break;
		}
	}

	set_request_msg_var_ls( req, buf,
			&(req->idx_when_2),
			ls_msg, FALSE );
}

/**/

void	set_request_msg_var_weapon(
	request_t *req, char *buf, char *arg
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;

	set_request_msg_var_ls( req, buf,
			&(req->idx_weapon),
			g_ls_weapon, FALSE );
}

/**/

void	set_request_msg_var_ls(
	request_t *req, char *buf,
	n_msg_idx_t *n_msg_idx, n_msg_t ls_msg[],
	bool_t flg_quote
)
{
	if( buf == NULL )
		return;
	buf[0] = '\0';
	if( req == NULL )
		return;
	if( n_msg_idx == NULL )
		return;
	if( ls_msg == NULL )
		return;

	if( *n_msg_idx <= -1 )
		*n_msg_idx = get_ls_n_msg_idx_randm( ls_msg );

	if( flg_quote ){
		sprintf( buf, MSG_REQUEST_VAR_QUOTE,
				MSG( ls_msg[*n_msg_idx] ) );
	} else {
		sprintf( buf, MSG_S,
				MSG( ls_msg[*n_msg_idx] ) );
	}
}

/**/

bool_t	set_request_heading( request_t *req )
{
	char	*str_contract;

	if( req == NULL )
		return FALSE;

	if( req->flg_finish ){
		str_contract = MSG_REQUEST_CONTRACT_FINISH;
	} else if( req->flg_contract ){
		if( req->flg_contract_mbr ){
			str_contract = MSG_REQUEST_CONTRACT_YOU;
		} else {
			str_contract = MSG_REQUEST_CONTRACT_OTHER;
		}
	} else {
		str_contract = MSG_REQUEST_CONTRACT_STILL;
	}

	sprintf( req->heading, MSG_REQUEST_HEADING_FMT,
			str_contract,
			get_request_kind_name( req->kind ),
			req->dun_max_lev,
			req->limit - get_game_day(),
			req->prize );

	return TRUE;
}

/**/

bool_t	chr_contract_request(
	request_t *req,
	chr_kind_t kind, n_msg_idx_t n_idx_name, sex_t sex
)
{
	if( req == NULL )
		return FALSE;

	if( req->kind == REQUEST_KIND_NULL )
		return FALSE;
	if( req->flg_contract )
		return FALSE;

	/**/

	if( kind == CHR_KIND_MBR ){
		req->idx_contract_name = -1;
		req->contract_sex = FEMALE;
		req->flg_contract_mbr = TRUE;

		if( !make_client( req, get_npc_kind_randm(), FALSE ) )
			return FALSE;
	} else if( kind == CHR_KIND_MNSTR ){
		req->idx_contract_name = n_idx_name;
		req->contract_sex = sex;
		req->flg_contract_mbr = FALSE;
	} else {
		return FALSE;
	}

	req->flg_contract = TRUE;

	return TRUE;
}

/**/

bool_t	finish_request( request_t *req )
{
	party_t	*pty = get_party();

	if( req == NULL )
		return FALSE;
	if( req->kind == REQUEST_KIND_NULL )
		return FALSE;
	if( req->flg_finish )
		return FALSE;

	req->flg_finish = TRUE;

	curs_attrset_chr( pty->mbr[0], +1, TRUE );
	print_msg( FLG_NULL, MSG_REQUEST_FINISH,
			get_request_kind_name( req->kind ) );
	curs_attrset_dflt();

	return TRUE;
}

/**/

bool_t	dont_finish_request( request_t *req )
{
	if( req == NULL )
		return FALSE;

	if( req->kind == REQUEST_KIND_NULL )
		return FALSE;
	if( !req->flg_finish )
		return FALSE;

	req->flg_finish = FALSE;

	return TRUE;
}

/**/

void	chk_finish_request_chr_dead( chr_t *chr )
{
	request_t	*req;

	if( chr == NULL )
		return;

	chk_finish_request_exterminate( chr->mnstr_kind, 1,
			REQUEST_KIND_TOUR_GUIDE, FALSE );
	chk_finish_request_exterminate( chr->mnstr_kind, 1,
			REQUEST_KIND_EXTERMINATE, TRUE );

	req = chr->work.request;
	if( req != NULL ){
		switch( req->kind ){
		case REQUEST_KIND_NULL:
		case REQUEST_KIND_RARE_GOODS:
		case REQUEST_KIND_TAME_MNSTR:
		case REQUEST_KIND_RESCUE:
		case REQUEST_KIND_TOUR_GUIDE:
		case REQUEST_KIND_EXTERMINATE:
			break;
		case REQUEST_KIND_REVENGE:
			chk_finish_request_revenge( req );
			break;
		case REQUEST_KIND_WANTED_CRIMINAL:
			chk_finish_request_wanted_criminal( req );
			break;
		case REQUEST_KIND_MAX_N:
			break;
		}
	}

	put_request_rare_goods( chr );
}

/**/

void	chk_finish_request_rare_goods( void )
{
	party_t	*pty = get_party();
	long	i, j;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( g_request[i].kind != REQUEST_KIND_RARE_GOODS )
			continue;
		if( !g_request[i].flg_contract )
			continue;
		if( !g_request[i].flg_contract_mbr )
			continue;

		dont_finish_request( &(g_request[i]) );

		for( j = 0; j < MBR_MAX_N; j++ ){
			if( chk_mbr_have_rare_goods(
					pty->mbr[j],
					g_request[i].rare_goods_kind,
					g_request[i].mnstr_kind,
					FALSE ) ){
				finish_request( &(g_request[i]) );
				break;
			}
		}
	}
}

/**/

bool_t	chk_finish_request_join( request_t *req, mnstr_t *npc )
{
	if( req == NULL )
		return FALSE;
	if( req->flg_finish )
		return FALSE;
	if( !req->flg_contract )
		return FALSE;
	if( !req->flg_contract_mbr )
		return FALSE;
	if( npc == NULL )
		return FALSE;

	switch( req->kind ){
	case REQUEST_KIND_NULL:
	case REQUEST_KIND_RARE_GOODS:
		return FALSE;
	case REQUEST_KIND_TAME_MNSTR:
	case REQUEST_KIND_RESCUE:
		break;
	case REQUEST_KIND_TOUR_GUIDE:
	case REQUEST_KIND_EXTERMINATE:
	case REQUEST_KIND_REVENGE:
	case REQUEST_KIND_WANTED_CRIMINAL:
	case REQUEST_KIND_MAX_N:
		return FALSE;
	}

	make_client( npc->work.request, npc->mnstr_kind, TRUE );
	die_chr( npc, FALSE, FALSE, TRUE );
	finish_request( req );

	return TRUE;
}

/**/

void	chk_finish_request_exterminate(
	mnstr_kind_t mnstr_kind,
	long add,
	request_kind_t req_kind,
	bool_t flg_dec_add
)
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		request_t	*req;

		if( add < 0 )
			break;

		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( g_request[i].kind != req_kind )
			continue;
		if( !g_request[i].flg_contract )
			continue;
		if( !g_request[i].flg_contract_mbr )
			continue;
		if( g_request[i].mnstr_kind != mnstr_kind )
			continue;

		req = &(g_request[i]);
		req->mnstr_exterminate_n += add;
		if( flg_dec_add )
			add = req->mnstr_exterminate_n - req->mnstr_n;
		if( req->mnstr_exterminate_n >= req->mnstr_n )
			finish_request( req );
	}
}

/**/

bool_t	chk_finish_request_revenge( request_t *req )
{
	pet_t	*npc;

	if( req == NULL )
		return FALSE;
	if( req->kind != REQUEST_KIND_REVENGE )
		return FALSE;

	npc = get_npc_request( req );
	if( npc == NULL ){
		free_request( req );
		return FALSE;
	}

	print_words( npc->name, npc->sex.cur,
			MSG_WORDS_REQUEST_REVENGE_FINISH_FEMALE,
			MSG_WORDS_REQUEST_REVENGE_FINISH_MALE );

	finish_request( req );

	return TRUE;
}

/**/

bool_t	chk_finish_request_wanted_criminal( request_t *req )
{
	if( req == NULL )
		return FALSE;
	if( req->kind != REQUEST_KIND_WANTED_CRIMINAL )
		return FALSE;

	if( req->flg_contract && req->flg_contract_mbr ){
		finish_request( req );
		return TRUE;
	} else {
		free_request( req );
		return FALSE;
	}
}

/**/

void	close_all_request( chr_kind_t chr_kind )
{
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( !g_request[i].flg_contract )
			continue;

		/**/

		close_request( &(g_request[i]), chr_kind );
	}
}

/**/

bool_t	close_request( request_t *req, chr_kind_t chr_kind )
{
	party_t	*pty = get_party();
	long	i;

	if( req == NULL )
		return FALSE;

	if( req->kind == REQUEST_KIND_NULL )
		return FALSE;
	if( !req->flg_contract )
		return FALSE;
	if( !req->flg_finish )
		return FALSE;

	if( chr_kind == CHR_KIND_MBR ){
		if( !req->flg_contract_mbr )
			return FALSE;
	} else {
		if( req->flg_contract_mbr )
			return FALSE;
	}

	/* OK */

	if( chr_kind != CHR_KIND_MBR )
		return TRUE;

	if( req->kind == REQUEST_KIND_RARE_GOODS ){
		for( i = 0; i < MBR_MAX_N; i++ ){
			if( chk_mbr_have_rare_goods( pty->mbr[i],
					req->rare_goods_kind,
					req->mnstr_kind, TRUE ) ){
				break;
			}
		}
	}

	not_join_client( req );

	print_words( MSG_NPC_NAME_BAR_MASTER, MALE,
			MSG_WORDS_REQUEST_CLOSE_1,
			MSG_WORDS_REQUEST_CLOSE_1 );

	add_party_gold( req->prize );
	exp_party( req->exp, TRUE );

	print_words( MSG_NPC_NAME_BAR_MASTER, MALE,
			MSG_WORDS_REQUEST_CLOSE_2,
			MSG_WORDS_REQUEST_CLOSE_2 );

	/* end */

	req->kind = REQUEST_KIND_NULL;

	return TRUE;
}

/**/

void	not_join_client( request_t *req )
{
	pet_t	*npc;

	if( req == NULL )
		return;

	npc = get_npc_request( req );
	if( npc == NULL )
		return;

	switch( req->kind ){
	case REQUEST_KIND_NULL:
	case REQUEST_KIND_RARE_GOODS:
		return;
	case REQUEST_KIND_TAME_MNSTR:
		break;	/* return ǤϤʤ */
	case REQUEST_KIND_RESCUE:
		print_words( npc->name, npc->sex.cur,
				MSG_WORDS_REQUEST_RESCUE_FINISH_FEMALE,
				MSG_WORDS_REQUEST_RESCUE_FINISH_MALE );
		break;
	case REQUEST_KIND_TOUR_GUIDE:
		print_words( npc->name, npc->sex.cur,
				MSG_WORDS_REQUEST_TOUR_GUIDE_FINISH_FEMALE,
				MSG_WORDS_REQUEST_TOUR_GUIDE_FINISH_MALE );
		break;
	case REQUEST_KIND_EXTERMINATE:
		return;
	case REQUEST_KIND_REVENGE:
		print_words( npc->name, npc->sex.cur,
				MSG_WORDS_REQUEST_REVENGE_FINISH_FEMALE,
				MSG_WORDS_REQUEST_REVENGE_FINISH_MALE );
		break;
	case REQUEST_KIND_WANTED_CRIMINAL:
	case REQUEST_KIND_MAX_N:
		return;
	}

	print_msg( FLG_NULL, MSG_NOT_JOIN_CHR, npc->name );
	npc->gold = 0;
	remove_pet( npc );
}

/**/

void	put_request_all_obj( void )
{
	put_request_item();
	put_request_mnstr();
}

/**/

void	put_request_rare_goods( chr_t *chr )
{
	dun_t	*dun = get_dun();
	long	tab_n;
	item_t	*item;
	long	i;

	if( chr == NULL )
		return;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( g_request[i].kind != REQUEST_KIND_RARE_GOODS )
			continue;
		if( g_request[i].flg_finish )
			continue;
		if( g_request[i].mnstr_kind != chr->mnstr_kind )
			continue;
		if( sgn_l( g_request[i].dun_min_lev ) != sgn_l( dun->lev ) )
			continue;
		if( sgn_l( g_request[i].dun_max_lev ) != sgn_l( dun->lev ) )
			continue;
		if( labs( g_request[i].dun_min_lev ) > labs( dun->lev ) )
			continue;
		if( labs( g_request[i].dun_max_lev ) < labs( dun->lev ) )
			continue;

		if( !rate_randm( REQUEST_RARE_GOODS_DROP_RATE ) )
			continue;

		/* ɸΥƥ */

		tab_n = get_rare_goods_tab_n( get_rare_goods_tab(
				g_request[i].rare_goods_kind ) );
		if( tab_n <= -1 )
			continue;

		item = make_item_rare_goods( dun->lev, tab_n );
		if( item == NULL )
			continue;

		item->dat.rare_goods.mnstr_kind = chr->mnstr_kind;
		put_item( item, chr->x, chr->y, PUT_ITEM_R, FALSE );
	}
}

/**/

void	put_request_item( void )
{
}

/**/

void	put_request_mnstr( void )
{
	dun_t	*dun = get_dun();
	long	i;

	for( i = 0; i < REQUEST_MAX_N; i++ ){
		mnstr_kind_t	mnstr_kind;
		char	*name;
		sex_t	sex;
		bool_t	flg_make_npc, flg_hungry;
		mnstr_t	*p;

		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( g_request[i].flg_finish )
			continue;
		if( g_request[i].dun_true_lev != dun->lev )
			continue;

		mnstr_kind = MNSTR_KIND_NULL;
		name = MSG_MNSTR_UNKNOWN;
		sex = MALE;
		flg_make_npc = FALSE;
		flg_hungry = FALSE;

		switch( g_request[i].kind ){
		case REQUEST_KIND_TAME_MNSTR:
			if( g_request[i].mnstr_kind == MNSTR_KIND_NULL )
				continue;
			mnstr_kind = g_request[i].mnstr_kind;
			name = cv_idx_to_mnstr_name( &(g_request[i]) );
			sex = g_request[i].mnstr_sex;
			flg_make_npc = TRUE;
			flg_hungry = TRUE;
			break;
		case REQUEST_KIND_RESCUE:
			if( g_request[i].idx_rescue_trgt_name <= -1 )
				continue;
			mnstr_kind = g_request[i].rescue_trgt_kind;
			name = cv_idx_to_rescue_trgt_name( &(g_request[i]) );
			sex = g_request[i].rescue_trgt_sex;
			flg_make_npc = TRUE;
			flg_hungry = FALSE;
			break;
		case REQUEST_KIND_REVENGE:
		case REQUEST_KIND_WANTED_CRIMINAL:
			if( g_request[i].mnstr_kind == MNSTR_KIND_NULL )
				continue;
			mnstr_kind = g_request[i].mnstr_kind;
			name = cv_idx_to_mnstr_name( &(g_request[i]) );
			sex = g_request[i].mnstr_sex;
			flg_make_npc = FALSE;
			flg_hungry = FALSE;
			break;
		case REQUEST_KIND_NULL:
		case REQUEST_KIND_RARE_GOODS:
		case REQUEST_KIND_TOUR_GUIDE:
		case REQUEST_KIND_EXTERMINATE:
		case REQUEST_KIND_MAX_N:
			continue;
		}

		/* ɸΥ󥹥 */

		p = make_mnstr( MAP_DEL_X, MAP_DEL_Y,
				dun->lev, mnstr_kind );
		if( p == NULL )
			continue;

		if( flg_make_npc ){
			p->attitude = ATTITUDE_MATE;
		} else {
			p->attitude = ATTITUDE_ENEMY;
		}
		strncpy( p->name, name, CHR_NAME_MAX_LEN );
		p->work.request = &(g_request[i]);
		p->sex.org = sex;
		p->sex.cur = sex;
		if( flg_hungry ){
			p->fx_data.stomach.rate
					= p->fx_data.stomach.hungry_rate;
		}

		if( g_flg_debug && FLG_DEBUG_REQUEST ){
			mbr_t	*mbr;

			mbr = get_mbr_randm( MAP_DEL_X, MAP_DEL_Y );
			if( mbr != NULL ){
				put_chr( p, mbr->x, mbr->y, FALSE );
				return;
			}
		}
		put_chr( p, randm( MAP_MAX_X ),
				randm( MAP_MAX_Y ), FALSE );
	}
}

/**/

char	*cb_menu_request_mbr( menu_t **pp, menu_t **dflt )
{
	chk_finish_request_rare_goods();

	return( set_menu_request( pp, dflt,
			cb_menu_sel_request_mbr, TRUE ) );
}

/**/

char	*cb_menu_request_bar( menu_t **pp, menu_t **dflt )
{
	chk_finish_request_rare_goods();
	close_all_request( CHR_KIND_MBR );

	return( set_menu_request( pp, dflt,
			cb_menu_sel_request_bar, FALSE ) );
}

/**/

char	*set_menu_request(
	menu_t **pp, menu_t **dflt, menu_call_back_t cb, bool_t flg_mbr
)
{
	menu_t	*ls;
	long	n;
	long	i, k;

	ls = ls_menu_request;
	k = 0;

	strncpy( ls[k].path, "/Request", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Request/--", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_MENU_BAR_REQUEST, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	n = 0;
	for( i = 0; i < REQUEST_MAX_N; i++ ){
		if( g_request[i].kind == REQUEST_KIND_NULL )
			continue;
		if( !g_request[i].flg_contract_mbr )
			if( flg_mbr )
				continue;

		set_request_heading( &(g_request[i]) );

		sprintf( ls[k].path, "/Request/%ld", i );
		strncpy( ls[k].kind, "<OpenWinItem>",
				MENU_KIND_MAX_LEN );
		ls[k].key = (char)('A' + (n % MENU_MAX_N_PER_PAGE));
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, g_request[i].heading, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb;
		ls[k].arg = &(g_request[i]);
		ls[k].flg = FLG_NULL;
		k++;
		n++;

		if( (n % MENU_MAX_N_PER_PAGE) == 0 ){
			strncpy( ls[k].path, "/Request/--",
					MENU_PATH_MAX_LEN );
			strncpy( ls[k].kind, "<PageSeparator>",
					MENU_KIND_MAX_LEN );
			ls[k].key = '\0';
			ls[k].accel_key[0] = '\0';
			ls[k].n_msg = N_MSG_NULL;
			ls[k].msg[0] = '\0';
			ls[k].call_back = NULL;
			ls[k].arg = NULL;
			ls[k].flg = FLG_NULL;
			k++;
		}
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	if( n <= 0 ){
		print_msg( FLG_NULL, MSG_ERR_MENU_REQUEST );
		return STR_MENU_CANCEL;
	}

	return NULL;
}

/**/

char	*cb_menu_sel_request_mbr( menu_t **pp, menu_t **dflt )
{
	request_t	*req;

	req = (request_t *)((*pp)->arg);
	if( req == NULL )
		return STR_MENU_ERR;

	set_request_msg( req );
	draw_request( req );
	wait_key( FALSE );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_sel_request_bar( menu_t **pp, menu_t **dflt )
{
	request_t	*req;
	bool_t	flg_yes = FALSE;

	req = (request_t *)((*pp)->arg);
	if( req == NULL )
		return STR_MENU_ERR;

	set_request_msg( req );
	draw_request( req );
	wait_key( FALSE );

	if( req->flg_finish )
		return STR_MENU_CANCEL;
	if( req->flg_contract ){
		if( req->flg_contract_mbr ){
			flg_yes = ask_cancel_request( req );
		}
	} else {
		flg_yes = ask_contract_request( req );
	}

	if( flg_yes )
		return "/Bar/Request";

	return STR_MENU_CANCEL;
}

/**/

bool_t	ask_contract_request( request_t *req )
{
	ask_t	ask;

	if( req == NULL )
		return FALSE;

	ask = exec_menu_ask( MSG_TTL_MENU_REQUEST_MBR_CONTRACT,
			ASK_NO, TRUE );

	if( ask != ASK_YES )
		return FALSE;

	print_words( MSG_NPC_NAME_BAR_MASTER, MALE,
			MSG_WORDS_REQUEST_CONTRACT,
			MSG_WORDS_REQUEST_CONTRACT );

	return( chr_contract_request( req, CHR_KIND_MBR, -1, FEMALE ) );
}

/**/

bool_t	ask_cancel_request( request_t *req )
{
	ask_t	ask;

	if( req == NULL )
		return FALSE;

	ask = exec_menu_ask( MSG_TTL_MENU_REQUEST_MBR_CANCEL,
			ASK_NO, TRUE );

	if( ask != ASK_YES )
		return FALSE;

	print_words( MSG_NPC_NAME_BAR_MASTER, MALE,
			MSG_WORDS_REQUEST_CANCEL,
			MSG_WORDS_REQUEST_CANCEL );

	req->flg_contract = FALSE;
	req->flg_contract_mbr = FALSE;

	return TRUE;
}

/**/

char	*cv_idx_to_request_fmt( request_t *req )
{
	if( req == NULL )
		return( MSG_NULL );
	if( req->idx_fmt <= -1 )
		return( MSG_NULL );

	switch( req->kind ){
	case REQUEST_KIND_NULL:
		return( MSG_NULL );
	case REQUEST_KIND_TAME_MNSTR:
		return( MSG( g_tame_mnstr_tab[req->idx_fmt] ) );
	case REQUEST_KIND_RESCUE:
		return( MSG( g_rescue_tab[req->idx_fmt] ) );
	case REQUEST_KIND_REVENGE:
		return( MSG( g_revenge_tab[req->idx_fmt] ) );
	case REQUEST_KIND_WANTED_CRIMINAL:
		return( MSG( g_wanted_criminal_tab[req->idx_fmt] ) );
	case REQUEST_KIND_RARE_GOODS:
		return( MSG( g_rare_goods_tab[req->idx_fmt] ) );
	case REQUEST_KIND_TOUR_GUIDE:
		return( MSG( g_tour_guide_tab[req->idx_fmt] ) );
	case REQUEST_KIND_EXTERMINATE:
		return( MSG( g_exterminate_tab[req->idx_fmt] ) );
	case REQUEST_KIND_MAX_N:
		return( MSG_NULL );
	}

	return( MSG_NULL );
}

/**/

char	*cv_idx_to_contract_name( request_t *req )
{
	n_msg_t	n_msg;

	if( req == NULL )
		return( MSG_MNSTR_UNKNOWN );

	if( req->contract_sex == FEMALE ){
		n_msg = g_ls_npc_name_female[req->idx_contract_name];
	} else {
		n_msg = g_ls_npc_name_male[req->idx_contract_name];
	}

	return( MSG( n_msg ) );
}

/**/

char	*cv_idx_to_client_name( request_t *req )
{
	n_msg_t	n_msg;

	if( req == NULL )
		return( MSG_MNSTR_UNKNOWN );

	if( req->client_sex == FEMALE ){
		n_msg = g_ls_npc_name_female[req->idx_client_name];
	} else {
		n_msg = g_ls_npc_name_male[req->idx_client_name];
	}

	return( MSG( n_msg ) );
}

/**/

char	*cv_idx_to_mnstr_name( request_t *req )
{
	if( req == NULL )
		return( MSG_MNSTR_UNKNOWN );

	if( req->flg_mnstr_is_npc ){
		n_msg_t	n_msg;

		if( req->mnstr_sex == FEMALE ){
			n_msg = g_ls_npc_name_female[req->idx_mnstr_name];
		} else {
			n_msg = g_ls_npc_name_male[req->idx_mnstr_name];
		}

		return( MSG( n_msg ) );
	} else {
		mnstr_tab_t	*tab;

		tab = get_mnstr_tab( req->mnstr_kind, req->dun_true_lev );

		return( tab->name );
	}

	return( MSG_MNSTR_UNKNOWN );
}

/**/

char	*cv_idx_to_rescue_trgt_name( request_t *req )
{
	n_msg_t	n_msg;

	if( req == NULL )
		return( MSG_MNSTR_UNKNOWN );

	if( req->rescue_trgt_sex == FEMALE ){
		n_msg = g_ls_npc_name_female[req->idx_rescue_trgt_name];
	} else {
		n_msg = g_ls_npc_name_male[req->idx_rescue_trgt_name];
	}

	return( MSG( n_msg ) );
}

/**/

char	*cv_idx_to_client_family_name( request_t *req )
{
	n_msg_t	n_msg;

	if( req == NULL )
		return( MSG_MNSTR_UNKNOWN );

	if( req->client_family_sex == FEMALE ){
		n_msg = g_ls_npc_name_female[req->idx_client_family_name];
	} else {
		n_msg = g_ls_npc_name_male[req->idx_client_family_name];
	}

	return( MSG( n_msg ) );
}

/**/

char	*cv_idx_to_client_mate_name( request_t *req )
{
	n_msg_t	n_msg;

	if( req == NULL )
		return( MSG_MNSTR_UNKNOWN );

	if( req->client_mate_sex == FEMALE ){
		n_msg = g_ls_npc_name_female[req->idx_client_mate_name];
	} else {
		n_msg = g_ls_npc_name_male[req->idx_client_mate_name];
	}

	return( MSG( n_msg ) );
}

/**/

