/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: trap.c,v 1.44 2004/07/30 15:15:28 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
#include	"dun.h"
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
#include	"pet.h"
#include	"fight.h"
#include	"fx.h"
#include	"trap.h"
#include	"draw.h"
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"amenu.h"*/
/*#include	"request.h"*/
/*#include	"gfile.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain-prot.h"
#include	"misc-prot.h"
/*#include	"turn-prot.h"*/
#include	"dun-prot.h"
/*#include	"town-prot.h"*/
/*#include	"item-prot.h"*/
#include	"spell-prot.h"
#include	"chr-prot.h"
/*#include	"party-prot.h"*/
/*#include	"mnstr-prot.h"*/
#include	"pet-prot.h"
#include	"fight-prot.h"
#include	"fx-prot.h"
#include	"trap-prot.h"
#include	"draw-prot.h"
/*#include	"curs-prot.h"*/
#include	"menu-prot.h"
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
/*#include	"request-prot.h"*/
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

/**/

#define	TRAP_DIFFICULTY_LEV_RATE	RATE_LEV_PER_DUN_LEV
#define	TRAP_DIFFICULTY_LEV_ADD	1

#define	TRAP_MAX_RATE	100
#define	TRAP_MIN_RATE	50

#define	TRAP_ROOM_RATE	1
#define	TRAP_ROOM_N	50

#define	PIT_DAM_RATE	25
#define	PIT_DAM_ADD	1

/**/

static trap_t	trap_buf[TRAP_MAX_N];
static trap_t	trap_free;
static trap_t	dun_trap_asgn;

static long	trap_tab_max_n;

static trap_tab_t	trap_tab[] = {
	{ TRAP_KIND_SLEEP, NULL, N_MSG_TRAP_SLEEP,
		100, FACE_MNR_TRAP_SLEEP,
		1, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_ARW, NULL, N_MSG_TRAP_ARW,
		100, FACE_MNR_TRAP_ARW,
		2, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_POISON_DARTS, NULL, N_MSG_TRAP_POISON_DARTS,
		100, FACE_MNR_TRAP_POISON_DARTS,
		3, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_BOMB, NULL, N_MSG_TRAP_BOMB,
		100, FACE_MNR_TRAP_BOMB,
		10, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_TELEPORT_PARTY, NULL, N_MSG_TRAP_TELEPORT_PARTY,
		100, FACE_MNR_TRAP_TELEPORT_PARTY,
		20, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_TELEPORT, NULL, N_MSG_TRAP_TELEPORT,
		100, FACE_MNR_TRAP_TELEPORT,
		30, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_PIT, NULL, N_MSG_TRAP_PIT,
		100, FACE_MNR_TRAP_PIT,
		4, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_CHUTE, NULL, N_MSG_TRAP_CHUTE,
		80, FACE_MNR_TRAP_CHUTE,
		10, DUN_MAX_LEV_BASE, -1 },

	{ TRAP_KIND_NULL, NULL, N_MSG_NULL,
		0, FACE_MNR_NULL,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0 },
};

chr_t	g_dmy_chr;

/**/

void	init_trap( void )
{
	long	i;

	trap_tab_max_n = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( trap_tab[i].kind == TRAP_KIND_NULL )
			break;
		trap_tab[i].name = MSG( trap_tab[i].name_n );
	}
	trap_tab_max_n = i;

	dun_trap_asgn.prev = &dun_trap_asgn;
	dun_trap_asgn.next = &dun_trap_asgn;

	i = 0;
	trap_free.next = &(trap_buf[i]);
	trap_buf[i].prev = &trap_free;
	trap_buf[i].next = &(trap_buf[i + 1]);
	for( i++; i < TRAP_MAX_N - 1; i++ ){
		trap_buf[i].prev = &(trap_buf[i - 1]);
		trap_buf[i].next = &(trap_buf[i + 1]);
	}
	trap_buf[i].prev = &(trap_buf[i - 1]);
	trap_buf[i].next = &trap_free;
	trap_free.prev = &(trap_buf[i]);
}

/**/

void	reset_trap( void )
{
	trap_t	*p, *end;

	end = &dun_trap_asgn;
	for( p = end->next->next; p->prev != end; p = p->next )
		free_trap( p->prev );
}

/**/

trap_t	*make_trap( long x, long y, long dun_lev )
{
	long	i;
	dun_t	*dun;
	trap_t	*trap;
	long	n;

	dun = get_dun();

	if( clip_pos( x, y ) )
		if( dun->map.obj.mjr[y][x] != FACE_MJR_FLOOR )
			return NULL;

	n = 0;
	for( i = LOOP_MAX_100; i > 0; i-- ){
		n = randm( trap_tab_max_n );

#if	defined( DEBUG ) && defined( D_TEST_TRAP_KIND )
		if( D_TEST_TRAP_KIND != TRAP_KIND_NULL ){
			if( trap_tab[n].kind == D_TEST_TRAP_KIND ){
				break;
			} else {
				continue;
			}
		}
#endif

		if( trap_tab[n].kind == TRAP_KIND_NULL )
			continue;
		if( !rate_randm( trap_tab[n].rate ) )
			continue;
		if( labs( dun_lev ) < trap_tab[n].min_lev )
			continue;
		if( labs( dun_lev ) > trap_tab[n].max_lev )
			continue;
		if( sgn_l( dun_lev ) != trap_tab[n].sgn_lev )
			continue;

		break;
	}
	if( i <= 0 )
		return NULL;

	trap = alloc_trap();
	if( trap == NULL )
		return NULL;

	do {
		if( !make_trap_std( dun_lev, trap, n ) )
			break;
		if( clip_pos( x, y ) )
			if( !set_trap( x, y, trap ) )
				break;

		return trap;
	} while( 0 );

	free_trap( trap );

	return NULL;
}

/**/

bool_t	make_trap_std( long dun_lev, trap_t *trap, long n )
{
	long	difficulty;

	if( trap == NULL )
		return FALSE;

	trap->kind = trap_tab[n].kind;
	trap->x = MAP_DEL_X;
	trap->y = MAP_DEL_Y;
	trap->lev = dun_lev;

	difficulty = labs( dun_lev );
	difficulty *= TRAP_DIFFICULTY_LEV_RATE;
	difficulty /= _100_PERCENT;
	difficulty += TRAP_DIFFICULTY_LEV_ADD;
	trap->difficulty = difficulty;

	trap->flg_chked = FALSE;
	trap->tab = get_trap_tab( trap_tab[n].kind );

	return TRUE;
}

/**/

bool_t	set_trap( long x, long y, trap_t *trap )
{
	dun_t	*dun = get_dun();

	if( trap == NULL )
		return FALSE;

	if( !clip_pos( x, y ) )
		return FALSE;
	if( dun->map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return FALSE;

	trap->x = x;
	trap->y = y;

	dun->map.obj.mjr[y][x] = FACE_MJR_TRAP;
	dun->map.obj.mnr[y][x] = FACE_MNR_NULL;
	dun->map.obj.flg[y][x] |= FLG_MAP_OBJ_PASS;
	dun->map.obj.flg[y][x] |= FLG_MAP_OBJ_LOOK_FLOOR;

	set_trap_face_mnr( trap );

	ins_ls_trap( &dun_trap_asgn, trap );

	return TRUE;
}

/**/

bool_t	set_trap_face_mnr( trap_t *trap )
{
	dun_t	*dun = get_dun();
	long	x, y;

	if( trap == NULL )
		return FALSE;
	if( trap->tab == NULL )
		return FALSE;

	x = trap->x;
	y = trap->y;

	if( !clip_pos( x, y ) )
		return FALSE;
	if( dun->map.obj.mjr[y][x] != FACE_MJR_TRAP )
		return FALSE;

	if( chk_flg( dun->map.obj.flg[y][x], FLG_MAP_OBJ_LOOK_FLOOR ) ){
		dun->map.obj.mnr[y][x] = FACE_MNR_NULL;
	} else if( trap->flg_chked ){
		dun->map.obj.mnr[y][x] = trap->tab->mnr;
	} else {
		dun->map.obj.mnr[y][x] = FACE_MNR_NULL;
	}

	draw_trap( trap );

	return TRUE;
}

/**/

void	make_trap_room( long area_x, long area_y, long lev )
{
	dun_t	*dun = get_dun();
	long	n;
	long	i;

	if( !rate_randm( TRAP_ROOM_RATE ) )
		return;

	n = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		long	mx, my;
		trap_t	*trap;

		mx = area_x * AREA_MAX_X + randm( AREA_MAX_X );
		my = area_y * AREA_MAX_Y + randm( AREA_MAX_Y );

		if( dun->map.obj.mjr[my][mx] != FACE_MJR_FLOOR )
			continue;

		trap = make_trap( mx, my, lev );
		if( trap != NULL )
			n++;
		if( n >= TRAP_ROOM_N )
			break;
	}
}

/**/

void	chk_trap_chest( item_t *item, chr_t *chr, rate_t rate )
{
	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_CHEST )
		return;

	if( !rate_randm( rate ) )
		return;

	caught_trap( item->dat.chest.trap, chr );

	free_trap_chest( item );
}

/**/

void	chk_trap( chr_t *chr, chr_t *thief )
{
	trap_t	*trap;
	dun_t	*dun = get_dun();

	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;
	if( chk_flg( chr->stat, FLG_STAT_FLY ) )
		return;
	if( !chk_can_act_chr( chr ) )
		return;

	if( chr->x == chr->pre_x )
		if( chr->y == chr->pre_y )
			return;

	if( thief == NULL )
		thief = chr;

	if( dun->map.obj.mjr[chr->y][chr->x] != FACE_MJR_TRAP )
		return;

	trap = get_trap( chr->x, chr->y );
	if( trap == NULL )
		return;

	if( chr->kind == CHR_KIND_MBR ){
		find_trap( trap );
	} else {
		if( chk_flg( chr->flg_map, FLG_MAP_CHR_FIND ) )
			find_trap( trap );
	}

	if( chr_roll( thief, ABL_KIND_THI, ABL_KIND_AGI, trap->difficulty ) )
		print_msg_mbr( chr, FLG_NULL, MSG_NOT_TRAPPED, chr->name );
	else
		caught_trap( trap, chr );
}

/**/

void	find_trap( trap_t *trap )
{
	dun_t	*dun = get_dun();

	if( trap == NULL )
		return;

	if( !clip_pos( trap->x, trap->y ) )
		return;

	dun->map.obj.flg[trap->y][trap->x] &= ~FLG_MAP_OBJ_LOOK_FLOOR;
	dun->map.obj.flg[trap->y][trap->x] |= FLG_MAP_OBJ_FIND;
	draw_trap( trap );
}

/**/

void	caught_trap( trap_t *trap, chr_t *chr )
{
	if( trap == NULL )
		return;
	if( trap->tab == NULL )
		return;
	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	if( chr->kind == CHR_KIND_MBR ){
		find_trap( trap );
	} else {
		if( chk_flg( chr->flg_map, FLG_MAP_CHR_FIND ) )
			find_trap( trap );
	}

	print_msg_mbr( chr, FLG_NULL, MSG_TRAPPED,
			chr->name, trap->tab->name );

	g_dmy_chr.kind = CHR_KIND_NULL;
	strncpy( g_dmy_chr.name, trap->tab->name, CHR_NAME_MAX_LEN );
	g_dmy_chr.x = trap->x;
	g_dmy_chr.y = trap->y;
	g_dmy_chr.trgt.kind = get_trgt_kind_from_chr( chr );
	g_dmy_chr.trgt.x = chr->x;
	g_dmy_chr.trgt.y = chr->y;
	g_dmy_chr.trgt.true_x = g_dmy_chr.trgt.x;
	g_dmy_chr.trgt.true_y = g_dmy_chr.trgt.y;
	g_dmy_chr.trgt.p = chr;

	switch( trap->kind ){
	case TRAP_KIND_NULL:
	case TRAP_KIND_MAX_N:
		return;
	case TRAP_KIND_SLEEP:
		chr_cast_spell_spread( &g_dmy_chr, TRUE,
				get_spell_tab( SPELL_KIND_SLEEP ),
				_100_PERCENT );
		break;
	case TRAP_KIND_ARW:
		set_trap_arw_pos( chr, &g_dmy_chr.x, &g_dmy_chr.y );
		chr_cast_spell_normal( &g_dmy_chr, TRUE,
				get_spell_tab( SPELL_KIND_MAGIC_MISSILE ),
				_100_PERCENT );
		break;
	case TRAP_KIND_POISON_DARTS:
		chr_cast_spell_normal( &g_dmy_chr, TRUE,
				get_spell_tab( SPELL_KIND_POISON_CLOUD ),
				_100_PERCENT );
		break;
	case TRAP_KIND_BOMB:
		chr_cast_spell_spread( &g_dmy_chr, TRUE,
				get_spell_tab( SPELL_KIND_MAGIC_MISSILE ),
				_100_PERCENT );
		break;
	case TRAP_KIND_TELEPORT_PARTY:
		teleport_party();
		break;
	case TRAP_KIND_TELEPORT:
		teleport_chr( chr );
		break;
	case TRAP_KIND_PIT:
		caught_trap_pit( chr );
		break;
	case TRAP_KIND_CHUTE:
		caught_trap_chute( chr );
		break;
	}
}

/**/

void	set_trap_arw_pos( chr_t *chr, long *x, long *y )
{
	dun_t	*dun = get_dun();
	long	mx, my;
	long	nx, ny;
	long	i;

	if( chr == NULL )
		return;

	*x = chr->x;
	*y = chr->y;

	switch( randm( 4 ) ){
	default:
	case 0:
		mx = chr->x;
		my = (chr->y / AREA_MAX_Y) * AREA_MAX_Y;
		break;
	case 1:
		mx = (chr->x / AREA_MAX_X) * AREA_MAX_X;
		my = chr->y;
		break;
	case 2:
		mx = chr->x;
		my = (chr->y / AREA_MAX_Y) * AREA_MAX_Y;
		my += AREA_MAX_Y - 1;
		break;
	case 3:
		mx = (chr->x / AREA_MAX_X) * AREA_MAX_X;
		mx += AREA_MAX_X - 1;
		my = chr->y;
		break;
	}

	nx = chr->x;
	ny = chr->y;
	for( i = max_l( AREA_MAX_X, AREA_MAX_Y ); i >= 0; i-- ){
		nx += sgn_l( mx - chr->x );
		ny += sgn_l( my - chr->y );
		if( !clip_pos( nx, ny ) )
			break;
		if( !chk_flg( dun->map.obj.flg[ny][nx],
				FLG_MAP_OBJ_PASS ) ){
			break;
		}
		*x = nx;
		*y = ny;
	}
}

/**/

void	caught_trap_pit( chr_t *chr )
{
	long	dam;

	dam = calc_max_hp( chr ) * PIT_DAM_RATE / _100_PERCENT;
	dam += PIT_DAM_ADD;

	add_hp( chr, -dam, TRUE, FALSE );
}

/**/

void	caught_trap_chute( chr_t *chr )
{
	bool_t	flg_party;

	if( chr == NULL )
		return;

	flg_party = FALSE;
	if( chr->kind == CHR_KIND_MBR )
		flg_party = TRUE;
	if( chr->kind == CHR_KIND_MNSTR )
		if( is_pet( chr ) )
			flg_party = TRUE;

	if( flg_party )
		up_dun( -1 );
}

/**/

void	disarm_trap( trap_t *p )
{
	dun_t	*dun;

	if( p == NULL )
		return;

	dun = get_dun();

	dun->map.obj.mjr[p->y][p->x] = FACE_MJR_FLOOR;
	dun->map.obj.mnr[p->y][p->x] = FACE_MNR_FLOOR;
	draw_map( p->x, p->y, 1, 1 );

	free_trap( p );
}

/**/

void	detect_trap( long x, long y, long r )
{
	trap_t	*p;

	for( p = dun_trap_asgn.next; p != &dun_trap_asgn; p = p->next ){
		if( p->x < (x - r) )
			continue;
		if( p->x > (x + r) )
			continue;
		if( p->y < (y - r) )
			continue;
		if( p->y > (y + r) )
			continue;

		find_trap( p );
	}
}

/**/

void	ins_ls_trap( trap_t *ls, trap_t *p )
{
	if( ls == NULL )
		return;
	if( p == NULL )
		return;

	if( p->prev != NULL )
		p->prev->next = p->next;
	if( p->next != NULL )
		p->next->prev = p->prev;

	p->prev = ls->prev;
	p->next = ls;

	if( ls->prev != NULL )
		ls->prev->next = p;
	ls->prev = p;
}

/**/

trap_t	*alloc_trap( void )
{
	trap_t	*p, dmy;

	p = get_trap_free_next();
	if( p == NULL )
		return NULL;

	p->kind = ITEM_KIND_NULL;
	p->x = MAP_DEL_X;
	p->y = MAP_DEL_Y;

	/* ŪʥȥåץꥹȤˤ֤鲼 */

	dmy.prev = &dmy;
	dmy.next = &dmy;

	ins_ls_trap( &dmy, p );

	p->prev = NULL;
	p->next = NULL;

	return p;
}

/**/

void	free_trap_chest( item_t *chest )
{
	if( chest == NULL )
		return;
	if( chest->kind != ITEM_KIND_CHEST )
		return;

	free_trap( chest->dat.chest.trap );
	chest->dat.chest.trap = NULL;
}

/**/

void	free_trap( trap_t *p )
{
	trap_t	*ls;

	ls = get_trap_free_next();
	if( ls == NULL )
		return;

	ins_ls_trap( ls, p );
}

/**/

trap_t	*get_trap_free_next( void )
{
	if( trap_free.next == &trap_free )
		return NULL;

	return trap_free.next;
}

/**/

trap_t	*get_dun_trap_asgn( void )
{
	return &dun_trap_asgn;
}

/**/

trap_t	*get_trap( long x, long y )
{
	trap_t	*p;

	for( p = dun_trap_asgn.next; p != &dun_trap_asgn; p = p->next )
		if( (p->x == x) && (p->y == y) )
			return p;

	return NULL;
}

/**/

trap_tab_t	*get_trap_tab( trap_kind_t kind )
{
	long	i;

	for( i = 0; i < LOOP_MAX_1000; i++ )
		if( trap_tab[i].kind == kind )
			return( &(trap_tab[i]) );

	return NULL;
}

/**/

