/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: curs.c,v 1.57 2004/12/26 01:22:16 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
#include	"curs.h"
/*#include	"menu.h"*/
/*#include	"amenu.h"*/
/*#include	"request.h"*/
/*#include	"gfile.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain-prot.h"
#include	"misc-prot.h"
/*#include	"turn-prot.h"*/
/*#include	"dun-prot.h"*/
/*#include	"town-prot.h"*/
/*#include	"item-prot.h"*/
/*#include	"spell-prot.h"*/
/*#include	"chr-prot.h"*/
/*#include	"party-prot.h"*/
/*#include	"mnstr-prot.h"*/
/*#include	"pet-prot.h"*/
/*#include	"fight-prot.h"*/
/*#include	"fx-prot.h"*/
/*#include	"trap-prot.h"*/
#include	"draw-prot.h"
#include	"curs-prot.h"
/*#include	"menu-prot.h"*/
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
/*#include	"request-prot.h"*/
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

#if	D_DOS
# include	<windows.h>
# include	<conio.h>
# include	"lnl-dos/stdafx.h"
#endif	/* D_DOS */

/***************************************************************/

/* ס󥹤Ȥäȿž°褹뤫? */
#define	FLG_PRINT_REVERSE	0

/* 褬ǽɤΥǥץե饰 */
static long	flg_curs, flg_curs_draw;
/* 顼ǽե饰 */
static bool_t	flg_color;
/* ߤ° */
static curs_attr_t	g_current_attr;

/* °Υǥե */

static curs_attr_t	g_curs_attr[CURS_ATTR_MAX_N] = {
	{ 0, N_MSG_ATTR_NORMAL,
		COLOR_WHITE, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_REV,
		COLOR_WHITE, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_ERR,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MENU_DIS,
		COLOR_YELLOW, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MENU_SEL,
		COLOR_WHITE, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MAP_ITEM,
		COLOR_GREEN, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MAP_SQUARE,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MAP_MNSTR,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MAP_NPC,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MAP_CRSR,
		COLOR_GREEN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MBR_PLUS,
		COLOR_CYAN, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_FX_MBR_MINUS,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_FX_MBR_CRTCL,
		COLOR_RED, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_FX_MNSTR_PLUS,
		COLOR_RED, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MNSTR_MINUS,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MNSTR_CRTCL,
		COLOR_CYAN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_VFX,
		COLOR_YELLOW, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MBR_1,
		COLOR_RED, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_2,
		COLOR_GREEN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_3,
		COLOR_BLUE, COLOR_BLACK, A_BOLD | A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_4,
		COLOR_CYAN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_5,
		COLOR_MAGENTA, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_6,
		COLOR_YELLOW, COLOR_BLACK, A_REVERSE, },
};

/***************************************************************
* 
***************************************************************/

void	init_curs( void )
{
	flg_curs = 0;
	flg_curs_draw = 0;
}

/***************************************************************
* ɽν
* return : Ȥ뤫
***************************************************************/

bool_t	init_curs_color( void )
{
#if	HAVE_LIBCURSES
	curs_attr_n_t	n;

	if( !g_flg_cui )
		return FALSE;

	flg_color = TRUE;

# if	HAVE_HAS_COLORS
	if( !has_colors() ){
		flg_color = FALSE;
		return FALSE;
	}
# else	/* HAVE_HAS_COLORS */
	return FALSE;
# endif	/* HAVE_HAS_COLORS */

# if	HAVE_START_COLOR
	if( start_color() != OK ){
		flg_color = FALSE;
		return FALSE;
	}
# else	/* HAVE_START_COLOR */
	return FALSE;
# endif	/* HAVE_START_COLOR */

	for( n = 0; n < CURS_ATTR_MAX_N; n++ ){
		short	pair_n;

		pair_n = n + 1;
		init_curs_color_pair( &(g_curs_attr[n]), pair_n );
		g_curs_attr[n].color_pair_n = pair_n;
	}
#endif	/* HAVE_LIBCURSES */
	return TRUE;
}

/***************************************************************
* 顼ڥν
* curs_attr_t *p : ⡼
* short pair_n : 顼ڥ
* return : Ȥ뤫
***************************************************************/

bool_t	init_curs_color_pair( curs_attr_t *p, short pair_n )
{
#if	HAVE_LIBCURSES
	if( !g_flg_cui )
		return FALSE;

	if( !flg_color )
		return FALSE;

# if	HAVE_INIT_PAIR
	init_pair( pair_n, p->fg, p->bg );
# endif	/* HAVE_INIT_PAIR */
	p->color_pair_n = pair_n;
#endif	/* HAVE_LIBCURSES */

	return TRUE;
}

/***************************************************************
* 뤫Ĵ٤
* return : 뤫
***************************************************************/

bool_t	chk_curs_draw( void )
{
	if( !g_flg_cui )
		return FALSE;

	if( flg_curs_draw <= 0 )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ե饰ͭ
***************************************************************/

void	ena_curs_draw( void )
{
	flg_curs_draw++;
}

/***************************************************************
* ե饰̵
***************************************************************/

void	dis_curs_draw( void )
{
	flg_curs_draw--;
}

/***************************************************************
* ü꤬ͭĴ٤
* return : ü꤬ͭ
***************************************************************/

bool_t	chk_curs( void )
{
	if( !g_flg_use_curs )
		return FALSE;

	if( !g_flg_cui )
		return FALSE;

	if( flg_curs <= 0 )
		return FALSE;

	return TRUE;
}

/***************************************************************
* üͭ
***************************************************************/

void	ena_curs( void )
{
	if( !g_flg_cui )
		return;

	if( chk_curs() ){
		curs_noecho();
		curs_cbreak();
		curs_raw();
	}
}

/***************************************************************
* ü̵
***************************************************************/

void	dis_curs( void )
{
	if( !g_flg_cui )
		return;

	if( chk_curs() ){
		curs_noraw();
		curs_nocbreak();
		curs_echo();
	}
}

/***************************************************************
* ü򥯥ꥢ
* WINDOW *win : ɥ
* bool_t bf : 1ԥ뤹뤫
***************************************************************/

void	curs_clearok( WINDOW *win, bool_t bf )
{
	if( !g_flg_cui )
		return;

	flg_curs++;

#if	HAVE_LIBCURSES
	if( flg_curs == 1 ){
		if( chk_curs() ){
			clearok( win, bf );
			ena_curs();
		}
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ü
***************************************************************/

void	curs_initscr( void )
{
	if( !g_flg_cui )
		return;

	flg_curs++;

#if	HAVE_LIBCURSES
	if( flg_curs == 1 ){
		if( chk_curs() ){
			initscr();
			ena_curs();
			init_curs_color();
		}
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* üѤλ
***************************************************************/

void	curs_endwin( void )
{
	if( !g_flg_cui )
		return;

	if( flg_curs == 1 ){

#if	HAVE_LIBCURSES
		if( chk_curs() ){
			dis_curs();
			endwin();
		}
#endif	/* HAVE_LIBCURSES */

#ifdef	D_DOS
		curs_move( get_max_line(), 0 );
#endif	/* D_DOS */

	}

	flg_curs--;
}

/***************************************************************
* ѥåɤ
* WINDOW *win : ɥ
* bool_t bf : 1ԥ뤹뤫
***************************************************************/

void	curs_keypad( WINDOW *win, bool_t bf )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( g_flg_use_keypad ){
		if( chk_curs() ){
# if	HAVE_KEYPAD
			keypad( win, bf );
# endif	/* HAVE_KEYPAD */
		}
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ̤
***************************************************************/

void	curs_refresh( void )
{
	if( !g_flg_cui )
		return;

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		if( chk_curs() ){
			refresh();
			return;
		}
	}
#endif	/* HAVE_LIBCURSES */

	fflush( OUT_FP );
}

/***************************************************************
* ߤ⡼ɤ
* return : ߤ⡼
***************************************************************/

curs_attr_t	get_current_attr( void )
{
	return g_current_attr;
}

/***************************************************************
* ǥեȤ⡼ɤ
***************************************************************/

void	curs_attrset_dflt( void )
{
	if( !g_flg_cui )
		return;

	curs_attrset_dir( &(g_curs_attr[CURS_ATTR_N_NORMAL]) );
}

/***************************************************************
* ꤷֹ⡼ɤ
* curs_attr_n_t n : ⡼ֹ
***************************************************************/

void	curs_attrset_n( curs_attr_n_t n )
{
	if( !g_flg_cui )
		return;

	curs_attrset_dir( &(g_curs_attr[n]) );
}

/***************************************************************
* ߤ⡼ɤ
* curs_attr_t *attr : ⡼
***************************************************************/

void	curs_attrset_dir( curs_attr_t *attr )
{
	long	tmp_attr;

	if( !g_flg_cui )
		return;

	g_current_attr = *attr;

	if( !chk_curs_draw() )
		return;

	tmp_attr = 0;
#ifdef	D_DOS
	tmp_attr = attr_dos( attr );
#else	/* D_DOS */
	tmp_attr = COLOR_PAIR( attr->color_pair_n );
	tmp_attr |= attr->attr;
#endif	/* D_DOS */

	curs_attrset( tmp_attr );
}

/***************************************************************
* ⡼ɤ
* long at : Ͳ⡼
***************************************************************/

void	curs_attrset( long at )
{
	if( !g_flg_cui )
		return;

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
# if	HAVE_ATTRSET
		attrset( at );
# endif	/* HAVE_ATTRSET */
		return;
	}
#endif	/* HAVE_LIBCURSES */

#if	D_DOS
	{
		HANDLE hStdOut;
		WORD wAttributes;

		hStdOut = GetStdHandle( STD_OUTPUT_HANDLE );
		wAttributes = (WORD)at;
		SetConsoleTextAttribute(hStdOut, wAttributes);
		return;
	}
#endif	/* D_DOS */

#if	FLG_PRINT_REVERSE
	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[43m" );
	else
		fprintf( OUT_FP, "\033[m" );
#endif	/* FLG_PRINT_REVERSE */
}

/***************************************************************
* ⡼ɤͭ
* long at : Ͳ⡼
***************************************************************/

void	curs_attron( long at )
{
	if( !g_flg_cui )
		return;

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
# if	HAVE_ATTRON
		attron( at );
# endif	/* HAVE_ATTRON */
		return;
	}
#endif	/* HAVE_LIBCURSES */
#if	FLG_PRINT_REVERSE
	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[43m" );
#endif	/* FLG_PRINT_REVERSE */
}

/***************************************************************
* ⡼ɤ̵
* long at : Ͳ⡼
***************************************************************/

void	curs_attroff( long at )
{
	if( !g_flg_cui )
		return;

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
# if	HAVE_ATTROFF
		attroff( at );
# endif	/* HAVE_ATTROFF */
		return;
	}
#endif	/* HAVE_LIBCURSES */
#if	FLG_PRINT_REVERSE
	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[m" );
#endif	/* FLG_PRINT_REVERSE */
}

/***************************************************************
* ⡼ɤΥơ֥
* return : ⡼ɤΥơ֥
***************************************************************/

curs_attr_t	*get_curs_attr( void )
{
	return g_curs_attr;
}

/***************************************************************
* ϥɽͭ
***************************************************************/

void	curs_echo( void )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		echo();
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ϥɽ̵
***************************************************************/

void	curs_noecho( void )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		noecho();
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ǥͭ
***************************************************************/

void	curs_cbreak( void )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		cbreak();
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ǥ̵
***************************************************************/

void	curs_nocbreak( void )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		nocbreak();
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ϹԽͭ
***************************************************************/

void	curs_raw( void )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		raw();
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ϹԽ̵
***************************************************************/

void	curs_noraw( void )
{
	if( !g_flg_cui )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		noraw();
	}
#endif	/* HAVE_LIBCURSES */
}

/***************************************************************
* ư
* int scrn_y : 
* int scrn_x : 
***************************************************************/

void	curs_move( int scrn_y, int scrn_x )
{
	if( !g_flg_cui )
		return;

#ifndef	D_DOS
	if( !chk_curs_draw() )
		return;
#endif	/* ! D_DOS */

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		move( scrn_y, scrn_x );
		return;
	}
#endif	/* HAVE_LIBCURSES */

#ifdef	D_DOS
	{
		COORD	scrn_pos;

		scrn_pos.X = scrn_x;
		scrn_pos.Y = scrn_y;
		SetConsoleCursorPosition( GetStdHandle( STD_OUTPUT_HANDLE ), scrn_pos );
		return;
	}
#endif	/* D_DOS */

	fprintf( OUT_FP, "\033[%d;%dH", scrn_y + 1, scrn_x + 1 );
}

/***************************************************************
* ɥʸ
* char *s : եޥåʸ
* ... : ɽ륪ץ
***************************************************************/

void	curs_printw( char *s, ... )
{
	va_list	argptr;

	if( !g_flg_cui )
		return;

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		va_start( argptr, s );
		vwprintw( stdscr, s, argptr );
		va_end( argptr );

		return;
	}
#endif	/* HAVE_LIBCURSES */

	va_start( argptr, s );
	vfprintf( OUT_FP, s, argptr );
	va_end( argptr );
}

/***************************************************************
* ̤򥯥ꥢ
***************************************************************/

void	curs_clear( void )
{
	if( !g_flg_cui )
		return;

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		clear();
		return;
	}
#endif	/* HAVE_LIBCURSES */

#ifdef	D_X68K
	fprintf( OUT_FP, "\032" );
	return;
#endif	/* D_X68K */

	{
		long	i;
		const long	max_n = get_max_line();

		curs_move( 0, 0 );
		for( i = 0; i < max_n; i++ )
			fprintf( OUT_FP, "%*s", SCREEN_WIDTH, " " );
	}
}

/***************************************************************
* 1ʸ
* return : ʸ
***************************************************************/

int	curs_getch( void )
{
	int	c;
	bool_t	flg_getc = FALSE;

	if( !g_flg_cui )
		return '\0';

	c = '\0';

#if	HAVE_LIBCURSES

	if( !flg_getc ){
		if( chk_curs() ){
			c = getch();
			flg_getc = TRUE;
		}
	}

#endif	/* HAVE_LIBCURSES */

#ifdef	D_DOS

	if( !flg_getc ){
		c = getch();
		flg_getc = TRUE;
	}

#else	/* D_DOS */

	if( !flg_getc ){
		c = getchar();
		flg_getc = TRUE;
	}

#endif	/* D_DOS */

	return c;
}

/***************************************************************
* ʸ
* char *s : ʸ֤
* int len : ʸ
***************************************************************/

void	curs_getnstr( char *s, int len )
{
	static char	buf[255 + 1];

	if( !g_flg_cui )
		return;

	s[0] = '\0';

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
# if	HAVE_GETNSTR
		getnstr( s, len );
		return;
# endif	/* HAVE_GETNSTR */
	}
#endif	/* HAVE_LIBCURSES */

	fgets( buf, sizeof( buf ) - 1, stdin );
	strncpy( s, buf, len );
}

/***************************************************************
* 顼⡼ɤĴ٤
* return : 顼⡼ɤ
***************************************************************/

bool_t	chk_color( void )
{
	return flg_color;
}

/***************************************************************
* ̤κԿĴ٤
* return : Կ
***************************************************************/

long	get_max_line( void )
{
	if( !g_flg_cui )
		return 1;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		return LINES;
	}
#endif	/* HAVE_LIBCURSES */

#ifdef	D_DOS
	{
		CONSOLE_SCREEN_BUFFER_INFO cInfo;

		GetConsoleScreenBufferInfo( GetStdHandle( STD_OUTPUT_HANDLE ), &cInfo );
		return( cInfo.srWindow.Bottom - cInfo.srWindow.Top + 1 );
	}
#endif	/* D_DOS */

	return SCREEN_HEIGHT;
}

/***************************************************************
* DOS ѤοѴ
* curs_attr_t *attr : ⡼
* return : 
***************************************************************/

int	attr_dos( curs_attr_t *attr )
{
	int	a;
	short	fg, bg;

	if( !g_flg_cui )
		return 0;

	a = 0;
	fg = 0;
	bg = 0;

	if( attr == NULL )
		return 0;

#ifdef	D_DOS
	if( chk_flg( attr->attr, A_BOLD ) )
		a |= FOREGROUND_INTENSITY;

	if( chk_flg( attr->attr, A_REVERSE ) ){
		bg = attr->fg;
		fg = attr->bg;
	} else {
		fg = attr->fg;
		bg = attr->bg;
	}

	switch( fg ){
	case COLOR_BLACK:
		break;
	case COLOR_RED:
		a |= FOREGROUND_RED;
		break;
	case COLOR_GREEN:
		a |= FOREGROUND_GREEN;
		break;
	case COLOR_YELLOW:
		a |= FOREGROUND_RED;
		a |= FOREGROUND_GREEN;
		break;
	case COLOR_BLUE:
		a |= FOREGROUND_BLUE;
		break;
	case COLOR_MAGENTA:
		a |= FOREGROUND_RED;
		a |= FOREGROUND_BLUE;
		break;
	case COLOR_CYAN:
		a |= FOREGROUND_GREEN;
		a |= FOREGROUND_BLUE;
		break;
	case COLOR_WHITE:
		a |= FOREGROUND_RED;
		a |= FOREGROUND_GREEN;
		a |= FOREGROUND_BLUE;
		break;
	}

	switch( bg ){
	case COLOR_BLACK:
		break;
	case COLOR_RED:
		a |= BACKGROUND_RED;
		break;
	case COLOR_GREEN:
		a |= BACKGROUND_GREEN;
		break;
	case COLOR_YELLOW:
		a |= BACKGROUND_RED;
		a |= BACKGROUND_GREEN;
		break;
	case COLOR_BLUE:
		a |= BACKGROUND_BLUE;
		break;
	case COLOR_MAGENTA:
		a |= BACKGROUND_RED;
		a |= BACKGROUND_BLUE;
		break;
	case COLOR_CYAN:
		a |= BACKGROUND_GREEN;
		a |= BACKGROUND_BLUE;
		break;
	case COLOR_WHITE:
		a |= BACKGROUND_RED;
		a |= BACKGROUND_GREEN;
		a |= BACKGROUND_BLUE;
		break;
	}
#endif	/* D_DOS */

	return a;
}

