/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: draw-tab.h,v 1.5 2004/12/06 06:18:18 bowkenken Exp $
***************************************************************/

#ifndef	DRAW_TAB_H
#define	DRAW_TAB_H

/*  */

#include	"gmain.h"
#include	"menu.h"

/**/

/* ,ɸ */

#define	WIN_STAT_NAME_DRAW_MIN_X	0
#define	WIN_STAT_NAME_DRAW_MIN_Y	0
#define	WIN_STAT_NAME_DRAW_WIDTH	16

#define	WIN_STAT_HP_DRAW_MIN_X	0
#define	WIN_STAT_HP_DRAW_MIN_Y	1
#define	WIN_STAT_HP_DRAW_WIDTH	(2 + 1 + 1 + 2 + 1 \
		+ WIN_STAT_CURE_HP_DRAW_WIDTH \
		+ WIN_STAT_MAX_HP_DRAW_WIDTH \
		+ WIN_STAT_CURE_MP_DRAW_WIDTH \
		+ WIN_STAT_MAX_MP_DRAW_WIDTH)

#define	WIN_STAT_MP_DRAW_MIN_X	\
		(WIN_STAT_HP_DRAW_MIN_X \
		+ 2 + WIN_STAT_CURE_HP_DRAW_WIDTH \
		+ 1 + WIN_STAT_MAX_HP_DRAW_WIDTH + 1)
#define	WIN_STAT_MP_DRAW_MIN_Y	WIN_STAT_HP_DRAW_MIN_Y

#define	WIN_STAT_CURE_HP_DRAW_WIDTH	4
#define	WIN_STAT_CURE_MP_DRAW_WIDTH	4
#define	WIN_STAT_MAX_HP_DRAW_WIDTH	4
#define	WIN_STAT_MAX_MP_DRAW_WIDTH	4

#define	WIN_STAT_ACT_DRAW_MIN_X	(WIN_STAT_NAME_DRAW_WIDTH + 1)
#define	WIN_STAT_ACT_DRAW_MIN_Y	0
#define	WIN_STAT_ACT_DRAW_WIDTH	(39 - WIN_STAT_NAME_DRAW_WIDTH - 1)

#define	WIN_STAT_COND_DRAW_MIN_X	(WIN_STAT_HP_DRAW_WIDTH + 1)
#define	WIN_STAT_COND_DRAW_MIN_Y	1
#define	WIN_STAT_COND_DRAW_WIDTH	(39 - WIN_STAT_HP_DRAW_WIDTH - 1)

#define	WIN_STAT_DUN_LEV_DRAW_MIN_X	0
#define	WIN_STAT_DUN_LEV_DRAW_MIN_Y	0

#define	WIN_STAT_TIME_DRAW_MIN_X	20
#define	WIN_STAT_TIME_DRAW_MIN_Y	0

/* ޤ,ɸ */

/* Data begin */

#define	WIN_MBR_DATA_DRAW_MID_X	41

/* page 1/2 */

#define	WIN_MBR_DATA_NAME_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_NAME_TTL_DRAW_MIN_Y	0

#define	WIN_MBR_DATA_FACE_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_FACE_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_NAME_TTL_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_RACE_STR_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_RACE_STR_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_FACE_TTL_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RACE_STR_TTL_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_SEX_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_SEX_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_HP_VAL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_HP_VAL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_SEX_TTL_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_MP_VAL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_MP_VAL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_HP_VAL_DRAW_MIN_Y + 1)

/**/

#define	WIN_MBR_DATA_VAL_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_MP_VAL_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_HIT_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_WPN_CRTCL_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X
#define	WIN_MBR_DATA_WPN_CRTCL_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_DAM_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X
#define	WIN_MBR_DATA_DAM_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y + 3)

#define	WIN_MBR_DATA_DEF_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X
#define	WIN_MBR_DATA_DEF_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y + 4)

#define	WIN_MBR_DATA_ARMOR_CRTCL_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X
#define	WIN_MBR_DATA_ARMOR_CRTCL_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y + 5)

#define	WIN_MBR_DATA_AC_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X
#define	WIN_MBR_DATA_AC_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y + 6)


#define	WIN_MBR_DATA_GOLD_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_GOLD_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_AC_TTL_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_TURN_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_TURN_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_GOLD_TTL_DRAW_MIN_Y + 2)


#define	WIN_MBR_DATA_STAT_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_STAT_DRAW_MIN_Y	0

#define	WIN_MBR_DATA_STAT_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_STAT_DRAW_MIN_X
#define	WIN_MBR_DATA_STAT_TTL_DRAW_MIN_Y	\
		WIN_MBR_DATA_STAT_DRAW_MIN_Y

#define	WIN_MBR_DATA_STAT_DEAD_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_DEAD_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_STAT_STONE_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_STONE_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_STAT_PARALYZE_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_PARALYZE_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_STAT_POISON_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_POISON_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_STAT_CONFUSION_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_CONFUSION_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 3)

#define	WIN_MBR_DATA_STAT_BLIND_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_BLIND_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 3)

#define	WIN_MBR_DATA_STAT_SLEEP_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_SLEEP_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 4)

#define	WIN_MBR_DATA_STAT_SILENCE_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_SILENCE_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 4)

#define	WIN_MBR_DATA_STAT_CAUGHT_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_CAUGHT_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 5)

#define	WIN_MBR_DATA_STAT_FEAR_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_FEAR_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 5)

#define	WIN_MBR_DATA_STAT_HALLUCINATION_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_HALLUCINATION_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 6)

#define	WIN_MBR_DATA_STAT_CHARM_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_CHARM_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 6)

#define	WIN_MBR_DATA_STAT_FLY_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_FLY_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 7)

#define	WIN_MBR_DATA_STAT_HUNGRY_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_HUNGRY_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 7)

#define	WIN_MBR_DATA_STAT_FAINT_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_FAINT_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 8)

#define	WIN_MBR_DATA_STAT_DRUNK_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_DRUNK_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 8)

#define	WIN_MBR_DATA_STAT_VANISH_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_VANISH_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 9)

#define	WIN_MBR_DATA_STAT_IRON_BODY_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 0)
#define	WIN_MBR_DATA_STAT_IRON_BODY_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 9)

#define	WIN_MBR_DATA_STAT_PASSWALL_DRAW_MIN_X	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_X + 20)
#define	WIN_MBR_DATA_STAT_PASSWALL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_STAT_DRAW_MIN_Y + 9)

/* page 2/2 */

#define	WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_X	(0 + 6)
#define	WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y	2

#define	WIN_MBR_DATA_EXP_TTL_LEFT_DRAW_MIN_X	(0 + 18)
#define	WIN_MBR_DATA_EXP_TTL_LEFT_DRAW_MIN_Y	\
		WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y

#define	WIN_MBR_DATA_NEED_EXP_TTL_LEFT_DRAW_MIN_X	(0 + 25)
#define	WIN_MBR_DATA_NEED_EXP_TTL_LEFT_DRAW_MIN_Y	\
		WIN_MBR_DATA_EXP_TTL_LEFT_DRAW_MIN_Y

#define	WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_X	\
		(WIN_MBR_DATA_DRAW_MID_X + 6)
#define	WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y	0

#define	WIN_MBR_DATA_EXP_TTL_RIGHT_DRAW_MIN_X	\
		(WIN_MBR_DATA_DRAW_MID_X + 18)
#define	WIN_MBR_DATA_EXP_TTL_RIGHT_DRAW_MIN_Y	0

#define	WIN_MBR_DATA_NEED_EXP_TTL_RIGHT_DRAW_MIN_X	\
		(WIN_MBR_DATA_DRAW_MID_X + 25)
#define	WIN_MBR_DATA_NEED_EXP_TTL_RIGHT_DRAW_MIN_Y	0

/* abl 1/2 */

#define	WIN_MBR_DATA_HP_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_HP_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_MP_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_MP_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_DEX_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_DEX_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 3)

#define	WIN_MBR_DATA_STR_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_STR_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 4)

#define	WIN_MBR_DATA_AGI_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_AGI_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 5)

#define	WIN_MBR_DATA_INT_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_INT_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 6)

#define	WIN_MBR_DATA_WIS_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_WIS_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 7)

#define	WIN_MBR_DATA_CHA_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_CHA_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y + 8)

/* resi */

#define	WIN_MBR_DATA_DRAW_LEFT_LEFT_X	\
		(WIN_MBR_DATA_DRAW_MID_X * 1 / 4 - 1)
#define	WIN_MBR_DATA_DRAW_LEFT_MID_X	\
		(WIN_MBR_DATA_DRAW_MID_X * 2 / 4 - 1)
#define	WIN_MBR_DATA_DRAW_LEFT_RIGHT_X	\
		(WIN_MBR_DATA_DRAW_MID_X * 3 / 4 - 1)

#define	WIN_MBR_DATA_RESI_TTL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_CHA_TTL_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_RESI_TTL_LAWFUL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_LEFT_X
#define	WIN_MBR_DATA_RESI_TTL_LAWFUL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 0)
#define	WIN_MBR_DATA_RESI_TTL_NEUTRAL_1_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_MID_X
#define	WIN_MBR_DATA_RESI_TTL_NEUTRAL_1_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 0)
#define	WIN_MBR_DATA_RESI_TTL_CHAOTIC_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_RIGHT_X
#define	WIN_MBR_DATA_RESI_TTL_CHAOTIC_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 0)

#define	WIN_MBR_DATA_RESI_TTL_GOOD_DRAW_MIN_X	0
#define	WIN_MBR_DATA_RESI_TTL_GOOD_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 1)
#define	WIN_MBR_DATA_RESI_TTL_NEUTRAL_2_DRAW_MIN_X	0
#define	WIN_MBR_DATA_RESI_TTL_NEUTRAL_2_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 2)
#define	WIN_MBR_DATA_RESI_TTL_EVIL_DRAW_MIN_X	0
#define	WIN_MBR_DATA_RESI_TTL_EVIL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 3)

#define	WIN_MBR_DATA_RESI_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_RESI_ELEC_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_LEFT_X
#define	WIN_MBR_DATA_RESI_ELEC_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 0)

#define	WIN_MBR_DATA_RESI_COLD_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_MID_X
#define	WIN_MBR_DATA_RESI_COLD_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 0)

#define	WIN_MBR_DATA_RESI_KNOC_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_RIGHT_X
#define	WIN_MBR_DATA_RESI_KNOC_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 0)

#define	WIN_MBR_DATA_RESI_ACID_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_LEFT_X
#define	WIN_MBR_DATA_RESI_ACID_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_RESI_SLAS_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_MID_X
#define	WIN_MBR_DATA_RESI_SLAS_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_RESI_MIND_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_RIGHT_X
#define	WIN_MBR_DATA_RESI_MIND_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_RESI_STIN_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_LEFT_X
#define	WIN_MBR_DATA_RESI_STIN_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_RESI_HEAT_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_MID_X
#define	WIN_MBR_DATA_RESI_HEAT_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_RESI_POIS_TTL_DRAW_MIN_X	\
		WIN_MBR_DATA_DRAW_LEFT_RIGHT_X
#define	WIN_MBR_DATA_RESI_POIS_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_RESI_DRAW_MIN_Y + 2)

/* abl 2/2 */

#define	WIN_MBR_DATA_FIG_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_FIG_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 1)

#define	WIN_MBR_DATA_MON_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_MON_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_HUN_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_HUN_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 3)

#define	WIN_MBR_DATA_THI_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_THI_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 4)

#define	WIN_MBR_DATA_MAG_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_MAG_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 5)

#define	WIN_MBR_DATA_SOR_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_SOR_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 6)

#define	WIN_MBR_DATA_ENC_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_ENC_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 7)

#define	WIN_MBR_DATA_SUM_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_SUM_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 8)

#define	WIN_MBR_DATA_PRI_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_PRI_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 9)

#define	WIN_MBR_DATA_SHA_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_SHA_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 10)

#define	WIN_MBR_DATA_BAR_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_BAR_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 11)

#define	WIN_MBR_DATA_NIN_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_NIN_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y + 12)

/* Class */

#define	WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_Y	\
		(WIN_MBR_DATA_NIN_TTL_DRAW_MIN_Y + 2)

#define	WIN_MBR_DATA_NEXT_PAGE_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_MBR_DATA_NEXT_PAGE_DRAW_MIN_Y	19

/* Data end */

/* Edit class begin */

#define	WIN_EDIT_CLASS_PREV_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_EDIT_CLASS_PREV_DRAW_MIN_Y	\
		(WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_Y + 2)

#define	WIN_EDIT_CLASS_NEXT_DRAW_MIN_X	WIN_MBR_DATA_DRAW_MID_X
#define	WIN_EDIT_CLASS_NEXT_DRAW_MIN_Y	\
		(WIN_EDIT_CLASS_PREV_DRAW_MIN_Y + 1)

/* Edit class end */

/* Edit pet begin */

#define	WIN_PET_DATA_NAME_TTL_DRAW_MIN_X	0
#define	WIN_PET_DATA_NAME_TTL_DRAW_MIN_Y	0

/* Edit pet end */

/**/

/* СǡΥǥݥȽ */

bool_t	flg_sel_data_n[MBR_DATA_EDIT_KIND_MAX_N][DATA_N_MAX_N] = {
	{
		/* ɽΤ */
		/* MBR_DATA_EDIT_KIND_SHOW */

		FALSE,	/* DATA_N_NULL, */

		FALSE,	/* DATA_N_NAME, */
		FALSE,	/* DATA_N_FACE, */
		FALSE,	/* DATA_N_RACE_STR, */
		FALSE,	/* DATA_N_RACE_NAME, */
		FALSE,	/* DATA_N_SEX, */

		FALSE,	/* DATA_N_HP_VAL, */
		FALSE,	/* DATA_N_MP_VAL, */

		FALSE,	/* DATA_N_VAL_TTL, */
		FALSE,	/* DATA_N_HIT, */
		FALSE,	/* DATA_N_WPN_CRTCL, */
		FALSE,	/* DATA_N_DAM, */
		FALSE,	/* DATA_N_DEF, */
		FALSE,	/* DATA_N_ARMOR_CRTCL, */
		FALSE,	/* DATA_N_AC, */
		FALSE,	/* DATA_N_GOLD, */
		FALSE,	/* DATA_N_TURN, */

		FALSE,	/* DATA_N_STAT_TTL, */
		FALSE,	/* DATA_N_STAT_DEAD, */
		FALSE,	/* DATA_N_STAT_STONE, */
		FALSE,	/* DATA_N_STAT_PARALYZE, */
		FALSE,	/* DATA_N_STAT_POISON, */
		FALSE,	/* DATA_N_STAT_CONFUSION, */
		FALSE,	/* DATA_N_STAT_BLIND, */
		FALSE,	/* DATA_N_STAT_SLEEP, */
		FALSE,	/* DATA_N_STAT_SILENCE, */
		FALSE,	/* DATA_N_STAT_CAUGHT, */
		FALSE,	/* DATA_N_STAT_FEAR, */
		FALSE,	/* DATA_N_STAT_HALLUCINATION, */
		FALSE,	/* DATA_N_STAT_CHARM, */
		FALSE,	/* DATA_N_STAT_FLY, */
		FALSE,	/* DATA_N_STAT_HUNGRY, */
		FALSE,	/* DATA_N_STAT_FAINT, */
		FALSE,	/* DATA_N_STAT_DRUNK, */
		FALSE,	/* DATA_N_STAT_VANISH, */
		FALSE,	/* DATA_N_STAT_IRON_BODY, */
		FALSE,	/* DATA_N_STAT_PASSWALL, */

		FALSE,	/* DATA_N_LEV_LEFT, */
		FALSE,	/* DATA_N_EXP_LEFT, */
		FALSE,	/* DATA_N_NEED_EXP_LEFT, */

		FALSE,	/* DATA_N_LEV_RIGHT, */
		FALSE,	/* DATA_N_EXP_RIGHT, */
		FALSE,	/* DATA_N_NEED_EXP_RIGHT, */

		FALSE,	/* DATA_N_HP, */
		FALSE,	/* DATA_N_MP, */
		FALSE,	/* DATA_N_DEX, */
		FALSE,	/* DATA_N_STR, */
		FALSE,	/* DATA_N_AGI, */
		FALSE,	/* DATA_N_INT, */
		FALSE,	/* DATA_N_WIS, */
		FALSE,	/* DATA_N_CHA, */

		FALSE,	/* DATA_N_RESI_TTL, */
		FALSE,	/* DATA_N_RESI_TTL_LAWFUL, */
		FALSE,	/* DATA_N_RESI_TTL_NEUTRAL_1, */
		FALSE,	/* DATA_N_RESI_TTL_CHAOTIC, */
		FALSE,	/* DATA_N_RESI_TTL_GOOD, */
		FALSE,	/* DATA_N_RESI_TTL_NEUTRAL_2, */
		FALSE,	/* DATA_N_RESI_TTL_EVIL, */
		FALSE,	/* DATA_N_RESI_KNOC, */
		FALSE,	/* DATA_N_RESI_SLAS, */
		FALSE,	/* DATA_N_RESI_STIN, */
		FALSE,	/* DATA_N_RESI_HEAT, */
		FALSE,	/* DATA_N_RESI_COLD, */
		FALSE,	/* DATA_N_RESI_MIND, */
		FALSE,	/* DATA_N_RESI_ACID, */
		FALSE,	/* DATA_N_RESI_ELEC, */
		FALSE,	/* DATA_N_RESI_POIS, */

		FALSE,	/* DATA_N_FIG, */
		FALSE,	/* DATA_N_MON, */
		FALSE,	/* DATA_N_HUN, */
		FALSE,	/* DATA_N_THI, */
		FALSE,	/* DATA_N_MAG, */
		FALSE,	/* DATA_N_SOR, */
		FALSE,	/* DATA_N_ENC, */
		FALSE,	/* DATA_N_SUM, */
		FALSE,	/* DATA_N_PRI, */
		FALSE,	/* DATA_N_SHA, */
		FALSE,	/* DATA_N_BAR, */
		FALSE,	/* DATA_N_NIN, */

		FALSE,	/* DATA_N_CLASS, */

		TRUE,	/* DATA_N_NEXT_PAGE, */
	},
	{
		/* Խ */
		/* MBR_DATA_EDIT_KIND_EDIT */

		FALSE,	/* DATA_N_NULL, */

		TRUE,	/* DATA_N_NAME, */
		TRUE,	/* DATA_N_FACE, */
		FALSE,	/* DATA_N_RACE_STR, */
		TRUE,	/* DATA_N_RACE_NAME, */
		FALSE,	/* DATA_N_SEX, */

		FALSE,	/* DATA_N_HP_VAL, */
		FALSE,	/* DATA_N_MP_VAL, */

		FALSE,	/* DATA_N_VAL_TTL, */
		FALSE,	/* DATA_N_HIT, */
		FALSE,	/* DATA_N_WPN_CRTCL, */
		FALSE,	/* DATA_N_DAM, */
		FALSE,	/* DATA_N_DEF, */
		FALSE,	/* DATA_N_ARMOR_CRTCL, */
		FALSE,	/* DATA_N_AC, */
		FALSE,	/* DATA_N_GOLD, */
		FALSE,	/* DATA_N_TURN, */

		FALSE,	/* DATA_N_STAT_TTL, */
		FALSE,	/* DATA_N_STAT_DEAD, */
		FALSE,	/* DATA_N_STAT_STONE, */
		FALSE,	/* DATA_N_STAT_PARALYZE, */
		FALSE,	/* DATA_N_STAT_POISON, */
		FALSE,	/* DATA_N_STAT_CONFUSION, */
		FALSE,	/* DATA_N_STAT_BLIND, */
		FALSE,	/* DATA_N_STAT_SLEEP, */
		FALSE,	/* DATA_N_STAT_SILENCE, */
		FALSE,	/* DATA_N_STAT_CAUGHT, */
		FALSE,	/* DATA_N_STAT_FEAR, */
		FALSE,	/* DATA_N_STAT_HALLUCINATION, */
		FALSE,	/* DATA_N_STAT_CHARM, */
		FALSE,	/* DATA_N_STAT_FLY, */
		FALSE,	/* DATA_N_STAT_HUNGRY, */
		FALSE,	/* DATA_N_STAT_FAINT, */
		FALSE,	/* DATA_N_STAT_DRUNK, */
		FALSE,	/* DATA_N_STAT_VANISH, */
		FALSE,	/* DATA_N_STAT_IRON_BODY, */
		FALSE,	/* DATA_N_STAT_PASSWALL, */

		FALSE,	/* DATA_N_LEV_LEFT, */
		FALSE,	/* DATA_N_EXP_LEFT, */
		FALSE,	/* DATA_N_NEED_EXP_LEFT, */

		FALSE,	/* DATA_N_LEV_RIGHT, */
		FALSE,	/* DATA_N_EXP_RIGHT, */
		FALSE,	/* DATA_N_NEED_EXP_RIGHT, */

		FALSE,	/* DATA_N_HP, */
		FALSE,	/* DATA_N_MP, */
		FALSE,	/* DATA_N_DEX, */
		FALSE,	/* DATA_N_STR, */
		FALSE,	/* DATA_N_AGI, */
		FALSE,	/* DATA_N_INT, */
		FALSE,	/* DATA_N_WIS, */
		FALSE,	/* DATA_N_CHA, */

		FALSE,	/* DATA_N_RESI_TTL, */
		FALSE,	/* DATA_N_RESI_TTL_LAWFUL, */
		FALSE,	/* DATA_N_RESI_TTL_NEUTRAL_1, */
		FALSE,	/* DATA_N_RESI_TTL_CHAOTIC, */
		FALSE,	/* DATA_N_RESI_TTL_GOOD, */
		FALSE,	/* DATA_N_RESI_TTL_NEUTRAL_2, */
		FALSE,	/* DATA_N_RESI_TTL_EVIL, */
		FALSE,	/* DATA_N_RESI_KNOC, */
		FALSE,	/* DATA_N_RESI_SLAS, */
		FALSE,	/* DATA_N_RESI_STIN, */
		FALSE,	/* DATA_N_RESI_HEAT, */
		FALSE,	/* DATA_N_RESI_COLD, */
		FALSE,	/* DATA_N_RESI_MIND, */
		FALSE,	/* DATA_N_RESI_ACID, */
		FALSE,	/* DATA_N_RESI_ELEC, */
		FALSE,	/* DATA_N_RESI_POIS, */

		FALSE,	/* DATA_N_FIG, */
		FALSE,	/* DATA_N_MON, */
		FALSE,	/* DATA_N_HUN, */
		FALSE,	/* DATA_N_THI, */
		FALSE,	/* DATA_N_MAG, */
		FALSE,	/* DATA_N_SOR, */
		FALSE,	/* DATA_N_ENC, */
		FALSE,	/* DATA_N_SUM, */
		FALSE,	/* DATA_N_PRI, */
		FALSE,	/* DATA_N_SHA, */
		FALSE,	/* DATA_N_BAR, */
		FALSE,	/* DATA_N_NIN, */

		TRUE,	/* DATA_N_CLASS, */

		TRUE,	/* DATA_N_NEXT_PAGE, */
	},
	{
		/*  */
		/* MBR_DATA_EDIT_KIND_NEW */

		FALSE,	/* DATA_N_NULL, */

		TRUE,	/* DATA_N_NAME, */
		TRUE,	/* DATA_N_FACE, */
		TRUE,	/* DATA_N_RACE_STR, */
		TRUE,	/* DATA_N_RACE_NAME, */
		TRUE,	/* DATA_N_SEX, */

		FALSE,	/* DATA_N_HP_VAL, */
		FALSE,	/* DATA_N_MP_VAL, */

		FALSE,	/* DATA_N_VAL_TTL, */
		FALSE,	/* DATA_N_HIT, */
		FALSE,	/* DATA_N_WPN_CRTCL, */
		FALSE,	/* DATA_N_DAM, */
		FALSE,	/* DATA_N_DEF, */
		FALSE,	/* DATA_N_ARMOR_CRTCL, */
		FALSE,	/* DATA_N_AC, */
		FALSE,	/* DATA_N_GOLD, */
		FALSE,	/* DATA_N_TURN, */

		FALSE,	/* DATA_N_STAT_TTL, */
		FALSE,	/* DATA_N_STAT_DEAD, */
		FALSE,	/* DATA_N_STAT_STONE, */
		FALSE,	/* DATA_N_STAT_PARALYZE, */
		FALSE,	/* DATA_N_STAT_POISON, */
		FALSE,	/* DATA_N_STAT_CONFUSION, */
		FALSE,	/* DATA_N_STAT_BLIND, */
		FALSE,	/* DATA_N_STAT_SLEEP, */
		FALSE,	/* DATA_N_STAT_SILENCE, */
		FALSE,	/* DATA_N_STAT_CAUGHT, */
		FALSE,	/* DATA_N_STAT_FEAR, */
		FALSE,	/* DATA_N_STAT_HALLUCINATION, */
		FALSE,	/* DATA_N_STAT_CHARM, */
		FALSE,	/* DATA_N_STAT_FLY, */
		FALSE,	/* DATA_N_STAT_HUNGRY, */
		FALSE,	/* DATA_N_STAT_FAINT, */
		FALSE,	/* DATA_N_STAT_DRUNK, */
		FALSE,	/* DATA_N_STAT_VANISH, */
		FALSE,	/* DATA_N_STAT_IRON_BODY, */
		FALSE,	/* DATA_N_STAT_PASSWALL, */

		FALSE,	/* DATA_N_LEV_LEFT, */
		FALSE,	/* DATA_N_EXP_LEFT, */
		FALSE,	/* DATA_N_NEED_EXP_LEFT, */

		FALSE,	/* DATA_N_LEV_RIGHT, */
		FALSE,	/* DATA_N_EXP_RIGHT, */
		FALSE,	/* DATA_N_NEED_EXP_RIGHT, */

		FALSE,	/* DATA_N_HP, */
		FALSE,	/* DATA_N_MP, */
		FALSE,	/* DATA_N_DEX, */
		FALSE,	/* DATA_N_STR, */
		FALSE,	/* DATA_N_AGI, */
		FALSE,	/* DATA_N_INT, */
		FALSE,	/* DATA_N_WIS, */
		FALSE,	/* DATA_N_CHA, */

		FALSE,	/* DATA_N_RESI_TTL, */
		FALSE,	/* DATA_N_RESI_TTL_LAWFUL, */
		FALSE,	/* DATA_N_RESI_TTL_NEUTRAL_1, */
		FALSE,	/* DATA_N_RESI_TTL_CHAOTIC, */
		FALSE,	/* DATA_N_RESI_TTL_GOOD, */
		FALSE,	/* DATA_N_RESI_TTL_NEUTRAL_2, */
		FALSE,	/* DATA_N_RESI_TTL_EVIL, */
		FALSE,	/* DATA_N_RESI_KNOC, */
		FALSE,	/* DATA_N_RESI_SLAS, */
		FALSE,	/* DATA_N_RESI_STIN, */
		FALSE,	/* DATA_N_RESI_HEAT, */
		FALSE,	/* DATA_N_RESI_COLD, */
		FALSE,	/* DATA_N_RESI_MIND, */
		FALSE,	/* DATA_N_RESI_ACID, */
		FALSE,	/* DATA_N_RESI_ELEC, */
		FALSE,	/* DATA_N_RESI_POIS, */

		FALSE,	/* DATA_N_FIG, */
		FALSE,	/* DATA_N_MON, */
		FALSE,	/* DATA_N_HUN, */
		FALSE,	/* DATA_N_THI, */
		FALSE,	/* DATA_N_MAG, */
		FALSE,	/* DATA_N_SOR, */
		FALSE,	/* DATA_N_ENC, */
		FALSE,	/* DATA_N_SUM, */
		FALSE,	/* DATA_N_PRI, */
		FALSE,	/* DATA_N_SHA, */
		FALSE,	/* DATA_N_BAR, */
		FALSE,	/* DATA_N_NIN, */

		TRUE,	/* DATA_N_CLASS, */

		TRUE,	/* DATA_N_NEXT_PAGE, */
	},
};

/* СΥǡɽڡֹ */

#define	DATA_PAGE_N_ALL	127

long	data_page_n_tab[] = {
	0,	/* DATA_N_NULL, */

	DATA_PAGE_N_ALL,	/* DATA_N_NAME, */
	0,	/* DATA_N_FACE, */
	0,	/* DATA_N_RACE_STR, */
	0,	/* DATA_N_RACE_NAME, */
	0,	/* DATA_N_SEX, */

	0,	/* DATA_N_HP_VAL, */
	0,	/* DATA_N_MP_VAL, */

	0,	/* DATA_N_VAL_TTL, */
	0,	/* DATA_N_HIT, */
	0,	/* DATA_N_WPN_CRTCL, */
	0,	/* DATA_N_DAM, */
	0,	/* DATA_N_DEF, */
	0,	/* DATA_N_ARMOR_CRTCL, */
	0,	/* DATA_N_AC, */
	0,	/* DATA_N_GOLD, */
	0,	/* DATA_N_TURN, */

	0,	/* DATA_N_STAT_TTL, */
	0,	/* DATA_N_STAT_DEAD, */
	0,	/* DATA_N_STAT_STONE, */
	0,	/* DATA_N_STAT_PARALYZE, */
	0,	/* DATA_N_STAT_POISON, */
	0,	/* DATA_N_STAT_CONFUSION, */
	0,	/* DATA_N_STAT_BLIND, */
	0,	/* DATA_N_STAT_SLEEP, */
	0,	/* DATA_N_STAT_SILENCE, */
	0,	/* DATA_N_STAT_CAUGHT, */
	0,	/* DATA_N_STAT_FEAR, */
	0,	/* DATA_N_STAT_HALLUCINATION, */
	0,	/* DATA_N_STAT_CHARM, */
	0,	/* DATA_N_STAT_FLY, */
	0,	/* DATA_N_STAT_HUNGRY, */
	0,	/* DATA_N_STAT_FAINT, */
	0,	/* DATA_N_STAT_DRUNK, */
	0,	/* DATA_N_STAT_VANISH, */
	0,	/* DATA_N_STAT_IRON_BODY, */
	0,	/* DATA_N_STAT_PASSWALL, */

	1,	/* DATA_N_LEV_LEFT, */
	1,	/* DATA_N_EXP_LEFT, */
	1,	/* DATA_N_NEED_EXP_LEFT, */

	1,	/* DATA_N_LEV_RIGHT, */
	1,	/* DATA_N_EXP_RIGHT, */
	1,	/* DATA_N_NEED_EXP_RIGHT, */

	1,	/* DATA_N_HP, */
	1,	/* DATA_N_MP, */
	1,	/* DATA_N_DEX, */
	1,	/* DATA_N_STR, */
	1,	/* DATA_N_AGI, */
	1,	/* DATA_N_INT, */
	1,	/* DATA_N_WIS, */
	1,	/* DATA_N_CHA, */

	1,	/* DATA_N_RESI_TTL, */
	1,	/* DATA_N_RESI_TTL_LAWFUL, */
	1,	/* DATA_N_RESI_TTL_NEUTRAL_1, */
	1,	/* DATA_N_RESI_TTL_CHAOTIC, */
	1,	/* DATA_N_RESI_TTL_GOOD, */
	1,	/* DATA_N_RESI_TTL_NEUTRAL_2, */
	1,	/* DATA_N_RESI_TTL_EVIL, */
	1,	/* DATA_N_RESI_KNOC, */
	1,	/* DATA_N_RESI_SLAS, */
	1,	/* DATA_N_RESI_STIN, */
	1,	/* DATA_N_RESI_HEAT, */
	1,	/* DATA_N_RESI_COLD, */
	1,	/* DATA_N_RESI_MIND, */
	1,	/* DATA_N_RESI_ACID, */
	1,	/* DATA_N_RESI_ELEC, */
	1,	/* DATA_N_RESI_POIS, */

	1,	/* DATA_N_FIG, */
	1,	/* DATA_N_MON, */
	1,	/* DATA_N_HUN, */
	1,	/* DATA_N_THI, */
	1,	/* DATA_N_MAG, */
	1,	/* DATA_N_SOR, */
	1,	/* DATA_N_ENC, */
	1,	/* DATA_N_SUM, */
	1,	/* DATA_N_PRI, */
	1,	/* DATA_N_SHA, */
	1,	/* DATA_N_BAR, */
	1,	/* DATA_N_NIN, */

	1,	/* DATA_N_CLASS, */

	DATA_PAGE_N_ALL,	/* DATA_N_NEXT_PAGE, */
};

/* § */

typedef struct {
	n_msg_t	n_str;
	char	*str;
} kin_soku_t;

/* ζ§ */

kin_soku_t	okuri_tab[] = {
	{ N_MSG_OKURI_00, NULL },
	{ N_MSG_OKURI_01, NULL },
	{ N_MSG_OKURI_02, NULL },
	{ N_MSG_OKURI_03, NULL },
	{ N_MSG_OKURI_04, NULL },
	{ N_MSG_OKURI_05, NULL },
	{ N_MSG_OKURI_06, NULL },
	{ N_MSG_OKURI_07, NULL },
	{ N_MSG_OKURI_08, NULL },
	{ N_MSG_OKURI_09, NULL },
	{ N_MSG_OKURI_10, NULL },
	{ N_MSG_OKURI_11, NULL },
	{ N_MSG_OKURI_12, NULL },
	{ N_MSG_OKURI_13, NULL },
	{ N_MSG_OKURI_14, NULL },
	{ N_MSG_OKURI_15, NULL },
	{ N_MSG_OKURI_16, NULL },
	{ N_MSG_OKURI_17, NULL },
	{ N_MSG_OKURI_18, NULL },
	{ N_MSG_OKURI_19, NULL },
	{ N_MSG_OKURI_20, NULL },
	{ N_MSG_OKURI_21, NULL },
	{ N_MSG_OKURI_22, NULL },
	{ N_MSG_OKURI_23, NULL },
	{ N_MSG_OKURI_24, NULL },
	{ N_MSG_OKURI_25, NULL },
	{ N_MSG_OKURI_26, NULL },
	{ N_MSG_OKURI_27, NULL },
	{ N_MSG_OKURI_28, NULL },
	{ N_MSG_OKURI_29, NULL },
	{ N_MSG_NULL, NULL },
};

/* § */

kin_soku_t	kin_soku_tab[] = {
	{ N_MSG_KIN_SOKU_00, NULL },
	{ N_MSG_KIN_SOKU_01, NULL },
	{ N_MSG_KIN_SOKU_02, NULL },
	{ N_MSG_KIN_SOKU_03, NULL },
	{ N_MSG_KIN_SOKU_04, NULL },
	{ N_MSG_KIN_SOKU_05, NULL },
	{ N_MSG_KIN_SOKU_06, NULL },
	{ N_MSG_KIN_SOKU_07, NULL },
	{ N_MSG_KIN_SOKU_08, NULL },
	{ N_MSG_KIN_SOKU_09, NULL },
	{ N_MSG_KIN_SOKU_10, NULL },
	{ N_MSG_KIN_SOKU_11, NULL },
	{ N_MSG_KIN_SOKU_12, NULL },
	{ N_MSG_KIN_SOKU_13, NULL },
	{ N_MSG_KIN_SOKU_14, NULL },
	{ N_MSG_KIN_SOKU_15, NULL },
	{ N_MSG_KIN_SOKU_16, NULL },
	{ N_MSG_KIN_SOKU_17, NULL },
	{ N_MSG_KIN_SOKU_18, NULL },
	{ N_MSG_KIN_SOKU_19, NULL },
	{ N_MSG_KIN_SOKU_20, NULL },
	{ N_MSG_KIN_SOKU_21, NULL },
	{ N_MSG_KIN_SOKU_22, NULL },
	{ N_MSG_KIN_SOKU_23, NULL },
	{ N_MSG_KIN_SOKU_24, NULL },
	{ N_MSG_KIN_SOKU_25, NULL },
	{ N_MSG_KIN_SOKU_26, NULL },
	{ N_MSG_KIN_SOKU_27, NULL },
	{ N_MSG_KIN_SOKU_28, NULL },
	{ N_MSG_KIN_SOKU_29, NULL },
	{ N_MSG_NULL, NULL },
};

#endif	/* DRAW_TAB_H */
