/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: item-tab.h,v 1.8 2004/12/06 06:18:18 bowkenken Exp $
***************************************************************/

#ifndef	ITEM_TAB_H
#define	ITEM_TAB_H

/* ƥࡦǡ */

#include	"chr.h"

/**/

/* иΨ */

typedef struct {
	ratio_t	ratio;
	item_kind_t	kind;
} item_ratio_tab_t;

item_ratio_tab_t	item_ratio_tab[ITEM_KIND_MAX_N] = {
	{  80, ITEM_KIND_WPN, },
	{  80, ITEM_KIND_ARMOR, },
	{ 100, ITEM_KIND_POTION, },
	{ 100, ITEM_KIND_SCROLL, },
	{  50, ITEM_KIND_STICK, },
	{  30, ITEM_KIND_ACCE, },
	{  30, ITEM_KIND_INST, },
	{  30, ITEM_KIND_ANTHOLOGY, },
	{  30, ITEM_KIND_LIGHT, },
	{  30, ITEM_KIND_SPIKE, },
	{ 100, ITEM_KIND_FOOD, },
	{ 300, ITEM_KIND_CHEST, },
	{  50, ITEM_KIND_TOBACCO, },
	{  20, ITEM_KIND_PIPE, },
	{  20, ITEM_KIND_DISPOSAL, },
	{   0, ITEM_KIND_RARE_GOODS, },
	{ 100, ITEM_KIND_COIN, },
	{  20, ITEM_KIND_JUNK, },
	{   0, ITEM_KIND_NULL, },
};

wpn_tab_t	wpn_tab[] = {
#include	"item-wpn-tab.h"
};

armor_tab_t	armor_tab[] = {
#include	"item-armor-tab.h"
};

potion_tab_t	potion_tab[] = {
#include	"item-potion-tab.h"
};

long	color_tab_max_n;
ls_identified_t	*color_tab;

/* ֤ѹϥǡɴؿ⽤ */
n_msg_t	color_idx_tab[] = {
	N_MSG_POTION_COLOR_CRYSTAL,
	N_MSG_POTION_COLOR_CRYSTAL_WHITE,
	N_MSG_POTION_COLOR_CRYSTAL_BLACK,
	N_MSG_POTION_COLOR_CRYSTAL_RED,
	N_MSG_POTION_COLOR_CRYSTAL_GREEN,
	N_MSG_POTION_COLOR_CRYSTAL_BLUE,
	N_MSG_POTION_COLOR_CRYSTAL_YELLOW,
	N_MSG_POTION_COLOR_CRYSTAL_RED_PURPLE,
	N_MSG_POTION_COLOR_CRYSTAL_BLUE_PURPLE,
	N_MSG_POTION_COLOR_CRYSTAL_ORANGE,
	N_MSG_POTION_COLOR_CRYSTAL_PINK,
	N_MSG_POTION_COLOR_CRYSTAL_BROWN,
	N_MSG_POTION_COLOR_WHITE,
	N_MSG_POTION_COLOR_BLACK,
	N_MSG_POTION_COLOR_RED,
	N_MSG_POTION_COLOR_GREEN,
	N_MSG_POTION_COLOR_BLUE,
	N_MSG_POTION_COLOR_YELLOW,
	N_MSG_POTION_COLOR_RED_PURPLE,
	N_MSG_POTION_COLOR_BLUE_PURPLE,
	N_MSG_POTION_COLOR_ORANGE,
	N_MSG_POTION_COLOR_PINK,
	N_MSG_POTION_COLOR_BROWN,
	N_MSG_POTION_COLOR_LUMINOUS_WHITE,
	N_MSG_POTION_COLOR_LUMINOUS_BLACK,
	N_MSG_POTION_COLOR_LUMINOUS_RED,
	N_MSG_POTION_COLOR_LUMINOUS_GREEN,
	N_MSG_POTION_COLOR_LUMINOUS_BLUE,
	N_MSG_POTION_COLOR_LUMINOUS_YELLOW,
	N_MSG_POTION_COLOR_LUMINOUS_RED_PURPLE,
	N_MSG_POTION_COLOR_LUMINOUS_BLUE_PURPLE,
	N_MSG_POTION_COLOR_LUMINOUS_ORANGE,
	N_MSG_POTION_COLOR_LUMINOUS_PINK,
	N_MSG_POTION_COLOR_LUMINOUS_BROWN,
	N_MSG_POTION_COLOR_SPOTTED_WHITE,
	N_MSG_POTION_COLOR_SPOTTED_BLACK,
	N_MSG_POTION_COLOR_SPOTTED_RED,
	N_MSG_POTION_COLOR_SPOTTED_GREEN,
	N_MSG_POTION_COLOR_SPOTTED_BLUE,
	N_MSG_POTION_COLOR_SPOTTED_YELLOW,
	N_MSG_POTION_COLOR_SPOTTED_RED_PURPLE,
	N_MSG_POTION_COLOR_SPOTTED_BLUE_PURPLE,
	N_MSG_POTION_COLOR_SPOTTED_ORANGE,
	N_MSG_POTION_COLOR_SPOTTED_PINK,
	N_MSG_POTION_COLOR_SPOTTED_BROWN,
	N_MSG_POTION_COLOR_MILK,
	N_MSG_POTION_COLOR_RED_WINE,
	N_MSG_POTION_COLOR_WHITE_WINE,
	N_MSG_POTION_COLOR_ROSE_WINE,
	N_MSG_POTION_COLOR_ALE,
	N_MSG_POTION_COLOR_BRANDY,
	N_MSG_POTION_COLOR_RUM,
	N_MSG_POTION_COLOR_COFFE,
	N_MSG_POTION_COLOR_ICE_COFFE,
	N_MSG_POTION_COLOR_TEA,
	N_MSG_POTION_COLOR_MILK_TEA,
	N_MSG_POTION_COLOR_LEMON_TEA,
	N_MSG_POTION_COLOR_ICE_TEA,
	N_MSG_POTION_COLOR_ICE_MILK_TEA,
	N_MSG_POTION_COLOR_ICE_LEMON_TEA,
	N_MSG_POTION_COLOR_APPLE_JUICE,
	N_MSG_POTION_COLOR_GRAPE_JUICE,
	N_MSG_POTION_COLOR_ORANGE_JUICE,
	N_MSG_POTION_COLOR_BLACK_BERRY_JUICE,
	N_MSG_POTION_COLOR_CRAN_BERRY_JUICE,
	N_MSG_POTION_COLOR_RASP_BERRY_JUICE,
	N_MSG_POTION_COLOR_STRAW_BERRY_JUICE,
	N_MSG_NULL,
};

scroll_tab_t	scroll_tab[] = {
#include	"item-scroll-tab.h"
};

long	ttl_syllable_tab_max_n;

/* ֤ѹϥǡɴؿ⽤ */
n_msg_t	ttl_syllable_idx_tab[] = {
	N_MSG_SCROLL_TTL_SYLLABLE_000,
	N_MSG_SCROLL_TTL_SYLLABLE_001,
	N_MSG_SCROLL_TTL_SYLLABLE_002,
	N_MSG_SCROLL_TTL_SYLLABLE_010,
	N_MSG_SCROLL_TTL_SYLLABLE_011,
	N_MSG_SCROLL_TTL_SYLLABLE_012,
	N_MSG_SCROLL_TTL_SYLLABLE_013,
	N_MSG_SCROLL_TTL_SYLLABLE_020,
	N_MSG_SCROLL_TTL_SYLLABLE_021,
	N_MSG_SCROLL_TTL_SYLLABLE_030,
	N_MSG_SCROLL_TTL_SYLLABLE_031,
	N_MSG_SCROLL_TTL_SYLLABLE_032,
	N_MSG_SCROLL_TTL_SYLLABLE_040,
	N_MSG_SCROLL_TTL_SYLLABLE_041,
	N_MSG_SCROLL_TTL_SYLLABLE_042,
	N_MSG_SCROLL_TTL_SYLLABLE_050,
	N_MSG_SCROLL_TTL_SYLLABLE_051,
	N_MSG_SCROLL_TTL_SYLLABLE_052,
	N_MSG_SCROLL_TTL_SYLLABLE_060,
	N_MSG_SCROLL_TTL_SYLLABLE_061,
	N_MSG_SCROLL_TTL_SYLLABLE_070,
	N_MSG_SCROLL_TTL_SYLLABLE_071,
	N_MSG_SCROLL_TTL_SYLLABLE_072,
	N_MSG_SCROLL_TTL_SYLLABLE_080,
	N_MSG_SCROLL_TTL_SYLLABLE_081,
	N_MSG_SCROLL_TTL_SYLLABLE_082,
	N_MSG_SCROLL_TTL_SYLLABLE_090,
	N_MSG_SCROLL_TTL_SYLLABLE_091,
	N_MSG_SCROLL_TTL_SYLLABLE_092,
	N_MSG_SCROLL_TTL_SYLLABLE_101,
	N_MSG_SCROLL_TTL_SYLLABLE_102,
	N_MSG_SCROLL_TTL_SYLLABLE_103,
	N_MSG_SCROLL_TTL_SYLLABLE_104,
	N_MSG_SCROLL_TTL_SYLLABLE_110,
	N_MSG_SCROLL_TTL_SYLLABLE_111,
	N_MSG_SCROLL_TTL_SYLLABLE_120,
	N_MSG_SCROLL_TTL_SYLLABLE_121,
	N_MSG_SCROLL_TTL_SYLLABLE_130,
	N_MSG_SCROLL_TTL_SYLLABLE_131,
	N_MSG_SCROLL_TTL_SYLLABLE_140,
	N_MSG_SCROLL_TTL_SYLLABLE_141,
	N_MSG_SCROLL_TTL_SYLLABLE_142,
	N_MSG_NULL,
};

stick_tab_t	stick_tab[] = {
#include	"item-stick-tab.h"
};

long	wand_material_tab_max_n;
ls_identified_t	*wand_material_tab;

long	rod_material_tab_max_n;
ls_identified_t	*rod_material_tab;

long	staff_material_tab_max_n;
ls_identified_t	*staff_material_tab;

/* ֤ѹϥǡɴؿ⽤ */
n_msg_t	stick_material_idx_tab[] = {
	N_MSG_STICK_MATERIAL_APPLEWOOD,
	N_MSG_STICK_MATERIAL_ASHEN,
	N_MSG_STICK_MATERIAL_ASPEN,
	N_MSG_STICK_MATERIAL_AVOCADO_WOOD,
	N_MSG_STICK_MATERIAL_BALSA,
	N_MSG_STICK_MATERIAL_BANYAN,
	N_MSG_STICK_MATERIAL_BIRCH,
	N_MSG_STICK_MATERIAL_CEDAR,
	N_MSG_STICK_MATERIAL_CHERRYWOOD,
	N_MSG_STICK_MATERIAL_COTTONWOOD,
	N_MSG_STICK_MATERIAL_CYPRESS,
	N_MSG_STICK_MATERIAL_DOGWOOD,
	N_MSG_STICK_MATERIAL_DRIFTWOOD,
	N_MSG_STICK_MATERIAL_EBONY,
	N_MSG_STICK_MATERIAL_ELM_WOOD,
	N_MSG_STICK_MATERIAL_EUCALYPTUS,
	N_MSG_STICK_MATERIAL_GRAPEVINE,
	N_MSG_STICK_MATERIAL_HAWTHORN,
	N_MSG_STICK_MATERIAL_HEMLOCK,
	N_MSG_STICK_MATERIAL_HICKORY,
	N_MSG_STICK_MATERIAL_JUNIPER,
	N_MSG_STICK_MATERIAL_LOCUST,
	N_MSG_STICK_MATERIAL_MAHOGANY,
	N_MSG_STICK_MATERIAL_MAGNOLIA,
	N_MSG_STICK_MATERIAL_MAPLE,
	N_MSG_STICK_MATERIAL_MULBERRY,
	N_MSG_STICK_MATERIAL_OAK,
	N_MSG_STICK_MATERIAL_PECAN,
	N_MSG_STICK_MATERIAL_PERSIMMON,
	N_MSG_STICK_MATERIAL_PINE,
	N_MSG_STICK_MATERIAL_REDWOOD,
	N_MSG_STICK_MATERIAL_ROSEWOOD,
	N_MSG_STICK_MATERIAL_SPRUCE,
	N_MSG_STICK_MATERIAL_SUMAC,
	N_MSG_STICK_MATERIAL_SYCAMORE,
	N_MSG_STICK_MATERIAL_TEAK,
	N_MSG_STICK_MATERIAL_WALNUT,
	N_MSG_NULL,
};

acce_tab_t	acce_tab[] = {
#include	"item-acce-tab.h"
};

long	ring_material_tab_max_n;
ls_identified_t	*ring_material_tab;

long	amulet_material_tab_max_n;
ls_identified_t	*amulet_material_tab;

long	necklace_material_tab_max_n;
ls_identified_t	*necklace_material_tab;

/* ֤ѹϥǡɴؿ⽤ */
n_msg_t	acce_material_idx_tab[] = {
	N_MSG_ACCE_MATERIAL_BONE,
	N_MSG_ACCE_MATERIAL_GOLD,
	N_MSG_ACCE_MATERIAL_SILVER,
	N_MSG_ACCE_GEM_AMBER,
	N_MSG_ACCE_GEM_AGATE,
	N_MSG_ACCE_GEM_ALEXANDRITE,
	N_MSG_ACCE_GEM_AMETHYST,
	N_MSG_ACCE_GEM_ANTLERITE,
	N_MSG_ACCE_GEM_AQUAMARINE,
	N_MSG_ACCE_GEM_ARGENTITE,
	N_MSG_ACCE_GEM_AZURITE,
	N_MSG_ACCE_GEM_BERYL,
	N_MSG_ACCE_GEM_BLOODSTONE,
	N_MSG_ACCE_GEM_CALCITE,
	N_MSG_ACCE_GEM_CARNELIAN,
	N_MSG_ACCE_GEM_CORAL,
	N_MSG_ACCE_GEM_CORUNDUM,
	N_MSG_ACCE_GEM_CRYOLITE,
	N_MSG_ACCE_GEM_DIAMOND,
	N_MSG_ACCE_GEM_DIORITE,
	N_MSG_ACCE_GEM_EMERALD,
	N_MSG_ACCE_GEM_FLINT,
	N_MSG_ACCE_GEM_FLUORITE,
	N_MSG_ACCE_GEM_GABBRO,
	N_MSG_ACCE_GEM_GARNET,
	N_MSG_ACCE_GEM_GRANITE,
	N_MSG_ACCE_GEM_GYPSUM,
	N_MSG_ACCE_GEM_HEMATITE,
	N_MSG_ACCE_GEM_JADE,
	N_MSG_ACCE_GEM_JASPER,
	N_MSG_ACCE_GEM_KRYPTONITE,
	N_MSG_ACCE_GEM_LAPIS_LAZULI,
	N_MSG_ACCE_GEM_LIMESTONE,
	N_MSG_ACCE_GEM_MALACHITE,
	N_MSG_ACCE_GEM_MANGANITE,
	N_MSG_ACCE_GEM_MARBLE,
	N_MSG_ACCE_GEM_MOONSTONE,
	N_MSG_ACCE_GEM_NEPTUNITE,
	N_MSG_ACCE_GEM_OBSIDIAN,
	N_MSG_ACCE_GEM_ONYX,
	N_MSG_ACCE_GEM_OPAL,
	N_MSG_ACCE_GEM_PEARL,
	N_MSG_ACCE_GEM_PYRITES,
	N_MSG_ACCE_GEM_QUARTZ,
	N_MSG_ACCE_GEM_QUARTZITE,
	N_MSG_ACCE_GEM_RHODONITE,
	N_MSG_ACCE_GEM_RHYOLITE,
	N_MSG_ACCE_GEM_RUBY,
	N_MSG_ACCE_GEM_SAPPHIRE,
	N_MSG_ACCE_GEM_SPHALERITE,
	N_MSG_ACCE_GEM_STAUROLITE,
	N_MSG_ACCE_GEM_TIGER_EYE,
	N_MSG_ACCE_GEM_TOPAZ,
	N_MSG_ACCE_GEM_TURQUOISE,
	N_MSG_ACCE_GEM_ZIRCON,
	N_MSG_NULL,
};

inst_tab_t	inst_tab[] = {
#include	"item-inst-tab.h"
};

anthology_tab_t	anthology_tab[] = {
#include	"item-anthology-tab.h"
};

light_tab_t	light_tab[] = {
#include	"item-light-tab.h"
};

food_tab_t	food_tab[] = {
#include	"item-food-tab.h"
};

/*  */

#define	TOBACCO_PRICE_CIGARET	((gold_t)2)
#define	TOBACCO_PRICE_CIGAR	((gold_t)10)
#define	TOBACCO_PRICE_CUT_TOBACCO	((gold_t)2)
#define	TOBACCO_PRICE_SNUFF_TOBACCO	((gold_t)3)
#define	TOBACCO_PRICE_CHEWING_TOBACCO	((gold_t)4)
#define	TOBACCO_PRICE_ABSTAIN_GUM	((gold_t)8)

/* ۤޤǤΥ */

#define	TOBACCO_AVE_TURN_CIGARET	(5 * TURN_PER_MINUTE)
#define	TOBACCO_AVE_TURN_CIGAR	(10 * TURN_PER_MINUTE)
#define	TOBACCO_AVE_TURN_CUT_TOBACCO	(5 * TURN_PER_MINUTE)
#define	TOBACCO_AVE_TURN_SNUFF_TOBACCO	(10 * TURN_PER_MINUTE)
#define	TOBACCO_AVE_TURN_CHEWING_TOBACCO	(15 * TURN_PER_MINUTE)
#define	TOBACCO_AVE_TURN_ABSTAIN_GUM	(15 * TURN_PER_MINUTE)

tobacco_tab_t	tobacco_tab[] = {
#include	"item-tobacco-tab.h"
};

pipe_tab_t	pipe_tab[] = {
#include	"item-pipe-tab.h"
};

rare_goods_tab_t	rare_goods_tab[] = {
#include	"item-rare-goods-tab.h"
};

coin_tab_t	coin_tab[] = {
#include	"item-coin-tab.h"
};

range_tab_t	range_tab[] = {
#include	"item-range-tab.h"
};

#endif	/* ITEM_TAB_H */
