/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: menu-tab.h,v 1.3 2004/12/23 06:12:38 bowkenken Exp $
***************************************************************/

#ifndef	MENU_TAB_H
#define	MENU_TAB_H

/* ˥塼 */

#include	"request.h"

#include	"request-prot.h"

/**/

#if	0
	"<Title>"	/* ȥ */
	"<Item>"	/*  */
	"<CheckItem>"	/* å */
	"<RadioItem>"	/*  */
	"<OpenWinItem>"	/* ̥ɥ򳫤 */
	"<Separator>"	/* <RadioItem>ζڤ */
	"<PageSeparator>"	/* ˥塼ʣڡͭζڤ */
	"<Branch>"	/* ֥˥塼 */
#endif

#if	0
typedef struct menu_t {
	/* ڹ¤Υѥ */
	char	path[MENU_PATH_MAX_LEN + 1];
	/* ܤμ */
	char	kind[MENU_KIND_MAX_LEN + 1];

	/* ľΥ */
	unsigned char	key;
	/* 硼ȡåȡ */
	char	accel_key[MENU_ACCEL_KEY_MAX_LEN + 1];

	/* ̾ */
	n_msg_t	n_msg;
	char	msg[MENU_MSG_MAX_LEN + 1];

	/* 롦Хåؿ */
	menu_call_back_t	call_back;
	/* 롦Хåؿؤΰ */
	void	*arg;

	/* ե饰 */
	unsigned long	flg;
} menu_t;
#endif

/* ˥塼ꥹ */

menu_t	ls_menu_ask[] = {
	{
		"/Ask",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_ask_init, NULL,
		FLG_NULL,
	},
	{
		"/Ask/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Ask/Yes",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_YES, "",
		cb_menu_ask_yes, NULL,
		FLG_NULL,
	},
	{
		"/Ask/No",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_NO, "",
		cb_menu_ask_no, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_main_race[] = {
	{
		"/Main Race",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Main Race/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_MAIN_RACE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Main Race/Human",
		"<Item>",
		'H',
		"",
		N_MSG_MAIN_RACE_HUMAN, "",
		cb_menu_main_race, (void *)MAIN_RACE_HUMAN,
		FLG_NULL,
	},
	{
		"/Main Race/Half elf",
		"<Item>",
		'F',
		"",
		N_MSG_MAIN_RACE_HALF_ELF, "",
		cb_menu_main_race, (void *)MAIN_RACE_HALF_ELF,
		FLG_NULL,
	},
	{
		"/Main Race/Elf",
		"<Item>",
		'E',
		"",
		N_MSG_MAIN_RACE_ELF, "",
		cb_menu_main_race, (void *)MAIN_RACE_ELF,
		FLG_NULL,
	},
	{
		"/Main Race/Dwarf",
		"<Item>",
		'D',
		"",
		N_MSG_MAIN_RACE_DWARF, "",
		cb_menu_main_race, (void *)MAIN_RACE_DWARF,
		FLG_NULL,
	},
	{
		"/Main Race/Bibit",
		"<Item>",
		'B',
		"",
		N_MSG_MAIN_RACE_VIVID, "",
		cb_menu_main_race, (void *)MAIN_RACE_VIVID,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sub_race[] = {
	{
		"/Sub Race",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Sub Race/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SUB_RACE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Sub Race/Null",
		"<Item>",
		'N',
		"",
		N_MSG_SUB_RACE_NULL, "",
		cb_menu_sub_race, (void *)SUB_RACE_NULL,
		FLG_NULL,
	},
	{
		"/Sub Race/Cat",
		"<Item>",
		'C',
		"",
		N_MSG_SUB_RACE_CAT, "",
		cb_menu_sub_race, (void *)SUB_RACE_CAT,
		FLG_NULL,
	},
	{
		"/Sub Race/Dog",
		"<Item>",
		'D',
		"",
		N_MSG_SUB_RACE_DOG, "",
		cb_menu_sub_race, (void *)SUB_RACE_DOG,
		FLG_NULL,
	},
	{
		"/Sub Race/Mouse",
		"<Item>",
		'U',
		"",
		N_MSG_SUB_RACE_MOUSE, "",
		cb_menu_sub_race, (void *)SUB_RACE_MOUSE,
		FLG_NULL,
	},
	{
		"/Sub Race/Rabbit",
		"<Item>",
		'R',
		"",
		N_MSG_SUB_RACE_RABBIT, "",
		cb_menu_sub_race, (void *)SUB_RACE_RABBIT,
		FLG_NULL,
	},
	{
		"/Sub Race/Monkey",
		"<Item>",
		'K',
		"",
		N_MSG_SUB_RACE_MONKEY, "",
		cb_menu_sub_race, (void *)SUB_RACE_MONKEY,
		FLG_NULL,
	},
	{
		"/Sub Race/Pig",
		"<Item>",
		'P',
		"",
		N_MSG_SUB_RACE_PIG, "",
		cb_menu_sub_race, (void *)SUB_RACE_PIG,
		FLG_NULL,
	},
	{
		"/Sub Race/Bird",
		"<Item>",
		'B',
		"",
		N_MSG_SUB_RACE_BIRD, "",
		cb_menu_sub_race, (void *)SUB_RACE_BIRD,
		FLG_NULL,
	},
	{
		"/Sub Race/Lizard",
		"<Item>",
		'L',
		"",
		N_MSG_SUB_RACE_LIZARD, "",
		cb_menu_sub_race, (void *)SUB_RACE_LIZARD,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sex[] = {
	{
		"/Sex",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Sex/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SEX, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Sex/male",
		"<Item>",
		'M',
		"",
		N_MSG_MALE, "",
		cb_menu_sex, (void *)MALE,
		FLG_NULL,
	},
	{
		"/Sex/Female",
		"<Item>",
		'F',
		"",
		N_MSG_FEMALE, "",
		cb_menu_sex, (void *)FEMALE,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_class
		[1 + CLASS_MAX_N + (CLASS_MAX_N / LS_CLASS_N_PER_PAGE) + 1];

menu_t	ls_menu_main[] = {
	{
		"/",
		"<Branch>",
		'\0',
		"m M ^M ^J",
		N_MSG_NULL, "",
		cb_menu_main_init, NULL,
		FLG_NULL,
	},
	{
		"/Mark",
		"<OpenWinItem>",
		'K',
		"",
		N_MSG_MENU_MARK, "",
		cb_menu_mark, NULL,
		FLG_NULL,
	},
	{
		"/Move",
		"<Item>",
		'V',
		"v",
		N_MSG_MENU_MOVE, "",
		cb_menu_move, NULL,
		FLG_NULL,
	},
	{
		"/Exec",
		"<Item>",
		'X',
		". 5",
		N_MSG_MENU_EXEC, "",
		cb_menu_exec, NULL,
		FLG_NULL,
	},
	{
		"/Item",
		"<Branch>",
		'I',
		"i",
		N_MSG_MENU_ITEM, "",
		cb_menu_item, NULL,
		FLG_NULL,
	},
	{
		"/Equip",
		"<Branch>",
		'E',
		"e",
		N_MSG_MENU_EQUIP, "",
		cb_menu_equip, NULL,
		FLG_NULL,
	},
	{
		"/Fight",
		"<OpenWinItem>",
		'F',
		"f",
		N_MSG_MENU_FIGHT, "",
		cb_menu_fight, NULL,
		FLG_NULL,
	},
	{
		"/Spell",
		"<Branch>",
		'C',
		"c",
		N_MSG_MENU_SPELL, "",
		cb_menu_sel_spell, NULL,
		FLG_NULL,
	},
/* misc begin */
	{
		"/Misc",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_MISC, "",
		cb_menu_misc, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Stairs",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_STAIRS, "",
		cb_menu_stairs, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Stairs/Up",
		"<Item>",
		'U',
		"<",
		N_MSG_MENU_STAIRS_UP, "",
		cb_menu_stairs_up, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Stairs/Down",
		"<Item>",
		'D',
		">",
		N_MSG_MENU_STAIRS_DOWN, "",
		cb_menu_stairs_down, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Search",
		"<Branch>",
		'S',
		"# ^S s",
		N_MSG_MENU_SRCH, "",
		cb_menu_srch, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Hint",
		"<Item>",
		'I',
		"?",
		N_MSG_MENU_MAP_HINT, "",
		cb_menu_show_map_hint, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Char Data",
		"<OpenWinItem>",
		'D',
		"d",
		N_MSG_MENU_CHR_DATA, "",
		cb_menu_chr_data, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Gold",
		"<Branch>",
		'G',
		"",
		N_MSG_MENU_GOLD, "",
		cb_menu_gold, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Gold/Collect",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLLECT_GOLD, "",
		cb_menu_collect_gold, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Gold/Divide",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_DIVIDE_GOLD, "",
		cb_menu_divide_gold, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Formation",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_FORMATION, "",
		cb_menu_formation, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Cursor",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_CRSR, "",
		cb_menu_crsr, NULL,
		FLG_NULL,
	},
	{
		"/Misc/List Message",
		"<OpenWinItem>",
		'M',
		"g",
		N_MSG_MENU_LS_MSG, "",
		cb_menu_ls_msg, NULL,
		FLG_NULL,
	},
	{
		"/Misc/List Monster",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_LS_MNSTR, "",
		cb_menu_ls_mnstr, NULL,
		FLG_NULL,
	},
	{
		"/Misc/List Request",
		"<Branch>",
		'R',
		"r",
		N_MSG_MENU_LS_REQUEST, "",
		cb_menu_request_mbr, NULL,
		FLG_NULL,
	},
/* config begin */
	{
		"/Misc/Config",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_CNF, "",
		cb_menu_cnf, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Auto fight",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_AUTO_FIGHT, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_FIGHT,
		FLG_NULL,
	},
	{
		"/Misc/Config/Auto open door",
		"<Branch>",
		'D',
		"",
		N_MSG_MENU_AUTO_DOOR, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_DOOR,
		FLG_NULL,
	},
	{
		"/Misc/Config/Avoid trap",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_AVOID_TRAP, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AVOID_TRAP,
		FLG_NULL,
	},
	{
		"/Misc/Config/Reload arrow",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_AUTO_RELOAD, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_RELOAD,
		FLG_NULL,
	},
	{
		"/Misc/Config/Scroll",
		"<Branch>",
		'R',
		"",
		N_MSG_MENU_SCROLL_MODE, "",
		cb_menu_scroll_init, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Scroll/Page",
		"<RadioItem>",
		'P',
		"",
		N_MSG_MENU_SCROLL_PAGE, "",
		cb_menu_scroll_page, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Scroll/Smooth",
		"<RadioItem>",
		'S',
		"",
		N_MSG_MENU_SCROLL_SMOOTH, "",
		cb_menu_scroll_smooth, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Scroll/Center",
		"<RadioItem>",
		'C',
		"",
		N_MSG_MENU_SCROLL_CENTER, "",
		cb_menu_scroll_center, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Actual Fighting",
		"<CheckItem>",
		'I',
		"",
		N_MSG_MENU_ACTUAL_FIGHTING, "",
		cb_menu_actual_fighting, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Space Select",
		"<CheckItem>",
		'S',
		"",
		N_MSG_MENU_SPACE_SELECT, "",
		cb_menu_space_select, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Window",
		"<Branch>",
		'W',
		"",
		N_MSG_MENU_WINDOW, "",
		cb_menu_window, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Window/Redraw Every Turn",
		"<CheckItem>",
		'D',
		"",
		N_MSG_MENU_REDRAW_EVERY_TURN, "",
		cb_menu_redraw_every_turn, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Window/Multi Message",
		"<CheckItem>",
		'M',
		"",
		N_MSG_MENU_MUL_MSG_LINE, "",
		cb_menu_mul_msg_line, NULL,
		FLG_NULL,
	},
/* VFX begin */
	{
		"/Misc/Config/VFX",
		"<Branch>",
		'X',
		"",
		N_MSG_MENU_VFX, "",
		cb_menu_vfx, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Member cure",
		"<CheckItem>",
		'A',
		"",
		N_MSG_MENU_VFX_MBR_CURE, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_CURE,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Member dam",
		"<CheckItem>",
		'B',
		"",
		N_MSG_MENU_VFX_MBR_DAM, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_DAM,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Member critical",
		"<CheckItem>",
		'C',
		"",
		N_MSG_MENU_VFX_MBR_CRTCL, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_CRTCL,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Member arrow",
		"<CheckItem>",
		'D',
		"",
		N_MSG_MENU_VFX_MBR_ARW, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_ARW,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Monster cure",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_VFX_MNSTR_CURE, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_CURE,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Monster dam",
		"<CheckItem>",
		'F',
		"",
		N_MSG_MENU_VFX_MNSTR_DAM, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_DAM,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Monster critical",
		"<CheckItem>",
		'G',
		"",
		N_MSG_MENU_VFX_MNSTR_CRTCL, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_CRTCL,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Monster arrow",
		"<CheckItem>",
		'H',
		"",
		N_MSG_MENU_VFX_MNSTR_ARW, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_ARW,
		FLG_NULL,
	},
	{
		"/Misc/Config/VFX/Wait",
		"<Item>",
		'Z',
		"",
		N_MSG_MENU_VFX_WAIT, "",
		cb_menu_vfx_wait, NULL,
		FLG_NULL,
	},
/* VFX end */
	{
		"/Misc/Config/Color",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_COLOR, "",
		cb_menu_color, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Cursor Pattern",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_CRSR_PTN, "",
		cb_menu_crsr_ptn, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Key Bind",
		"<Branch>",
		'K',
		"",
		N_MSG_MENU_KEY_BIND, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Key Bind/Set Key",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_SET_KEY, "",
		cb_menu_set_key, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Key Bind/Unset Key",
		"<OpenWinItem>",
		'U',
		"",
		N_MSG_MENU_UNSET_KEY, "",
		cb_menu_unset_key, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/Macro",
		"<Branch>",
		'N',
		"",
		N_MSG_MENU_MACRO, "",
		cb_menu_macro, NULL,
		FLG_NULL,
	},
	{
		"/Misc/Config/User Menu Select",
		"<Branch>",
		'M',
		"x",
		N_MSG_MENU_USER, "",
		cb_menu_user, NULL,
		FLG_NULL,
	},
/* config end */
/* system begin */
	{
		"/Misc/System",
		"<Branch>",
		'Y',
		"",
		N_MSG_MENU_SYS, "",
		NULL, NULL,
		FLG_NULL,
	},
/* wizard begin */
	{
		"/Misc/System/Wizard",
		"<Branch>",
		'W',
		"^W",
		N_MSG_MENU_WIZARD, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_WIZARD, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/On Light",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_WIZARD_ON_LIGHT, "",
		cb_menu_wizard_on_light, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/Off Light",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_WIZARD_OFF_LIGHT, "",
		cb_menu_wizard_off_light, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/Add Turn",
		"<OpenWinItem>",
		'T',
		"",
		N_MSG_MENU_WIZARD_ADD_TURN, "",
		cb_menu_wizard_add_turn, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/Level Up",
		"<OpenWinItem>",
		'V',
		"",
		N_MSG_MENU_WIZARD_LEV_UP, "",
		cb_menu_wizard_lev_up, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/Text Load",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_WIZARD_TEXT_LOAD, "",
		cb_menu_load, (void *)TRUE,
		FLG_NULL,
	},
	{
		"/Misc/System/Wizard/Text Save",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_WIZARD_TEXT_SAVE, "",
		cb_menu_save, (void *)TRUE,
		FLG_NULL,
	},
/* wizard end */
	{
		"/Misc/System/Output map file",
		"<OpenWinItem>",
		'O',
		"",
		N_MSG_MENU_OUT_MAP_FILE, "",
		cb_menu_out_map_file, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Shell",
		"<OpenWinItem>",
		'H',
		"!",
		N_MSG_MENU_SHELL, "",
		cb_menu_shell, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/About",
		"<OpenWinItem>",
		'A',
		"",
		N_MSG_MENU_ABOUT_GAME, "",
		cb_menu_about_game, NULL,
		FLG_NULL,
	},
	{
		"/Misc/System/Exit",
		"<Branch>",
		'Q',
		"^C ^Q Q",
		N_MSG_MENU_EXIT, "",
		cb_menu_exit, NULL,
		FLG_NULL,
	},
/* system end */
/* misc end */
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sel_obj[] = {
	{
		"/Sel Obj",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_sel_obj_init, NULL,
		FLG_NULL,
	},
	{
		"/Sel Obj/Member",
		"<OpenWinItem>",
		'P',
		"",
		N_MSG_MENU_SEL_OBJ_MBR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_MBR,
		FLG_NULL,
	},
	{
		"/Sel Obj/Monster",
		"<OpenWinItem>",
		'X',
		"",
		N_MSG_MENU_SEL_OBJ_MNSTR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_MNSTR,
		FLG_NULL,
	},
	{
		"/Sel Obj/Item",
		"<OpenWinItem>",
		'I',
		"",
		N_MSG_MENU_SEL_OBJ_ITEM, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_ITEM,
		FLG_NULL,
	},
	{
		"/Sel Obj/Door",
		"<OpenWinItem>",
		'D',
		"",
		N_MSG_MENU_SEL_OBJ_DOOR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_DOOR,
		FLG_NULL,
	},
	{
		"/Sel Obj/Trap",
		"<OpenWinItem>",
		'T',
		"",
		N_MSG_MENU_SEL_OBJ_TRAP, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_TRAP,
		FLG_NULL,
	},
	{
		"/Sel Obj/Square",
		"<OpenWinItem>",
		'V',
		"",
		N_MSG_MENU_SEL_OBJ_SQUARE, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_SQUARE,
		FLG_NULL,
	},
	{
		"/Sel Obj/Position",
		"<OpenWinItem>",
		'N',
		"",
		N_MSG_MENU_SEL_OBJ_POS, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_POS,
		FLG_NULL,
	},
	{
		"/Sel Obj/Auto",
		"<Branch>",
		'A',
		"a",
		N_MSG_MENU_SEL_OBJ_AUTO, "",
		cb_menu_sel_obj_auto, (void *)TRGT_KIND_AUTO,
		FLG_NULL,
	},
	{
		"/Sel Obj/Clear",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_SEL_OBJ_CLEAR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mbr[1 + MBR_MAX_N + PET_MAX_N + 1];

menu_t	ls_menu_dist[] = {
	{
		"/Dist",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_dist_init, NULL,
		FLG_NULL,
	},
/* Near */
	{
		"/Dist/Near",
		"<Branch>",
		'N',
		"",
		N_MSG_MENU_DIST_NEAR, "",
		cb_menu_dist, (void *)"Near",
		FLG_NULL,
	},
	{
		"/Dist/Near/Fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"Fight",
		FLG_NULL,
	},
	{
		"/Dist/Near/Throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"Throw",
		FLG_NULL,
	},
	{
		"/Dist/Near/Steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"Steal",
		FLG_NULL,
	},
	{
		"/Dist/Near/Tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"Tail",
		FLG_NULL,
	},
/* Medium */
	{
		"/Dist/Medium",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_DIST_MEDIUM, "",
		cb_menu_dist, (void *)"Medium",
		FLG_NULL,
	},
	{
		"/Dist/Medium/Fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"Fight",
		FLG_NULL,
	},
	{
		"/Dist/Medium/Throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"Throw",
		FLG_NULL,
	},
	{
		"/Dist/Medium/Steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"Steal",
		FLG_NULL,
	},
	{
		"/Dist/Medium/Tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"Tail",
		FLG_NULL,
	},
/* Far */
	{
		"/Dist/Far",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_DIST_FAR, "",
		cb_menu_dist, (void *)"Far",
		FLG_NULL,
	},
	{
		"/Dist/Far/Fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"Fight",
		FLG_NULL,
	},
	{
		"/Dist/Far/Throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"Throw",
		FLG_NULL,
	},
	{
		"/Dist/Far/Steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"Steal",
		FLG_NULL,
	},
	{
		"/Dist/Far/Tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"Tail",
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_item[] = {
	{
		"/Mark Item",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Mark Item/Pick Up",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_MARK_ITEM_PICK_UP, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_PICK_UP,
		FLG_NULL,
	},
	{
		"/Mark Item/Open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_MARK_ITEM_OPEN, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_OPEN,
		FLG_NULL,
	},
	{
		"/Mark Item/Disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_ITEM_DISARM, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_DISARM,
		FLG_NULL,
	},
	{
		"/Mark Item/Break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_ITEM_BREAK, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_BREAK,
		FLG_NULL,
	},
	{
		"/Mark Item/Search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_ITEM_CHK, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_door[] = {
	{
		"/Mark Door",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Mark Door/Open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_MARK_DOOR_OPEN, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_OPEN,
		FLG_NULL,
	},
	{
		"/Mark Door/Close",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_MARK_DOOR_CLOSE, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_CLOSE,
		FLG_NULL,
	},
	{
		"/Mark Door/Jamming",
		"<Item>",
		'J',
		"",
		N_MSG_MENU_MARK_DOOR_JAM, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_JAM,
		FLG_NULL,
	},
	{
		"/Mark Door/Disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_DOOR_DISARM, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_DISARM,
		FLG_NULL,
	},
	{
		"/Mark Door/Break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_DOOR_BREAK, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_BREAK,
		FLG_NULL,
	},
	{
		"/Mark Door/Peep",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_MARK_DOOR_PEEP, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_PEEP,
		FLG_NULL,
	},
	{
		"/Mark Door/Search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_DOOR_CHK, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_trap[] = {
	{
		"/Mark Trap",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Mark Trap/Disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_TRAP_DISARM, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_DISARM,
		FLG_NULL,
	},
	{
		"/Mark Trap/Break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_TRAP_BREAK, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_BREAK,
		FLG_NULL,
	},
	{
		"/Mark Trap/Search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_TRAP_CHK, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_item[MBR_ITEM_MAX_N * 2 * MBR_MAX_N];

menu_t	ls_menu_item_self[] = {
	{
		"/Self",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_item_self_init, NULL,
		FLG_NULL,
	},
	{
		"/Self/Quaff",
		"<Item>",
		'Q',
		"",
		N_MSG_MENU_ITEM_QUAFF, "",
		cb_menu_item_use, (void *)ACT_KIND_POTION_QUAFF,
		FLG_NULL,
	},
	{
		"/Self/Read",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_ITEM_READ, "",
		cb_menu_item_use, (void *)ACT_KIND_SCROLL_READ,
		FLG_NULL,
	},
	{
		"/Self/Zap",
		"<Item>",
		'Z',
		"",
		N_MSG_MENU_ITEM_ZAP, "",
		cb_menu_item_zap, (void *)ACT_KIND_STICK_ZAP,
		FLG_NULL,
	},
	{
		"/Self/Eat",
		"<Item>",
		'A',
		"",
		N_MSG_MENU_ITEM_EAT, "",
		cb_menu_item_use, (void *)ACT_KIND_FOOD_EAT,
		FLG_NULL,
	},
	{
		"/Self/Smoke",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_ITEM_SMOKE, "",
		cb_menu_item_smoke, (void *)ACT_KIND_EQUIP,
		FLG_NULL,
	},
	{
		"/Self/Dispose",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_ITEM_DISPOSE, "",
		cb_menu_item_use, (void *)ACT_KIND_TOBACCO_DISPOSE,
		FLG_NULL,
	},
	{
		"/Self/Fill Lamp",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_ITEM_FILL_LAMP, "",
		cb_menu_item_fill_lamp, (void *)ACT_KIND_POTION_FILL,
		FLG_NULL,
	},
	{
		"/Self/Equip",
		"<Item>",
		'E',
		"",
		N_MSG_MENU_ITEM_EQUIP, "",
		cb_menu_item_use, (void *)ACT_KIND_EQUIP_SEL,
		FLG_NULL,
	},
	{
		"/Self/Ready Throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_ITEM_READY_THROW, "",
		cb_menu_item_ready_throw, (void *)ACT_KIND_EQUIP,
		FLG_NULL,
	},
	{
		"/Self/Send",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_ITEM_SEND, "",
		cb_menu_item_send, (void *)ACT_KIND_ITEM_SEND,
		FLG_NULL,
	},
	{
		"/Self/Drop",
		"<OpenWinItem>",
		'D',
		"",
		N_MSG_MENU_ITEM_DROP, "",
		cb_menu_item_drop, (void *)ACT_KIND_ITEM_DROP,
		FLG_NULL,
	},
	{
		"/Self/Check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, (void *)ACT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_item_other[] = {
	{
		"/Other",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_item_other, NULL,
		FLG_NULL,
	},
	{
		"/Other/Recieve",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_ITEM_RECEIVE, "",
		cb_menu_item_receive, NULL,
		FLG_NULL,
	},
	{
		"/Other/Check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, (void *)ACT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip[EQUIP_KIND_MAX_N * 2 * MBR_MAX_N];

menu_t	ls_menu_equip_self[] = {
	{
		"/Self",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_equip_self, NULL,
		FLG_NULL,
	},
	{
		"/Self/Wear",
		"<Branch>",
		'W',
		"",
		N_MSG_MENU_EQUIP_WEAR, "",
		cb_menu_equip_wear_sel, NULL,
		FLG_NULL,
	},
	{
		"/Self/Take Off",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_EQUIP_TAKE_OFF, "",
		cb_menu_equip_take_off, NULL,
		FLG_NULL,
	},
	{
		"/Self/Check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip_other[] = {
	{
		"/Other",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_equip_other, NULL,
		FLG_NULL,
	},
	{
		"/Other/Wear",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_EQUIP_WEAR_MBR, "",
		cb_menu_equip_wear_sel, NULL,
		FLG_NULL,
	},
	{
		"/Other/Take Off",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_EQUIP_TAKE_OFF_MBR, "",
		cb_menu_equip_take_off, NULL,
		FLG_NULL,
	},
	{
		"/Other/Check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip_wear_sel[MBR_ITEM_MAX_N * 2];
menu_t	ls_menu_identify_item[MBR_ITEM_MAX_N * 2 * MBR_MAX_N];
menu_t	ls_menu_resurrection[MBR_ITEM_MAX_N * 2];
menu_t	ls_menu_srch[1 + 4 + MBR_MAX_N + 1];
menu_t	ls_menu_formation[1 + 1 + MBR_MAX_N + 1];

menu_t	ls_menu_move_crsr[] = {
	{
		"/Cursor",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* cursor move begin */
	{
		"/Cursor/Move",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_CRSR_MOVE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Down left",
		"<Item>",
		'B',
		"1 b",
		N_MSG_MENU_CRSR_MOVE_DOWN_LEFT, "",
		cb_menu_crsr_move, (void *)1,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Down",
		"<Item>",
		'J',
		"^N 2 j",
		N_MSG_MENU_CRSR_MOVE_DOWN, "",
		cb_menu_crsr_move, (void *)2,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Down right",
		"<Item>",
		'N',
		"3 n",
		N_MSG_MENU_CRSR_MOVE_DOWN_RIGHT, "",
		cb_menu_crsr_move, (void *)3,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Left",
		"<Item>",
		'H',
		"^B 4 h",
		N_MSG_MENU_CRSR_MOVE_LEFT, "",
		cb_menu_crsr_move, (void *)4,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Right",
		"<Item>",
		'L',
		"^F 6 l",
		N_MSG_MENU_CRSR_MOVE_RIGHT, "",
		cb_menu_crsr_move, (void *)6,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Up left",
		"<Item>",
		'Y',
		"7 y",
		N_MSG_MENU_CRSR_MOVE_UP_LEFT, "",
		cb_menu_crsr_move, (void *)7,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Up",
		"<Item>",
		'K',
		"^P 8 k",
		N_MSG_MENU_CRSR_MOVE_UP, "",
		cb_menu_crsr_move, (void *)8,
		FLG_NULL,
	},
	{
		"/Cursor/Move/Up right",
		"<Item>",
		'U',
		"9 u",
		N_MSG_MENU_CRSR_MOVE_UP_RIGHT, "",
		cb_menu_crsr_move, (void *)9,
		FLG_NULL,
	},
/* cursor move end */
/* cursor quick move begin */
	{
		"/Cursor/Quick move",
		"<Branch>",
		'Q',
		"",
		N_MSG_MENU_CRSR_QUICK_MOVE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Down left",
		"<Item>",
		'B',
		"B",
		N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_LEFT, "",
		cb_menu_crsr_quick_move, (void *)1,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Down",
		"<Item>",
		'J',
		"J",
		N_MSG_MENU_CRSR_QUICK_MOVE_DOWN, "",
		cb_menu_crsr_quick_move, (void *)2,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Down right",
		"<Item>",
		'N',
		"N",
		N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_RIGHT, "",
		cb_menu_crsr_quick_move, (void *)3,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Left",
		"<Item>",
		'H',
		"H",
		N_MSG_MENU_CRSR_QUICK_MOVE_LEFT, "",
		cb_menu_crsr_quick_move, (void *)4,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Right",
		"<Item>",
		'L',
		"L",
		N_MSG_MENU_CRSR_QUICK_MOVE_RIGHT, "",
		cb_menu_crsr_quick_move, (void *)6,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Up left",
		"<Item>",
		'Y',
		"Y",
		N_MSG_MENU_CRSR_QUICK_MOVE_UP_LEFT, "",
		cb_menu_crsr_quick_move, (void *)7,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Up",
		"<Item>",
		'K',
		"K",
		N_MSG_MENU_CRSR_QUICK_MOVE_UP, "",
		cb_menu_crsr_quick_move, (void *)8,
		FLG_NULL,
	},
	{
		"/Cursor/Quick move/Up right",
		"<Item>",
		'U',
		"U",
		N_MSG_MENU_CRSR_QUICK_MOVE_UP_RIGHT, "",
		cb_menu_crsr_quick_move, (void *)9,
		FLG_NULL,
	},
/* cursor quick move end */
	{
		"/Cursor/Move member",
		"<Branch>",
		'B',
		"@",
		N_MSG_MENU_CRSR_MOVE_MBR, "",
		cb_menu_crsr_move_mbr, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Scroll center",
		"<Item>",
		'C',
		"^R ^L",
		N_MSG_MENU_CRSR_SCROLL_CENTER, "",
		cb_menu_crsr_scroll_center, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position member",
		"<Item>",
		'P',
		"P",
		N_MSG_MENU_CRSR_NEXT_POS_MBR, "",
		cb_menu_crsr_next_pos_mbr, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position monster",
		"<Item>",
		'X',
		"^I X",
		N_MSG_MENU_CRSR_NEXT_POS_MNSTR, "",
		cb_menu_crsr_next_pos_mnstr, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position item",
		"<Item>",
		'I',
		"I",
		N_MSG_MENU_CRSR_NEXT_POS_ITEM, "",
		cb_menu_crsr_next_pos_item, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position door",
		"<Item>",
		'D',
		"D",
		N_MSG_MENU_CRSR_NEXT_POS_DOOR, "",
		cb_menu_crsr_next_pos_door, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position object",
		"<Item>",
		'O',
		"O",
		N_MSG_MENU_CRSR_NEXT_POS_OBJ, "",
		cb_menu_crsr_next_pos_obj, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position square",
		"<Item>",
		'V',
		"V",
		N_MSG_MENU_CRSR_NEXT_POS_SQUARE, "",
		cb_menu_crsr_next_pos_square, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Next position all",
		"<Item>",
		'A',
		"A",
		N_MSG_MENU_CRSR_NEXT_POS_ALL, "",
		cb_menu_crsr_next_pos_all, NULL,
		FLG_NULL,
	},
	{
		"/Cursor/Prev position",
		"<Item>",
		'R',
		"R",
		N_MSG_MENU_CRSR_PREV_POS, "",
		cb_menu_crsr_prev_pos, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mbr_flg[MBR_ITEM_MAX_N + 4];

menu_t	ls_menu_color[2 + 1 + CURS_ATTR_MAX_N + 1];
menu_t	ls_menu_color_sel[] = {
	{
		"/Color",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* FG */
	{
		"/Color/Fg",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_FG, "",
		cb_menu_fg_init, NULL,
		FLG_NULL,
	},
	{
		"/Color/Fg/Black",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_COLOR_BLACK, "",
		cb_menu_fg, (void *)COLOR_BLACK,
		FLG_NULL,
	},
	{
		"/Color/Fg/Red",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_COLOR_RED, "",
		cb_menu_fg, (void *)COLOR_RED,
		FLG_NULL,
	},
	{
		"/Color/Fg/Green",
		"<Item>",
		'G',
		"",
		N_MSG_MENU_COLOR_GREEN, "",
		cb_menu_fg, (void *)COLOR_GREEN,
		FLG_NULL,
	},
	{
		"/Color/Fg/Yellow",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_COLOR_YELLOW, "",
		cb_menu_fg, (void *)COLOR_YELLOW,
		FLG_NULL,
	},
	{
		"/Color/Fg/Blue",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_COLOR_BLUE, "",
		cb_menu_fg, (void *)COLOR_BLUE,
		FLG_NULL,
	},
	{
		"/Color/Fg/Magenta",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_COLOR_MAGENTA, "",
		cb_menu_fg, (void *)COLOR_MAGENTA,
		FLG_NULL,
	},
	{
		"/Color/Fg/Cyan",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLOR_CYAN, "",
		cb_menu_fg, (void *)COLOR_CYAN,
		FLG_NULL,
	},
	{
		"/Color/Fg/White",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_COLOR_WHITE, "",
		cb_menu_fg, (void *)COLOR_WHITE,
		FLG_NULL,
	},
/* BG */
	{
		"/Color/Bg",
		"<Branch>",
		'B',
		"",
		N_MSG_MENU_BG, "",
		cb_menu_bg_init, NULL,
		FLG_NULL,
	},
	{
		"/Color/Bg/Black",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_COLOR_BLACK, "",
		cb_menu_bg, (void *)COLOR_BLACK,
		FLG_NULL,
	},
	{
		"/Color/Bg/Red",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_COLOR_RED, "",
		cb_menu_bg, (void *)COLOR_RED,
		FLG_NULL,
	},
	{
		"/Color/Bg/Green",
		"<Item>",
		'G',
		"",
		N_MSG_MENU_COLOR_GREEN, "",
		cb_menu_bg, (void *)COLOR_GREEN,
		FLG_NULL,
	},
	{
		"/Color/Bg/Yellow",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_COLOR_YELLOW, "",
		cb_menu_bg, (void *)COLOR_YELLOW,
		FLG_NULL,
	},
	{
		"/Color/Bg/Blue",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_COLOR_BLUE, "",
		cb_menu_bg, (void *)COLOR_BLUE,
		FLG_NULL,
	},
	{
		"/Color/Bg/Magenta",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_COLOR_MAGENTA, "",
		cb_menu_bg, (void *)COLOR_MAGENTA,
		FLG_NULL,
	},
	{
		"/Color/Bg/Cyan",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLOR_CYAN, "",
		cb_menu_bg, (void *)COLOR_CYAN,
		FLG_NULL,
	},
	{
		"/Color/Bg/White",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_COLOR_WHITE, "",
		cb_menu_bg, (void *)COLOR_WHITE,
		FLG_NULL,
	},
/* Attr */
	{
		"/Color/Attribute",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_ATTR, "",
		cb_menu_attr_init, NULL,
		FLG_NULL,
	},
	{
		"/Color/Attribute/Underline",
		"<CheckItem>",
		'U',
		"",
		N_MSG_MENU_UNDERLINE, "",
		cb_menu_attr, (void *)A_UNDERLINE,
		FLG_NULL,
	},
	{
		"/Color/Attribute/Reverse",
		"<CheckItem>",
		'R',
		"",
		N_MSG_MENU_REVERSE, "",
		cb_menu_attr, (void *)A_REVERSE,
		FLG_NULL,
	},
	{
		"/Color/Attribute/Blink",
		"<CheckItem>",
		'L',
		"",
		N_MSG_MENU_BLINK, "",
		cb_menu_attr, (void *)A_BLINK,
		FLG_NULL,
	},
	{
		"/Color/Attribute/Bold",
		"<CheckItem>",
		'B',
		"",
		N_MSG_MENU_BOLD, "",
		cb_menu_attr, (void *)A_BOLD,
		FLG_NULL,
	},
/* End */
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_crsr_ptn[1 + 1 + CRSR_PTN_MAX_N + 1];
menu_t	ls_menu_save_load[MENU_SAVE_LOAD_MAX_N * 2];
menu_t	ls_menu_macro[1 + 1 + (4 * FUNC_KEY_MAX_N) + 1];

menu_t	ls_menu_user[
	1 + 1
	+ USER_MENU_MAX_N
	+ (USER_MENU_MAX_N / MENU_MAX_N_PER_PAGE)
	+ 3 + 1];
menu_t	ls_menu_user_edit[
	1 + 1
	+ USER_MENU_MAX_N
	+ (USER_MENU_MAX_N / MENU_MAX_N_PER_PAGE)
	+ 3 + 1];

#endif	/* MENU_TAB_H */
