/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: menu.h,v 1.26 2004/12/06 07:00:15 bowkenken Exp $
***************************************************************/

#ifndef	MENU_H
#define	MENU_H

/* ˥塼 */

#include	"party.h"
#include	"item.h"
#include	"msg.h"

/*  */

#define	STR_MENU_ERR	"# Error"
#define	STR_MENU_CANCEL	"# Cancel"

/* ˥塼ѤΥ */

#define	CASE_ENTER	\
		'M' - '@': case 'J' - '@'
#define	CASE_CANCEL	\
		'G' - '@': case 'H' - '@': case '0': case '\033'
#define	CASE_EXEC	\
		'5': case '.'

#define	CASE_CRSR_UP	\
		'8': case 'k': case 'P' - '@'
#define	CASE_CRSR_DOWN	\
		'2': case 'j': case 'N' - '@'
#define	CASE_CRSR_LEFT	\
		'4': case 'h': case 'B' - '@'
#define	CASE_CRSR_RIGHT	\
		'6': case 'l': case 'F' - '@'
#define	CASE_CRSR_UP_LEFT	\
		'7': case 'y'
#define	CASE_CRSR_UP_RIGHT	\
		'9': case 'u'
#define	CASE_CRSR_DOWN_LEFT	\
		'1': case 'b'
#define	CASE_CRSR_DOWN_RIGHT	\
		'3': case 'n'

/* ܤκʸ */
#define	MENU_MAX_LEN	(SCREEN_WIDTH - 4)

/* ڡκܿ */
#define	MENU_MAX_N_PER_PAGE	18

/* ڡ */
#define	MENU_MAX_PAGE	32

/* ܿ */
#define	MENU_MAX_N	(MENU_MAX_N_PER_PAGE * MENU_MAX_PAGE)

/* ̵ */
#define	FLG_MENU_DIS	(1 << 0)

/* ɽ */
#define	FLG_MENU_HIDDEN	(1 << 1)

/* å */
#define	FLG_MENU_CHK_ON	(1 << 4)

/* å */
#define	FLG_MENU_CHK_OFF	(1 << 5)

#define	FLG_MENU_ALL	\
	(FLG_MENU_DIS | FLG_MENU_HIDDEN \
	| FLG_MENU_CHK_ON | FLG_MENU_CHK_OFF)

/* ˥塼ѥκʸ */
#define	MENU_PATH_MAX_LEN	64

/* ܤμκʸ */
#define	MENU_KIND_MAX_LEN	16

/* 졼κʸ */
#define	MENU_ACCEL_KEY_MAX_LEN	16

/* ܤκʸ */
#define	MENU_MSG_MAX_LEN	128

/* ֡ */

#define	MENU_SAVE_LOAD_MAX_N	20
#define	MENU_SAVE_LOAD_N_PER_PAGE	10

#define	MBR_DATA_PAGE_MAX_N	2

/* 桼˥塼κܿ */
#define	USER_MENU_MAX_N	(MENU_MAX_N_PER_PAGE * 4)

/* ˥塼Υ롦Хåؿ */

struct menu_t;
typedef char	*(*menu_call_back_t)(
	struct menu_t **pp, struct menu_t **dflt );

/* ޥåפΥ */

typedef unsigned long	flg_scroll_t;
#define	FLG_SCROLL_SMOOTH	(1 << 0)
#define	FLG_SCROLL_CENTER	(1 << 1)

/* ˥塼 */

typedef struct menu_t {
	/* ڹ¤Υѥ */
	char	path[MENU_PATH_MAX_LEN + 1];
	/* ܤμ */
	char	kind[MENU_KIND_MAX_LEN + 1];

	/* ľΥ */
	unsigned char	key;
	/* 硼ȡåȡ */
	char	accel_key[MENU_ACCEL_KEY_MAX_LEN + 1];

	/* ̾ */
	n_msg_t	n_msg;
	char	msg[MENU_MSG_MAX_LEN + 1];

	/* 롦Хåؿ */
	menu_call_back_t	call_back;
	/* 롦Хåؿؤΰ */
	void	*arg;

	/* ե饰 */
	unsigned long	flg;
} menu_t;

typedef struct {
	/* ȥ */
	char	*ttl;

	/* Υ˥塼Υꥹ */
	menu_t	*ls[MENU_MAX_N_PER_PAGE + 1];

	/* 򤵤Ƥܤֹ */
	long	sel_n, prev_sel_n;

	/* ڡ */
	long	page_sel_n, page_max_n;

	/* ƬǽڡǤЯΥե饰 */
	bool_t	flg_min_page, flg_max_page;

	/* ե饰 */
	bool_t	flg_redraw;
} draw_menu_t;

/* Ϥ */

typedef enum {
	ASK_NO,
	ASK_YES,
	ASK_CANCEL,
	ASK_ERR,
} ask_t;

/* μ */

typedef enum {
	DEAL_KIND_BUY,	/* 㤦 */
	DEAL_KIND_SALE_ITEM,	/* ƥ */
	DEAL_KIND_SALE_EQUIP,	/*  */
} deal_kind_t;

/*  */

typedef enum {
	MENU_NUM_MIN,
	MENU_NUM_MAX,
	MENU_NUM_CLR,
	MENU_NUM_OK,
	MENU_NUM_MAX_N
} menu_num_t;

/* ֥ */

typedef enum {
	NEXT_POS_KIND_SQUARE,
	NEXT_POS_KIND_MBR,
	NEXT_POS_KIND_MNSTR,
	NEXT_POS_KIND_DOOR,
	NEXT_POS_KIND_OBJ,
} next_pos_kind_t;

typedef struct {
	next_pos_kind_t	kind;
	void	*p;
	long	n;
	int	x, y;
} next_pos_t;

/* СǡԽ⡼ */

typedef enum {
	MBR_DATA_EDIT_KIND_SHOW,	/* ɽΤ */
	MBR_DATA_EDIT_KIND_EDIT,	/* Խ */
	MBR_DATA_EDIT_KIND_NEW,	/*  */
	MBR_DATA_EDIT_KIND_MAX_N,
} mbr_data_edit_kind_t;

#endif	/* MENU_H */
