/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: misc.c,v 1.28 2004/12/14 08:52:04 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"amenu.h"*/
/*#include	"request.h"*/
/*#include	"gfile.h"*/
#include	"msg.h"
/*#include	"ver.h"*/
#include	"gmain-prot.h"
#include	"misc-prot.h"
/*#include	"turn-prot.h"*/
/*#include	"dun-prot.h"*/
/*#include	"town-prot.h"*/
/*#include	"item-prot.h"*/
/*#include	"spell-prot.h"*/
/*#include	"chr-prot.h"*/
/*#include	"party-prot.h"*/
/*#include	"mnstr-prot.h"*/
/*#include	"pet-prot.h"*/
/*#include	"fight-prot.h"*/
/*#include	"fx-prot.h"*/
/*#include	"trap-prot.h"*/
#include	"draw-prot.h"
/*#include	"curs-prot.h"*/
/*#include	"menu-prot.h"*/
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
/*#include	"request-prot.h"*/
/*#include	"gfile-prot.h"*/
#include	"msg-prot.h"

/**/

static long	rand_seed = 1;

/**/

long	sgn_l( long n )
{
	if( n > 0 )
		return +1;
	else if( n < 0 )
		return -1;
	else
		return +-0;
}

/**/

long	min_l( long n1, long n2 )
{
	if( n1 < n2 )
		return n1;
	else
		return n2;
}

/**/

long	max_l( long n1, long n2 )
{
	if( n1 > n2 )
		return n1;
	else
		return n2;
}

/**/

void	srandm( long n )
{
	rand_seed = n;
}

/**/

long	randm( long n )
{
	long	i, max_i;

	max_i = randm_sub( 3 );
	for( i = 0; i < max_i; i++ )
		randm_sub( n );

	return( randm_sub( n ) );
}

/**/

long	randm_sub( long n )
{
	long	a;

	rand_seed += 15349;
	rand_seed *= 3793;
	rand_seed += 598393;
	a = (rand_seed & 0xffff0000) >> 16;
	rand_seed = ((rand_seed & 0x0000ffff) << 16) + a;
	rand_seed += 379;
	rand_seed = labs( rand_seed );

	if( n > 0 )
		return( rand_seed % n );
	else
		return 0;
}

/**/

bool_t	rate_randm( rate_t rate )
{
	return( randm( _100_PERCENT ) < rate );
}

/**/

bool_t	per_randm( long per )
{
	return( randm( per ) == 0 );
}

/**/

bool_t	chk_ver_old( const ver_t *ver, long mjr, long mnr, long pat )
{
	if( ver == NULL )
		return FALSE;

	if( ver->mjr > mjr )
		return FALSE;
	if( ver->mjr < mjr )
		return TRUE;

	if( ver->mnr > mnr )
		return FALSE;
	if( ver->mnr < mnr )
		return TRUE;

	if( ver->pat > pat )
		return FALSE;
	if( ver->pat < pat )
		return TRUE;

	return TRUE;
}

/**/

bool_t	chk_ver_match( const ver_t *ver, long mjr, long mnr, long pat )
{
	if( ver == NULL )
		return FALSE;

	if( ver->mjr != mjr )
		return FALSE;
	if( ver->mnr != mnr )
		return FALSE;
	if( ver->pat != pat )
		return FALSE;

	return TRUE;
}

/**/

rate_t	modified_rate( rate_t rate, long n )
{
	if( n >= +1 )
		rate += 20 * labs( n );
	if( n <= -1 )
		rate -= 10 * labs( n );

	if( rate < MODIFIED_MIN_RATE )
		rate = MODIFIED_MIN_RATE;

	return rate;
}

/**/

long	str_len_draw( const char *s )
{
#ifdef	D_DOS

	return( (long)strlen( s ) );

#else	/* D_DOS */

	switch( get_lang_kind() ){
	case LANG_KIND_ENGLISH:
		return str_len_draw_english( s );
	case LANG_KIND_JAPANESE_EUC:
		return str_len_draw_japanese_euc( s );
	case LANG_KIND_JAPANESE_UTF_8:
		return str_len_draw_japanese_utf_8( s );
	case LANG_KIND_MAX_N:
		break;
	}

	return( (long)strlen( s ) );

#endif	/* D_DOS */
}

/**/

long	str_len_draw_english( const char *s )
{
#if	1
/*@@@*/
	return str_len_draw_japanese_euc( s );
#else
	return( (long)strlen( s ) );
#endif
}

/**/

long	str_len_draw_japanese_euc( const char *s )
{
	long	len;

	for( len = 0; *s; len++, s++ ){
		unsigned char	c;

		c = (unsigned char)*s;
		if( (0x80 <= c) && (c <= 0x9f) )
			len--;
	}

	return len;
}

/**/

long	str_len_draw_japanese_utf_8( const char *s )
{
	long	len;
	unsigned char	c;
	long	skip_n;
	long	i;

	len = 0;
	for( ; *s != '\0'; s++ ){
		c = (unsigned char)*s;
		skip_n = 0;

		if( (c & 0x80) == 0x00 ){
			len++;
			continue;
		} else if( (c & 0xe0) == 0xc0 ){
			skip_n = 2;
		} else if( (c & 0xf0) == 0xe0 ){
			skip_n = 3;
		} else if( (c & 0xf8) == 0xf0 ){
			skip_n = 4;
		} else if( (c & 0xfc) == 0xf8 ){
			skip_n = 5;
		} else if( (c & 0xfe) == 0xfc ){
			skip_n = 6;
		}

		len += 2;
		s++;
		for( i = 1; i < skip_n; i++ ){
			if( *s == '\0' ){
				s--;
				break;
			}
			if( (c & 0xc0) != 0x80 ){
				s--;
				break;
			}

			s++;
		}
	}

	return len;
}

/**/

long	str_len_std( const char *s )
{
	return( (long)strlen( s ) );
}

/**/

char	*str_max_n_cat( char *dst, char *src, int len )
{
	return strncat( dst, src, len - strlen( dst ) );
}

/**/

bool_t	chk_flg( unsigned long var, unsigned long flg )
{
	return( (var & flg) == flg );
}

/**/

bool_t	chk_flg_or( unsigned long var, unsigned long flg )
{
	return( (var & flg) != 0 );
}

/**/

void	*alloc_mem( long size, bool_t flg_exit )
{
	void	*p;

	p = malloc( size );
	if( p == NULL ){
		print_msg( FLG_MSG_ERR, MSG_ERR_ALLOC_MEM, size );

		if( flg_exit ){
			exit_game( EXIT_FAILURE );
		}
	}

	return p;
}

/**/

void	free_mem( void *p )
{
	if( p != NULL )
		free( p );
}

/**/

