/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: msg.c,v 1.20 2004/12/06 06:18:18 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"amenu.h"*/
/*#include	"request.h"*/
/*#include	"gfile.h"*/
#include	"msg.h"
/*#include	"ver.h"*/
#include	"gmain-prot.h"
/*#include	"misc-prot.h"*/
/*#include	"turn-prot.h"*/
/*#include	"dun-prot.h"*/
/*#include	"town-prot.h"*/
/*#include	"item-prot.h"*/
/*#include	"spell-prot.h"*/
/*#include	"chr-prot.h"*/
/*#include	"party-prot.h"*/
/*#include	"mnstr-prot.h"*/
/*#include	"pet-prot.h"*/
/*#include	"fight-prot.h"*/
/*#include	"fx-prot.h"*/
/*#include	"trap-prot.h"*/
#include	"draw-prot.h"
/*#include	"curs-prot.h"*/
/*#include	"menu-prot.h"*/
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
/*#include	"request-prot.h"*/
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

/**/

#define	STR_S	"%s"
#define	STR_ENV_LANG	"LANG"
#define	STR_SUPPORT_LANG	"Supporting language is:"
#define	STR_SUPPORT_LANG_LIST	"\t`%s'\n"
#define	STR_ERR_LANG	"Don't support language: LANG=%s"
#define	STR_ERR_REDEFINED_MSG	"Redefined message data: LANG=%s %ld `%s'"
#define	STR_ERR_NOT_DEFINED_MSG	"Don't defined message data: LANG=%s %ld"

/* lang */

#define	LANG_TAB_MAX_N	64
#define	STR_DFLT_LANG	"ja_JP.eucJP"

lang_kind_t	g_lang_kind;

typedef struct {
	char	*name;
	lang_kind_t	kind;
} lang_t;

static lang_t	lang_tab[LANG_TAB_MAX_N] = {
	{
		"C",
		LANG_KIND_ENGLISH,
	},
	{
		"ja_JP.eucJP",
		LANG_KIND_JAPANESE_EUC,
	},
	{
		"ja_JP.ujis",
		LANG_KIND_JAPANESE_EUC,
	},
	{
		"ja_JP.UTF-8",
		LANG_KIND_JAPANESE_UTF_8,
	},
	{
		NULL,
		LANG_KIND_MAX_N,
	},
};

/* msg_t */

typedef struct {
	n_msg_t	n;
	char	*s;
} msg_t;

static msg_t	all_lang_msg[LANG_KIND_MAX_N][N_MSG_MAX_N] = {
	{
#include	"msg-eng.h"
	},
	{
#include	"msg-jpn.h"
	},
	{
#ifdef	D_DOS
# include	"msg-jpn.h"
#else	/* D_DOS */
# include	"msg-jpn-utf8.h"
#endif	/* D_DOS */
	},
};

static bool_t	flg_msg_def[N_MSG_MAX_N];

/**/

void	init_msg( void )
{
	char	*lang;
	long	k;

	n_msg_t	m;
	long	i;
	bool_t	flg_exit;

	flg_exit = FALSE;

	lang = getenv( STR_ENV_LANG );
	if( lang == NULL )
		lang = STR_DFLT_LANG;

	g_lang_kind = LANG_KIND_MAX_N;
	for( k = 0; k < LANG_TAB_MAX_N; k++ ){
		if( lang_tab[k].name == NULL )
			break;
		if( strcmp( lang, lang_tab[k].name ) == 0 ){
			g_lang_kind = lang_tab[k].kind;
			break;
		}
	}
	if( g_lang_kind >= LANG_KIND_MAX_N ){
		print_err( STR_ERR_LANG, lang );
		print_err( STR_S, STR_SUPPORT_LANG );
		for( k = 0; k < LANG_TAB_MAX_N; k++ ){
			if( lang_tab[k].name == NULL )
				break;
			fprintf( stderr, STR_SUPPORT_LANG_LIST,
					lang_tab[k].name );
		}
		fprintf( stderr, "\n" );
		exit_game( EXIT_FAILURE );
	}

	for( m = 0; m < N_MSG_MAX_N; m++ )
		flg_msg_def[m] = FALSE;

	for( i = 0; i < N_MSG_MAX_N; i++ ){
		if( all_lang_msg[g_lang_kind][i].s == NULL )
			break;

		m = all_lang_msg[g_lang_kind][i].n;
		if( flg_msg_def[m] ){
			char	*s;

			/* åƤ */
			s = all_lang_msg[g_lang_kind][m].s;
			print_err( STR_ERR_REDEFINED_MSG,
					lang_tab[g_lang_kind].name, m, s );
			flg_exit = TRUE;
		}
		ary_msg[m] = all_lang_msg[g_lang_kind][i].s;
		flg_msg_def[m] = TRUE;
	}

	for( m = 0; m < N_MSG_MAX_N; m++ ){
		if( !flg_msg_def[m] ){
			/* åƤʤ */
			print_err( STR_ERR_NOT_DEFINED_MSG,
					lang_tab[g_lang_kind].name, m );
			flg_exit = TRUE;
		}
	}

	if( flg_exit )
		exit_game( EXIT_FAILURE );
}

/**/

lang_kind_t	get_lang_kind( void )
{
	return g_lang_kind;
}

/**/

