/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: pet.c,v 1.46 2004/12/08 04:56:17 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
/*#include	"spell.h"*/
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
/*#include	"fight.h"*/
#include	"fx.h"
#include	"trap.h"
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"amenu.h"*/
/*#include	"request.h"*/
/*#include	"gfile.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain-prot.h"
#include	"misc-prot.h"
/*#include	"turn-prot.h"*/
/*#include	"dun-prot.h"*/
/*#include	"town-prot.h"*/
/*#include	"item-prot.h"*/
/*#include	"spell-prot.h"*/
#include	"chr-prot.h"
#include	"party-prot.h"
#include	"mnstr-prot.h"
#include	"pet-prot.h"
#include	"pet-prot.h"
/*#include	"fight-prot.h"*/
#include	"fx-prot.h"
#include	"trap-prot.h"
#include	"draw-prot.h"
/*#include	"curs-prot.h"*/
/*#include	"menu-prot.h"*/
/*#include	"tmenu-prot.h"*/
/*#include	"amenu-prot.h"*/
/*#include	"request-prot.h"*/
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

/**/

static pet_t	*party_pet[PET_MAX_N];

static pet_t	*ls_pet[LS_PET_MAX_N + 1];
static pet_t	ls_pet_buf[LS_PET_MAX_N + 1];

/**/

void	init_pet( void )
{
	long	i;

	for( i = 0; i < LS_PET_MAX_N + 1; i++ )
		ls_pet[i] = &(ls_pet_buf[i]);

	for( i = 0; i < LS_PET_MAX_N + 1; i++ ){
		new_pet( ls_pet[i] );
		ls_pet[i]->stat = FLG_STAT_NOT_EXIST;
	}

	for( i = 0; i < PET_MAX_N; i++ )
		party_pet[i] = NULL;

	if( g_flg_debug )
		init_pet_debug();
}

/**/

void	init_pet_debug( void )
{
	party_t	*pty = get_party();
	pet_t	*p;
	long	i;

	i = 0;
	p = make_pet( 10, MNSTR_KIND_PYON_PYON, pty->mbr[i] );
	if( p != NULL )
		join_pet( p );
}

/**/

pet_t	*make_pet( long dun_lev, pet_kind_t pet_kind, chr_t *owner )
{
	long	i;
	pet_t	*p;

	p = NULL;
	for( i = 0; i < LS_PET_MAX_N; i++ ){
		if( ls_pet[i] == NULL )
			continue;

		if( chk_flg( ls_pet[i]->stat, FLG_STAT_NOT_EXIST ) ){
			p = ls_pet[i];
			break;
		}
	}
	if( p == NULL )
		return NULL;

	if( make_pet_alloc( p, dun_lev, pet_kind ) == NULL ){
		p->stat = FLG_STAT_NOT_EXIST;
		return NULL;
	}

	p->owner = owner;

	return p;
}

/**/

pet_t	*make_pet_alloc( pet_t *p, long dun_lev, pet_kind_t pet_kind )
{
	mnstr_t	*m;

	if( p == NULL )
		return NULL;

	new_pet( p );

	m = make_mnstr_alloc( p, MAP_DEL_X, MAP_DEL_Y, FALSE,
			dun_lev, pet_kind );
	if( m == NULL )
		return NULL;

	p->flg_chr |= FLG_CHR_CAN_DEL;
	p->flg_map |= FLG_MAP_CHR_NPC;
	p->attitude = ATTITUDE_MATE;
	p->owner = NULL;

	set_chr_id( p, get_ls_pet(), LS_PET_MAX_N );

	return p;
}

/**/

void	new_pet( pet_t *pet )
{
	if( pet == NULL )
		return;

	new_mnstr( pet );
}

/**/

bool_t	reset_pet_resi( pet_t *pet )
{
	resi_kind_t	k;

	if( pet == NULL )
		return FALSE;
	if( !is_pet( pet ) )
		return FALSE;

	if( pet->mnstr_tab == NULL )
		return FALSE;

	for( k = 0; k < RESI_KIND_MAX_N; k++ )
		pet->resi[k].max = pet->mnstr_tab->resi[k];

	return TRUE;
}

/**/

void	clr_map_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ )
		clr_map_chr( party_pet[i] );
}

/**/

void	set_map_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ )
		set_map_chr( party_pet[i] );
}

/**/

void	appear_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == NULL )
			continue;

		appear_pet( party_pet[i] );
	}
}

/**/

void	appear_pet( pet_t *pet )
{
	long	x, y;

	if( pet == NULL )
		return;
	if( chk_flg_or( pet->stat,
			FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
		return;
	}

	if( pet->owner == NULL ){
		x = MAP_MAX_X / 2;
		y = MAP_MAX_Y / 2;
	} else {
		x = pet->owner->x;
		y = pet->owner->y;
	}

	put_chr( pet, x, y );
	draw_pet( pet );
}

/**/

void	move_phase_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];
		if( pp == NULL )
			continue;

		set_act_mnstr( pp );
		move_phase_chr( pp );
	}
}

/**/

void	act_phase_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];
		if( pp == NULL )
			continue;

		act_phase_chr( pp );
		set_modifier( pp );
	}
}

/**/

void	set_act_pet_std( pet_t *p )
{
	if( p == NULL )
		return;

	pet_mark_std( p );

	if( (p->trgt.kind == TRGT_KIND_MNSTR)
			|| (p->trgt.kind == TRGT_KIND_MNSTR_NULL) ){
		mnstr_move_or_atack_std( p );
	}
}

/**/

void	pet_mark_std( pet_t *p )
{
	mnstr_t	*mnstr;
	item_t	*item;

	if( p == NULL )
		return;

	clr_chr_trgt_act( p, TRUE );

	if( p->owner == NULL )
		return;

	switch( p->owner->trgt.kind ){
	case TRGT_KIND_NULL:
		break;
	case TRGT_KIND_MBR:
		break;
	case TRGT_KIND_MNSTR:
	case TRGT_KIND_MNSTR_NULL:
		mnstr = (mnstr_t *)(p->owner->trgt.p);
		if( mnstr == NULL )
			break;
		if( mnstr->attitude != ATTITUDE_ENEMY )
			break;

		mark_mnstr( p, mnstr, DIST_NEAR );
		break;
	case TRGT_KIND_ITEM:
		item = (item_t *)(p->owner->trgt.p);
		if( item == NULL )
			break;
		if( p->owner->trgt.dist == DIST_NEAR )
			break;

		set_chr_act( p, ACT_KIND_ITEM_PICK_UP,
				NULL, NULL, 0, 0 );
		mark_item( p, item, DIST_NEAR );
		break;
	case TRGT_KIND_DOOR:
	case TRGT_KIND_TRAP:
	case TRGT_KIND_QUEUE:
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_POS:
	case TRGT_KIND_AUTO:
		break;
	case TRGT_KIND_MAX_N:
		break;
	}
}

/**/

void	chk_trap_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];
		if( pp == NULL )
			continue;

		chk_trap( pp, pp );
	}
}

/**/

pet_t	**get_party_pet( void )
{
	return party_pet;
}

/**/

pet_t	**get_ls_pet( void )
{
	return ls_pet;
}

/**/

pet_t	*get_pet( long x, long y )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];
		if( pp == NULL )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( x < get_chr_left( pp->x, pp->dx ) )
			continue;
		if( x > get_chr_right( pp->x, pp->dx ) )
			continue;
		if( y < get_chr_top( pp->y, pp->dy ) )
			continue;
		if( y > get_chr_bottom( pp->y, pp->dy ) )
			continue;

		return pp;
	}

	return NULL;
}

/**/

pet_t	*get_npc_request( request_t *req )
{
	long	i;

	for( i = 0; i < LS_PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = ls_pet[i];
		if( pp == NULL )
			continue;
		if( chk_flg_or( pp->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		if( pp->work.request == req )
			return pp;
	}

	return NULL;
}

/**/

void	clr_pet_owner( pet_t *p )
{
	party_t	*pty = get_party();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		chr_t	*chr;

		chr = pty->mbr[i];
		if( chk_flg_or( chr->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		p->owner = chr;
		break;
	}
}

/**/

bool_t	chk_can_join_pet( pet_t *pet )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == pet )
			return FALSE;
	}

	return TRUE;
}

/**/

bool_t	chk_can_not_join_pet( pet_t *pet )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == pet )
			return TRUE;
	}

	return FALSE;
}

/**/

bool_t	join_pet( pet_t *pet )
{
	long	i;

	if( pet == NULL )
		return FALSE;
	if( !chk_can_join_pet( pet ) )
		return FALSE;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] != NULL )
			continue;

		party_pet[i] = pet;
		appear_pet( pet );

		return TRUE;
	}

	return FALSE;
}

/**/

bool_t	not_join_pet( pet_t *pet )
{
	long	i;

	if( pet == NULL )
		return FALSE;
	if( !chk_can_not_join_pet( pet ) )
		return FALSE;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] != pet )
			continue;

		clr_map_chr( pet );
		draw_pet( pet );

		pet->pre_x = pet->x;
		pet->pre_y = pet->y;
		pet->x = MAP_DEL_X;
		pet->y = MAP_DEL_Y;
		party_pet[i] = NULL;

		return TRUE;
	}

	return FALSE;
}

/**/

void	die_pet( pet_t *pet )
{
}

/**/

void	remove_pet( pet_t *pet )
{
	if( pet == NULL )
		return;
	if( !is_pet( pet ) )
		return;

	pet->flg_chr |= FLG_CHR_CAN_DISMISSAL;
	dismissal( pet );
}

/**/

bool_t	dismissal( pet_t *pet )
{
	long	i;

	if( pet == NULL )
		return FALSE;
	if( pet->kind != CHR_KIND_MNSTR )
		return FALSE;
	if( !chk_flg( pet->flg_chr, FLG_CHR_CAN_DISMISSAL ) )
		return FALSE;

	not_join_pet( pet );

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == pet ){
			party_pet[i] = NULL;
			break;
		}
	}
	die_chr( pet, FALSE, FALSE, FALSE );

	return TRUE;
}

/**/

bool_t	is_pet( pet_t *pet )
{
	long	i;

	if( pet == NULL )
		return FALSE;
	if( pet->kind != CHR_KIND_MNSTR )
		return FALSE;

	for( i = 0; i < LS_PET_MAX_N; i++ ){
		if( ls_pet[i] == NULL )
			continue;

		if( ls_pet[i] == pet )
			return TRUE;
	}

	return FALSE;
}

/**/

