/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: request.h,v 1.29 2004/12/13 14:14:23 bowkenken Exp $
***************************************************************/

#ifndef	REQUEST_H
#define	REQUEST_H

#include	"item.h"
#include	"chr.h"
#include	"menu.h"

/* ΰ */

#define	REQUEST_MAX_N	64	/*  */
#define	REQUEST_AVE_N	32	/* ʿѿ */

#define	REQUEST_MSG_MAX_LEN	1024

/* μ */

typedef enum {
	REQUEST_KIND_NULL,
	REQUEST_KIND_RARE_GOODS,	/* ƥõ */
	REQUEST_KIND_TAME_MNSTR,	/* ץ */
	REQUEST_KIND_RESCUE,	/* ߽ */
	REQUEST_KIND_TOUR_GUIDE,	/* Ѹ */
	REQUEST_KIND_EXTERMINATE,	/* 󥹥༣ */
	REQUEST_KIND_REVENGE,	/* Ƥ */
	REQUEST_KIND_WANTED_CRIMINAL,	/* ޶ */
	REQUEST_KIND_MAX_N,
} request_kind_t;

typedef struct request_t {
	request_kind_t	kind;
	long	dun_min_lev, dun_max_lev, dun_true_lev;	/*  */
	gold_t	prize;	/* ޶ */
	long	exp;	/* 󽷷и */
	long	limit;	/*  */
	bool_t	flg_contract;	/* ե饰 */
	bool_t	flg_contract_mbr;	/* Сΰե饰 */
	n_msg_idx_t	idx_contract_name;	/* ̾ */
	sex_t	contract_sex;
	bool_t	flg_finish;	/* ãե饰 */

	rare_goods_kind_t	rare_goods_kind;

	bool_t	flg_mnstr_is_npc;
	mnstr_kind_t	mnstr_kind;
	long	mnstr_n;
	long	mnstr_exterminate_n;	/* ݤ󥹥ο */

	char	heading[MENU_MSG_MAX_LEN + 1];	/* ꥹȾθФ */
	n_msg_idx_t	idx_fmt;
	char	msg[REQUEST_MSG_MAX_LEN + 1];	/*  */

	n_msg_idx_t	idx_client_name;
	n_msg_idx_t	idx_mnstr_name;
	n_msg_idx_t	idx_rescue_trgt_name;
	n_msg_idx_t	idx_client_family_name;
	n_msg_idx_t	idx_client_mate_name;
	sex_t	client_sex;
	sex_t	mnstr_sex;
	sex_t	rescue_trgt_sex;
	sex_t	client_family_sex;
	sex_t	client_mate_sex;
	mnstr_kind_t	rescue_trgt_kind;

	n_msg_idx_t	idx_when_1, idx_when_2;
	n_msg_idx_t	idx_weapon;
} request_t;

#endif	/* REQUEST_H */
