/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: trap.h,v 1.23 2004/12/06 06:18:18 bowkenken Exp $
***************************************************************/

#ifndef	TRAP_H
#define	TRAP_H

#include	"gmain.h"
#include	"msg.h"

/* 1 ˤ櫤̤ˤĤ */
#if	0
# ifndef	D_TEST_TRAP
#  define	D_TEST_TRAP
# endif
#endif

/* 1 ˤ櫤Ĥ */
#if	0
# ifndef	D_TEST_TRAP_KIND
#  define	D_TEST_TRAP_KIND	TRAP_KIND_ARW
# endif
#endif

#if	defined( DEBUG ) && defined( D_TEST_TRAP )
# define	TRAP_AVE_N	512
# define	TRAP_MAX_N	1024
#else
# define	TRAP_AVE_N	12
# define	TRAP_MAX_N	128
#endif

/* 櫤μ */

typedef enum {
	TRAP_KIND_NULL,
	TRAP_KIND_SLEEP,
	TRAP_KIND_ARW,
	TRAP_KIND_POISON_DARTS,
	TRAP_KIND_BOMB,
	TRAP_KIND_TELEPORT_PARTY,
	TRAP_KIND_TELEPORT,
	TRAP_KIND_PIT,
	TRAP_KIND_CHUTE,
	TRAP_KIND_MAX_N
} trap_kind_t;

typedef struct {
	trap_kind_t	kind;
	char	*name;
	n_msg_t	name_n;
	rate_t	rate;	/* иΨ */
	char	mnr;
	long	min_lev, max_lev, sgn_lev;	/* и */
} trap_tab_t;

typedef struct trap_t {
	struct trap_t	*next, *prev;
	trap_kind_t	kind;
	long	x, y;
	long	lev;
	long	difficulty;	/* 񤷤 */
	bool_t	flg_chked;
	trap_tab_t	*tab;
} trap_t;

#endif	/* TRAP_H */
