/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: menu-tab.h,v 1.15 2006/01/12 08:51:38 bowkenken Exp $
***************************************************************/

#ifndef	MENU_TAB_H
#define	MENU_TAB_H

/* ˥塼 */

#include	"request.h"

#include	"request-prot.h"

/**/

#if	0
char	*menu_kind_ls[] = {
	/* ȥ */
	"<Title>",

	/*  */
	"<Item>",

	/* å */
	"<CheckItem>",

	/*  */
	"<RadioItem>",

	/* ̥ɥ򳫤 */
	"<OpenWinItem>",

	/* <RadioItem>ζڤ */
	"<Separator>",

	/* ˥塼ʣڡͭζڤ */
	"<PageSeparator>",

	/* ֥˥塼 */
	"<Branch>",

	NULL,
};
#endif

#if	0
typedef struct menu_t {
	/* ڹ¤Υѥ */
	char	path[MENU_PATH_MAX_LEN + 1];
	/* ܤμ */
	char	kind[MENU_KIND_MAX_LEN + 1];

	/* ľΥ */
	unsigned char	key;
	/* 硼ȡåȡ */
	char	accel_key[MENU_ACCEL_KEY_MAX_LEN + 1];

	/* ̾ */
	n_msg_t	n_msg;
	char	msg[MENU_MSG_MAX_LEN + 1];

	/* 롦Хåؿ */
	menu_call_back_t	call_back;
	/* 롦Хåؿؤΰ */
	void	*arg;

	/* ե饰 */
	unsigned long	flg;
} menu_t;
#endif

/* ˥塼ꥹ */

menu_t	ls_menu_ask[] = {
	{
		"/ask",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_ask_init, NULL,
		FLG_NULL,
	},
	{
		"/ask/title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/ask/yes",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_YES, "",
		cb_menu_ask_yes, NULL,
		FLG_NULL,
	},
	{
		"/ask/no",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_NO, "",
		cb_menu_ask_no, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_main_race[] = {
	{
		"/main race",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/main race/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_MAIN_RACE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/main race/human",
		"<Item>",
		'H',
		"",
		N_MSG_MAIN_RACE_HUMAN, "",
		cb_menu_main_race, (void *)MAIN_RACE_HUMAN,
		FLG_NULL,
	},
	{
		"/main race/half elf",
		"<Item>",
		'F',
		"",
		N_MSG_MAIN_RACE_HALF_ELF, "",
		cb_menu_main_race, (void *)MAIN_RACE_HALF_ELF,
		FLG_NULL,
	},
	{
		"/main race/elf",
		"<Item>",
		'E',
		"",
		N_MSG_MAIN_RACE_ELF, "",
		cb_menu_main_race, (void *)MAIN_RACE_ELF,
		FLG_NULL,
	},
	{
		"/main race/dwarf",
		"<Item>",
		'D',
		"",
		N_MSG_MAIN_RACE_DWARF, "",
		cb_menu_main_race, (void *)MAIN_RACE_DWARF,
		FLG_NULL,
	},
	{
		"/main race/bibit",
		"<Item>",
		'B',
		"",
		N_MSG_MAIN_RACE_VIVID, "",
		cb_menu_main_race, (void *)MAIN_RACE_VIVID,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sub_race[] = {
	{
		"/sub race",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sub race/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SUB_RACE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sub race/null",
		"<Item>",
		'N',
		"",
		N_MSG_SUB_RACE_NULL, "",
		cb_menu_sub_race, (void *)SUB_RACE_NULL,
		FLG_NULL,
	},
	{
		"/sub race/cat",
		"<Item>",
		'C',
		"",
		N_MSG_SUB_RACE_CAT, "",
		cb_menu_sub_race, (void *)SUB_RACE_CAT,
		FLG_NULL,
	},
	{
		"/sub race/dog",
		"<Item>",
		'D',
		"",
		N_MSG_SUB_RACE_DOG, "",
		cb_menu_sub_race, (void *)SUB_RACE_DOG,
		FLG_NULL,
	},
	{
		"/sub race/mouse",
		"<Item>",
		'U',
		"",
		N_MSG_SUB_RACE_MOUSE, "",
		cb_menu_sub_race, (void *)SUB_RACE_MOUSE,
		FLG_NULL,
	},
	{
		"/sub race/rabbit",
		"<Item>",
		'R',
		"",
		N_MSG_SUB_RACE_RABBIT, "",
		cb_menu_sub_race, (void *)SUB_RACE_RABBIT,
		FLG_NULL,
	},
	{
		"/sub race/monkey",
		"<Item>",
		'K',
		"",
		N_MSG_SUB_RACE_MONKEY, "",
		cb_menu_sub_race, (void *)SUB_RACE_MONKEY,
		FLG_NULL,
	},
	{
		"/sub race/pig",
		"<Item>",
		'P',
		"",
		N_MSG_SUB_RACE_PIG, "",
		cb_menu_sub_race, (void *)SUB_RACE_PIG,
		FLG_NULL,
	},
	{
		"/sub race/bird",
		"<Item>",
		'B',
		"",
		N_MSG_SUB_RACE_BIRD, "",
		cb_menu_sub_race, (void *)SUB_RACE_BIRD,
		FLG_NULL,
	},
	{
		"/sub race/lizard",
		"<Item>",
		'L',
		"",
		N_MSG_SUB_RACE_LIZARD, "",
		cb_menu_sub_race, (void *)SUB_RACE_LIZARD,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sex[] = {
	{
		"/sex",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sex/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SEX, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sex/male",
		"<Item>",
		'M',
		"",
		N_MSG_MALE, "",
		cb_menu_sex, (void *)MALE,
		FLG_NULL,
	},
	{
		"/sex/female",
		"<Item>",
		'F',
		"",
		N_MSG_FEMALE, "",
		cb_menu_sex, (void *)FEMALE,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_class
		[1 + CLASS_MAX_N + (CLASS_MAX_N / LS_CLASS_N_PER_PAGE) + 1];

menu_t	ls_menu_main[] = {
	{
		"/",
		"<Branch>",
		'\0',
		"m M ^M ^J",
		N_MSG_NULL, "",
		cb_menu_main_init, NULL,
		FLG_NULL,
	},
	{
		"/mark",
		"<OpenWinItem>",
		'M',
		"",
		N_MSG_MENU_MARK, "",
		cb_menu_mark, NULL,
		FLG_NULL,
	},
	{
		"/move",
		"<Item>",
		'V',
		"v",
		N_MSG_MENU_MOVE, "",
		cb_menu_move, NULL,
		FLG_NULL,
	},
	{
		"/exec",
		"<Item>",
		'X',
		". 5",
		N_MSG_MENU_EXEC, "",
		cb_menu_exec, NULL,
		FLG_NULL,
	},
	{
		"/item",
		"<Branch>",
		'I',
		"i",
		N_MSG_MENU_ITEM, "",
		cb_menu_item, NULL,
		FLG_NULL,
	},
	{
		"/equip",
		"<Branch>",
		'E',
		"e",
		N_MSG_MENU_EQUIP, "",
		cb_menu_equip, NULL,
		FLG_NULL,
	},
	{
		"/fight",
		"<OpenWinItem>",
		'F',
		"f",
		N_MSG_MENU_FIGHT, "",
		cb_menu_fight, NULL,
		FLG_NULL,
	},
	{
		"/spell",
		"<Branch>",
		'C',
		"c",
		N_MSG_MENU_SPELL, "",
		cb_menu_sel_spell, NULL,
		FLG_NULL,
	},
/* misc begin */
	{
		"/misc",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_MISC, "",
		cb_menu_misc, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_STAIRS, "",
		cb_menu_stairs, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs/up",
		"<Item>",
		'U',
		"<",
		N_MSG_MENU_STAIRS_UP, "",
		cb_menu_stairs_up, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs/down",
		"<Item>",
		'D',
		">",
		N_MSG_MENU_STAIRS_DOWN, "",
		cb_menu_stairs_down, NULL,
		FLG_NULL,
	},
	{
		"/misc/search",
		"<Branch>",
		'S',
		"# ^S s",
		N_MSG_MENU_SRCH, "",
		cb_menu_srch, NULL,
		FLG_NULL,
	},
	{
		"/misc/hint",
		"<Item>",
		'I',
		"?",
		N_MSG_MENU_MAP_HINT, "",
		cb_menu_show_map_hint, NULL,
		FLG_NULL,
	},
	{
		"/misc/char data",
		"<OpenWinItem>",
		'D',
		"d",
		N_MSG_MENU_CHR_DATA, "",
		cb_menu_chr_data, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold",
		"<Branch>",
		'G',
		"",
		N_MSG_MENU_GOLD, "",
		cb_menu_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold/collect",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLLECT_GOLD, "",
		cb_menu_collect_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold/divide",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_DIVIDE_GOLD, "",
		cb_menu_divide_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold/give",
		"<Item>",
		'G',
		"",
		N_MSG_MENU_GIVE_GOLD, "",
		cb_menu_give_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/formation",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_FORMATION, "",
		cb_menu_formation, NULL,
		FLG_NULL,
	},
	{
		"/misc/cursor",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_CRSR, "",
		cb_menu_crsr, NULL,
		FLG_NULL,
	},
	{
		"/misc/list message",
		"<OpenWinItem>",
		'M',
		"g",
		N_MSG_MENU_LS_MSG, "",
		cb_menu_ls_msg, NULL,
		FLG_NULL,
	},
	{
		"/misc/list monster",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_LS_MNSTR, "",
		cb_menu_ls_mnstr, NULL,
		FLG_NULL,
	},
	{
		"/misc/list request",
		"<Branch>",
		'R',
		"r",
		N_MSG_MENU_LS_REQUEST, "",
		cb_menu_request_mbr, NULL,
		FLG_NULL,
	},
/* config begin */
	{
		"/misc/config",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_CNF, "",
		cb_menu_cnf, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/auto fight",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_AUTO_FIGHT, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_FIGHT,
		FLG_NULL,
	},
	{
		"/misc/config/auto open door",
		"<Branch>",
		'D',
		"",
		N_MSG_MENU_AUTO_DOOR, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_DOOR,
		FLG_NULL,
	},
	{
		"/misc/config/avoid trap",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_AVOID_TRAP, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AVOID_TRAP,
		FLG_NULL,
	},
	{
		"/misc/config/reload arrow",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_AUTO_RELOAD, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_RELOAD,
		FLG_NULL,
	},
	{
		"/misc/config/actual fighting",
		"<CheckItem>",
		'I',
		"",
		N_MSG_MENU_ACTUAL_FIGHTING, "",
		cb_menu_actual_fighting, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/space select",
		"<CheckItem>",
		'S',
		"",
		N_MSG_MENU_SPACE_SELECT, "",
		cb_menu_space_select, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_LANG, "",
		cb_menu_lang, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_LANG, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang/list",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_LANG_LS, "",
		cb_menu_lang_ls, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang/list priority",
		"<CheckItem>",
		'P',
		"",
		N_MSG_MENU_LANG_LS_PRIORITY, "",
		cb_menu_lang_ls_priority, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window",
		"<Branch>",
		'W',
		"",
		N_MSG_MENU_WINDOW, "",
		cb_menu_window, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_WINDOW, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/scroll",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_SCROLL_MODE, "",
		cb_menu_scroll_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/scroll/page",
		"<RadioItem>",
		'P',
		"",
		N_MSG_MENU_SCROLL_PAGE, "",
		cb_menu_scroll_page, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/scroll/smooth",
		"<RadioItem>",
		'S',
		"",
		N_MSG_MENU_SCROLL_SMOOTH, "",
		cb_menu_scroll_smooth, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/scroll/center",
		"<RadioItem>",
		'C',
		"",
		N_MSG_MENU_SCROLL_CENTER, "",
		cb_menu_scroll_center, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/redraw every turn",
		"<CheckItem>",
		'D',
		"",
		N_MSG_MENU_REDRAW_EVERY_TURN, "",
		cb_menu_redraw_every_turn, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/window/multi message",
		"<CheckItem>",
		'M',
		"",
		N_MSG_MENU_MUL_MSG_LINE, "",
		cb_menu_mul_msg_line, NULL,
		FLG_NULL,
	},
/* VFX begin */
	{
		"/misc/config/vfx",
		"<Branch>",
		'X',
		"",
		N_MSG_MENU_VFX, "",
		cb_menu_vfx, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_VFX, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/member cure",
		"<CheckItem>",
		'A',
		"",
		N_MSG_MENU_VFX_MBR_CURE, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_CURE,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/member dam",
		"<CheckItem>",
		'B',
		"",
		N_MSG_MENU_VFX_MBR_DAM, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_DAM,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/member critical",
		"<CheckItem>",
		'C',
		"",
		N_MSG_MENU_VFX_MBR_CRTCL, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_CRTCL,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/member arrow",
		"<CheckItem>",
		'D',
		"",
		N_MSG_MENU_VFX_MBR_ARW, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_ARW,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/monster cure",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_VFX_MNSTR_CURE, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_CURE,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/monster dam",
		"<CheckItem>",
		'F',
		"",
		N_MSG_MENU_VFX_MNSTR_DAM, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_DAM,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/monster critical",
		"<CheckItem>",
		'G',
		"",
		N_MSG_MENU_VFX_MNSTR_CRTCL, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_CRTCL,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/monster arrow",
		"<CheckItem>",
		'H',
		"",
		N_MSG_MENU_VFX_MNSTR_ARW, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_ARW,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/wait",
		"<OpenWinItem>",
		'W',
		"",
		N_MSG_MENU_VFX_WAIT, "",
		cb_menu_vfx_wait, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/vfx/measure clock",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_VFX_MEASURE_CLK_TCK, "",
		cb_menu_vfx_measure_clk_tck, NULL,
		FLG_NULL,
	},
/* VFX end */
	{
		"/misc/config/color",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_COLOR, "",
		cb_menu_color, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/cursor pattern",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_CRSR_PTN, "",
		cb_menu_crsr_ptn, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key",
		"<Branch>",
		'K',
		"",
		N_MSG_MENU_KEY, "",
		cb_menu_key_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_KEY, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_CLR_KEY_BUF, "",
		cb_menu_clr_key_buf_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_CLR_KEY_BUF, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer/every",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_CLR_KEY_BUF_EVERY, "",
		cb_menu_clr_key_buf_every, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer/menu",
		"<CheckItem>",
		'M',
		"",
		N_MSG_MENU_CLR_KEY_BUF_MENU, "",
		cb_menu_clr_key_buf_menu, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/echo key",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_ECHO_KEY, "",
		cb_menu_echo_key, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind",
		"<Branch>",
		'B',
		"",
		N_MSG_MENU_KEY_BIND, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_KEY_BIND, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/set key",
		"<OpenWinItem>",
		'A',
		"",
		N_MSG_MENU_SET_KEY, "",
		cb_menu_set_key, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/unset key",
		"<OpenWinItem>",
		'F',
		"",
		N_MSG_MENU_UNSET_KEY, "",
		cb_menu_unset_key, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/macro",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_MACRO, "",
		cb_menu_macro, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/user menu select",
		"<Branch>",
		'M',
		"x",
		N_MSG_MENU_USER, "",
		cb_menu_user, NULL,
		FLG_NULL,
	},
/* config end */
/* system begin */
	{
		"/misc/system",
		"<Branch>",
		'Y',
		"",
		N_MSG_MENU_SYS, "",
		cb_menu_system, NULL,
		FLG_NULL,
	},
/* wizard begin */
	{
		"/misc/system/wizard",
		"<Branch>",
		'W',
		"^W",
		N_MSG_MENU_WIZARD, "",
		cb_menu_wizard, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_WIZARD, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/on light",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_WIZARD_ON_LIGHT, "",
		cb_menu_wizard_on_light, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/off light",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_WIZARD_OFF_LIGHT, "",
		cb_menu_wizard_off_light, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/add turn",
		"<OpenWinItem>",
		'T',
		"",
		N_MSG_MENU_WIZARD_ADD_TURN, "",
		cb_menu_wizard_add_turn, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/level up",
		"<OpenWinItem>",
		'V',
		"",
		N_MSG_MENU_WIZARD_LEV_UP, "",
		cb_menu_wizard_lev_up, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/text load",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_WIZARD_TEXT_LOAD, "",
		cb_menu_load, (void *)TRUE,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/text save",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_WIZARD_TEXT_SAVE, "",
		cb_menu_save, (void *)TRUE,
		FLG_NULL,
	},
/* wizard end */
	{
		"/misc/system/output map file",
		"<OpenWinItem>",
		'O',
		"",
		N_MSG_MENU_OUT_MAP_FILE, "",
		cb_menu_out_map_file, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/shell",
		"<OpenWinItem>",
		'H',
		"!",
		N_MSG_MENU_SHELL, "",
		cb_menu_shell, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/about",
		"<OpenWinItem>",
		'A',
		"",
		N_MSG_MENU_ABOUT_GAME, "",
		cb_menu_about_game, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/exit",
		"<Branch>",
		'Q',
		"^C ^Q Q",
		N_MSG_MENU_EXIT, "",
		cb_menu_exit, NULL,
		FLG_NULL,
	},
/* system end */
/* misc end */
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sel_obj[] = {
	{
		"/sel obj",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_sel_obj_init, NULL,
		FLG_NULL,
	},
	{
		"/sel obj/member",
		"<OpenWinItem>",
		'P',
		"",
		N_MSG_MENU_SEL_OBJ_MBR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_MBR,
		FLG_NULL,
	},
	{
		"/sel obj/monster",
		"<OpenWinItem>",
		'X',
		"",
		N_MSG_MENU_SEL_OBJ_MNSTR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_MNSTR,
		FLG_NULL,
	},
	{
		"/sel obj/item",
		"<OpenWinItem>",
		'I',
		"",
		N_MSG_MENU_SEL_OBJ_ITEM, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_ITEM,
		FLG_NULL,
	},
	{
		"/sel obj/door",
		"<OpenWinItem>",
		'D',
		"",
		N_MSG_MENU_SEL_OBJ_DOOR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_DOOR,
		FLG_NULL,
	},
	{
		"/sel obj/trap",
		"<OpenWinItem>",
		'T',
		"",
		N_MSG_MENU_SEL_OBJ_TRAP, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_TRAP,
		FLG_NULL,
	},
	{
		"/sel obj/square",
		"<OpenWinItem>",
		'V',
		"",
		N_MSG_MENU_SEL_OBJ_SQUARE, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_SQUARE,
		FLG_NULL,
	},
	{
		"/sel obj/position",
		"<OpenWinItem>",
		'N',
		"",
		N_MSG_MENU_SEL_OBJ_POS, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_POS,
		FLG_NULL,
	},
	{
		"/sel obj/auto",
		"<Branch>",
		'A',
		"a",
		N_MSG_MENU_SEL_OBJ_AUTO, "",
		cb_menu_sel_obj_auto, (void *)TRGT_KIND_AUTO,
		FLG_NULL,
	},
	{
		"/sel obj/clear",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_SEL_OBJ_CLEAR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mbr[1 + MBR_MAX_N + PET_MAX_N + 1];

menu_t	ls_menu_dist[] = {
	{
		"/dist",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_dist_init, NULL,
		FLG_NULL,
	},
/* Near */
	{
		"/dist/near",
		"<Branch>",
		'N',
		"",
		N_MSG_MENU_DIST_NEAR, "",
		cb_menu_dist, (void *)"near",
		FLG_NULL,
	},
	{
		"/dist/near/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"fight",
		FLG_NULL,
	},
	{
		"/dist/near/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"throw",
		FLG_NULL,
	},
	{
		"/dist/near/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"steal",
		FLG_NULL,
	},
	{
		"/dist/near/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"tail",
		FLG_NULL,
	},
/* Medium */
	{
		"/dist/medium",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_DIST_MEDIUM, "",
		cb_menu_dist, (void *)"medium",
		FLG_NULL,
	},
	{
		"/dist/medium/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"fight",
		FLG_NULL,
	},
	{
		"/dist/medium/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"throw",
		FLG_NULL,
	},
	{
		"/dist/medium/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"steal",
		FLG_NULL,
	},
	{
		"/dist/medium/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"tail",
		FLG_NULL,
	},
/* Far */
	{
		"/dist/far",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_DIST_FAR, "",
		cb_menu_dist, (void *)"far",
		FLG_NULL,
	},
	{
		"/dist/far/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"fight",
		FLG_NULL,
	},
	{
		"/dist/far/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"throw",
		FLG_NULL,
	},
	{
		"/dist/far/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"steal",
		FLG_NULL,
	},
	{
		"/dist/far/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"tail",
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_item[] = {
	{
		"/mark item",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/mark item/pick up",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_MARK_ITEM_PICK_UP, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_PICK_UP,
		FLG_NULL,
	},
	{
		"/mark item/open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_MARK_ITEM_OPEN, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_OPEN,
		FLG_NULL,
	},
	{
		"/mark item/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_ITEM_DISARM, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_DISARM,
		FLG_NULL,
	},
	{
		"/mark item/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_ITEM_BREAK, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_BREAK,
		FLG_NULL,
	},
	{
		"/mark item/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_ITEM_CHK, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_door[] = {
	{
		"/mark door",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/mark door/open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_MARK_DOOR_OPEN, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_OPEN,
		FLG_NULL,
	},
	{
		"/mark door/close",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_MARK_DOOR_CLOSE, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_CLOSE,
		FLG_NULL,
	},
	{
		"/mark door/jamming",
		"<Item>",
		'J',
		"",
		N_MSG_MENU_MARK_DOOR_JAM, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_JAM,
		FLG_NULL,
	},
	{
		"/mark door/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_DOOR_DISARM, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_DISARM,
		FLG_NULL,
	},
	{
		"/mark door/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_DOOR_BREAK, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_BREAK,
		FLG_NULL,
	},
	{
		"/mark door/peep",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_MARK_DOOR_PEEP, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_PEEP,
		FLG_NULL,
	},
	{
		"/mark door/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_DOOR_CHK, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_trap[] = {
	{
		"/mark trap",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/mark trap/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_TRAP_DISARM, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_DISARM,
		FLG_NULL,
	},
	{
		"/mark trap/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_TRAP_BREAK, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_BREAK,
		FLG_NULL,
	},
	{
		"/mark trap/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_TRAP_CHK, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_item[MBR_ITEM_MAX_N * 2 * MBR_MAX_N];

menu_t	ls_menu_item_self[] = {
	{
		"/self",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_item_self_init, NULL,
		FLG_NULL,
	},
	{
		"/self/quaff",
		"<Item>",
		'Q',
		"",
		N_MSG_MENU_ITEM_QUAFF, "",
		cb_menu_item_use, (void *)ACT_KIND_POTION_QUAFF,
		FLG_NULL,
	},
	{
		"/self/read",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_ITEM_READ, "",
		cb_menu_item_use, (void *)ACT_KIND_SCROLL_READ,
		FLG_NULL,
	},
	{
		"/self/zap",
		"<Item>",
		'Z',
		"",
		N_MSG_MENU_ITEM_ZAP, "",
		cb_menu_item_zap, (void *)ACT_KIND_STICK_ZAP,
		FLG_NULL,
	},
	{
		"/self/eat",
		"<Item>",
		'A',
		"",
		N_MSG_MENU_ITEM_EAT, "",
		cb_menu_item_use, (void *)ACT_KIND_FOOD_EAT,
		FLG_NULL,
	},
	{
		"/self/smoke",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_ITEM_SMOKE, "",
		cb_menu_item_smoke, (void *)ACT_KIND_EQUIP,
		FLG_NULL,
	},
	{
		"/self/dispose",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_ITEM_DISPOSE, "",
		cb_menu_item_use, (void *)ACT_KIND_TOBACCO_DISPOSE,
		FLG_NULL,
	},
	{
		"/self/fill lamp",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_ITEM_FILL_LAMP, "",
		cb_menu_item_fill_lamp, (void *)ACT_KIND_POTION_FILL,
		FLG_NULL,
	},
	{
		"/self/equip",
		"<Item>",
		'E',
		"",
		N_MSG_MENU_ITEM_EQUIP, "",
		cb_menu_item_use, (void *)ACT_KIND_EQUIP_SEL,
		FLG_NULL,
	},
	{
		"/self/ready throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_ITEM_READY_THROW, "",
		cb_menu_item_ready_throw, (void *)ACT_KIND_EQUIP,
		FLG_NULL,
	},
	{
		"/self/send",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_ITEM_SEND, "",
		cb_menu_item_send, (void *)ACT_KIND_ITEM_SEND,
		FLG_NULL,
	},
	{
		"/self/drop",
		"<OpenWinItem>",
		'D',
		"",
		N_MSG_MENU_ITEM_DROP, "",
		cb_menu_item_drop, (void *)ACT_KIND_ITEM_DROP,
		FLG_NULL,
	},
	{
		"/self/check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, (void *)ACT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_item_other[] = {
	{
		"/other",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_item_other, NULL,
		FLG_NULL,
	},
	{
		"/other/recieve",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_ITEM_RECEIVE, "",
		cb_menu_item_receive, NULL,
		FLG_NULL,
	},
	{
		"/other/check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, (void *)ACT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip[EQUIP_KIND_MAX_N * 2 * MBR_MAX_N];

menu_t	ls_menu_equip_self[] = {
	{
		"/self",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_equip_self, NULL,
		FLG_NULL,
	},
	{
		"/self/wear",
		"<Branch>",
		'W',
		"",
		N_MSG_MENU_EQUIP_WEAR, "",
		cb_menu_equip_wear_sel, NULL,
		FLG_NULL,
	},
	{
		"/self/take off",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_EQUIP_TAKE_OFF, "",
		cb_menu_equip_take_off, NULL,
		FLG_NULL,
	},
	{
		"/self/check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip_other[] = {
	{
		"/other",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_equip_other, NULL,
		FLG_NULL,
	},
	{
		"/other/wear",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_EQUIP_WEAR_MBR, "",
		cb_menu_equip_wear_sel, NULL,
		FLG_NULL,
	},
	{
		"/other/take off",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_EQUIP_TAKE_OFF_MBR, "",
		cb_menu_equip_take_off, NULL,
		FLG_NULL,
	},
	{
		"/other/check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip_wear_sel[MBR_ITEM_MAX_N * 2];
menu_t	ls_menu_identify_item[MBR_ITEM_MAX_N * 2 * MBR_MAX_N];
menu_t	ls_menu_resurrection[MBR_ITEM_MAX_N * 2];
menu_t	ls_menu_srch[1 + 4 + MBR_MAX_N + 1];
menu_t	ls_menu_formation[1 + 1 + MBR_MAX_N + 1];

menu_t	ls_menu_move_crsr[] = {
	{
		"/cursor",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* cursor move begin */
	{
		"/cursor/move",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_CRSR_MOVE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/cursor/move/down left",
		"<Item>",
		'B',
		"1 b",
		N_MSG_MENU_CRSR_MOVE_DOWN_LEFT, "",
		cb_menu_crsr_move, (void *)1,
		FLG_NULL,
	},
	{
		"/cursor/move/down",
		"<Item>",
		'J',
		"^N 2 j",
		N_MSG_MENU_CRSR_MOVE_DOWN, "",
		cb_menu_crsr_move, (void *)2,
		FLG_NULL,
	},
	{
		"/cursor/move/down right",
		"<Item>",
		'N',
		"3 n",
		N_MSG_MENU_CRSR_MOVE_DOWN_RIGHT, "",
		cb_menu_crsr_move, (void *)3,
		FLG_NULL,
	},
	{
		"/cursor/move/left",
		"<Item>",
		'H',
		"^B 4 h",
		N_MSG_MENU_CRSR_MOVE_LEFT, "",
		cb_menu_crsr_move, (void *)4,
		FLG_NULL,
	},
	{
		"/cursor/move/right",
		"<Item>",
		'L',
		"^F 6 l",
		N_MSG_MENU_CRSR_MOVE_RIGHT, "",
		cb_menu_crsr_move, (void *)6,
		FLG_NULL,
	},
	{
		"/cursor/move/up left",
		"<Item>",
		'Y',
		"7 y",
		N_MSG_MENU_CRSR_MOVE_UP_LEFT, "",
		cb_menu_crsr_move, (void *)7,
		FLG_NULL,
	},
	{
		"/cursor/move/up",
		"<Item>",
		'K',
		"^P 8 k",
		N_MSG_MENU_CRSR_MOVE_UP, "",
		cb_menu_crsr_move, (void *)8,
		FLG_NULL,
	},
	{
		"/cursor/move/up right",
		"<Item>",
		'U',
		"9 u",
		N_MSG_MENU_CRSR_MOVE_UP_RIGHT, "",
		cb_menu_crsr_move, (void *)9,
		FLG_NULL,
	},
/* cursor move end */
/* cursor quick move begin */
	{
		"/cursor/quick move",
		"<Branch>",
		'Q',
		"",
		N_MSG_MENU_CRSR_QUICK_MOVE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/cursor/quick move/down left",
		"<Item>",
		'B',
		"B",
		N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_LEFT, "",
		cb_menu_crsr_quick_move, (void *)1,
		FLG_NULL,
	},
	{
		"/cursor/quick move/down",
		"<Item>",
		'J',
		"J",
		N_MSG_MENU_CRSR_QUICK_MOVE_DOWN, "",
		cb_menu_crsr_quick_move, (void *)2,
		FLG_NULL,
	},
	{
		"/cursor/quick move/down right",
		"<Item>",
		'N',
		"N",
		N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_RIGHT, "",
		cb_menu_crsr_quick_move, (void *)3,
		FLG_NULL,
	},
	{
		"/cursor/quick move/left",
		"<Item>",
		'H',
		"H",
		N_MSG_MENU_CRSR_QUICK_MOVE_LEFT, "",
		cb_menu_crsr_quick_move, (void *)4,
		FLG_NULL,
	},
	{
		"/cursor/quick move/right",
		"<Item>",
		'L',
		"L",
		N_MSG_MENU_CRSR_QUICK_MOVE_RIGHT, "",
		cb_menu_crsr_quick_move, (void *)6,
		FLG_NULL,
	},
	{
		"/cursor/quick move/up left",
		"<Item>",
		'Y',
		"Y",
		N_MSG_MENU_CRSR_QUICK_MOVE_UP_LEFT, "",
		cb_menu_crsr_quick_move, (void *)7,
		FLG_NULL,
	},
	{
		"/cursor/quick move/up",
		"<Item>",
		'K',
		"K",
		N_MSG_MENU_CRSR_QUICK_MOVE_UP, "",
		cb_menu_crsr_quick_move, (void *)8,
		FLG_NULL,
	},
	{
		"/cursor/quick move/up right",
		"<Item>",
		'U',
		"U",
		N_MSG_MENU_CRSR_QUICK_MOVE_UP_RIGHT, "",
		cb_menu_crsr_quick_move, (void *)9,
		FLG_NULL,
	},
/* cursor quick move end */
	{
		"/cursor/move member",
		"<Branch>",
		'B',
		"@",
		N_MSG_MENU_CRSR_MOVE_MBR, "",
		cb_menu_crsr_move_mbr, NULL,
		FLG_NULL,
	},
	{
		"/cursor/center",
		"<Item>",
		'C',
		"^R ^L",
		N_MSG_MENU_CRSR_CENTER, "",
		cb_menu_crsr_center, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position member",
		"<Item>",
		'P',
		"P",
		N_MSG_MENU_CRSR_NEXT_POS_MBR, "",
		cb_menu_crsr_next_pos_mbr, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position monster",
		"<Item>",
		'X',
		"^I X",
		N_MSG_MENU_CRSR_NEXT_POS_MNSTR, "",
		cb_menu_crsr_next_pos_mnstr, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position item",
		"<Item>",
		'I',
		"I",
		N_MSG_MENU_CRSR_NEXT_POS_ITEM, "",
		cb_menu_crsr_next_pos_item, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position door",
		"<Item>",
		'D',
		"D",
		N_MSG_MENU_CRSR_NEXT_POS_DOOR, "",
		cb_menu_crsr_next_pos_door, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position object",
		"<Item>",
		'O',
		"O",
		N_MSG_MENU_CRSR_NEXT_POS_OBJ, "",
		cb_menu_crsr_next_pos_obj, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position square",
		"<Item>",
		'V',
		"V",
		N_MSG_MENU_CRSR_NEXT_POS_SQUARE, "",
		cb_menu_crsr_next_pos_square, NULL,
		FLG_NULL,
	},
	{
		"/cursor/next position all",
		"<Item>",
		'A',
		"A",
		N_MSG_MENU_CRSR_NEXT_POS_ALL, "",
		cb_menu_crsr_next_pos_all, NULL,
		FLG_NULL,
	},
	{
		"/cursor/prev position",
		"<Item>",
		'R',
		"R",
		N_MSG_MENU_CRSR_PREV_POS, "",
		cb_menu_crsr_prev_pos, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mbr_flg[MBR_ITEM_MAX_N + 4];

menu_t	ls_menu_lang_ls[LANG_KIND_MAX_N * 2];

menu_t	ls_menu_color[2 + 1 + CURS_ATTR_MAX_N + 1];
menu_t	ls_menu_color_sel[] = {
	{
		"/color",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* FG */
	{
		"/color/fg",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_FG, "",
		cb_menu_fg_init, NULL,
		FLG_NULL,
	},
	{
		"/color/fg/black",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_COLOR_BLACK, "",
		cb_menu_fg, (void *)COLOR_BLACK,
		FLG_NULL,
	},
	{
		"/color/fg/red",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_COLOR_RED, "",
		cb_menu_fg, (void *)COLOR_RED,
		FLG_NULL,
	},
	{
		"/color/fg/green",
		"<Item>",
		'G',
		"",
		N_MSG_MENU_COLOR_GREEN, "",
		cb_menu_fg, (void *)COLOR_GREEN,
		FLG_NULL,
	},
	{
		"/color/fg/yellow",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_COLOR_YELLOW, "",
		cb_menu_fg, (void *)COLOR_YELLOW,
		FLG_NULL,
	},
	{
		"/color/fg/blue",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_COLOR_BLUE, "",
		cb_menu_fg, (void *)COLOR_BLUE,
		FLG_NULL,
	},
	{
		"/color/fg/magenta",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_COLOR_MAGENTA, "",
		cb_menu_fg, (void *)COLOR_MAGENTA,
		FLG_NULL,
	},
	{
		"/color/fg/cyan",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLOR_CYAN, "",
		cb_menu_fg, (void *)COLOR_CYAN,
		FLG_NULL,
	},
	{
		"/color/fg/white",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_COLOR_WHITE, "",
		cb_menu_fg, (void *)COLOR_WHITE,
		FLG_NULL,
	},
/* BG */
	{
		"/color/bg",
		"<Branch>",
		'B',
		"",
		N_MSG_MENU_BG, "",
		cb_menu_bg_init, NULL,
		FLG_NULL,
	},
	{
		"/color/bg/black",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_COLOR_BLACK, "",
		cb_menu_bg, (void *)COLOR_BLACK,
		FLG_NULL,
	},
	{
		"/color/bg/red",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_COLOR_RED, "",
		cb_menu_bg, (void *)COLOR_RED,
		FLG_NULL,
	},
	{
		"/color/bg/green",
		"<Item>",
		'G',
		"",
		N_MSG_MENU_COLOR_GREEN, "",
		cb_menu_bg, (void *)COLOR_GREEN,
		FLG_NULL,
	},
	{
		"/color/bg/yellow",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_COLOR_YELLOW, "",
		cb_menu_bg, (void *)COLOR_YELLOW,
		FLG_NULL,
	},
	{
		"/color/bg/blue",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_COLOR_BLUE, "",
		cb_menu_bg, (void *)COLOR_BLUE,
		FLG_NULL,
	},
	{
		"/color/bg/magenta",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_COLOR_MAGENTA, "",
		cb_menu_bg, (void *)COLOR_MAGENTA,
		FLG_NULL,
	},
	{
		"/color/bg/cyan",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLOR_CYAN, "",
		cb_menu_bg, (void *)COLOR_CYAN,
		FLG_NULL,
	},
	{
		"/color/bg/white",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_COLOR_WHITE, "",
		cb_menu_bg, (void *)COLOR_WHITE,
		FLG_NULL,
	},
/* Attr */
	{
		"/color/attribute",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_ATTR, "",
		cb_menu_attr_init, NULL,
		FLG_NULL,
	},
	{
		"/color/attribute/underline",
		"<CheckItem>",
		'U',
		"",
		N_MSG_MENU_UNDERLINE, "",
		cb_menu_attr, (void *)A_UNDERLINE,
		FLG_NULL,
	},
	{
		"/color/attribute/reverse",
		"<CheckItem>",
		'R',
		"",
		N_MSG_MENU_REVERSE, "",
		cb_menu_attr, (void *)A_REVERSE,
		FLG_NULL,
	},
	{
		"/color/attribute/blink",
		"<CheckItem>",
		'L',
		"",
		N_MSG_MENU_BLINK, "",
		cb_menu_attr, (void *)A_BLINK,
		FLG_NULL,
	},
	{
		"/color/attribute/bold",
		"<CheckItem>",
		'B',
		"",
		N_MSG_MENU_BOLD, "",
		cb_menu_attr, (void *)A_BOLD,
		FLG_NULL,
	},
/* End */
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_crsr_ptn[1 + 1 + CRSR_PTN_MAX_N + 1];
menu_t	ls_menu_save_load[MENU_SAVE_LOAD_MAX_N * 2];
menu_t	ls_menu_macro[1 + 1 + (4 * FUNC_KEY_MAX_N) + 1];

menu_t	ls_menu_user[
	1 + 1
	+ USER_MENU_MAX_N
	+ (USER_MENU_MAX_N / MENU_MAX_N_PER_PAGE)
	+ 3 + 1];
menu_t	ls_menu_user_edit[
	1 + 1
	+ USER_MENU_MAX_N
	+ (USER_MENU_MAX_N / MENU_MAX_N_PER_PAGE)
	+ 3 + 1];

#endif	/* MENU_TAB_H */
