/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: misc.c,v 1.34 2006/01/12 08:51:38 bowkenken Exp $
***************************************************************/

/***************************************************************
* ¾
***************************************************************/

#define	MISC_C
#include	"inc.h"

/***************************************************************/

/* μ */

static long	rand_seed = 1;

/***************************************************************
* ߤ򥳥ޡեޥåʸѴ
* long n : 
* return : ޡեޥåʸ
***************************************************************/

char	*fmt_gold( gold_t gold )
{
	return( fmt_num( (long)(gold) ) );
}

/***************************************************************
* ͤ򥳥ޡեޥåʸѴ
* long n : 
* return : ޡեޥåʸ
***************************************************************/

char	*fmt_num( long n )
{
	long	i;
	static char	str[32 + 1];
	long	max_len;
	char	*head;
	char	str_tmp[4 + 1];

	max_len = (sizeof( str ) / sizeof( char )) - 1;

	head = &(str[max_len]);
	*head = '\0';
	head--;

	for( i = 0; i < max_len; i++ ){
		long	n1;

		n1 = labs( n ) % 10;

		sprintf( str_tmp, "%1ld", (long)n1 );
		head--;
		*head = str_tmp[0];

		n /= 10;
		if( n == 0 )
			break;

		if( (i % 3) == 2 ){
			head--;
			*head = ',';
		}
	}

	if( n <= -1 ){
		head--;
		*head = '-';
	}

	return head;
}

/***************************************************************
* long ͤ +- ֤
* long n : 
* return : 
***************************************************************/

long	sgn_l( long n )
{
	if( n > 0 )
		return +1;
	else if( n < 0 )
		return -1;
	else
		return +-0;
}

/***************************************************************
* 2 Ĥ long ͤξ֤
* long n1 :  1
* long n2 :  2
* return : ο
***************************************************************/

long	min_l( long n1, long n2 )
{
	if( n1 < n2 )
		return n1;
	else
		return n2;
}

/***************************************************************
* 2 Ĥ long ͤ礭֤
* long n1 :  1
* long n2 :  2
* return : 礭ο
***************************************************************/

long	max_l( long n1, long n2 )
{
	if( n1 > n2 )
		return n1;
	else
		return n2;
}

/***************************************************************
* μ
* long n : 
***************************************************************/

void	srandm( long n )
{
	rand_seed = n;
}

/***************************************************************
* 0 ̤֤
* long n : 
* return : 
***************************************************************/

long	randm( long n )
{
	long	i, max_i;

	max_i = randm_sub( 3 );
	for( i = 0; i < max_i; i++ )
		randm_sub( n );

	return( randm_sub( n ) );
}

/***************************************************************
* 0 ̤֤
* long n : 
* return : 
***************************************************************/

long	randm_sub( long n )
{
	long	a;

	rand_seed += 15349;
	rand_seed *= 3793;
	rand_seed += 598393;
	a = (rand_seed & 0xffff0000) >> 16;
	rand_seed = ((rand_seed & 0x0000ffff) << 16) + a;
	rand_seed += 379;
	rand_seed = labs( rand_seed );

	if( n > 0 )
		return( rand_seed % n );
	else
		return 0;
}

/***************************************************************
* Ψ(%)ʲˤʤ뤫?
* long n : Ψ(%)
* return : Ψ(%)ʲ?
***************************************************************/

bool_t	rate_randm( rate_t rate )
{
	return( randm( _100_PERCENT ) < rate );
}

/***************************************************************
* οʬ 1 ˤʤ뤫?
* long n : ο
* return : οʬ 1 ?
***************************************************************/

bool_t	per_randm( long per )
{
	return( randm( per ) == 0 );
}

/***************************************************************
* ͤΨ(%)
* rate_t rate : Ψ(%)
* long n : 
* return : Ψ(%)
***************************************************************/

rate_t	modified_rate( rate_t rate, long n )
{
	if( n >= +1 )
		rate += 20 * labs( n );
	if( n <= -1 )
		rate -= 10 * labs( n );

	if( rate < MODIFIED_MIN_RATE )
		rate = MODIFIED_MIN_RATE;

	return rate;
}

/***************************************************************
* С󤬻Ͱ?
* const ver_t *ver : С
* long mjr : ᥸㡼С
* long mnr : ޥʡС
* long pat : ѥå٥
* return : Ͱ?
***************************************************************/

bool_t	chk_ver_old( const ver_t *ver, long mjr, long mnr, long pat )
{
	if( ver == NULL )
		return FALSE;

	if( ver->mjr > mjr )
		return FALSE;
	if( ver->mjr < mjr )
		return TRUE;

	if( ver->mnr > mnr )
		return FALSE;
	if( ver->mnr < mnr )
		return TRUE;

	if( ver->pat > pat )
		return FALSE;
	if( ver->pat < pat )
		return TRUE;

	return TRUE;
}

/***************************************************************
* С󤬻ͤȰפ뤫?
* const ver_t *ver : С
* long mjr : ᥸㡼С
* long mnr : ޥʡС
* long pat : ѥå٥
* return : פ뤫?
***************************************************************/

bool_t	chk_ver_match( const ver_t *ver, long mjr, long mnr, long pat )
{
	if( ver == NULL )
		return FALSE;

	if( ver->mjr != mjr )
		return FALSE;
	if( ver->mnr != mnr )
		return FALSE;
	if( ver->pat != pat )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw( const char *s )
{
#ifdef	D_DOS

	return( (long)strlen( s ) );

#else	/* D_DOS */

	switch( get_lang_kind() ){
	case LANG_KIND_ENGLISH:
		return str_len_draw_english( s );
	case LANG_KIND_JAPANESE_EUC:
		return str_len_draw_japanese_euc( s );
	case LANG_KIND_JAPANESE_UTF_8:
		return str_len_draw_japanese_utf_8( s );
	case LANG_KIND_MAX_N:
		break;
	}

	return( (long)strlen( s ) );

#endif	/* D_DOS */
}

/***************************************************************
* Ѹʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_english( const char *s )
{
#if	1
/*@@@*/
	return str_len_draw_japanese_euc( s );
#else
	return( (long)strlen( s ) );
#endif
}

/***************************************************************
* ܸ(EUC)ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_japanese_euc( const char *s )
{
	long	len;

	for( len = 0; *s; len++, s++ ){
		unsigned char	c;

		c = (unsigned char)*s;
		if( (0x80 <= c) && (c <= 0x9f) )
			len--;
	}

	return len;
}

/***************************************************************
* ܸ(UTF-8)ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_japanese_utf_8( const char *s )
{
	long	len;
	unsigned char	c;
	long	skip_n;
	long	i;

	len = 0;
	for( ; *s != '\0'; s++ ){
		c = (unsigned char)*s;
		skip_n = 0;

		if( (c & 0x80) == 0x00 ){
			len++;
			continue;
		} else if( (c & 0xe0) == 0xc0 ){
			skip_n = 2;
		} else if( (c & 0xf0) == 0xe0 ){
			skip_n = 3;
		} else if( (c & 0xf8) == 0xf0 ){
			skip_n = 4;
		} else if( (c & 0xfc) == 0xf8 ){
			skip_n = 5;
		} else if( (c & 0xfe) == 0xfc ){
			skip_n = 6;
		}

		len += 2;
		s++;
		for( i = 1; i < skip_n; i++ ){
			if( *s == '\0' ){
				s--;
				break;
			}
			if( (c & 0xc0) != 0x80 ){
				s--;
				break;
			}

			s++;
		}
	}

	return len;
}

/***************************************************************
* ʸΥ꡼ʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_std( const char *s )
{
	return( (long)strlen( s ) );
}

/***************************************************************
* ʸʸۤʤͤϢ뤹
* char *dst : Ϣʸ
* const char *src : ȸʸ
* int len : ʸ
* return : Ϣʸ
***************************************************************/

char	*str_max_n_cat( char *dst, const char *src, int len )
{
	return strncat( dst, src, len - strlen( dst ) );
}

/***************************************************************
* ե饰λꤷӥåȤΩäƤ뤫Ĵ٤
* unsigned long var : ե饰
* unsigned long flg : Ĵ٤ӥå
* return : ΩäƤ뤫?
***************************************************************/

bool_t	chk_flg( unsigned long var, unsigned long flg )
{
	return( (var & flg) == flg );
}

/***************************************************************
* ե饰λꤷӥåȤ 1 ĤǤΩäƤ뤫Ĵ٤
* unsigned long var : ե饰
* unsigned long flg : Ĵ٤ӥå
* return : 1 ĤǤΩäƤ뤫?
***************************************************************/

bool_t	chk_flg_or( unsigned long var, unsigned long flg )
{
	return( (var & flg) != 0 );
}

/***************************************************************
* 顼åդΥ꡼
* long size : Ƥ꡼Υ
* bool_t flg_exit : 顼ǽλ뤫?
* return : Ƥ꡼
***************************************************************/

void	*alloc_mem( long size, bool_t flg_exit )
{
	void	*p;

	p = malloc( size );
	if( p == NULL ){
		print_msg( FLG_MSG_ERR, MSG_ERR_ALLOC_MEM, size );

		if( flg_exit ){
			exit_game( EXIT_FAILURE );
		}
	}

	return p;
}

/***************************************************************
* ꡼
* void *p : ꡼
***************************************************************/

void	free_mem( void *p )
{
	if( p != NULL )
		free( p );
}

