/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiMenu.cpp,v 1.10 2006/01/12 09:21:34 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
//#include	"turn.h"
//#include	"dun.h"
//#include	"town.h"
//#include	"item.h"
//#include	"spell.h"
//#include	"chr.h"
//#include	"party.h"
//#include	"mnstr.h"
//#include	"pet.h"
//#include	"fight.h"
//#include	"fx.h"
//#include	"trap.h"
//#include	"draw.h"
//#include	"curs.h"
#include	"menu.h"
//#include	"amenu.h"
//#include	"request.h"
//#include	"gfile.h"
//#include	"msg.h"
//#include	"ver.h"
#include	"gmain-prot.h"
#include	"misc-prot.h"
//#include	"turn-prot.h"
//#include	"dun-prot.h"
//#include	"town-prot.h"
//#include	"item-prot.h"
//#include	"spell-prot.h"
//#include	"chr-prot.h"
//#include	"party-prot.h"
//#include	"mnstr-prot.h"
//#include	"pet-prot.h"
//#include	"fight-prot.h"
//#include	"fx-prot.h"
//#include	"trap-prot.h"
//#include	"draw-prot.h"
//#include	"curs-prot.h"
//#include	"menu-prot.h"
//#include	"tmenu-prot.h"
//#include	"amenu-prot.h"
//#include	"request-prot.h"
//#include	"gfile-prot.h"
//#include	"msg-prot.h"

#include <WSCwindow.h>
#include <WSCbase.h>
#include <WSCvbtn.h>
#include <WSDmouse.h>

#include "GuiMenu.h"
#include "GlobalVar.h"

extern WSCwindow *MenuWin;
extern WSCvbtn *MenuBtnPrevPage, *MenuBtnNextPage;
extern WSCvlabel *MenuLabelPage;

#define	GUI_MENU_BTN_MARGIN_X	4
#define	GUI_MENU_BTN_MARGIN_Y	4
#define	GUI_MENU_BTN_HEIGHT	24

void EpGuiMenuSel( WSCbase *obj );

////////////////////////////////////////////////////////////////
// ˥塼ν
////////////////////////////////////////////////////////////////

void GuiMenu::init()
{
	for( long i = 0; i < MENU_MAX_N_PER_PAGE; i++ ){
		WSCstring name;
		name << "NAME" << i;

		WSCbase *base = WSCbase::getNewInstance(
				"WSCvbtn", MenuWin, name );
		base->initialize();
		base->clear();

		aBtnMenu[i] = (WSCvbtn *)base->cast( "WSCvbtn" );

		aBtnMenu[i]->setVariantData( "accel_key", '\0' );

		aBtnMenu[i]->setProperty( WSNx, GUI_MENU_BTN_MARGIN_X );
		aBtnMenu[i]->setProperty( WSNy, GUI_MENU_BTN_MARGIN_Y
				+ (GUI_MENU_BTN_HEIGHT * i) );
		aBtnMenu[i]->setProperty( WSNheight, GUI_MENU_BTN_HEIGHT );

		aBtnMenu[i]->setProperty( WSNalignmentV, WS_CENTER );
		aBtnMenu[i]->setProperty( WSNalignmentH, WS_LEFT );

		aBtnMenu[i]->setProperty( WSNanchorTopFlag, (WSCbool)0 );
		aBtnMenu[i]->setProperty( WSNanchorBottomFlag, (WSCbool)0 );
		aBtnMenu[i]->setProperty( WSNanchorLeftFlag, (WSCbool)1 );
		aBtnMenu[i]->setProperty( WSNanchorRightFlag, (WSCbool)1 );
		aBtnMenu[i]->setProperty( WSNanchorTop,
				GUI_MENU_BTN_MARGIN_Y );
		aBtnMenu[i]->setProperty( WSNanchorBottom,
				GUI_MENU_BTN_MARGIN_Y );
		aBtnMenu[i]->setProperty( WSNanchorLeft,
				GUI_MENU_BTN_MARGIN_X );
		aBtnMenu[i]->setProperty( WSNanchorRight,
				GUI_MENU_BTN_MARGIN_X );

		aBtnMenu[i]->setVisible( false );
		aBtnMenu[i]->setSensitive( false );

		WSCprocedure *ep = new WSCprocedure( "EP", WSEV_ACTIVATE );
		ep->setFunction( EpGuiMenuSel, "EpGuiMenuSel" );
		aBtnMenu[i]->addProcedure( ep );
	}

	MenuWin->setVisible( false );
}

////////////////////////////////////////////////////////////////
// ˥塼򳫻
// draw_menu_t *data : ˥塼ѥǡ
////////////////////////////////////////////////////////////////

void GuiMenu::draw( draw_menu_t *data )
{
	static char tmp[1024 + 1];

	if( data == NULL )
		return;

	// åܥå

	WSCstring msgTitle = data->ttl;
	MenuWin->setProperty( WSNtitleString, (char *)msgTitle );

	// ڡڤؤܥ ON/OFF

	if( data->flg_min_page ){
		MenuBtnPrevPage->setProperty(
				WSNlabelString, (char *)"" );
	} else {
		MenuBtnPrevPage->setProperty(
				WSNlabelString, (char *)"<<" );
	}
	if( data->flg_max_page ){
		MenuBtnNextPage->setProperty(
				WSNlabelString, (char *)"" );
	} else {
		MenuBtnNextPage->setProperty(
				WSNlabelString, (char *)">>" );
	}

	// ڡ

	WSCstring strPage;
	strPage << (data->page_sel_n + 1) << "/" << data->page_max_n;

	MenuLabelPage->setProperty( WSNlabelString, (char *)strPage );

	// åޡ褹뤫Ĵ٤

	bool FlagUseOnOff = false;
	for( long i = 0; i < MENU_MAX_N_PER_PAGE; i++ ){
		if( data->ls[i] == NULL )
			break;

		if( strcmp( data->ls[i]->kind, "<CheckItem>" ) == 0 ){
			FlagUseOnOff = true;
		} else if( strcmp( data->ls[i]->kind, "<RadioItem>" ) == 0 ){
			FlagUseOnOff = true;
		}
	}

	// ˥塼̾ܥ

	long i = 0;
	for( i = 0; i < MENU_MAX_N_PER_PAGE; i++ ){
		if( data->ls[i] == NULL )
			break;
		if( data->ls[i]->msg == NULL )
			continue;
		if( aBtnMenu[i] == NULL )
			continue;

		// ˥塼

		WSCstring msgContents = data->ls[i]->msg;

		// 졼

		WSCstring msgAccel = "";
		if( data->ls[i]->accel_key != '\0' ){
			sprintf( tmp, MSG_MENU_ACCEL_KEY_FMT,
					data->ls[i]->accel_key );
			msgAccel = tmp;
		}

		// 硼ȥåȡ

		WSCstring msgShort = "";
		if( data->ls[i]->short_key[0] != '\0' ){
			sprintf( tmp, MSG_MENU_SHORT_CUT_KEY_FMT,
					data->ls[i]->short_key );
			msgShort = tmp;
		}

		// åܥå

		WSCstring msgChk = "";
		if( !FlagUseOnOff )
			msgChk = MSG_NULL;
		else if( chk_flg( data->ls[i]->flg, FLG_MENU_CHK_ON ) )
			msgChk = MSG_MENU_FLG_LS_CHK_ON;
		else if( chk_flg( data->ls[i]->flg, FLG_MENU_CHK_OFF ) )
			msgChk = MSG_MENU_FLG_LS_CHK_OFF;
		else
			msgChk = MSG_MENU_FLG_LS_CHK_NULL;

		// <Branch>

		WSCstring msgBranch = "";
		if( strcmp( data->ls[i]->kind, "<Branch>" ) == 0 )
			msgBranch = MSG_MENU_KIND_BRANCH;
		else
			msgBranch = MSG_NULL;

		// <OpenWinItem>

		WSCstring msgOpenWin = "";
		if( strcmp( data->ls[i]->kind, "<OpenWinItem>" ) == 0 )
			msgOpenWin = MSG_MENU_KIND_OPEN_WIN_ITEM;
		else
			msgOpenWin = MSG_NULL;

		// ˥塼ܥΥ٥

		WSCstring msg = "";
		msg << msgChk << msgAccel;
		msg << msgContents;
		msg << "" << msgShort;
		msg << " " << msgBranch;

		// ˥塼ܥΥץѥƥ

		aBtnMenu[i]->setVariantData( "accel_key",
				data->ls[i]->accel_key );

		aBtnMenu[i]->setProperty( WSNlabelString, msg );
		aBtnMenu[i]->setVisible( true );
		aBtnMenu[i]->setSensitive( true );

		// ǥեȤιܤ˥եư

		if( i == data->sel_n )
			aBtnMenu[i]->setFocus();
	}
	for( ; i < MENU_MAX_N_PER_PAGE; i++ ){
		// ;äܥɽˤ

		if( aBtnMenu[i] == NULL )
			continue;

		aBtnMenu[i]->setVisible( false );
		aBtnMenu[i]->setSensitive( false );
	}

	// ˥塼ɥɽ

	MenuWin->setVisible( true );
}

////////////////////////////////////////////////////////////////
// ˥塼Ĥ
////////////////////////////////////////////////////////////////

void GuiMenu::wipe()
{
	MenuWin->setVisible( false );
}

////////////////////////////////////////////////////////////////
// ǥեȤܤ˥ޥư
// long sel_n : 
////////////////////////////////////////////////////////////////

void GuiMenu::setMouseDfltMenu( long sel_n )
{
	if( sel_n <= -1 )
		return;
	if( sel_n >= MENU_MAX_N_PER_PAGE )
		return;
	if( !bFlagSetMouseDfltMenu )
		return;

	long x = (long)(MenuWin->getProperty( WSNx ));
	long y = (long)(MenuWin->getProperty( WSNy ));
	y += (long)(MenuWin->getProperty( WSNbarThickness ));
	x += (long)(aBtnMenu[sel_n]->getProperty( WSNx ));
	y += (long)(aBtnMenu[sel_n]->getProperty( WSNy ));
	long w = (long)(aBtnMenu[sel_n]->getProperty( WSNwidth ));
	long h = (long)(aBtnMenu[sel_n]->getProperty( WSNheight ));
	x += w * 4 / 5;
	y += h / 2;

	WSDmouse *mouse = WSGIappMouse();
	mouse->setMousePosition( x, y );
}

////////////////////////////////////////////////////////////////
// ˥塼Υܥ򥯥å
// WSCbase *obj : å줿ܥ
////////////////////////////////////////////////////////////////

void EpGuiMenuSel( WSCbase *obj )
{
	WSDmouse *mouse = WSGIappMouse();

	if( mouse->getTargetBtn() & WS_MOUSE_BTN1 ){
		char s[4 + 1];
		s[0] = (char)(obj->getVariantData( "accel_key" ));
		s[1] = '\0';

		gKey.setString( s );
	} else if( mouse->getTargetBtn() & WS_MOUSE_BTN3 ){
		gKey.setString( "0" );
	}
}
