/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: Pcg.cpp,v 1.18 2006/01/26 03:06:41 bowkenken Exp $
***************************************************************/

#include <time.h>

#include "misc.h"
#include "draw.h"
#include "town.h"
#include "gfile.h"
#include "misc-prot.h"
#include "draw-prot.h"
#include "gfile-prot.h"

#include "Pcg.h"

////////////////////////////////////////////////////////////////
// 
// WSCstring path : եåեХѥ
////////////////////////////////////////////////////////////////

void Pcg::init( WSCstring path )
{
	load( path );
}

////////////////////////////////////////////////////////////////
// եåեɤ߹
// WSCstring path : եåեХѥ
////////////////////////////////////////////////////////////////

void Pcg::load( WSCstring path )
{
	dis();

	WSCstring dir = path;
	long pos = dir.getWordCharPos( dir.getWords( "/" ), "/" ) - 1;
	if( pos > 0 ){
		dir.cutString( pos );
		make_dir( dir );
	}

	pImage = WSGIappImageSet()->getImage( path );
}

////////////////////////////////////////////////////////////////
// եåǡͭ
////////////////////////////////////////////////////////////////

void Pcg::ena()
{
	if( pImage == NULL )
		return;
	if( pMDev != NULL )
		return;

	pMDev = WSDmwindowDev::getNewInstance();

	WSCushort w = pImage->getImageWidth();
	WSCushort h = pImage->getImageHeight();

	pMDev->createPixmap( w, h );
	pMDev->beginDraw( 0, 0, w, h );
	if( !waitReady( pMDev ) )
		return;
	pMDev->drawImage( 0, 0, w, h, pImage, WS_CENTER );
	pMDev->endDraw();
}

////////////////////////////////////////////////////////////////
// եåǡ̵
////////////////////////////////////////////////////////////////

void Pcg::dis()
{
	if( pImage != NULL ){
		pImage->destroyImage();
	}
	if( pMDev != NULL ){
		delete pMDev;
		pMDev = NULL;
	}
}

////////////////////////////////////////////////////////////////
// եåѥ֤
// return : 
////////////////////////////////////////////////////////////////

long Pcg::getWidth()
{
	if( pImage == NULL )
		return 0;

	return pImage->getImageWidth();
}

////////////////////////////////////////////////////////////////
// եåѥ֤
// return : 
////////////////////////////////////////////////////////////////

long Pcg::getHeight()
{
	if( pImage == NULL )
		return 0;

	return pImage->getImageHeight();
}

////////////////////////////////////////////////////////////////
// ǽԤ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// return : false ʤڤ
////////////////////////////////////////////////////////////////

bool Pcg::waitReady( WSDmwindowDev *mDev )
{
	if( mDev == NULL )
		return false;

	double frame = (double)*get_clk_tck();
	frame = frame * (double)nWaitReadyMSec / 1000.0;
	clock_t end_clock = clock() + (clock_t)frame;

	while( clock() < end_clock ){
		if( mDev->getReady() )
			return true;
	}

#if	0
//@@@
	mDev->endDraw();
#endif

	return false;
}

////////////////////////////////////////////////////////////////
// եåѥ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::draw( WSDmwindowDev *mDev,
		long x, long y, long w, long h )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	mDev->beginDraw( x, y, w, h );
	mDev->drawImage( x, y, w, h, pImage, WS_LEFT_TOP );
	mDev->endDraw();

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// ʥѥкɸ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawFix( WSDmwindowDev *mDev,
		long x, long y, long w, long h )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long iw = pImage->getImageWidth();
	long ih = pImage->getImageHeight();
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;
	long bgnX = (x / iw) * iw;
	long bgnY = (y / ih) * ih;

#if	0
//@@@
	long bgnDrawX = max_l( x, 0 );
	long bgnDrawY = max_l( y, 0 );
	long bgnDrawW = w - (bgnDrawX - x);
	long bgnDrawH = h - (bgnDrawY - y);
	mDev->beginDraw( bgnDrawX, bgnDrawY, bgnDrawW, bgnDrawH );
#endif

	long drawH = ih - (y - bgnY);
	for( long yy = bgnY; yy < y + h; yy += ih ){
		if( drawH > (y + h - yy) )
			drawH = (y + h - yy);

		long drawW = iw - (x - bgnX);
		for( long xx = bgnX; xx < x + w; xx += iw ){
			if( drawW > (x + w - xx) )
				drawW = (x + w - xx);

			if( !waitReady( mDev ) )
				return false;

#ifdef	D_WIN
			mDev->beginDraw( xx, yy, drawW, drawH );
			mDev->drawImage( xx, yy, drawW, drawH,
					pImage, WS_LEFT_TOP );
			mDev->endDraw();
#else
			pMDev->copyToWindow( mDev,
					0, 0,
					drawW, drawH,
					xx, yy );
#endif

			drawW = iw;
		}

		drawH = ih;
	}

#if	0
//@@@
	mDev->endDraw();
#endif

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// ʥѥΥǥåդ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// long idxX : X ΥѥΥǥå
// long idxY : Y ΥѥΥǥå
// long sizeX : X ΥѥΥ
// long sizeY : Y ΥѥΥ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawIdx( WSDmwindowDev *mDev,
		long x, long y, long w, long h,
		long idxX, long idxY,
		long sizeX, long sizeY )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long iw = pImage->getImageWidth();
	long ih = pImage->getImageHeight();
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;

#ifdef	D_WIN
	mDev->beginDraw( x, y, sizeX, sizeY );
	mDev->drawImage(
			x - (idxX - sizeX),
			y - (idxY - sizeY),
			iw, ih,
			pImage, WS_LEFT_TOP );
	mDev->endDraw();
#else
	pMDev->copyToWindow( mDev,
			idxX * sizeX,
			idxY * sizeY,
			sizeX, sizeY,
			x, y );
#endif
	return true;

#if	0
//@@@
	long iw = sizeX;
	long ih = sizeY;
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;
	long bgnX = (x / iw) * iw;
	long bgnY = (y / ih) * ih;

#if	0
//@@@
	long bgnDrawX = max_l( x, 0 );
	long bgnDrawY = max_l( y, 0 );
	long bgnDrawW = w - (bgnDrawX - x);
	long bgnDrawH = h - (bgnDrawY - y);
	mDev->beginDraw( bgnDrawX, bgnDrawY, bgnDrawW, bgnDrawH );
#endif

	long drawH = ih - (y - bgnY);
	for( long yy = bgnY; yy < y + h; yy += ih ){
		long drawW = iw - (x - bgnX);

		if( drawH > (y + h - yy) )
			drawH = (y + h - yy);

		for( long xx = bgnX; xx < x + w; xx += iw ){
			if( drawW > (x + w - xx) )
				drawW = (x + w - xx);

			if( !waitReady( mDev ) )
				return false;

#ifdef	D_WIN
			mDev->beginDraw( xx, yy, sizeX, sizeY );
			mDev->drawImage(
					xx - (idxX - sizeX),
					yy - (idxY - sizeY),
					pImage->getImageWidth(),
					pImage->getImageHeight(),
					pImage, WS_LEFT_TOP );
			mDev->endDraw();
#else
			pMDev->copyToWindow( mDev,
					idxX * sizeX,
					idxY * sizeY,
					sizeX, sizeY,
					xx, yy );
#endif

			drawW = iw;
		}

		drawH = ih;
	}

#if	0
//@@@
	mDev->endDraw();
#endif

	return true;
#endif
}

